/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.slivkaws;

import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.ws.ServiceChangeListener;
import jalview.ws.WSDiscovererI;
import jalview.ws.api.ServiceWithParameters;
import jalview.ws.slivkaws.RNAalifoldServiceInstance;
import jalview.ws.slivkaws.SlivkaAnnotationServiceInstance;
import jalview.ws.slivkaws.SlivkaMsaServiceInstance;
import jalview.ws.slivkaws.SlivkaWSInstance;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.json.JSONException;
import uk.ac.dundee.compbio.slivkaclient.SlivkaClient;
import uk.ac.dundee.compbio.slivkaclient.SlivkaService;

public class SlivkaWSDiscoverer
implements WSDiscovererI {
    private static final String SLIVKA_HOST_URLS = "SLIVKAHOSTURLS";
    private static final String COMPBIO_SLIVKA = "https://www.compbio.dundee.ac.uk/slivka/";
    private static SlivkaWSDiscoverer instance = null;
    private List<ServiceWithParameters> services = List.of();
    private Set<ServiceChangeListener> serviceListeners = new CopyOnWriteArraySet<ServiceChangeListener>();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private Vector<Future<?>> discoveryTasks = new Vector();

    private SlivkaWSDiscoverer() {
    }

    public static SlivkaWSDiscoverer getInstance() {
        if (instance == null) {
            instance = new SlivkaWSDiscoverer();
        }
        return instance;
    }

    @Override
    public void addServiceChangeListener(ServiceChangeListener l) {
        this.serviceListeners.add(l);
    }

    @Override
    public void removeServiceChangeListener(ServiceChangeListener l) {
        this.serviceListeners.remove(l);
    }

    public void notifyServiceListeners(List<ServiceWithParameters> services) {
        for (ServiceChangeListener listener : this.serviceListeners) {
            listener.servicesChanged(this, services);
        }
    }

    @Override
    public CompletableFuture<WSDiscovererI> startDiscoverer() {
        CompletableFuture<WSDiscovererI> task = CompletableFuture.supplyAsync(() -> {
            this.reloadServices();
            return this;
        }, this.executor);
        this.discoveryTasks.add(task);
        return task;
    }

    private List<ServiceWithParameters> reloadServices() {
        Console.info("Reloading Slivka services");
        this.notifyServiceListeners(Collections.emptyList());
        ArrayList<ServiceWithParameters> instances = new ArrayList<ServiceWithParameters>();
        for (String url : this.getServiceUrls()) {
            List services;
            SlivkaClient client = SlivkaClient.newInstance((String)url);
            try {
                services = client.getServices();
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            for (SlivkaService service : services) {
                SlivkaWSInstance newInstance = null;
                for (String classifier : service.classifiers) {
                    String[] path = classifier.split("\\s*::\\s*");
                    if (path.length >= 3 && path[0].toLowerCase().equals("operation") && path[1].toLowerCase().equals("analysis")) {
                        switch (path[path.length - 1].toLowerCase()) {
                            case "rna secondary structure prediction": {
                                newInstance = new RNAalifoldServiceInstance(client, service, "Secondary Structure Prediction");
                                break;
                            }
                            case "sequence alignment analysis (conservation)": {
                                newInstance = new SlivkaAnnotationServiceInstance(client, service, "Conservation");
                                break;
                            }
                            case "protein sequence analysis": {
                                newInstance = new SlivkaAnnotationServiceInstance(client, service, "Protein Disorder");
                                break;
                            }
                            case "protein secondary structure prediction": {
                                newInstance = new SlivkaAnnotationServiceInstance(client, service, "Secondary Structure Prediction");
                                break;
                            }
                            case "multiple sequence alignment": {
                                newInstance = new SlivkaMsaServiceInstance(client, service, "Alignment");
                            }
                        }
                    }
                    if (newInstance == null) continue;
                    break;
                }
                if (newInstance == null) continue;
                instances.add(newInstance);
            }
        }
        this.services = instances;
        Console.info("Slivka services reloading finished");
        this.notifyServiceListeners(instances);
        return instances;
    }

    @Override
    public List<ServiceWithParameters> getServices() {
        return this.services;
    }

    @Override
    public boolean hasServices() {
        return !this.isRunning() && this.services.size() > 0;
    }

    @Override
    public boolean isRunning() {
        return !this.discoveryTasks.stream().allMatch(Future::isDone);
    }

    @Override
    public void setServiceUrls(List<String> wsUrls) {
        if (wsUrls != null && !wsUrls.isEmpty()) {
            Cache.setProperty(SLIVKA_HOST_URLS, String.join((CharSequence)",", wsUrls));
        } else {
            Cache.removeProperty(SLIVKA_HOST_URLS);
        }
    }

    @Override
    public List<String> getServiceUrls() {
        String surls = Cache.getDefault(SLIVKA_HOST_URLS, COMPBIO_SLIVKA);
        String[] urls = surls.split(",");
        ArrayList<String> valid = new ArrayList<String>(urls.length);
        for (String url : urls) {
            try {
                new URL(url);
                valid.add(url);
            }
            catch (MalformedURLException e) {
                Console.warn("Problem whilst trying to make a URL from '" + (url != null ? url : "<null>") + "'");
                Console.warn("This was probably due to a malformed comma separated list in the SLIVKAHOSTURLS entry of $(HOME)/.jalview_properties)");
                Console.debug("Exception was ", e);
            }
        }
        return valid;
    }

    @Override
    public boolean testServiceUrl(URL url) {
        return this.getServerStatusFor(url.toString()) == 1;
    }

    @Override
    public int getServerStatusFor(String url) {
        try {
            List services = SlivkaClient.newInstance((String)url).getServices();
            return services.isEmpty() ? 0 : 1;
        }
        catch (IOException | JSONException e) {
            Console.error("Slivka could not retrieve services list", e);
            return -1;
        }
    }

    @Override
    public String getErrorMessages() {
        return "";
    }
}

