/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws;

import jalview.bin.Console;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.OOMWarning;
import jalview.gui.WebserviceInfo;
import jalview.util.MessageManager;
import jalview.viewmodel.seqfeatures.FeatureRendererSettings;
import jalview.ws.AWsJob;
import jalview.ws.JobStateSummary;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;

public abstract class AWSThread {
    private Timer timer;
    protected AlignmentI currentView = null;
    protected FeatureRendererSettings featureSettings = null;
    protected WebserviceInfo wsInfo = null;
    protected AlignmentView input = null;
    protected List<AlignedCodonFrame> codonframe = null;
    protected boolean jobComplete = false;
    protected AWsJob[] jobs = null;
    protected String WebServiceName = null;
    protected char defGapChar = (char)45;
    protected String OutputHeader;
    protected String WsUrl = null;
    private AlignFrame alignFrame;

    public void start() {
        if (this.jobs == null) {
            this.jobComplete = true;
            Console.debug("WebServiceJob poll loop finished with no jobs created.");
            this.wsInfo.setStatus(4);
            this.wsInfo.appendProgressText(MessageManager.getString("info.no_jobs_ran"));
            this.wsInfo.setFinishedNoResults();
            return;
        }
        this.timer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobStateSummary jstate = new JobStateSummary();
                for (AWsJob job : AWSThread.this.jobs) {
                    if (!job.submitted && job.hasValidInput()) {
                        AWSThread.this.StartJob(job);
                    }
                    Console.debug(String.format("Job %s is %ssubmitted", job, job.submitted ? "" : "not "));
                    if (job.submitted && !job.subjobComplete) {
                        Console.debug(String.format("Polling Job %s Result state was:%s(ServerError=%b)", job, job.getState(), job.isServerError()));
                        try {
                            AWSThread.this.pollJob(job);
                            if (!job.hasResponse()) {
                                throw new Exception("Timed out when communicating with server. Try again later.");
                            }
                            Console.debug(String.format("Job %s Result state:%s(ServerError=%b)", job, job.getState(), job.isServerError()));
                        }
                        catch (Exception exc) {
                            AWSThread.this.wsInfo.appendProgressText(job.jobnum, MessageManager.formatMessage("info.server_exception", AWSThread.this.WebServiceName, exc.getMessage()));
                            Console.warn(String.format("%s job(%s) Server exception.", AWSThread.this.WebServiceName, job.jobnum));
                            exc.printStackTrace();
                            if (job.allowedServerExceptions > 0) {
                                --job.allowedServerExceptions;
                            } else {
                                Console.warn(String.format("Dropping job %s %s", job, job.jobId));
                                job.subjobComplete = true;
                                AWSThread.this.wsInfo.setStatus(job.jobnum, 5);
                            }
                        }
                        catch (OutOfMemoryError oomerror) {
                            AWSThread.this.jobComplete = true;
                            job.subjobComplete = true;
                            job.clearResponse();
                            AWSThread.this.wsInfo.setStatus(job.jobnum, 4);
                            Console.error(String.format("Out of memory when retrieving Job %s id:%s/%s", job, AWSThread.this.WsUrl, job.jobId), oomerror);
                            new OOMWarning("retrieving result for " + AWSThread.this.WebServiceName, oomerror);
                            System.gc();
                        }
                    }
                    jstate.updateJobPanelState(AWSThread.this.wsInfo, AWSThread.this.OutputHeader, job);
                }
                AWSThread.this.updateGlobalStatus(jstate);
                if (AWSThread.this.jobComplete) {
                    AWSThread.this.timer.stop();
                    AWSThread.this.parseResult();
                }
            }
        });
        this.timer.setInitialDelay(0);
        this.timer.start();
    }

    protected void updateGlobalStatus(JobStateSummary jstate) {
        if (jstate.running > 0) {
            this.wsInfo.setStatus(1);
        } else if (jstate.queuing > 0) {
            this.wsInfo.setStatus(0);
        } else {
            this.jobComplete = true;
            if (jstate.finished > 0) {
                this.wsInfo.setStatus(2);
            } else if (jstate.error > 0) {
                this.wsInfo.setStatus(4);
            } else if (jstate.serror > 0) {
                this.wsInfo.setStatus(5);
            }
        }
    }

    public void interrupt() {
        this.timer.stop();
    }

    public abstract void pollJob(AWsJob var1) throws Exception;

    public abstract void StartJob(AWsJob var1);

    public abstract void parseResult();

    public void propagateDatasetMappings(Alignment al) {
        if (this.codonframe != null) {
            SequenceI[] alignment = al.getSequencesArray();
            block0: for (int sq = 0; sq < alignment.length; ++sq) {
                for (AlignedCodonFrame acf : this.codonframe) {
                    SequenceI seq = alignment[sq];
                    if (acf == null || !acf.involvesSequence(seq)) continue;
                    al.addCodonFrame(acf);
                    continue block0;
                }
            }
        }
    }

    public char getGapChar() {
        return this.defGapChar;
    }

    public AWSThread(AlignFrame alignFrame, WebserviceInfo wsinfo, AlignmentView input, String webServiceName, String wsUrl) {
        this(alignFrame, wsinfo, input, wsUrl);
        this.WebServiceName = webServiceName;
    }

    public AWSThread(AlignFrame alframe, WebserviceInfo wsinfo2, AlignmentView alview, String wsurl2) {
        List<AlignedCodonFrame> cf;
        this.alignFrame = alframe;
        this.currentView = alframe.getCurrentView().getAlignment();
        this.featureSettings = alframe.getFeatureRenderer().getSettings();
        this.defGapChar = alframe.getViewport().getGapCharacter();
        this.wsInfo = wsinfo2;
        this.input = alview;
        this.WsUrl = wsurl2;
        if (alframe != null && (cf = alframe.getViewport().getAlignment().getCodonFrames()) != null) {
            this.codonframe = new ArrayList<AlignedCodonFrame>();
            this.codonframe.addAll(cf);
        }
    }

    protected AlignFrame getRequestingAlignFrame() {
        return this.alignFrame;
    }
}

