/*
 * Decompiled with CFR 0.152.
 */
package jalview.workers;

import jalview.analysis.AAFrequency;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.HiddenMarkovModel;
import jalview.datamodel.ProfilesI;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.util.MessageManager;
import jalview.workers.AlignCalcWorker;
import java.util.ArrayList;
import java.util.List;

public class InformationThread
extends AlignCalcWorker {
    public static final String HMM_CALC_ID = "HMM";

    public InformationThread(AlignViewportI alignViewport, AlignmentViewPanel alignPanel) {
        super(alignViewport, alignPanel);
    }

    @Override
    public void run() {
        int aWidth;
        if (this.alignViewport.getAlignment().getHmmSequences().isEmpty()) {
            return;
        }
        if (this.alignViewport.isClosed()) {
            this.abortAndDestroy();
            return;
        }
        AlignmentI alignment = this.alignViewport.getAlignment();
        int n = aWidth = alignment == null ? -1 : alignment.getWidth();
        if (aWidth < 0) {
            return;
        }
        this.computeProfiles(alignment);
        this.updateAnnotation();
        if (this.ap != null) {
            this.ap.adjustAnnotationHeight();
            this.ap.paintAlignment(true, true);
        }
    }

    protected void computeProfiles(AlignmentI alignment) {
        int width = alignment.getWidth();
        List<SequenceI> seqs = alignment.getHmmSequences();
        if (!seqs.isEmpty()) {
            HiddenMarkovModel hmm = seqs.get(0).getHMM();
            ProfilesI hmmProfiles = AAFrequency.calculateHMMProfiles(hmm, width, 0, width, this.alignViewport.isIgnoreBelowBackground(), this.alignViewport.isInfoLetterHeight());
            this.alignViewport.setHmmProfiles(hmmProfiles);
        }
        List<SequenceGroup> groups = alignment.getGroups();
        for (SequenceGroup group : groups) {
            seqs = group.getHmmSequences();
            if (seqs.isEmpty()) continue;
            HiddenMarkovModel hmm = seqs.get(0).getHMM();
            ProfilesI hmmProfiles = AAFrequency.calculateHMMProfiles(hmm, width, 0, width, group.isIgnoreBelowBackground(), group.isUseInfoLetterHeight());
            group.setHmmProfiles(hmmProfiles);
        }
    }

    protected SequenceI[] getSequences() {
        return this.alignViewport.getAlignment().getSequencesArray();
    }

    protected AlignmentAnnotation getGapAnnotation() {
        return this.alignViewport.getAlignmentGapAnnotation();
    }

    @Override
    public void updateAnnotation() {
        AlignmentI alignment = this.alignViewport.getAlignment();
        float maxInformation = 0.0f;
        ArrayList<AlignmentAnnotation> infos = new ArrayList<AlignmentAnnotation>();
        List<SequenceI> hmmSeqs = alignment.getHmmSequences();
        if (!hmmSeqs.isEmpty()) {
            ProfilesI profile = this.alignViewport.getHmmProfiles();
            float m = this.updateInformationAnnotation(hmmSeqs.get(0), profile, null, infos);
            maxInformation = Math.max(maxInformation, m);
        }
        for (SequenceGroup group : alignment.getGroups()) {
            hmmSeqs = group.getHmmSequences();
            if (hmmSeqs.isEmpty()) continue;
            ProfilesI profiles = group.getHmmProfiles();
            float m = this.updateInformationAnnotation(hmmSeqs.get(0), profiles, group, infos);
            maxInformation = Math.max(maxInformation, m);
        }
        for (AlignmentAnnotation ann : infos) {
            ann.graphMax = maxInformation;
        }
    }

    protected float updateInformationAnnotation(SequenceI seq, ProfilesI profile, SequenceGroup group, List<AlignmentAnnotation> infos) {
        if (seq == null || profile == null) {
            return 0.0f;
        }
        AlignmentAnnotation ann = this.findOrCreateAnnotation(seq, group);
        seq.addAlignmentAnnotation(ann);
        infos.add(ann);
        float max = AAFrequency.completeInformation(ann, profile, profile.getStartColumn(), profile.getEndColumn() + 1);
        return max;
    }

    AlignmentAnnotation findOrCreateAnnotation(SequenceI seq, SequenceGroup group) {
        AlignmentAnnotation info = null;
        AlignmentI alignment = this.alignViewport.getAlignment();
        AlignmentAnnotation[] anns = alignment.getAlignmentAnnotation();
        if (anns != null) {
            for (AlignmentAnnotation ann : anns) {
                if (!HMM_CALC_ID.equals(ann.getCalcId()) || group != ann.groupRef) continue;
                info = ann;
                info.setSequenceRef(seq);
                info.label = seq.getName();
                break;
            }
        }
        if (info == null) {
            int aWidth = alignment.getWidth();
            String desc = MessageManager.getString("label.information_description");
            float graphMax = 6.52f;
            info = new AlignmentAnnotation(seq.getName(), desc, new Annotation[aWidth], 0.0f, graphMax, 1);
            info.setCalcId(HMM_CALC_ID);
            info.setSequenceRef(seq);
            info.groupRef = group;
            info.hasText = true;
            alignment.addAnnotation(info);
        }
        return info;
    }
}

