/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.util.MessageManager;
import jalview.util.Platform;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class BrowserLauncher {
    private static BrowserLauncher INSTANCE = null;
    private static String preferredBrowser = null;

    public static BrowserLauncher getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = new BrowserLauncher();
        return INSTANCE;
    }

    public static void openURL(String url) {
        if (Platform.isJS()) {
            try {
                Platform.openURL(url);
            }
            catch (Throwable t) {
                System.err.println("Couldn't open " + url);
                System.err.print(t.getStackTrace());
            }
            return;
        }
        Desktop d = Desktop.getDesktop();
        if (d != null && d.isSupported(Desktop.Action.BROWSE)) {
            try {
                d.browse(new URI(url));
            }
            catch (IOException e) {
                Console.warn(MessageManager.formatMessage("exception.browser_unable_to_launch", url));
                Console.warn(e.getMessage());
                Console.debug(Cache.getStackTraceString(e));
            }
            catch (URISyntaxException e1) {
                Console.warn(MessageManager.formatMessage("exception.browser_unable_to_launch", url));
                Console.warn(e1.getMessage());
                Console.debug(Cache.getStackTraceString(e1));
            }
        } else {
            Console.warn(MessageManager.formatMessage("exception.browser_os_not_supported", url));
        }
    }

    public static void resetBrowser() {
        BrowserLauncher.resetBrowser(false);
    }

    public static void resetBrowser(boolean removeIfNull) {
        String defaultBrowser;
        preferredBrowser = defaultBrowser = Cache.getProperty("DEFAULT_BROWSER");
        if (defaultBrowser != null || removeIfNull) {
            // empty if block
        }
    }

    public static List<String> getBrowserList() {
        return new ArrayList<String>();
    }

    public static String getBrowserSystemProperty() {
        return "jalview.default.browser";
    }
}

