/*
 * Decompiled with CFR 0.152.
 */
package jalview.structure;

import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.io.StructureFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mc_view.PDBChain;

public class PDBEntryUtils {
    protected static Pattern id_and_chain = Pattern.compile("(\\d[0-9A-Za-z]{3})[_:|]?([0-9A-Za-z]{1,2})?.*");

    public static String inferChainId(SequenceI seq) {
        String targetChainId;
        if (seq.getName().indexOf("|") > -1) {
            targetChainId = seq.getName().substring(seq.getName().lastIndexOf("|") + 1);
            if (targetChainId.length() > 1) {
                targetChainId = targetChainId.trim().length() == 0 ? " " : "";
            }
        } else {
            targetChainId = "";
        }
        return targetChainId;
    }

    public static List<PDBEntry> inferPDBEntry(SequenceI seq) {
        Matcher matcher = id_and_chain.matcher(seq.getName());
        if (matcher.matches()) {
            String id = matcher.group(1);
            PDBEntry pdbe = new PDBEntry();
            pdbe.setId(id);
            if (matcher.groupCount() > 1) {
                pdbe.setChainCode(matcher.group(2));
            }
            return List.of(pdbe);
        }
        return List.of();
    }

    public static List<PDBEntry> selectPutativePDBe(SequenceI seq, SequenceI ds, StructureFile pdb) {
        ArrayList<PDBEntry> putativePDBe = new ArrayList<PDBEntry>();
        Set<PDBEntry> possiblePDBe = PDBEntryUtils.gatherPDBEntries(seq, true);
        for (PDBEntry infPDBe : possiblePDBe) {
            if (!infPDBe.getId().equalsIgnoreCase(pdb.getId())) continue;
            putativePDBe.add(infPDBe);
        }
        return putativePDBe;
    }

    public static Set<PDBEntry> gatherPDBEntries(SequenceI seq, boolean inferFromName) {
        HashSet<PDBEntry> possiblePDBe = new HashSet<PDBEntry>();
        while (seq != null) {
            if (seq.getAllPDBEntries() != null) {
                possiblePDBe.addAll(seq.getAllPDBEntries());
            }
            if (inferFromName) {
                possiblePDBe.addAll(PDBEntryUtils.inferPDBEntry(seq));
            }
            seq = seq.getDatasetSequence();
        }
        return possiblePDBe;
    }

    public static PDBEntry selectPutativePDBEntry(List<PDBEntry> putativePDBe, PDBChain chain) {
        if (putativePDBe.isEmpty()) {
            return null;
        }
        PDBEntry putativeEntry = null;
        for (PDBEntry pdbe : putativePDBe) {
            if (pdbe.getChainCode() != null) {
                boolean hasChainCodes = true;
                if (!pdbe.getChainCode().equals(chain.id)) continue;
                putativeEntry = pdbe;
                return putativeEntry;
            }
            return pdbe;
        }
        return null;
    }
}

