/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.AlignViewportI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.HiddenMarkovModel;
import jalview.datamodel.SequenceI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ResidueColourScheme;
import jalview.util.ColorUtils;
import jalview.util.Comparison;
import java.awt.Color;
import java.util.List;
import java.util.Map;

public abstract class HmmerColourScheme
extends ResidueColourScheme {
    private static final Color INSERTION_COLOUR = new Color(230, 0, 0);
    private SequenceI hmmSeq;
    private HiddenMarkovModel hmm;
    private Map<Character, Float> frequencies;

    public HmmerColourScheme(List<SequenceI> hmmSeqs) {
        this.hmmSeq = hmmSeqs.isEmpty() ? null : hmmSeqs.get(0);
        this.hmm = this.hmmSeq == null ? null : this.hmmSeq.getHMM();
    }

    public HmmerColourScheme() {
    }

    @Override
    public Color findColour(char symbol, int column, SequenceI seq, String consensusResidue, float pid) {
        return this.findColour(symbol, column);
    }

    private Color findColour(char symbol, int column) {
        if (this.getHmm() == null || Comparison.isGap(symbol)) {
            return Color.white;
        }
        if (Comparison.isGap(this.hmmSeq.getCharAt(column))) {
            return INSERTION_COLOUR;
        }
        if (Character.isLowerCase(symbol)) {
            symbol = Character.toUpperCase(symbol);
        }
        double prob = this.getHmm().getMatchEmissionProbability(column, symbol);
        Float freq = Float.valueOf(0.0f);
        if (!this.frequencies.containsKey(Character.valueOf(symbol))) {
            return Color.WHITE;
        }
        freq = this.frequencies.get(Character.valueOf(symbol));
        double infoRatio = prob / (double)freq.floatValue();
        Color colour = Color.ORANGE;
        if (infoRatio >= 1.0) {
            float infoLog = (float)Math.log(infoRatio);
            colour = ColorUtils.getGraduatedColour(infoLog, 0.0f, Color.WHITE, this.getMaxInformationScore(), Color.blue);
        }
        return colour;
    }

    abstract float getMaxInformationScore();

    @Override
    public ColourSchemeI getInstance(AlignViewportI viewport, AnnotatedCollectionI ac) {
        return this.newInstance(ac);
    }

    protected abstract HmmerColourScheme newInstance(AnnotatedCollectionI var1);

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isApplicableTo(AnnotatedCollectionI ac) {
        return !ac.getHmmSequences().isEmpty();
    }

    protected Map<Character, Float> getFrequencies() {
        return this.frequencies;
    }

    protected void setFrequencies(Map<Character, Float> frequencies) {
        this.frequencies = frequencies;
    }

    protected HiddenMarkovModel getHmm() {
        return this.hmm;
    }

    protected SequenceI getHmmSequence() {
        return this.hmmSeq;
    }
}

