/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.api.AlignExportSettingsI;
import jalview.api.AlignmentViewPanel;
import jalview.datamodel.HMMNode;
import jalview.datamodel.HiddenMarkovModel;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.AlignmentFileReaderI;
import jalview.io.AlignmentFileWriterI;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class HMMFile
extends AlignFile
implements AlignmentFileReaderI,
AlignmentFileWriterI {
    private static final String TERMINATOR = "//";
    public static final String HMM = "HMM";
    public static final String NAME = "NAME";
    public static final String ACCESSION_NUMBER = "ACC";
    public static final String DESCRIPTION = "DESC";
    public static final String LENGTH = "LENG";
    public static final String MAX_LENGTH = "MAXL";
    public static final String ALPHABET = "ALPH";
    public static final String DATE = "DATE";
    public static final String COMMAND_LOG = "COM";
    public static final String NUMBER_OF_SEQUENCES = "NSEQ";
    public static final String EFF_NUMBER_OF_SEQUENCES = "EFFN";
    public static final String CHECK_SUM = "CKSUM";
    public static final String STATISTICS = "STATS";
    public static final String COMPO = "COMPO";
    public static final String GATHERING_THRESHOLD = "GA";
    public static final String TRUSTED_CUTOFF = "TC";
    public static final String NOISE_CUTOFF = "NC";
    public static final String VITERBI = "VITERBI";
    public static final String MSV = "MSV";
    public static final String FORWARD = "FORWARD";
    public static final String MAP = "MAP";
    public static final String REFERENCE_ANNOTATION = "RF";
    public static final String CONSENSUS_RESIDUE = "CONS";
    public static final String CONSENSUS_STRUCTURE = "CS";
    public static final String MASKED_VALUE = "MM";
    private static final String ALPH_AMINO = "amino";
    private static final String ALPH_DNA = "DNA";
    private static final String ALPH_RNA = "RNA";
    private static final String ALPHABET_AMINO = "ACDEFGHIKLMNPQRSTVWY";
    private static final String ALPHABET_DNA = "ACGT";
    private static final String ALPHABET_RNA = "ACGU";
    private static final int NUMBER_OF_TRANSITIONS = 7;
    private static final String SPACE = " ";
    private static final String TRANSITIONTYPELINE = "            m->m     m->i     m->d     i->m     i->i     d->m     d->d";
    private static String NL = System.lineSeparator();
    private HiddenMarkovModel hmm;
    private int numberOfSymbols;

    public HMMFile(String inFile, DataSourceType type) throws IOException {
        super(inFile, type);
    }

    public HMMFile(FileParse source) throws IOException {
        super(source);
    }

    public HMMFile() {
    }

    public HMMFile(HiddenMarkovModel markov) {
        this.hmm = markov;
    }

    public HiddenMarkovModel getHMM() {
        return this.hmm;
    }

    public String getName() {
        return this.hmm.getName();
    }

    @Override
    public void parse() {
        try {
            this.hmm = new HiddenMarkovModel();
            this.parseHeaderLines(this.dataIn);
            this.parseModel(this.dataIn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void parseHeaderLines(BufferedReader input) throws IOException {
        boolean readingHeaders = true;
        this.hmm.setFileHeader(input.readLine());
        String line = input.readLine();
        while (readingHeaders && line != null) {
            Object value;
            String key;
            Scanner parser = new Scanner(line);
            String next = parser.next();
            if (ALPHABET.equals(next)) {
                String alphabetType = parser.next();
                this.hmm.setProperty(ALPHABET, alphabetType);
                String alphabet = ALPH_DNA.equalsIgnoreCase(alphabetType) ? ALPHABET_DNA : (ALPH_RNA.equalsIgnoreCase(alphabetType) ? ALPHABET_RNA : ALPHABET_AMINO);
                this.numberOfSymbols = this.hmm.setAlphabet(alphabet);
            } else if (HMM.equals(next)) {
                readingHeaders = false;
                String symbols = line.substring(line.indexOf(HMM) + HMM.length());
                this.numberOfSymbols = this.hmm.setAlphabet(symbols);
            } else if (STATISTICS.equals(next)) {
                parser.next();
                key = parser.next();
                value = parser.next() + "  " + parser.next();
                this.hmm.setProperty(key, (String)value);
            } else {
                key = next;
                value = parser.next();
                while (parser.hasNext()) {
                    value = (String)value + SPACE + parser.next();
                }
                this.hmm.setProperty(key, (String)value);
            }
            parser.close();
            line = input.readLine();
        }
    }

    void parseModel(BufferedReader input) throws IOException {
        int nodeNo = 0;
        String line = input.readLine();
        ArrayList<HMMNode> nodes = new ArrayList<HMMNode>();
        while (line != null && !TERMINATOR.equals(line)) {
            HMMNode node = new HMMNode();
            nodes.add(node);
            Scanner scanner = new Scanner(line);
            String next = scanner.next();
            if (COMPO.equals(next) || nodeNo > 0) {
                double[] matches = HMMFile.parseDoubles(scanner, this.numberOfSymbols);
                node.setMatchEmissions(matches);
                if (!COMPO.equals(next)) {
                    int resNo = this.parseAnnotations(scanner, node);
                    if (resNo == 0) {
                        resNo = nodeNo;
                    }
                    node.setResidueNumber(resNo);
                }
                line = input.readLine();
            }
            scanner.close();
            scanner = new Scanner(line);
            double[] inserts = HMMFile.parseDoubles(scanner, this.numberOfSymbols);
            node.setInsertEmissions(inserts);
            scanner.close();
            line = input.readLine();
            scanner = new Scanner(line);
            double[] transitions = HMMFile.parseDoubles(scanner, 7);
            node.setStateTransitions(transitions);
            scanner.close();
            line = input.readLine();
            ++nodeNo;
        }
        this.hmm.setNodes(nodes);
    }

    int parseAnnotations(Scanner scanner, HMMNode node) {
        String value;
        int mapTo = 0;
        if (scanner.hasNext() && !"-".equals(value = scanner.next())) {
            try {
                mapTo = Integer.parseInt(value);
                node.setResidueNumber(mapTo);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (scanner.hasNext()) {
            node.setConsensusResidue(scanner.next().charAt(0));
        }
        if (scanner.hasNext()) {
            node.setReferenceAnnotation(scanner.next().charAt(0));
        }
        if (scanner.hasNext()) {
            node.setMaskValue(scanner.next().charAt(0));
        }
        if (scanner.hasNext()) {
            node.setConsensusStructure(scanner.next().charAt(0));
        }
        return mapTo;
    }

    static double[] parseDoubles(Scanner input, int numberOfElements) throws IOException {
        double[] values = new double[numberOfElements];
        for (int i = 0; i < numberOfElements; ++i) {
            if (!input.hasNext()) {
                throw new IOException("Incomplete data");
            }
            String next = input.next();
            if (next.contains("*")) {
                values[i] = Double.NEGATIVE_INFINITY;
                continue;
            }
            double prob = Double.valueOf(next);
            values[i] = prob = Math.pow(Math.E, -prob);
        }
        return values;
    }

    String addData(int initialColumnSeparation, int columnSeparation, List<String> data) {
        Object line = "";
        boolean first = true;
        for (String value : data) {
            int sep = first ? initialColumnSeparation : columnSeparation;
            line = (String)line + String.format("%" + sep + "s", value);
            first = false;
        }
        return line;
    }

    List<String> charListToStringList(List<Character> list) {
        ArrayList<String> strList = new ArrayList<String>();
        for (char value : list) {
            String strValue = Character.toString(value);
            strList.add(strValue);
        }
        return strList;
    }

    List<String> doublesToStringList(double[] doubles) {
        ArrayList<String> strList = new ArrayList<String>();
        for (double value : doubles) {
            String strValue = value > 0.0 ? String.format("%.5f", value) : (value == -0.0 ? "0.00000" : "*");
            strList.add(strValue);
        }
        return strList;
    }

    void appendModelAsString(StringBuilder output) {
        output.append(HMM).append("  ");
        String charSymbols = this.hmm.getSymbols();
        for (char c : charSymbols.toCharArray()) {
            output.append(String.format("%9s", Character.valueOf(c)));
        }
        output.append(NL).append(TRANSITIONTYPELINE);
        int length = this.hmm.getLength();
        for (int nodeNo = 0; nodeNo <= length; ++nodeNo) {
            Object matchLine = String.format("%7s", nodeNo == 0 ? COMPO : Integer.toString(nodeNo));
            double[] doubleMatches = this.convertToLogSpace(this.hmm.getNode(nodeNo).getMatchEmissions());
            List<String> strMatches = this.doublesToStringList(doubleMatches);
            matchLine = (String)matchLine + this.addData(10, 9, strMatches);
            if (nodeNo != 0) {
                matchLine = (String)matchLine + SPACE + this.hmm.getNodeMapPosition(nodeNo);
                matchLine = (String)matchLine + SPACE + this.hmm.getConsensusResidue(nodeNo);
                matchLine = (String)matchLine + SPACE + this.hmm.getReferenceAnnotation(nodeNo);
                if (this.hmm.getFileHeader().contains("HMMER3/f")) {
                    matchLine = (String)matchLine + SPACE + this.hmm.getMaskedValue(nodeNo);
                    matchLine = (String)matchLine + SPACE + this.hmm.getConsensusStructure(nodeNo);
                }
            }
            output.append(NL).append((String)matchLine);
            Object insertLine = "";
            double[] doubleInserts = this.convertToLogSpace(this.hmm.getNode(nodeNo).getInsertEmissions());
            List<String> strInserts = this.doublesToStringList(doubleInserts);
            insertLine = (String)insertLine + this.addData(17, 9, strInserts);
            output.append(NL).append((String)insertLine);
            Object transitionLine = "";
            double[] doubleTransitions = this.convertToLogSpace(this.hmm.getNode(nodeNo).getStateTransitions());
            List<String> strTransitions = this.doublesToStringList(doubleTransitions);
            transitionLine = (String)transitionLine + this.addData(17, 9, strTransitions);
            output.append(NL).append((String)transitionLine);
        }
    }

    void appendProperties(StringBuilder output) {
        output.append(this.hmm.getFileHeader());
        String format = "%n%-5s %1s";
        this.appendProperty(output, format, NAME);
        this.appendProperty(output, format, ACCESSION_NUMBER);
        this.appendProperty(output, format, DESCRIPTION);
        this.appendProperty(output, format, LENGTH);
        this.appendProperty(output, format, MAX_LENGTH);
        this.appendProperty(output, format, ALPHABET);
        this.appendBooleanProperty(output, format, REFERENCE_ANNOTATION);
        this.appendBooleanProperty(output, format, MASKED_VALUE);
        this.appendBooleanProperty(output, format, CONSENSUS_RESIDUE);
        this.appendBooleanProperty(output, format, CONSENSUS_STRUCTURE);
        this.appendBooleanProperty(output, format, MAP);
        this.appendProperty(output, format, DATE);
        this.appendProperty(output, format, NUMBER_OF_SEQUENCES);
        this.appendProperty(output, format, EFF_NUMBER_OF_SEQUENCES);
        this.appendProperty(output, format, CHECK_SUM);
        this.appendProperty(output, format, GATHERING_THRESHOLD);
        this.appendProperty(output, format, TRUSTED_CUTOFF);
        this.appendProperty(output, format, NOISE_CUTOFF);
        if (this.hmm.getMSV() != null) {
            format = "%n%-19s %18s";
            output.append(String.format(format, "STATS LOCAL MSV", this.hmm.getMSV()));
            output.append(String.format(format, "STATS LOCAL VITERBI", this.hmm.getViterbi()));
            output.append(String.format(format, "STATS LOCAL FORWARD", this.hmm.getForward()));
        }
    }

    private void appendBooleanProperty(StringBuilder output, String format, String propertyName) {
        boolean set = this.hmm.getBooleanProperty(propertyName);
        output.append(String.format(format, propertyName, set ? "yes" : "no"));
    }

    private void appendProperty(StringBuilder output, String format, String propertyName) {
        String value = this.hmm.getProperty(propertyName);
        if (value != null) {
            output.append(String.format(format, propertyName, value));
        }
    }

    @Override
    public String print(SequenceI[] sequences, boolean jvsuffix) {
        if (sequences[0].getHMM() != null) {
            this.hmm = sequences[0].getHMM();
        }
        return this.print();
    }

    public String print() {
        StringBuilder output = new StringBuilder();
        this.appendProperties(output);
        output.append(NL);
        this.appendModelAsString(output);
        output.append(NL).append(TERMINATOR).append(NL);
        return output.toString();
    }

    double[] convertToLogSpace(double[] ds) {
        double[] converted = new double[ds.length];
        for (int i = 0; i < ds.length; ++i) {
            double logProb;
            double prob = ds[i];
            converted[i] = logProb = -1.0 * Math.log(prob);
        }
        return converted;
    }

    @Override
    public SequenceI[] getSeqsAsArray() {
        SequenceI hmmSeq = this.hmm.getConsensusSequence();
        SequenceI[] seq = new SequenceI[]{hmmSeq};
        return seq;
    }

    @Override
    public void setNewlineString(String newLine) {
        NL = newLine;
    }

    @Override
    public void setExportSettings(AlignExportSettingsI exportSettings) {
    }

    @Override
    public void configureForView(AlignmentViewPanel viewpanel) {
    }

    @Override
    public boolean hasWarningMessage() {
        return false;
    }

    @Override
    public String getWarningMessage() {
        return "warning message";
    }
}

