/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignViewportI;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.SequenceGroup;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.PaintRefresher;
import jalview.renderer.ScaleRenderer;
import jalview.util.MappingUtils;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.viewmodel.ViewportListenerI;
import jalview.workers.AlignmentComparisonThread;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;

public class ScalePanel
extends JPanel
implements MouseMotionListener,
MouseListener,
ViewportListenerI {
    protected int offy = 4;
    public int width;
    protected AlignViewport av;
    AlignmentPanel ap;
    boolean stretchingGroup = false;
    int min;
    int max;
    boolean mouseDragging = false;
    int[] reveal;

    public ScalePanel(AlignViewport av, AlignmentPanel ap) {
        this.av = av;
        this.ap = ap;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        av.getRanges().addPropertyChangeListener(this);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        int res;
        this.min = res = this.ap.getSeqPanel().findAlignmentColumn(evt);
        this.max = res;
        if (evt.isPopupTrigger()) {
            this.rightMouseButtonPressed(evt, res);
            return;
        }
        if (Platform.isWinRightButton(evt)) {
            return;
        }
        this.leftMouseButtonPressed(evt, res);
    }

    protected void rightMouseButtonPressed(MouseEvent evt, int res) {
        JPopupMenu pop = this.buildPopupMenu(res);
        if (pop.getSubElements().length > 0) {
            pop.show(this, evt.getX(), evt.getY());
        }
    }

    protected JPopupMenu buildPopupMenu(final int res) {
        JMenuItem item;
        JPopupMenu pop = new JPopupMenu();
        final int[] hiddenRange = this.reveal;
        if (hiddenRange != null) {
            item = new JMenuItem(MessageManager.getString("label.reveal"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScalePanel.this.av.showColumn(hiddenRange[0]);
                    ScalePanel.this.reveal = null;
                    ScalePanel.this.updatePanel();
                }
            });
            pop.add(item);
            if (this.av.getAlignment().getHiddenColumns().hasMultiHiddenColumnRegions()) {
                item = new JMenuItem(MessageManager.getString("action.reveal_all"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ScalePanel.this.av.showAllHiddenColumns();
                        ScalePanel.this.reveal = null;
                        ScalePanel.this.updatePanel();
                    }
                });
                pop.add(item);
            }
        }
        if (this.av.getColumnSelection().contains(res)) {
            item = new JMenuItem(MessageManager.getString("label.hide_columns"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScalePanel.this.av.hideColumns(res, res);
                    if (ScalePanel.this.av.getSelectionGroup() != null && ScalePanel.this.av.getSelectionGroup().getSize() == ScalePanel.this.av.getAlignment().getHeight()) {
                        ScalePanel.this.av.setSelectionGroup(null);
                    }
                    ScalePanel.this.updatePanel();
                }
            });
            pop.add(item);
        }
        return pop;
    }

    protected void updatePanel() {
        this.ap.updateLayout();
        this.ap.paintAlignment(true, true);
        this.ap.updateScrollBarsFromRanges();
        this.av.sendSelection();
    }

    protected void leftMouseButtonPressed(MouseEvent evt, int res) {
        if (!Platform.isControlDown(evt) && !evt.isShiftDown()) {
            this.av.getColumnSelection().clear();
        }
        this.av.getColumnSelection().addElement(res);
        SequenceGroup sg = new SequenceGroup(this.av.getAlignment().getSequences());
        sg.setStartRes(res);
        sg.setEndRes(res);
        if (evt.isShiftDown()) {
            int min = Math.min(this.av.getColumnSelection().getMin(), res);
            int max = Math.max(this.av.getColumnSelection().getMax(), res);
            for (int i = min; i < max; ++i) {
                this.av.getColumnSelection().addElement(i);
            }
            sg.setStartRes(min);
            sg.setEndRes(max);
        }
        this.av.setSelectionGroup(sg);
        this.ap.paintAlignment(false, false);
        PaintRefresher.Refresh(this, this.av.getSequenceSetId());
        this.av.sendSelection();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        boolean wasDragging = this.mouseDragging;
        this.mouseDragging = false;
        this.ap.getSeqPanel().stopScrolling();
        int res = this.ap.getSeqPanel().findAlignmentColumn(evt);
        if (!this.stretchingGroup) {
            if (evt.isPopupTrigger()) {
                this.rightMouseButtonPressed(evt, res);
            } else {
                this.ap.paintAlignment(false, false);
            }
            return;
        }
        SequenceGroup sg = this.av.getSelectionGroup();
        if (sg != null) {
            if (res > sg.getStartRes()) {
                sg.setEndRes(res);
            } else if (res < sg.getStartRes()) {
                sg.setStartRes(res);
            }
            if (wasDragging) {
                this.min = Math.min(res, this.min);
                this.max = Math.max(res, this.max);
                this.av.getColumnSelection().stretchGroup(res, sg, this.min, this.max);
            }
        }
        this.stretchingGroup = false;
        this.ap.paintAlignment(false, false);
        this.av.isSelectionGroupChanged(true);
        this.av.isColSelChanged(true);
        PaintRefresher.Refresh(this.ap, this.av.getSequenceSetId());
        this.av.sendSelection();
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.mouseDragging = true;
        int res = this.ap.getSeqPanel().findAlignmentColumn(evt);
        ColumnSelection cs = this.av.getColumnSelection();
        this.min = Math.min(res, this.min);
        this.max = Math.max(res, this.max);
        SequenceGroup sg = this.av.getSelectionGroup();
        if (sg != null) {
            this.stretchingGroup = true;
            cs.stretchGroup(res, sg, this.min, this.max);
            this.ap.paintAlignment(false, false);
            PaintRefresher.Refresh(this.ap, this.av.getSequenceSetId());
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        if (this.mouseDragging) {
            this.mouseDragging = false;
            this.ap.getSeqPanel().stopScrolling();
        }
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        if (this.mouseDragging) {
            this.ap.getSeqPanel().startScrolling(new Point(evt.getX(), 0));
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.setToolTipText(null);
        this.reveal = null;
        int res = this.ap.getSeqPanel().findAlignmentColumn(evt);
        this.highlightAllStructPos(res);
        if (!this.av.getCalcManager().getWorkersOfClass(AlignmentComparisonThread.class).isEmpty()) {
            AlignmentI alignment = this.av.getAlignment();
            AlignViewportI codingComplement = this.av.getCodingComplement();
            List<AlignedCodonFrame> ourMappings = alignment.getCodonFrames();
            SearchResultsI mappedPos = MappingUtils.allMappedRegionsForColumn(res, ourMappings, alignment.getSequences(), codingComplement.getAlignment().getSequences(), alignment.getGapCharacter());
            if (mappedPos.getCount() > 0) {
                Desktop.getAlignFrameFor((AlignViewportI)codingComplement).alignPanel.getSeqPanel().seqCanvas.highlightSearchResults(mappedPos, true);
            }
        }
        if (!this.av.hasHiddenColumns()) {
            return;
        }
        this.reveal = this.av.getAlignment().getHiddenColumns().getRegionWithEdgeAtRes(this.av.getAlignment().getHiddenColumns().absoluteToVisibleColumn(res));
        if (this.reveal == null) {
            return;
        }
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setToolTipText(MessageManager.getString("label.reveal_hidden_columns"));
        this.repaint();
    }

    public void highlightAllStructPos(int col) {
        this.ap.getStructureSelectionManager().highlightPositionsOnMany(this.ap.av.getAlignment().getSequencesArray(), new int[]{col, col}, this.ap);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.av.getWrapAlignment()) {
            this.drawScale(g, this.av.getRanges().getStartRes(), this.av.getRanges().getEndRes(), this.getWidth(), this.getHeight());
        }
    }

    public void drawScale(Graphics g, int startx, int endx, int width, int height) {
        Graphics2D gg = (Graphics2D)g;
        gg.setFont(this.av.getFont());
        if (this.av.antiAlias) {
            gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        gg.setColor(Color.white);
        gg.fillRect(0, 0, width, height);
        gg.setColor(Color.black);
        ColumnSelection cs = this.av.getColumnSelection();
        HiddenColumns hidden = this.av.getAlignment().getHiddenColumns();
        int avCharWidth = this.av.getCharWidth();
        int avCharHeight = this.av.getCharHeight();
        if (cs != null) {
            gg.setColor(new Color(220, 0, 0));
            for (int sel : cs.getSelected()) {
                if (this.av.hasHiddenColumns()) {
                    if (!hidden.isVisible(sel)) continue;
                    sel = hidden.absoluteToVisibleColumn(sel);
                }
                if (sel < startx || sel > endx) continue;
                gg.fillRect((sel - startx) * avCharWidth, 0, avCharWidth, this.getHeight());
            }
        }
        int widthx = 1 + endx - startx;
        FontMetrics fm = gg.getFontMetrics(this.av.getFont());
        int y = avCharHeight;
        int yOf = fm.getDescent();
        y -= yOf;
        if (this.av.hasHiddenColumns()) {
            gg.setColor(Color.blue);
            if (this.av.getShowHiddenMarkers()) {
                Iterator<Integer> it = hidden.getStartRegionIterator(startx, startx + widthx + 1);
                while (it.hasNext()) {
                    int res = it.next() - startx;
                    gg.fillPolygon(new int[]{-1 + res * avCharWidth - avCharHeight / 4, -1 + res * avCharWidth + avCharHeight / 4, -1 + res * avCharWidth}, new int[]{y, y, y + 2 * yOf}, 3);
                }
            }
        }
        gg.setColor(Color.black);
        int maxX = 0;
        List<ScaleRenderer.ScaleMark> marks = new ScaleRenderer().calculateMarks(this.av, startx, endx);
        for (ScaleRenderer.ScaleMark mark : marks) {
            boolean major = mark.major;
            int mpos = mark.column;
            String mstring = mark.text;
            if (mstring != null && mpos * avCharWidth > maxX) {
                gg.drawString(mstring, mpos * avCharWidth, y);
                maxX = (mpos + 2) * avCharWidth + fm.stringWidth(mstring);
            }
            if (major) {
                gg.drawLine(mpos * avCharWidth + avCharWidth / 2, y + 2, mpos * avCharWidth + avCharWidth / 2, y + yOf * 2);
                continue;
            }
            gg.drawLine(mpos * avCharWidth + avCharWidth / 2, y + yOf, mpos * avCharWidth + avCharWidth / 2, y + yOf * 2);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("startres") || evt.getPropertyName().equals("startresandseq") || evt.getPropertyName().equals("move_viewport")) {
            ((AlignmentPanel)this.av.getAlignPanel()).repaint();
        }
    }
}

