/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.android;

import jalview.ext.android.ContainerHelpers;

public class SparseDoubleArray
implements Cloneable {
    private int[] mKeys;
    private double[] mValues;
    private int mSize;

    public SparseDoubleArray() {
        this(10);
    }

    public SparseDoubleArray(int initialCapacity) {
        if (initialCapacity == 0) {
            this.mKeys = ContainerHelpers.EMPTY_INTS;
            this.mValues = ContainerHelpers.EMPTY_DOUBLES;
        } else {
            initialCapacity = SparseDoubleArray.idealDoubleArraySize(initialCapacity);
            this.mKeys = new int[initialCapacity];
            this.mValues = new double[initialCapacity];
        }
        this.mSize = 0;
    }

    public SparseDoubleArray(double[] row) {
        this();
        for (int i = 0; i < row.length; ++i) {
            if (row[i] == 0.0) continue;
            this.put(i, row[i]);
        }
    }

    public SparseDoubleArray clone() {
        SparseDoubleArray clone = null;
        try {
            clone = (SparseDoubleArray)super.clone();
            clone.mKeys = (int[])this.mKeys.clone();
            clone.mValues = (double[])this.mValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public double get(int key) {
        return this.get(key, 0.0);
    }

    public double get(int key, double valueIfKeyNotFound) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i < 0) {
            return valueIfKeyNotFound;
        }
        return this.mValues[i];
    }

    public void delete(int key) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0) {
            this.removeAt(i);
        }
    }

    public void removeAt(int index) {
        System.arraycopy(this.mKeys, index + 1, this.mKeys, index, this.mSize - (index + 1));
        System.arraycopy(this.mValues, index + 1, this.mValues, index, this.mSize - (index + 1));
        --this.mSize;
    }

    public void put(int key, double value) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0) {
            this.mValues[i] = value;
        } else {
            i ^= 0xFFFFFFFF;
            if (this.mSize >= this.mKeys.length) {
                int n = SparseDoubleArray.idealDoubleArraySize(this.mSize + 1);
                int[] nkeys = new int[n];
                double[] nvalues = new double[n];
                System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
                this.mKeys = nkeys;
                this.mValues = nvalues;
            }
            if (this.mSize - i != 0) {
                System.arraycopy(this.mKeys, i, this.mKeys, i + 1, this.mSize - i);
                System.arraycopy(this.mValues, i, this.mValues, i + 1, this.mSize - i);
            }
            this.mKeys[i] = key;
            this.mValues[i] = value;
            ++this.mSize;
        }
    }

    public int size() {
        return this.mSize;
    }

    public int keyAt(int index) {
        return this.mKeys[index];
    }

    public double valueAt(int index) {
        return this.mValues[index];
    }

    public int indexOfKey(int key) {
        return ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
    }

    public int indexOfValue(double value) {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.mSize = 0;
    }

    public void append(int key, double value) {
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        int pos = this.mSize;
        if (pos >= this.mKeys.length) {
            int n = SparseDoubleArray.idealDoubleArraySize(pos + 1);
            int[] nkeys = new int[n];
            double[] nvalues = new double[n];
            System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
            this.mKeys = nkeys;
            this.mValues = nvalues;
        }
        this.mKeys[pos] = key;
        this.mValues[pos] = value;
        this.mSize = pos + 1;
    }

    public static int idealDoubleArraySize(int need) {
        return SparseDoubleArray.idealByteArraySize(need * 8) / 8;
    }

    public static int idealByteArraySize(int need) {
        for (int i = 4; i < 32; ++i) {
            if (need > (1 << i) - 12) continue;
            return (1 << i) - 12;
        }
        return need;
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            int key = this.keyAt(i);
            buffer.append(key);
            buffer.append('=');
            double value = this.valueAt(i);
            buffer.append(value);
        }
        buffer.append('}');
        return buffer.toString();
    }

    public double add(int key, double toAdd) {
        double newValue = toAdd;
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0) {
            int n = i;
            this.mValues[n] = this.mValues[n] + toAdd;
            newValue = this.mValues[i];
        } else {
            i ^= 0xFFFFFFFF;
            if (this.mSize >= this.mKeys.length) {
                int n = SparseDoubleArray.idealDoubleArraySize(this.mSize + 1);
                int[] nkeys = new int[n];
                double[] nvalues = new double[n];
                System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
                this.mKeys = nkeys;
                this.mValues = nvalues;
            }
            if (this.mSize - i != 0) {
                System.arraycopy(this.mKeys, i, this.mKeys, i + 1, this.mSize - i);
                System.arraycopy(this.mValues, i, this.mValues, i + 1, this.mSize - i);
            }
            this.mKeys[i] = key;
            this.mValues[i] = toAdd;
            ++this.mSize;
        }
        return newValue;
    }

    public double divide(int key, double divisor) {
        double newValue = 0.0;
        if (divisor == 0.0) {
            return newValue;
        }
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0) {
            int n = i;
            this.mValues[n] = this.mValues[n] / divisor;
            newValue = this.mValues[i];
        }
        return newValue;
    }
}

