/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.AlignedCodon;
import jalview.datamodel.IncompleteCodonException;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.util.Comparison;
import jalview.util.MapList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Mapping {
    MapList map = null;
    SequenceI to = null;
    private String mappedFromId;

    public Mapping(MapList map) {
        this.map = map;
    }

    public Mapping(SequenceI to, MapList map) {
        this(map);
        this.to = to;
    }

    public Mapping(SequenceI to, int[] exon, int[] is, int i, int j) {
        this(to, new MapList(exon, is, i, j));
    }

    public Mapping(Mapping map2) {
        if (map2 != this && map2 != null) {
            if (map2.map != null) {
                this.map = new MapList(map2.map);
            }
            this.to = map2.to;
            this.mappedFromId = map2.mappedFromId;
        }
    }

    public MapList getMap() {
        return this.map;
    }

    public void setMap(MapList map) {
        this.map = map;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Mapping)) {
            return false;
        }
        Mapping other = (Mapping)o;
        if (other == this) {
            return true;
        }
        if (other.to != this.to) {
            return false;
        }
        if (this.map != null && other.map == null || this.map == null && other.map != null) {
            return false;
        }
        return this.map == null && other.map == null || this.map.equals(other.map);
    }

    public int hashCode() {
        int hashCode;
        int n = hashCode = this.to == null ? 1 : this.to.hashCode();
        if (this.map != null) {
            hashCode = hashCode * 31 + this.map.hashCode();
        }
        return hashCode;
    }

    public int getPosition(int mpos) {
        int[] mp;
        if (this.map != null && (mp = this.map.shiftTo(mpos)) != null) {
            return mp[0];
        }
        return mpos;
    }

    public int getWidth() {
        if (this.map != null) {
            return this.map.getFromRatio();
        }
        return 1;
    }

    public int getMappedWidth() {
        if (this.map != null) {
            return this.map.getToRatio();
        }
        return 1;
    }

    public int getMappedPosition(int pos) {
        int[] mp;
        if (this.map != null && (mp = this.map.shiftFrom(pos)) != null) {
            return mp[0];
        }
        return pos;
    }

    public int[] getMappedWord(int pos) {
        int[] mp;
        if (this.map != null && (mp = this.map.shiftFrom(pos)) != null) {
            return new int[]{mp[0], mp[0] + mp[2] * (this.map.getToRatio() - 1)};
        }
        return null;
    }

    public SequenceFeature[] locateFeature(SequenceFeature f) {
        if (this.map != null) {
            int[] frange = this.map.locateInFrom(f.getBegin(), f.getEnd());
            if (frange == null) {
                return null;
            }
            SequenceFeature[] vf = new SequenceFeature[frange.length / 2];
            int i = 0;
            int v = 0;
            while (i < frange.length) {
                vf[v] = new SequenceFeature(f, frange[i], frange[i + 1], f.getFeatureGroup(), f.getScore());
                if (frange.length > 2) {
                    vf[v].setDescription(f.getDescription() + "\nPart " + (v + 1));
                }
                i += 2;
                ++v;
            }
            return vf;
        }
        return new SequenceFeature[]{f};
    }

    public int[] locateRange(int from, int to) {
        if (this.map != null) {
            if (from <= to) {
                from = this.map.getToLowest() < from ? from : this.map.getToLowest();
                int n = to = this.map.getToHighest() > to ? to : this.map.getToHighest();
                if (from > to) {
                    return null;
                }
            } else {
                from = this.map.getToHighest() > from ? from : this.map.getToHighest();
                int n = to = this.map.getToLowest() < to ? to : this.map.getToLowest();
                if (from < to) {
                    return null;
                }
            }
            return this.map.locateInFrom(from, to);
        }
        return new int[]{from, to};
    }

    public int[] locateMappedRange(int from, int to) {
        if (this.map != null) {
            if (from <= to) {
                from = this.map.getFromLowest() < from ? from : this.map.getFromLowest();
                int n = to = this.map.getFromHighest() > to ? to : this.map.getFromHighest();
                if (from > to) {
                    return null;
                }
            } else {
                from = this.map.getFromHighest() > from ? from : this.map.getFromHighest();
                int n = to = this.map.getFromLowest() < to ? to : this.map.getFromLowest();
                if (from < to) {
                    return null;
                }
            }
            return this.map.locateInTo(from, to);
        }
        return new int[]{from, to};
    }

    public Mapping intersectVisContigs(int[] viscontigs) {
        Mapping copy = new Mapping(this);
        if (this.map != null) {
            int f;
            boolean vpos = false;
            boolean apos = false;
            Vector<int[]> toRange = new Vector<int[]>();
            Vector<int[]> fromRange = new Vector<int[]>();
            for (int vc = 0; vc < viscontigs.length; vc += 2) {
                int[] mpr = this.locateMappedRange(1 + viscontigs[vc], viscontigs[vc + 1] - 1);
                if (mpr == null) continue;
                for (int m = 0; m < mpr.length; m += 2) {
                    toRange.addElement(new int[]{mpr[m], mpr[m + 1]});
                    int[] xpos = this.locateRange(mpr[m], mpr[m + 1]);
                    for (int x = 0; x < xpos.length; x += 2) {
                        fromRange.addElement(new int[]{xpos[x], xpos[x + 1]});
                    }
                }
            }
            int[] from = new int[fromRange.size() * 2];
            int[] to = new int[toRange.size() * 2];
            int fSize = fromRange.size();
            for (f = 0; f < fSize; ++f) {
                int[] r = (int[])fromRange.elementAt(f);
                from[f * 2] = r[0];
                from[f * 2 + 1] = r[1];
            }
            fSize = toRange.size();
            for (f = 0; f < fSize; ++f) {
                int[] r = (int[])toRange.elementAt(f);
                to[f * 2] = r[0];
                to[f * 2 + 1] = r[1];
            }
            copy.setMap(new MapList(from, to, this.map.getFromRatio(), this.map.getToRatio()));
        }
        return copy;
    }

    public SequenceI getTo() {
        return this.to;
    }

    public void setTo(SequenceI tto) {
        this.to = tto;
    }

    public Iterator<AlignedCodon> getCodonIterator(SequenceI seq, char gapChar) {
        return new AlignedCodonIterator(seq, gapChar);
    }

    public String toString() {
        return String.format("%s %s", this.map.toString(), this.to == null ? "" : this.to.getName());
    }

    public String getMappedFromId() {
        return this.mappedFromId;
    }

    public void setMappedFromId(String mappedFromId) {
        this.mappedFromId = mappedFromId;
    }

    public class AlignedCodonIterator
    implements Iterator<AlignedCodon> {
        private final char gap;
        private final SequenceI alignedSeq;
        private int start;
        private int alignedColumn = 0;
        private int alignedBases = 0;
        private Iterator<int[]> fromRanges;
        private Iterator<int[]> toRanges;
        private int[] currentFromRange = null;
        private int[] currentToRange = null;
        private int fromPosition = 0;
        private int toPosition = 0;

        public AlignedCodonIterator(SequenceI seq, char gapChar) {
            this.alignedSeq = seq;
            this.start = seq.getStart();
            this.gap = gapChar;
            this.fromRanges = Mapping.this.map.getFromRanges().iterator();
            this.toRanges = Mapping.this.map.getToRanges().iterator();
            if (this.fromRanges.hasNext()) {
                this.currentFromRange = this.fromRanges.next();
                this.fromPosition = this.currentFromRange[0];
            }
            if (this.toRanges.hasNext()) {
                this.currentToRange = this.toRanges.next();
                this.toPosition = this.currentToRange[0];
            }
        }

        @Override
        public boolean hasNext() {
            if (this.fromRanges.hasNext()) {
                return true;
            }
            return this.currentFromRange != null && this.fromPosition < this.currentFromRange[1];
        }

        @Override
        public AlignedCodon next() throws IncompleteCodonException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int[] codon = this.getNextCodon();
            int[] alignedCodon = this.getAlignedCodon(codon);
            String peptide = this.getPeptide();
            int peptideCol = this.toPosition - 1 - Mapping.this.to.getStart();
            return new AlignedCodon(alignedCodon[0], alignedCodon[1], alignedCodon[2], peptide, peptideCol);
        }

        private String getPeptide() {
            if (this.toPosition <= this.currentToRange[1]) {
                SequenceI seq = Mapping.this.to;
                char pep = seq.getCharAt(this.toPosition - seq.getStart());
                ++this.toPosition;
                return String.valueOf(pep);
            }
            if (!this.toRanges.hasNext()) {
                throw new NoSuchElementException("Ran out of peptide at position " + this.toPosition);
            }
            this.currentToRange = this.toRanges.next();
            this.toPosition = this.currentToRange[0];
            return this.getPeptide();
        }

        private int[] getNextCodon() {
            int[] codon = new int[3];
            int codonbase = 0;
            while (codonbase < 3) {
                if (this.fromPosition <= this.currentFromRange[1]) {
                    codon[codonbase++] = this.fromPosition++;
                    continue;
                }
                if (!this.fromRanges.hasNext()) {
                    throw new IncompleteCodonException();
                }
                this.currentFromRange = this.fromRanges.next();
                this.fromPosition = this.currentFromRange[0];
            }
            return codon;
        }

        private int[] getAlignedCodon(int[] codon) {
            int[] aligned = new int[codon.length];
            for (int i = 0; i < codon.length; ++i) {
                aligned[i] = this.getAlignedColumn(codon[i]);
            }
            return aligned;
        }

        private int getAlignedColumn(int sequencePos) {
            int truePos = sequencePos - (this.start - 1);
            int length = this.alignedSeq.getLength();
            while (this.alignedBases < truePos && this.alignedColumn < length) {
                char c;
                if ((c = this.alignedSeq.getCharAt(this.alignedColumn++)) == this.gap || Comparison.isGap(c)) continue;
                ++this.alignedBases;
            }
            return this.alignedColumn - 1;
        }

        @Override
        public void remove() {
        }
    }
}

