/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import jalview.analysis.AlignmentUtils;
import jalview.analysis.SequenceIdMatcher;
import jalview.api.StructureSelectionManagerProvider;
import jalview.appletgui.AlignFrame;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.EmbmenuFrame;
import jalview.appletgui.FeatureSettings;
import jalview.appletgui.SplitFrame;
import jalview.appletgui.js.JSFunctionExec;
import jalview.appletgui.js.JalviewLiteJsApi;
import jalview.appletgui.js.JsCallBack;
import jalview.appletgui.js.JsSelectionSender;
import jalview.appletgui.js.MouseOverListener;
import jalview.appletgui.js.MouseOverStructureListener;
import jalview.bin.Console;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentOrder;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.io.AnnotationFile;
import jalview.io.AppletFormatAdapter;
import jalview.io.DataSourceType;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.io.FileParse;
import jalview.io.IdentifyFile;
import jalview.io.JPredFile;
import jalview.io.JnetAnnotationMaker;
import jalview.io.NewickFile;
import jalview.structure.SelectionListener;
import jalview.structure.StructureSelectionManager;
import jalview.util.ColorUtils;
import jalview.util.HttpUtils;
import jalview.util.MessageManager;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.javascript.JSObject;

public class JalviewLite
extends Applet
implements StructureSelectionManagerProvider,
JalviewLiteJsApi {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private Vector<JSFunctionExec> javascriptListeners = new Vector();
    private JSFunctionExec jsFunctionExec;
    public static int lastFrameX = 200;
    public static int lastFrameY = 200;
    boolean fileFound = true;
    String file = "No file";
    String file2 = null;
    Button launcher = new Button(MessageManager.getString("label.start_jalview"));
    public AlignFrame currentAlignFrame = null;
    AlignFrame initialAlignFrame = null;
    boolean embedded = false;
    private boolean checkForJmol = true;
    private boolean checkedForJmol = false;
    public boolean jmolAvailable = false;
    private boolean alignPdbStructures = false;
    public boolean useXtrnalSviewer = false;
    public static boolean debug = false;
    static String builddate = null;
    static String version = null;
    static String installation = null;
    protected String separator = "\u00ac";
    public boolean jsfallbackEnabled = false;
    private Hashtable<String, long[]> jshashes = new Hashtable();
    private Hashtable<String, Hashtable<String, String[]>> jsmessages = new Hashtable();
    private Vector jsExecQueue = new Vector();

    public StructureSelectionManager getStructureSelectionManager() {
        return StructureSelectionManager.getStructureSelectionManager(this);
    }

    @Override
    public String getSelectedSequences() {
        return this.getSelectedSequencesFrom(this.getDefaultTargetFrame());
    }

    @Override
    public String getSelectedSequences(String sep) {
        return this.getSelectedSequencesFrom(this.getDefaultTargetFrame(), sep);
    }

    @Override
    public String getSelectedSequencesFrom(AlignFrame alf) {
        return this.getSelectedSequencesFrom(alf, this.separator);
    }

    @Override
    public String getSelectedSequencesFrom(AlignFrame alf, String sep) {
        StringBuffer result = new StringBuffer("");
        if (sep == null || sep.length() == 0) {
            sep = this.separator;
        }
        if (alf.viewport.getSelectionGroup() != null) {
            SequenceI[] seqs = alf.viewport.getSelectionGroup().getSequencesInOrder(alf.viewport.getAlignment());
            for (int i = 0; i < seqs.length; ++i) {
                result.append(seqs[i].getName());
                result.append(sep);
            }
        }
        return result.toString();
    }

    @Override
    public void highlight(String sequenceId, String position, String alignedPosition) {
        this.highlightIn(this.getDefaultTargetFrame(), sequenceId, position, alignedPosition);
    }

    @Override
    public void highlightIn(AlignFrame alf, String sequenceId, String position, String alignedPosition) {
        SequenceIdMatcher matcher = new SequenceIdMatcher(alf.viewport.getAlignment().getSequencesArray());
        final SequenceI sq = matcher.findIdMatch(sequenceId);
        if (sq != null) {
            int apos = -1;
            try {
                apos = Integer.valueOf(position);
            }
            catch (NumberFormatException ex) {
                return;
            }
            final JalviewLite me = this;
            final int pos = --apos;
            if (alignedPosition != null && (alignedPosition.trim().length() == 0 || alignedPosition.toLowerCase(Locale.ROOT).indexOf(FALSE) > -1)) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StructureSelectionManager.getStructureSelectionManager(me).mouseOverVamsasSequence(sq, sq.findIndex(pos), null);
                    }
                });
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StructureSelectionManager.getStructureSelectionManager(me).mouseOverVamsasSequence(sq, pos, null);
                    }
                });
            }
        }
    }

    @Override
    public void select(String sequenceIds, String columns) {
        this.selectIn(this.getDefaultTargetFrame(), sequenceIds, columns, this.separator);
    }

    @Override
    public void select(String sequenceIds, String columns, String sep) {
        this.selectIn(this.getDefaultTargetFrame(), sequenceIds, columns, sep);
    }

    @Override
    public void selectIn(AlignFrame alf, String sequenceIds, String columns) {
        this.selectIn(alf, sequenceIds, columns, this.separator);
    }

    @Override
    public void selectIn(final AlignFrame alf, String sequenceIds, String columns, String sep) {
        if (sep == null || sep.length() == 0) {
            sep = this.separator;
        } else if (debug) {
            Console.errPrintln("Selecting region using separator string '" + this.separator + "'");
        }
        String[] ids = JalviewLite.separatorListToArray(sequenceIds, sep);
        String[] cols = JalviewLite.separatorListToArray(columns, sep);
        final SequenceGroup sel = new SequenceGroup();
        final ColumnSelection csel = new ColumnSelection();
        AlignmentI al = alf.viewport.getAlignment();
        SequenceIdMatcher matcher = new SequenceIdMatcher(alf.viewport.getAlignment().getSequencesArray());
        int start = 0;
        int end = al.getWidth();
        int alw = al.getWidth();
        boolean seqsfound = true;
        if (ids != null && ids.length > 0) {
            seqsfound = false;
            for (int i = 0; i < ids.length; ++i) {
                SequenceI sq;
                if (ids[i].trim().length() == 0 || (sq = matcher.findIdMatch(ids[i])) == null) continue;
                seqsfound = true;
                sel.addSequence(sq, false);
            }
        }
        boolean inseqpos = false;
        if (cols != null && cols.length > 0) {
            boolean seset = false;
            for (int i = 0; i < cols.length; ++i) {
                String cl = cols[i].trim();
                if (cl.length() == 0) continue;
                int p = cl.indexOf("-");
                if (p > -1) {
                    int from = -1;
                    int to = -1;
                    try {
                        from = Integer.valueOf(cl.substring(0, p));
                        --from;
                    }
                    catch (NumberFormatException ex) {
                        Console.errPrintln("ERROR: Couldn't parse first integer in range element column selection string '" + cl + "' - format is 'from-to'");
                        return;
                    }
                    try {
                        to = Integer.valueOf(cl.substring(p + 1));
                    }
                    catch (NumberFormatException ex) {
                        Console.errPrintln("ERROR: Couldn't parse second integer in range element column selection string '" + cl + "' - format is 'from-to'");
                        return;
                    }
                    if (from >= 0 && --to >= 0) {
                        if (from < to) {
                            int t = to;
                            to = from;
                            to = t;
                        }
                        if (!seset) {
                            start = from;
                            end = to;
                            seset = true;
                        } else {
                            if (start > from) {
                                start = from;
                            }
                            if (end < to) {
                                end = to;
                            }
                        }
                        for (int r = from; r <= to; ++r) {
                            if (r < 0 || r >= alw) continue;
                            csel.addElement(r);
                        }
                        if (!debug) continue;
                        Console.errPrintln("Range '" + cl + "' deparsed as [" + from + "," + to + "]");
                        continue;
                    }
                    Console.errPrintln("ERROR: Invalid Range '" + cl + "' deparsed as [" + from + "," + to + "]");
                    continue;
                }
                int r = -1;
                try {
                    r = Integer.valueOf(cl);
                    --r;
                }
                catch (NumberFormatException ex) {
                    if (cl.toLowerCase(Locale.ROOT).equals("sequence")) {
                        inseqpos = true;
                    }
                    Console.errPrintln("ERROR: Couldn't parse integer from point selection element of column selection string '" + cl + "'");
                    return;
                }
                if (r >= 0 && r <= alw) {
                    if (!seset) {
                        start = r;
                        end = r;
                        seset = true;
                    } else {
                        if (start > r) {
                            start = r;
                        }
                        if (end < r) {
                            end = r;
                        }
                    }
                    csel.addElement(r);
                    if (!debug) continue;
                    Console.errPrintln("Point selection '" + cl + "' deparsed as [" + r + "]");
                    continue;
                }
                Console.errPrintln("ERROR: Invalid Point selection '" + cl + "' deparsed as [" + r + "]");
            }
        }
        if (seqsfound) {
            if (inseqpos && sel.getSize() > 0) {
                SequenceI rs = sel.getSequenceAt(0);
                start = rs.findIndex(start);
                end = rs.findIndex(end);
                ArrayList<Integer> cs = new ArrayList<Integer>(csel.getSelected());
                csel.clear();
                for (Integer selectedCol : cs) {
                    csel.addElement(rs.findIndex(selectedCol));
                }
            }
            sel.setStartRes(start);
            sel.setEndRes(end);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    alf.select(sel, csel, alf.getAlignViewport().getAlignment().getHiddenColumns());
                }
            });
        }
    }

    @Override
    public String getSelectedSequencesAsAlignment(String format, String suffix) {
        return this.getSelectedSequencesAsAlignmentFrom(this.getDefaultTargetFrame(), format, suffix);
    }

    @Override
    public String getSelectedSequencesAsAlignmentFrom(AlignFrame alf, String format, String suffix) {
        try {
            FileFormatI theFormat = FileFormats.getInstance().forName(format);
            boolean seqlimits = suffix.equalsIgnoreCase(TRUE);
            if (alf.viewport.getSelectionGroup() != null) {
                String reply = new AppletFormatAdapter().formatSequences(theFormat, new Alignment(alf.viewport.getSelectionAsNewSequence()), seqlimits);
                return reply;
            }
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return "Error retrieving alignment, possibly invalid format specifier: " + format;
        }
        return "";
    }

    @Override
    public String getAlignmentOrder() {
        return this.getAlignmentOrderFrom(this.getDefaultTargetFrame());
    }

    @Override
    public String getAlignmentOrderFrom(AlignFrame alf) {
        return this.getAlignmentOrderFrom(alf, this.separator);
    }

    @Override
    public String getAlignmentOrderFrom(AlignFrame alf, String sep) {
        AlignmentI alorder = alf.getAlignViewport().getAlignment();
        String[] order = new String[alorder.getHeight()];
        for (int i = 0; i < order.length; ++i) {
            order[i] = alorder.getSequenceAt(i).getName();
        }
        return this.arrayToSeparatorList(order);
    }

    @Override
    public String orderBy(String order, String undoName) {
        return this.orderBy(order, undoName, this.separator);
    }

    @Override
    public String orderBy(String order, String undoName, String sep) {
        return this.orderAlignmentBy(this.getDefaultTargetFrame(), order, undoName, sep);
    }

    @Override
    public String orderAlignmentBy(AlignFrame alf, String order, String undoName, String sep) {
        String _undoName;
        String[] ids = JalviewLite.separatorListToArray(order, sep);
        SequenceI[] sqs = null;
        if (ids != null && ids.length > 0) {
            SequenceIdMatcher matcher = new SequenceIdMatcher(alf.viewport.getAlignment().getSequencesArray());
            int s = 0;
            sqs = new SequenceI[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                SequenceI sq;
                if (ids[i].trim().length() == 0 || (sq = matcher.findIdMatch(ids[i])) == null) continue;
                sqs[s++] = sq;
            }
            if (s > 0) {
                SequenceI[] sqq = new SequenceI[s];
                System.arraycopy(sqs, 0, sqq, 0, s);
                sqs = sqq;
            } else {
                sqs = null;
            }
        }
        if (sqs == null) {
            return "";
        }
        AlignmentOrder aorder = new AlignmentOrder(sqs);
        if (undoName != null && undoName.trim().length() == 0) {
            undoName = null;
        }
        return alf.sortBy(aorder, _undoName = undoName) ? TRUE : "";
    }

    @Override
    public String getAlignment(String format) {
        return this.getAlignmentFrom(this.getDefaultTargetFrame(), format, TRUE);
    }

    @Override
    public String getAlignmentFrom(AlignFrame alf, String format) {
        return this.getAlignmentFrom(alf, format, TRUE);
    }

    @Override
    public String getAlignment(String format, String suffix) {
        return this.getAlignmentFrom(this.getDefaultTargetFrame(), format, suffix);
    }

    @Override
    public String getAlignmentFrom(AlignFrame alf, String format, String suffix) {
        try {
            boolean seqlimits = suffix.equalsIgnoreCase(TRUE);
            FileFormatI theFormat = FileFormats.getInstance().forName(format);
            String reply = new AppletFormatAdapter().formatSequences(theFormat, alf.viewport.getAlignment(), seqlimits);
            return reply;
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return "Error retrieving alignment, possibly invalid format specifier: " + format;
        }
    }

    @Override
    public void loadAnnotation(String annotation) {
        this.loadAnnotationFrom(this.getDefaultTargetFrame(), annotation);
    }

    @Override
    public void loadAnnotationFrom(AlignFrame alf, String annotation) {
        if (new AnnotationFile().annotateAlignmentView(alf.getAlignViewport(), annotation, DataSourceType.PASTE)) {
            alf.alignPanel.fontChanged();
            alf.alignPanel.setScrollValues(0, 0);
        } else {
            alf.parseFeaturesFile(annotation, DataSourceType.PASTE);
        }
    }

    @Override
    public void loadFeatures(String features, boolean autoenabledisplay) {
        this.loadFeaturesFrom(this.getDefaultTargetFrame(), features, autoenabledisplay);
    }

    @Override
    public boolean loadFeaturesFrom(AlignFrame alf, String features, boolean autoenabledisplay) {
        return alf.parseFeaturesFile(features, DataSourceType.PASTE, autoenabledisplay);
    }

    @Override
    public String getFeatures(String format) {
        return this.getFeaturesFrom(this.getDefaultTargetFrame(), format);
    }

    @Override
    public String getFeaturesFrom(AlignFrame alf, String format) {
        return alf.outputFeatures(false, format);
    }

    @Override
    public String getAnnotation() {
        return this.getAnnotationFrom(this.getDefaultTargetFrame());
    }

    @Override
    public String getAnnotationFrom(AlignFrame alf) {
        return alf.outputAnnotations(false);
    }

    @Override
    public AlignFrame newView() {
        return this.newViewFrom(this.getDefaultTargetFrame());
    }

    @Override
    public AlignFrame newView(String name) {
        return this.newViewFrom(this.getDefaultTargetFrame(), name);
    }

    @Override
    public AlignFrame newViewFrom(AlignFrame alf) {
        return alf.newView(null);
    }

    @Override
    public AlignFrame newViewFrom(AlignFrame alf, String name) {
        return alf.newView(name);
    }

    @Override
    public AlignFrame loadAlignment(String text, String title) {
        AlignmentI al = null;
        try {
            FileFormatI format = new IdentifyFile().identify(text, DataSourceType.PASTE);
            al = new AppletFormatAdapter().readFile(text, DataSourceType.PASTE, format);
            if (al.getHeight() > 0) {
                return new AlignFrame(al, this, title, false);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public void setMouseoverListener(String listener) {
        this.setMouseoverListener(this.currentAlignFrame, listener);
    }

    @Override
    public void setMouseoverListener(AlignFrame af, String listener) {
        if (listener != null && (listener = listener.trim()).length() == 0) {
            Console.errPrintln("jalview Javascript error: Ignoring empty function for mouseover listener.");
            return;
        }
        MouseOverListener mol = new MouseOverListener(this, af, listener);
        this.javascriptListeners.addElement(mol);
        StructureSelectionManager.getStructureSelectionManager(this).addStructureViewerListener(mol);
        if (debug) {
            Console.errPrintln("Added a mouseover listener for " + (String)(af == null ? "All frames" : "Just views for " + af.getAlignViewport().getSequenceSetId()));
            Console.errPrintln("There are now " + this.javascriptListeners.size() + " listeners in total.");
        }
    }

    @Override
    public void setSelectionListener(String listener) {
        this.setSelectionListener(null, listener);
    }

    @Override
    public void setSelectionListener(AlignFrame af, String listener) {
        if (listener != null && (listener = listener.trim()).length() == 0) {
            Console.errPrintln("jalview Javascript error: Ignoring empty function for selection listener.");
            return;
        }
        JsSelectionSender mol = new JsSelectionSender(this, af, listener);
        this.javascriptListeners.addElement(mol);
        StructureSelectionManager.getStructureSelectionManager(this).addSelectionListener(mol);
        if (debug) {
            Console.errPrintln("Added a selection listener for " + (String)(af == null ? "All frames" : "Just views for " + af.getAlignViewport().getSequenceSetId()));
            Console.errPrintln("There are now " + this.javascriptListeners.size() + " listeners in total.");
        }
    }

    @Override
    public void setStructureListener(String listener, String modelSet) {
        if (listener != null && (listener = listener.trim()).length() == 0) {
            Console.errPrintln("jalview Javascript error: Ignoring empty function for selection listener.");
            return;
        }
        MouseOverStructureListener mol = new MouseOverStructureListener(this, listener, this.separatorListToArray(modelSet));
        this.javascriptListeners.addElement(mol);
        StructureSelectionManager.getStructureSelectionManager(this).addStructureViewerListener(mol);
        if (debug) {
            Console.errPrintln("Added a javascript structure viewer listener '" + listener + "'");
            Console.errPrintln("There are now " + this.javascriptListeners.size() + " listeners in total.");
        }
    }

    @Override
    public void removeJavascriptListener(AlignFrame af, String listener) {
        if (listener != null && (listener = listener.trim()).length() == 0) {
            listener = null;
        }
        boolean rprt = false;
        int ms = 0;
        int msSize = this.javascriptListeners.size();
        while (ms < msSize) {
            JSFunctionExec lstn = this.javascriptListeners.elementAt(ms);
            JsCallBack lstner = (JsCallBack)((Object)lstn);
            if (!(af != null && lstner.getAlignFrame() != af || listener != null && !lstner.getListenerFunction().equals(listener))) {
                this.javascriptListeners.removeElement(lstner);
                --msSize;
                if (lstner instanceof SelectionListener) {
                    StructureSelectionManager.getStructureSelectionManager(this).removeSelectionListener((SelectionListener)((Object)lstner));
                } else {
                    StructureSelectionManager.getStructureSelectionManager(this).removeStructureViewerListener(lstner, null);
                }
                rprt = debug;
                if (!debug) continue;
                Console.errPrintln("Removed listener '" + listener + "'");
                continue;
            }
            ++ms;
        }
        if (rprt) {
            Console.errPrintln("There are now " + this.javascriptListeners.size() + " listeners in total.");
        }
    }

    @Override
    public void stop() {
        Console.errPrintln("Applet " + this.getName() + " stop().");
        this.tidyUp();
    }

    @Override
    public void destroy() {
        Console.errPrintln("Applet " + this.getName() + " destroy().");
        this.tidyUp();
    }

    private void tidyUp() {
        this.removeAll();
        if (this.currentAlignFrame != null && this.currentAlignFrame.viewport != null && this.currentAlignFrame.viewport.applet != null) {
            AlignViewport av = this.currentAlignFrame.viewport;
            this.currentAlignFrame.closeMenuItem_actionPerformed();
            av.applet = null;
            this.currentAlignFrame = null;
        }
        if (this.javascriptListeners != null) {
            while (this.javascriptListeners.size() > 0) {
                JSFunctionExec mol = this.javascriptListeners.elementAt(0);
                this.javascriptListeners.removeElement(mol);
                if (mol instanceof SelectionListener) {
                    StructureSelectionManager.getStructureSelectionManager(this).removeSelectionListener((SelectionListener)((Object)mol));
                } else {
                    StructureSelectionManager.getStructureSelectionManager(this).removeStructureViewerListener(mol, null);
                }
                mol.jvlite = null;
            }
        }
        if (this.jsFunctionExec != null) {
            this.jsFunctionExec.stopQueue();
            this.jsFunctionExec.jvlite = null;
        }
        this.initialAlignFrame = null;
        this.jsFunctionExec = null;
        this.javascriptListeners = null;
        StructureSelectionManager.release(this);
    }

    @Override
    public void mouseOverStructure(final String pdbResNum, final String chain, final String pdbfile) {
        final JalviewLite me = this;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    StructureSelectionManager.getStructureSelectionManager(me).mouseOverStructure(Integer.valueOf(pdbResNum), chain, pdbfile);
                    if (debug) {
                        System.err.println("mouseOver for '" + pdbResNum + "' in chain '" + chain + "' in structure '" + pdbfile + "'");
                    }
                }
                catch (NumberFormatException e) {
                    Console.errPrintln("Ignoring invalid residue number string '" + pdbResNum + "'");
                }
            }
        });
    }

    @Override
    public void scrollViewToIn(final AlignFrame alf, final String topRow, final String leftHandColumn) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    alf.scrollTo(Integer.valueOf(topRow), Integer.valueOf(leftHandColumn));
                }
                catch (Exception ex) {
                    Console.errPrintln("Couldn't parse integer arguments (topRow='" + topRow + "' and leftHandColumn='" + leftHandColumn + "')");
                    ex.printStackTrace();
                }
            }
        });
    }

    @Override
    public void scrollViewToRowIn(final AlignFrame alf, final String topRow) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    alf.scrollToRow(Integer.valueOf(topRow));
                }
                catch (Exception ex) {
                    Console.errPrintln("Couldn't parse integer arguments (topRow='" + topRow + "')");
                    ex.printStackTrace();
                }
            }
        });
    }

    @Override
    public void scrollViewToColumnIn(final AlignFrame alf, final String leftHandColumn) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    alf.scrollToColumn(Integer.valueOf(leftHandColumn));
                }
                catch (Exception ex) {
                    Console.errPrintln("Couldn't parse integer arguments (leftHandColumn='" + leftHandColumn + "')");
                    ex.printStackTrace();
                }
            }
        });
    }

    private static void initBuildDetails() {
        if (builddate == null) {
            builddate = "unknown";
            version = "test";
            installation = "applet";
            URL url = JalviewLite.class.getResource("/.build_properties");
            if (url != null) {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(HttpUtils.openStream(url)));
                    while ((line = reader.readLine()) != null) {
                        if (line.indexOf("VERSION") > -1) {
                            version = line.substring(line.indexOf("=") + 1);
                        }
                        if (line.indexOf("BUILD_DATE") > -1) {
                            builddate = line.substring(line.indexOf("=") + 1);
                        }
                        if (line.indexOf("INSTALLATION") <= -1) continue;
                        installation = line.substring(line.indexOf("=") + 1);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static String getBuildDate() {
        JalviewLite.initBuildDetails();
        return builddate;
    }

    public static String getInstallation() {
        JalviewLite.initBuildDetails();
        return installation;
    }

    public static String getVersion() {
        JalviewLite.initBuildDetails();
        return version;
    }

    @Override
    public void init() {
        LoadingThread loader;
        String sep;
        String chkforJmol;
        String externalsviewer;
        block25: {
            debug = TRUE.equalsIgnoreCase(this.getParameter("debug"));
            try {
                if (debug) {
                    Console.errPrintln("Applet context is '" + this.getAppletContext().getClass().toString() + "'");
                }
                JSObject scriptObject = JSObject.getWindow((Applet)this);
                if (debug && scriptObject != null) {
                    Console.errPrintln("Applet has Javascript callback support.");
                }
            }
            catch (Exception ex) {
                Console.errPrintln("Warning: No JalviewLite javascript callbacks available.");
                if (!debug) break block25;
                ex.printStackTrace();
            }
        }
        if (debug) {
            Console.errPrintln("JalviewLite Version " + JalviewLite.getVersion());
            Console.errPrintln("Build Date : " + JalviewLite.getBuildDate());
            Console.errPrintln("Installation : " + JalviewLite.getInstallation());
        }
        if ((externalsviewer = this.getParameter("externalstructureviewer")) != null) {
            this.useXtrnalSviewer = externalsviewer.trim().toLowerCase(Locale.ROOT).equals(TRUE);
        }
        if ((chkforJmol = this.getParameter("nojmol")) != null) {
            boolean bl = this.checkForJmol = !chkforJmol.equals(TRUE);
        }
        if ((sep = this.getParameter("separator")) != null) {
            if (sep.length() > 0) {
                this.separator = sep;
                if (debug) {
                    Console.errPrintln("Separator set to '" + this.separator + "'");
                }
            } else {
                throw new Error(MessageManager.getString("error.invalid_separator_parameter"));
            }
        }
        int r = 255;
        int g = 255;
        int b = 255;
        String param = this.getParameter("RGB");
        if (param != null) {
            try {
                r = Integer.parseInt(param.substring(0, 2), 16);
                g = Integer.parseInt(param.substring(2, 4), 16);
                b = Integer.parseInt(param.substring(4, 6), 16);
            }
            catch (Exception ex) {
                r = 255;
                g = 255;
                b = 255;
            }
        }
        if ((param = this.getParameter("label")) != null) {
            this.launcher.setLabel(param);
        }
        this.setBackground(new Color(r, g, b));
        this.file = this.getParameter("file");
        if (this.file == null) {
            StringBuffer data = new StringBuffer("PASTE");
            int i = 1;
            while ((this.file = this.getParameter("sequence" + i)) != null) {
                data.append(this.file.toString() + "\n");
                ++i;
            }
            if (data.length() > 5) {
                this.file = data.toString();
            }
        }
        if (this.getDefaultParameter("enableSplitFrame", true)) {
            this.file2 = this.getParameter("file2");
        }
        this.embedded = TRUE.equalsIgnoreCase(this.getParameter("embedded"));
        if (this.embedded) {
            loader = new LoadingThread(this.file, this.file2, this);
            loader.start();
        } else if (this.file != null) {
            if (FALSE.equalsIgnoreCase(this.getParameter("showbutton"))) {
                loader = new LoadingThread(this.file, this.file2, this);
                loader.start();
            } else {
                this.add(this.launcher);
                this.launcher.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoadingThread loader = new LoadingThread(JalviewLite.this.file, JalviewLite.this.file2, JalviewLite.this);
                        loader.start();
                    }
                });
            }
        } else {
            this.file = "NO FILE";
            this.fileFound = false;
            this.callInitCallback();
        }
    }

    private void initLiveConnect() {
        boolean notFailed = false;
        int tries = 0;
        while (!notFailed && tries < 10) {
            if (tries > 0) {
                Console.errPrintln("LiveConnect request thread going to sleep.");
            }
            try {
                Thread.sleep(700 * (1 + tries));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (tries++ > 0) {
                Console.errPrintln("LiveConnect request thread woken up.");
            }
            try {
                JSObject scriptObject = JSObject.getWindow((Applet)this);
                if (scriptObject.eval("navigator") == null) continue;
                notFailed = true;
            }
            catch (Exception jsex) {
                Console.errPrintln("Attempt " + tries + " to access LiveConnect javascript failed.");
            }
        }
    }

    private void callInitCallback() {
        String initjscallback = this.getParameter("oninit");
        if (initjscallback == null) {
            return;
        }
        if ((initjscallback = initjscallback.trim()).length() > 0) {
            JSObject scriptObject = null;
            try {
                scriptObject = JSObject.getWindow((Applet)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.initLiveConnect();
            if (scriptObject != null) {
                try {
                    new JSFunctionExec(this).executeJavascriptFunction(true, initjscallback, null, "Calling oninit callback '" + initjscallback + "'.");
                }
                catch (Exception e) {
                    Console.errPrintln("Exception when executing _oninit callback '" + initjscallback + "'.");
                    e.printStackTrace();
                }
            } else {
                Console.errPrintln("Not executing _oninit callback '" + initjscallback + "' - no scripting allowed.");
            }
        }
    }

    public static void addFrame(final Frame frame, String title, int width, int height) {
        frame.setLocation(lastFrameX, lastFrameY);
        lastFrameX += 40;
        lastFrameY += 40;
        frame.setSize(width, height);
        frame.setTitle(title);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (frame instanceof AlignFrame) {
                    AlignViewport vp = ((AlignFrame)frame).viewport;
                    ((AlignFrame)frame).closeMenuItem_actionPerformed();
                    if (vp.applet.currentAlignFrame == frame) {
                        vp.applet.currentAlignFrame = null;
                    }
                    vp.applet = null;
                    Object var2_2 = null;
                }
                lastFrameX -= 40;
                lastFrameY -= 40;
                if (frame instanceof EmbmenuFrame) {
                    ((EmbmenuFrame)frame).destroyMenus();
                }
                frame.setMenuBar(null);
                frame.dispose();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                if (frame instanceof AlignFrame) {
                    ((AlignFrame)frame).viewport.applet.currentAlignFrame = (AlignFrame)frame;
                    if (debug) {
                        Console.errPrintln("Activated window " + frame);
                    }
                }
                super.windowActivated(e);
            }
        });
        frame.setVisible(true);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.fileFound) {
            g.setColor(new Color(200, 200, 200));
            g.setColor(Color.cyan);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g.setColor(Color.red);
            g.drawString(MessageManager.getString("label.jalview_cannot_open_file"), 5, 15);
            g.drawString("\"" + this.file + "\"", 5, 30);
        } else if (this.embedded) {
            g.setColor(Color.black);
            g.setFont(new Font("Arial", 1, 24));
            g.drawString(MessageManager.getString("label.jalview_applet"), 50, this.getSize().height / 2 - 30);
            g.drawString(MessageManager.getString("label.loading_data") + "...", 50, this.getSize().height / 2);
        }
    }

    public Vector getAppletWindow(Class class1) {
        Vector<Component[]> wnds = new Vector<Component[]>();
        Component[] cmp = this.getComponents();
        if (cmp != null) {
            for (int i = 0; i < cmp.length; ++i) {
                if (!class1.isAssignableFrom(cmp[i].getClass())) continue;
                wnds.addElement(cmp);
            }
        }
        return wnds;
    }

    public AlignFrame getDefaultTargetFrame() {
        if (this.currentAlignFrame != null) {
            return this.currentAlignFrame;
        }
        if (this.initialAlignFrame != null) {
            return this.initialAlignFrame;
        }
        Console.errPrintln("Implementation error: Jalview Applet API cannot work out which AlignFrame to use.");
        return null;
    }

    public String[] separatorListToArray(String list) {
        return JalviewLite.separatorListToArray(list, this.separator);
    }

    public static String[] separatorListToArray(String list, String separator) {
        String c;
        int pos;
        int seplen = separator.length();
        if (list == null || list.equals("") || list.equals(separator)) {
            return null;
        }
        Vector<String> jv = new Vector<String>();
        int cp = 0;
        while ((pos = list.indexOf(separator, cp)) > cp) {
            jv.addElement(list.substring(cp, pos));
            cp = pos + seplen;
        }
        if (cp < list.length() && !(c = list.substring(cp)).equals(separator)) {
            jv.addElement(c);
        }
        if (jv.size() > 0) {
            int i;
            String[] v = new String[jv.size()];
            for (i = 0; i < v.length; ++i) {
                v[i] = (String)jv.elementAt(i);
            }
            jv.removeAllElements();
            if (debug) {
                Console.errPrintln("Array from '" + separator + "' separated List:\n" + v.length);
                for (i = 0; i < v.length; ++i) {
                    Console.errPrintln("item " + i + " '" + v[i] + "'");
                }
            }
            return v;
        }
        if (debug) {
            Console.errPrintln("Empty Array from '" + separator + "' separated List");
        }
        return null;
    }

    public String arrayToSeparatorList(String[] list) {
        return JalviewLite.arrayToSeparatorList(list, this.separator);
    }

    public static String arrayToSeparatorList(String[] list, String separator) {
        StringBuffer v = new StringBuffer();
        if (list != null && list.length > 0) {
            int iSize = list.length;
            for (int i = 0; i < iSize; ++i) {
                if (list[i] == null) continue;
                if (i > 0) {
                    v.append(separator);
                }
                v.append(list[i]);
            }
            if (debug) {
                System.err.println("Returning '" + separator + "' separated List:\n");
                Console.errPrintln(v);
            }
            return v.toString();
        }
        if (debug) {
            Console.errPrintln("Returning empty '" + separator + "' separated List\n");
        }
        return separator;
    }

    @Override
    public String getFeatureGroups() {
        String lst = this.arrayToSeparatorList(this.getDefaultTargetFrame().getFeatureGroups());
        return lst;
    }

    @Override
    public String getFeatureGroupsOn(AlignFrame alf) {
        String lst = this.arrayToSeparatorList(alf.getFeatureGroups());
        return lst;
    }

    @Override
    public String getFeatureGroupsOfState(boolean visible) {
        return this.arrayToSeparatorList(this.getDefaultTargetFrame().getFeatureGroupsOfState(visible));
    }

    @Override
    public String getFeatureGroupsOfStateOn(AlignFrame alf, boolean visible) {
        return this.arrayToSeparatorList(alf.getFeatureGroupsOfState(visible));
    }

    @Override
    public void setFeatureGroupStateOn(final AlignFrame alf, final String groups, boolean state) {
        final boolean st = state;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                alf.setFeatureGroupState(JalviewLite.this.separatorListToArray(groups), st);
            }
        });
    }

    @Override
    public void setFeatureGroupState(String groups, boolean state) {
        this.setFeatureGroupStateOn(this.getDefaultTargetFrame(), groups, state);
    }

    @Override
    public String getSeparator() {
        return this.separator;
    }

    @Override
    public void setSeparator(String separator) {
        if (separator == null || separator.length() < 1) {
            separator = "\u00ac";
        }
        this.separator = separator;
        if (debug) {
            Console.errPrintln("Default Separator now: '" + separator + "'");
        }
    }

    public boolean getDefaultParameter(String name, boolean def) {
        String stn = this.getParameter(name);
        if (stn == null) {
            return def;
        }
        return TRUE.equalsIgnoreCase(stn);
    }

    @Override
    public boolean addPdbFile(AlignFrame alFrame, String sequenceId, String pdbEntryString, String pdbFile) {
        return alFrame.addPdbFile(sequenceId, pdbEntryString, pdbFile);
    }

    protected void setAlignPdbStructures(boolean alignPdbStructures) {
        this.alignPdbStructures = alignPdbStructures;
    }

    public boolean isAlignPdbStructures() {
        return this.alignPdbStructures;
    }

    @Override
    public void start() {
    }

    public void setJsMessageSet(String messageclass, String viewId, String[] colcommands) {
        Hashtable<String, Object> msgset = this.jsmessages.get(messageclass);
        if (msgset == null) {
            msgset = new Hashtable();
            this.jsmessages.put(messageclass, msgset);
        }
        msgset.put(viewId, colcommands);
        long[] l = new long[colcommands.length];
        for (int i = 0; i < colcommands.length; ++i) {
            l[i] = colcommands[i].hashCode();
        }
        this.jshashes.put(messageclass + "|" + viewId, l);
    }

    @Override
    public String getJsMessage(String messageclass, String viewId) {
        String[] msgs;
        Hashtable<String, String[]> msgset = this.jsmessages.get(messageclass);
        if (msgset != null && (msgs = msgset.get(viewId)) != null) {
            for (int i = 0; i < msgs.length; ++i) {
                if (msgs[i] == null) continue;
                String m = msgs[i];
                msgs[i] = null;
                return m;
            }
        }
        return "";
    }

    public boolean isJsMessageSetChanged(String string, String string2, String[] colcommands) {
        long[] l = this.jshashes.get(string + "|" + string2);
        if (l == null && colcommands != null) {
            return true;
        }
        for (int i = 0; i < colcommands.length; ++i) {
            if (l[i] == (long)colcommands[i].hashCode()) continue;
            return true;
        }
        return false;
    }

    public Vector getJsExecQueue() {
        return this.jsExecQueue;
    }

    public void setExecutor(JSFunctionExec jsFunctionExec2) {
        this.jsFunctionExec = jsFunctionExec2;
    }

    public Color getDefaultColourParameter(String colparam, Color defcolour) {
        String colprop = this.getParameter(colparam);
        if (colprop == null || colprop.trim().length() == 0) {
            return defcolour;
        }
        Color col = ColorUtils.parseColourString(colprop);
        if (col == null) {
            Console.errPrintln("Couldn't parse '" + colprop + "' as a colour for " + colparam);
        }
        return col == null ? defcolour : col;
    }

    public void openJalviewHelpUrl() {
        String helpUrl = this.getParameter("jalviewhelpurl");
        if (helpUrl == null || helpUrl.trim().length() < 5) {
            helpUrl = "http://www.jalview.org/help.html";
        }
        this.showURL(helpUrl, "HELP");
    }

    private String resolveUrlForLocalOrAbsolute(String targetPath, URL localref) {
        Object resolvedPath = "";
        if (targetPath.startsWith("/")) {
            String codebase = localref.toString();
            String localfile = localref.getFile();
            resolvedPath = codebase.substring(0, codebase.length() - localfile.length()) + targetPath;
            return resolvedPath;
        }
        String urlPath = localref.toString();
        String directoryPath = urlPath;
        int lastSeparator = directoryPath.lastIndexOf("/");
        if (lastSeparator > 0) {
            directoryPath = directoryPath.substring(0, lastSeparator + 1);
        }
        resolvedPath = targetPath.startsWith("/") ? directoryPath + targetPath.substring(1) : directoryPath + targetPath;
        if (debug) {
            Console.errPrintln("resolveUrlForLocalOrAbsolute returning " + (String)resolvedPath);
        }
        return resolvedPath;
    }

    public void showURL(String url, String target) {
        try {
            if (url.indexOf(":") == -1) {
                URL prepend = this.getDefaultParameter("resolvetocodebase", false) ? this.getCodeBase() : this.getDocumentBase();
                url = this.resolveUrlForLocalOrAbsolute(url, prepend);
                if (debug) {
                    Console.errPrintln("Show url (prepended " + prepend + " - toggle resolvetocodebase if code/docbase resolution is wrong): " + url);
                }
            } else if (debug) {
                Console.errPrintln("Show url: " + url);
            }
            if (url.indexOf("javascript:") == 0) {
                this.getAppletContext().showDocument(new URL(url));
            } else {
                this.getAppletContext().showDocument(new URL(url), target);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class LoadingThread
    extends Thread {
        DataSourceType protocol;
        String _file;
        String _file2;
        JalviewLite applet;

        private void dbgMsg(String msg) {
            if (debug) {
                Console.errPrintln(msg);
            }
        }

        public String resolveFileProtocol(String path) {
            if (path.startsWith("PASTE")) {
                this.protocol = DataSourceType.PASTE;
                return path.substring(5);
            }
            if (path.indexOf("://") != -1) {
                this.protocol = DataSourceType.URL;
                return path;
            }
            URL documentBase = JalviewLite.this.getDocumentBase();
            String withDocBase = JalviewLite.this.resolveUrlForLocalOrAbsolute(path, documentBase);
            if (HttpUtils.isValidUrl(withDocBase)) {
                if (debug) {
                    Console.errPrintln("Prepended document base '" + documentBase + "' to make: '" + withDocBase + "'");
                }
                this.protocol = DataSourceType.URL;
                return withDocBase;
            }
            URL codeBase = JalviewLite.this.getCodeBase();
            String withCodeBase = this.applet.resolveUrlForLocalOrAbsolute(path, codeBase);
            if (!withCodeBase.equals(withDocBase) && HttpUtils.isValidUrl(withCodeBase)) {
                this.protocol = DataSourceType.URL;
                if (debug) {
                    Console.errPrintln("Prepended codebase '" + codeBase + "' to make: '" + withCodeBase + "'");
                }
                return withCodeBase;
            }
            if (this.inArchive(path)) {
                this.protocol = DataSourceType.CLASSLOADER;
            }
            return path;
        }

        public LoadingThread(String file, String file2, JalviewLite _applet) {
            this._file = file;
            this._file2 = file2;
            this.applet = _applet;
        }

        @Override
        public void run() {
            LoadJmolThread jmolchecker = new LoadJmolThread();
            jmolchecker.start();
            while (jmolchecker.notFinished()) {
                try {
                    Thread.sleep(2L);
                }
                catch (Exception exception) {}
            }
            this.startLoading();
        }

        private void startLoading() {
            this.dbgMsg("Loading thread started with:\n>>file\n" + this._file + ">>endfile");
            this.dbgMsg("Loading started.");
            AlignFrame newAlignFrame = this.readAlignment(this._file);
            AlignFrame newAlignFrame2 = this.readAlignment(this._file2);
            if (newAlignFrame != null) {
                this.addToDisplay(newAlignFrame, newAlignFrame2);
                this.loadTree(newAlignFrame);
                this.loadScoreFile(newAlignFrame);
                this.loadFeatures(newAlignFrame);
                this.loadAnnotations(newAlignFrame);
                this.loadJnetFile(newAlignFrame);
                this.loadPdbFiles(newAlignFrame);
            } else {
                JalviewLite.this.fileFound = false;
                this.applet.remove(JalviewLite.this.launcher);
                this.applet.repaint();
            }
            JalviewLite.this.callInitCallback();
        }

        public void addToDisplay(AlignFrame af, AlignFrame af2) {
            if (af2 != null) {
                AlignmentI prot;
                AlignmentI al1 = af.viewport.getAlignment();
                AlignmentI al2 = af2.viewport.getAlignment();
                AlignmentI cdna = al1.isNucleotide() ? al1 : al2;
                AlignmentI alignmentI = prot = al1.isNucleotide() ? al2 : al1;
                if (AlignmentUtils.mapProteinAlignmentToCdna(prot, cdna)) {
                    al2.alignAs(al1);
                    SplitFrame sf = new SplitFrame(af, af2);
                    sf.addToDisplay(JalviewLite.this.embedded, JalviewLite.this);
                    return;
                }
                String msg = "Could not map any sequence in " + af2.getTitle() + " as " + (al1.isNucleotide() ? "protein product" : "cDNA") + " for " + af.getTitle();
                Console.errPrintln(msg);
            }
            af.addToDisplay(JalviewLite.this.embedded);
        }

        protected AlignFrame readAlignment(String fileParam) {
            block9: {
                if (fileParam == null) {
                    return null;
                }
                String resolvedFile = this.resolveFileProtocol(fileParam);
                AlignmentI al = null;
                try {
                    FileFormatI format = new IdentifyFile().identify(resolvedFile, this.protocol);
                    this.dbgMsg("File identified as '" + format + "'");
                    al = new AppletFormatAdapter().readFile(resolvedFile, this.protocol, format);
                    if (al != null && al.getHeight() > 0) {
                        this.dbgMsg("Successfully loaded file.");
                        al.setDataset(null);
                        AlignFrame newAlignFrame = new AlignFrame(al, this.applet, resolvedFile, JalviewLite.this.embedded, false);
                        newAlignFrame.setTitle(resolvedFile);
                        if (JalviewLite.this.initialAlignFrame == null) {
                            JalviewLite.this.initialAlignFrame = newAlignFrame;
                        }
                        JalviewLite.this.currentAlignFrame = newAlignFrame;
                        if (this.protocol == DataSourceType.PASTE) {
                            newAlignFrame.setTitle(MessageManager.formatMessage("label.sequences_from", this.applet.getDocumentBase().toString()));
                        }
                        newAlignFrame.statusBar.setText(MessageManager.formatMessage("label.successfully_loaded_file", resolvedFile));
                        return newAlignFrame;
                    }
                }
                catch (IOException ex) {
                    this.dbgMsg("File load exception.");
                    ex.printStackTrace();
                    if (!debug) break block9;
                    try {
                        FileParse fp = new FileParse(resolvedFile, this.protocol);
                        String ln = null;
                        this.dbgMsg(">>>Dumping contents of '" + resolvedFile + "' (" + this.protocol + ")");
                        while ((ln = fp.nextLine()) != null) {
                            this.dbgMsg(ln);
                        }
                        this.dbgMsg(">>>Dump finished.");
                    }
                    catch (Exception e) {
                        Console.errPrintln("Exception when trying to dump the content of the file parameter.");
                        e.printStackTrace();
                    }
                }
            }
            return null;
        }

        protected boolean loadPdbFiles(AlignFrame alignFrame) {
            String param;
            boolean result = false;
            this.applet.setAlignPdbStructures(JalviewLite.this.getDefaultParameter("alignpdbfiles", false));
            int pdbFileCount = 0;
            Vector<Object[]> pdbs = new Vector<Object[]>();
            SequenceIdMatcher matcher = this.applet.getDefaultParameter("relaxedidmatch", false) ? new SequenceIdMatcher(alignFrame.getAlignViewport().getAlignment().getSequencesArray()) : null;
            do {
                if ((param = pdbFileCount > 0 ? this.applet.getParameter("PDBFILE" + pdbFileCount) : this.applet.getParameter("PDBFILE")) == null) continue;
                PDBEntry pdb = new PDBEntry();
                SequenceI[] seqs = null;
                String[] chains = null;
                StringTokenizer st = new StringTokenizer(param, " ");
                if (st.countTokens() < 2) {
                    String sequence = this.applet.getParameter("PDBSEQ");
                    if (sequence != null) {
                        seqs = new SequenceI[]{matcher == null ? (Sequence)alignFrame.getAlignViewport().getAlignment().findName(sequence) : matcher.findIdMatch(sequence)};
                    }
                } else {
                    param = st.nextToken();
                    ArrayList<SequenceI> tmp = new ArrayList<SequenceI>();
                    ArrayList<String> tmp2 = new ArrayList<String>();
                    while (st.hasMoreTokens()) {
                        String seqstring = st.nextToken();
                        StringTokenizer st2 = new StringTokenizer(seqstring, "=");
                        if (st2.countTokens() > 1) {
                            tmp2.add(st2.nextToken());
                            seqstring = st2.nextToken();
                        }
                        tmp.add(matcher == null ? (Sequence)alignFrame.getAlignViewport().getAlignment().findName(seqstring) : matcher.findIdMatch(seqstring));
                    }
                    seqs = tmp.toArray(new SequenceI[tmp.size()]);
                    if (tmp2.size() == tmp.size()) {
                        chains = tmp2.toArray(new String[tmp2.size()]);
                    }
                }
                param = this.resolveFileProtocol(param);
                pdb.setFile(param);
                if (seqs == null) continue;
                for (int i = 0; i < seqs.length; ++i) {
                    if (seqs[i] != null) {
                        ((Sequence)seqs[i]).addPDBId(pdb);
                        StructureSelectionManager.getStructureSelectionManager(this.applet).registerPDBEntry(pdb);
                        continue;
                    }
                    if (!debug) continue;
                    Console.errPrintln("Warning: Possible input parsing error: Null sequence for attachment of PDB (sequence " + i + ")");
                }
                if (!JalviewLite.this.alignPdbStructures) {
                    alignFrame.newStructureView(this.applet, pdb, seqs, chains, this.protocol);
                    continue;
                }
                pdbs.addElement(new Object[]{pdb, seqs, chains, this.protocol});
            } while (param != null || ++pdbFileCount < 10);
            if (pdbs.size() > 0) {
                SequenceI[][] seqs = new SequenceI[pdbs.size()][];
                PDBEntry[] pdb = new PDBEntry[pdbs.size()];
                String[][] chains = new String[pdbs.size()][];
                String[] protocols = new String[pdbs.size()];
                int pdbsiSize = pdbs.size();
                for (int pdbsi = 0; pdbsi < pdbsiSize; ++pdbsi) {
                    Object[] o = (Object[])pdbs.elementAt(pdbsi);
                    pdb[pdbsi] = (PDBEntry)o[0];
                    seqs[pdbsi] = (SequenceI[])o[1];
                    chains[pdbsi] = (String[])o[2];
                    protocols[pdbsi] = (String)o[3];
                }
                alignFrame.alignedStructureView(this.applet, pdb, seqs, chains, protocols);
                result = true;
            }
            return result;
        }

        protected boolean loadJnetFile(AlignFrame alignFrame) {
            boolean result = false;
            String param = this.applet.getParameter("jnetfile");
            if (param == null) {
                param = this.applet.getParameter("jpredfile");
            }
            if (param != null) {
                try {
                    param = this.resolveFileProtocol(param);
                    JPredFile predictions = new JPredFile(param, this.protocol);
                    JnetAnnotationMaker.add_annotation(predictions, alignFrame.viewport.getAlignment(), 0, false);
                    alignFrame.viewport.getAlignment().setupJPredAlignment();
                    alignFrame.alignPanel.fontChanged();
                    alignFrame.alignPanel.setScrollValues(0, 0);
                    result = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return result;
        }

        protected boolean loadAnnotations(AlignFrame alignFrame) {
            boolean result = false;
            String param = this.applet.getParameter("annotations");
            if (param != null) {
                if (new AnnotationFile().annotateAlignmentView(alignFrame.viewport, param = this.resolveFileProtocol(param), this.protocol)) {
                    alignFrame.alignPanel.fontChanged();
                    alignFrame.alignPanel.setScrollValues(0, 0);
                    result = true;
                } else {
                    Console.errPrintln("Annotations were not added from annotation file '" + param + "'");
                }
            }
            return result;
        }

        protected boolean loadFeatures(AlignFrame alignFrame) {
            boolean result = false;
            String param = this.applet.getParameter("hidefeaturegroups");
            if (param != null) {
                alignFrame.setFeatureGroupState(JalviewLite.this.separatorListToArray(param), false);
            }
            if ((param = this.applet.getParameter("showfeaturegroups")) != null) {
                alignFrame.setFeatureGroupState(JalviewLite.this.separatorListToArray(param), true);
            }
            if ((param = this.applet.getParameter("features")) != null) {
                param = this.resolveFileProtocol(param);
                result = alignFrame.parseFeaturesFile(param, this.protocol);
            }
            if ((param = this.applet.getParameter("showFeatureSettings")) != null && param.equalsIgnoreCase(JalviewLite.TRUE)) {
                alignFrame.viewport.setShowSequenceFeatures(true);
                new FeatureSettings(alignFrame.alignPanel);
            }
            return result;
        }

        protected boolean loadScoreFile(AlignFrame alignFrame) {
            boolean result = false;
            String sScoreFile = this.applet.getParameter("scoreFile");
            if (sScoreFile != null && !"".equals(sScoreFile)) {
                try {
                    if (debug) {
                        Console.errPrintln("Attempting to load T-COFFEE score file from the scoreFile parameter");
                    }
                    if (!(result = alignFrame.loadScoreFile(sScoreFile))) {
                        Console.errPrintln("Failed to parse T-COFFEE parameter as a valid score file ('" + sScoreFile + "')");
                    }
                }
                catch (Exception e) {
                    System.err.printf("Cannot read score file: '%s'. Cause: %s \n", sScoreFile, e.getMessage());
                }
            }
            return result;
        }

        protected boolean loadTree(AlignFrame alignFrame) {
            boolean result = false;
            String treeFile = this.applet.getParameter("tree");
            if (treeFile == null) {
                treeFile = this.applet.getParameter("treeFile");
            }
            if (treeFile != null) {
                try {
                    treeFile = this.resolveFileProtocol(treeFile);
                    NewickFile fin = new NewickFile(treeFile, this.protocol);
                    fin.parse();
                    if (fin.getTree() != null) {
                        alignFrame.loadTree(fin, treeFile);
                        result = true;
                        this.dbgMsg("Successfully imported tree.");
                    } else {
                        this.dbgMsg("Tree parameter did not resolve to a valid tree.");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return result;
        }

        boolean inArchive(String f) {
            try {
                boolean rtn;
                boolean bl = rtn = this.getClass().getResourceAsStream("/" + f) != null;
                if (debug) {
                    Console.errPrintln("Resource '" + f + "' was " + (rtn ? "" : "not ") + "located by classloader.");
                }
                return rtn;
            }
            catch (Exception ex) {
                Console.outPrintln("Exception checking resources: " + f + " " + ex);
                return false;
            }
        }
    }

    class LoadJmolThread
    extends Thread {
        private boolean running = false;

        LoadJmolThread() {
        }

        @Override
        public void run() {
            if (this.running || JalviewLite.this.checkedForJmol) {
                return;
            }
            this.running = true;
            if (JalviewLite.this.checkForJmol) {
                try {
                    if (!System.getProperty("java.version").startsWith("1.1")) {
                        Class.forName("org.jmol.adapter.smarter.SmarterJmolAdapter");
                        JalviewLite.this.jmolAvailable = true;
                    }
                    if (!JalviewLite.this.jmolAvailable) {
                        Console.outPrintln("Jmol not available - Using mc_view for structures");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                JalviewLite.this.jmolAvailable = false;
                if (debug) {
                    Console.errPrintln("Skipping Jmol check. Will use mc_view (probably)");
                }
            }
            JalviewLite.this.checkedForJmol = true;
            this.running = false;
        }

        public boolean notFinished() {
            return this.running || !JalviewLite.this.checkedForJmol;
        }
    }
}

