/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.appletgui.FeatureRenderer;
import jalview.renderer.OverviewRenderer;
import jalview.renderer.OverviewResColourFinder;
import jalview.viewmodel.OverviewDimensions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;

public class OverviewCanvas
extends Component {
    private volatile boolean restart = false;
    private volatile boolean updaterunning = false;
    private OverviewDimensions od;
    private OverviewRenderer or = null;
    private Image miniMe;
    private Image offscreen;
    private AlignViewport av;
    private jalview.renderer.seqfeatures.FeatureRenderer fr;
    private Frame nullFrame;

    public OverviewCanvas(OverviewDimensions overviewDims, AlignViewport alignvp) {
        this.od = overviewDims;
        this.av = alignvp;
        this.nullFrame = new Frame();
        this.nullFrame.addNotify();
        this.fr = new jalview.renderer.seqfeatures.FeatureRenderer(this.av);
    }

    public void resetOviewDims(OverviewDimensions overviewDims) {
        this.od = overviewDims;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restartDraw() {
        OverviewCanvas overviewCanvas = this;
        synchronized (overviewCanvas) {
            if (this.updaterunning) {
                this.restart = true;
                if (this.or != null) {
                    this.or.setRedraw(true);
                }
            } else {
                this.updaterunning = true;
            }
            return this.restart;
        }
    }

    public void draw(boolean showSequenceFeatures, boolean showAnnotation, FeatureRenderer transferRenderer) {
        this.miniMe = null;
        if (showSequenceFeatures) {
            this.fr.transferSettings(transferRenderer);
        }
        this.setPreferredSize(new Dimension(this.od.getWidth(), this.od.getHeight()));
        this.or = new OverviewRenderer(this.fr, this.od, this.av.getAlignment(), this.av.getResidueShading(), new OverviewResColourFinder());
        this.miniMe = this.nullFrame.createImage(this.od.getWidth(), this.od.getHeight());
        this.offscreen = this.nullFrame.createImage(this.od.getWidth(), this.od.getHeight());
        this.miniMe = this.or.draw(this.od.getRows(this.av.getAlignment()), this.od.getColumns(this.av.getAlignment()));
        Graphics mg = this.miniMe.getGraphics();
        if (showAnnotation) {
            mg.translate(0, this.od.getSequencesHeight());
            this.or.drawGraph(mg, this.av.getAlignmentConservationAnnotation(), this.od.getGraphHeight(), this.od.getColumns(this.av.getAlignment()));
            mg.translate(0, -this.od.getSequencesHeight());
        }
        if (this.restart) {
            this.restart = false;
            this.draw(showSequenceFeatures, showAnnotation, transferRenderer);
        } else {
            this.updaterunning = false;
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        Graphics og = this.offscreen.getGraphics();
        if (this.miniMe != null) {
            og.drawImage(this.miniMe, 0, 0, this);
            og.setColor(Color.red);
            this.od.drawBox(og);
            g.drawImage(this.offscreen, 0, 0, this);
        }
    }

    void dispose() {
        this.od = null;
    }
}

