/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.dundee.compbio.hmmerclient;

import io.github.warownia1.simplehttpclient.HttpClient;
import io.github.warownia1.simplehttpclient.HttpRequest;
import io.github.warownia1.simplehttpclient.HttpResponse;
import io.github.warownia1.simplehttpclient.impl.WWWFormURLEncodedRequestBodyBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import uk.ac.dundee.compbio.hmmerclient.PhmmerRequest;
import uk.ac.dundee.compbio.hmmerclient.ResultType;
import uk.ac.dundee.compbio.hmmerclient.XMLProcessor;

public class PhmmerClient {
    private static final URI defaultURL;
    private final URI phmmerUrl;
    private final HttpClient httpClient = HttpClient.newHttpClient();

    public PhmmerClient(URI uri) {
        this.phmmerUrl = uri;
    }

    public PhmmerClient(URL url) throws URISyntaxException {
        this(url.toURI());
    }

    public PhmmerClient() {
        this(defaultURL);
    }

    public URI getURL() {
        return this.phmmerUrl;
    }

    public boolean testEndpoint() {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder((URI)this.phmmerUrl);
        requestBuilder.GET();
        try {
            HttpResponse response = this.httpClient.send(requestBuilder.build(), HttpResponse.BodyHandlers.discarding());
            return response.statusCode() == 200;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String submit(PhmmerRequest request, String email) throws IOException {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder();
        requestBuilder.uri(this.phmmerUrl.resolve("run"));
        requestBuilder.header("Content-Type", "application/x-www-form-urlencoded");
        HttpRequest.Body body = this.prepareSubmitRequestBody(request, email);
        requestBuilder.POST(body);
        HttpResponse response = this.httpClient.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        try (InputStream stream = (InputStream)response.body();){
            if (response.statusCode() == 200) {
                String string = new String(stream.readAllBytes(), "UTF-8");
                return string;
            }
            if (response.statusCode() == 400) {
                throw XMLProcessor.processErrorBody(stream);
            }
            throw new IOException(String.format("server returned %d code for URL %s", response.statusCode(), response.uri().toString()));
        }
    }

    private HttpRequest.Body prepareSubmitRequestBody(PhmmerRequest request, String email) throws IOException {
        WWWFormURLEncodedRequestBodyBuilder body = new WWWFormURLEncodedRequestBodyBuilder();
        body.append("email", email);
        BufferedReader bufferedReader = new BufferedReader(request.getSequence());
        StringWriter sequence = new StringWriter();
        bufferedReader.transferTo(sequence);
        body.append("sequence", sequence.toString());
        body.append("database", request.getDatabase().strvalue);
        if (request.getIncE() != null) {
            body.append("incE", request.getIncE().toString());
        }
        if (request.getIncdomE() != null) {
            body.append("incdomE", request.getIncdomE().toString());
        }
        if (request.getE() != null) {
            body.append("E", request.getE().toString());
        }
        if (request.getDomE() != null) {
            body.append("domE", request.getDomE().toString());
        }
        if (request.getIncT() != null) {
            body.append("incT", request.getIncT().toString());
        }
        if (request.getIncdomT() != null) {
            body.append("incdomT", request.getIncdomT().toString());
        }
        if (request.getT() != null) {
            body.append("T", request.getT().toString());
        }
        if (request.getDomT() != null) {
            body.append("domT", request.getDomT().toString());
        }
        if (request.getPopen() != null) {
            body.append("popen", request.getPopen().toString());
        }
        if (request.getPextend() != null) {
            body.append("pextend", request.getPextend().toString());
        }
        if (request.getMx() != null) {
            body.append("mx", request.getMx().strvalue);
        }
        body.append("nobias", Boolean.toString(request.getNoBias()));
        body.append("compressedout", Boolean.toString(request.getCompressedOut()));
        body.append("alignView", Boolean.toString(request.getAlignView()));
        if (request.getEvalue() != null) {
            body.append("evalue", request.getEvalue().toString());
        }
        if (request.getNhits() != null) {
            body.append("nhits", request.getNhits().toString());
        }
        return body.build();
    }

    public Status getStatus(String jobId) throws IOException {
        HttpRequest.Builder request = HttpRequest.newBuilder((URI)this.phmmerUrl.resolve("status/" + jobId));
        HttpResponse response = this.httpClient.send(request.build(), HttpResponse.BodyHandlers.ofString());
        try {
            return Status.valueOf((String)response.body());
        }
        catch (IllegalArgumentException e) {
            throw new IOException(String.format("response body does not match any known job status \"%s\"", response.body()));
        }
    }

    public Collection<ResultType> getResultTypes(String jobId) throws IOException {
        HttpRequest.Builder request = HttpRequest.newBuilder((URI)this.phmmerUrl.resolve("resulttypes/" + jobId));
        HttpResponse response = this.httpClient.send(request.build(), (info, stream) -> {
            if (info.statusCode() != 200) {
                throw XMLProcessor.processErrorBody(stream);
            }
            return XMLProcessor.processResultTypesBody(stream);
        });
        return (Collection)response.body();
    }

    public URI getResultURL(String jobId, String identifier) {
        return this.phmmerUrl.resolve("result/" + jobId + "/" + identifier);
    }

    public InputStream getResultStream(String jobId, String identifier) throws IOException {
        return (InputStream)this.getResult(jobId, identifier, HttpResponse.BodyHandlers.ofInputStream());
    }

    public <T> T getResult(String jobId, String identifier, HttpResponse.BodyHandler<T> handler) throws IOException {
        HttpRequest.Builder request = HttpRequest.newBuilder((URI)this.getResultURL(jobId, identifier));
        HttpResponse response = this.httpClient.send(request.build(), handler);
        return (T)response.body();
    }

    static {
        try {
            defaultURL = new URI("https://www.ebi.ac.uk/Tools/services/rest/hmmer3_phmmer/");
        }
        catch (URISyntaxException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static enum Status {
        PENDING,
        QUEUED,
        RUNNING,
        FINISHED,
        ERROR,
        FAILURE,
        NOT_FOUND,
        UNDEFINED;

    }
}

