/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.treealign;

import fr.orsay.lri.varna.exceptions.MappingException;
import fr.orsay.lri.varna.models.rna.Mapping;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.models.treealign.AlignedNode;
import fr.orsay.lri.varna.models.treealign.ExampleDistance3;
import fr.orsay.lri.varna.models.treealign.RNANodeValue;
import fr.orsay.lri.varna.models.treealign.RNANodeValue2;
import fr.orsay.lri.varna.models.treealign.RNATree;
import fr.orsay.lri.varna.models.treealign.RNATree2Exception;
import fr.orsay.lri.varna.models.treealign.Tree;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class RNATree2 {
    public static Tree<RNANodeValue2> RNATree2FromRNA(RNA rNA) throws RNATree2Exception {
        Tree<RNANodeValue> tree = RNATree.RNATreeFromRNA(rNA);
        return RNATree2.RNATree2FromRNATree(tree);
    }

    public static Tree<RNANodeValue2> RNATree2FromRNATree(Tree<RNANodeValue> tree) throws RNATree2Exception {
        Tree<RNANodeValue2> tree2 = new Tree<RNANodeValue2>();
        tree2.setValue(null);
        tree2.replaceChildrenListBy(RNATree2.RNAForest2FromRNAForest(tree.getChildren()));
        return tree2;
    }

    private static void RNAForest2FromRNAForestCommitNonPaired(List<Tree<RNANodeValue2>> list, List<RNANodeValue> list2) {
        if (list2.size() > 0) {
            RNANodeValue2 rNANodeValue2 = new RNANodeValue2(false);
            rNANodeValue2.getNodes().addAll(list2);
            Tree<RNANodeValue2> tree = new Tree<RNANodeValue2>();
            tree.setValue(rNANodeValue2);
            list.add(tree);
            list2.clear();
        }
    }

    private static List<Tree<RNANodeValue2>> RNAForest2FromRNAForest(List<Tree<RNANodeValue>> list) throws RNATree2Exception {
        ArrayList<Tree<RNANodeValue2>> arrayList = new ArrayList<Tree<RNANodeValue2>>();
        LinkedList<RNANodeValue> linkedList = new LinkedList<RNANodeValue>();
        for (Tree<RNANodeValue> tree : list) {
            Tree<RNANodeValue2> tree2;
            RNANodeValue2 rNANodeValue2;
            if (tree.getValue().getRightBasePosition() == -1) {
                if (tree.getChildren().size() > 0) {
                    throw new RNATree2Exception("Non-paired base cannot have children.");
                }
                switch (tree.getValue().getOrigin()) {
                    case BASE_FROM_HELIX_STRAND5: 
                    case BASE_FROM_HELIX_STRAND3: {
                        RNATree2.RNAForest2FromRNAForestCommitNonPaired(arrayList, linkedList);
                        rNANodeValue2 = new RNANodeValue2(true);
                        rNANodeValue2.setNode(tree.getValue());
                        tree2 = new Tree();
                        tree2.setValue(rNANodeValue2);
                        arrayList.add(tree2);
                        break;
                    }
                    case BASE_FROM_UNPAIRED_REGION: {
                        linkedList.add(tree.getValue());
                        break;
                    }
                    case BASE_PAIR_FROM_HELIX: {
                        throw new RNATree2Exception("Origin is BASE_PAIR_FROM_HELIX but this is not a pair.");
                    }
                }
                continue;
            }
            RNATree2.RNAForest2FromRNAForestCommitNonPaired(arrayList, linkedList);
            rNANodeValue2 = new RNANodeValue2(true);
            rNANodeValue2.setNode(tree.getValue());
            tree2 = new Tree<RNANodeValue2>();
            tree2.setValue(rNANodeValue2);
            tree2.replaceChildrenListBy(RNATree2.RNAForest2FromRNAForest(tree.getChildren()));
            arrayList.add(tree2);
        }
        RNATree2.RNAForest2FromRNAForestCommitNonPaired(arrayList, linkedList);
        return arrayList;
    }

    public static Mapping mappingFromAlignment(Tree<AlignedNode<RNANodeValue2, RNANodeValue2>> tree) throws MappingException {
        ConvertToMapping convertToMapping = new ConvertToMapping();
        return convertToMapping.convert(tree);
    }

    private static class ConvertToMapping {
        private Mapping m;
        ExampleDistance3 sequenceAligner = new ExampleDistance3();

        private ConvertToMapping() {
        }

        public Mapping convert(Tree<AlignedNode<RNANodeValue2, RNANodeValue2>> tree) throws MappingException {
            this.m = new Mapping();
            this.convertSubTree(tree);
            return this.m;
        }

        private void convertSubTree(Tree<AlignedNode<RNANodeValue2, RNANodeValue2>> tree) throws MappingException {
            AlignedNode<RNANodeValue2, RNANodeValue2> alignedNode = tree.getValue();
            Tree<RNANodeValue2> tree2 = alignedNode.getLeftNode();
            Tree<RNANodeValue2> tree3 = alignedNode.getRightNode();
            if (tree2 != null && tree3 != null) {
                int n;
                Object object;
                Object object2;
                int n2;
                Object object3;
                RNANodeValue2 rNANodeValue2 = tree2.getValue();
                RNANodeValue2 object4 = tree3.getValue();
                if (rNANodeValue2.isSingleNode() && object4.isSingleNode()) {
                    object3 = rNANodeValue2.getNode();
                    RNANodeValue rNANodeValue = object4.getNode();
                    n2 = ((RNANodeValue)object3).getLeftBasePosition();
                    object2 = ((RNANodeValue)object3).getRightBasePosition();
                    object = rNANodeValue.getLeftBasePosition();
                    n = rNANodeValue.getRightBasePosition();
                    if (n2 >= 0 && object >= 0) {
                        this.m.addCouple(n2, (int)object);
                    }
                    if (object2 >= 0 && n >= 0) {
                        this.m.addCouple((int)object2, n);
                    }
                } else if (!rNANodeValue2.isSingleNode() && !object4.isSingleNode()) {
                    object3 = this.sequenceAligner.alignSequenceNodes(rNANodeValue2, object4).getAlignment();
                    int n3 = ((Object)object3[0]).length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        object2 = object3[0][n2];
                        object = object3[1][n2];
                        if (object2 == -1 || object == -1) continue;
                        n = rNANodeValue2.getNodes().get((int)object2).getLeftBasePosition();
                        int n4 = object4.getNodes().get((int)object).getLeftBasePosition();
                        this.m.addCouple(n, n4);
                    }
                }
            }
            for (Tree tree4 : tree.getChildren()) {
                this.convertSubTree(tree4);
            }
        }
    }
}

