/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.treealign;

import fr.orsay.lri.varna.exceptions.MappingException;
import fr.orsay.lri.varna.models.rna.Mapping;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.ModeleBaseNucleotide;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.models.treealign.AlignedNode;
import fr.orsay.lri.varna.models.treealign.RNANodeValue;
import fr.orsay.lri.varna.models.treealign.Tree;
import java.util.ArrayList;
import java.util.List;

public class RNATree {
    public static Tree<RNANodeValue> RNATreeFromRNA(RNA rNA) {
        ConvertToTree convertToTree = new ConvertToTree(rNA);
        return convertToTree.toTreeAux(0);
    }

    public static Mapping mappingFromAlignment(Tree<AlignedNode<RNANodeValue, RNANodeValue>> tree) throws MappingException {
        ConvertToMapping convertToMapping = new ConvertToMapping();
        return convertToMapping.convert(tree);
    }

    private static class ConvertToMapping {
        private Mapping m;

        private ConvertToMapping() {
        }

        public Mapping convert(Tree<AlignedNode<RNANodeValue, RNANodeValue>> tree) throws MappingException {
            this.m = new Mapping();
            this.convertSubTree(tree);
            return this.m;
        }

        private void convertSubTree(Tree<AlignedNode<RNANodeValue, RNANodeValue>> tree) throws MappingException {
            AlignedNode<RNANodeValue, RNANodeValue> alignedNode = tree.getValue();
            Tree<RNANodeValue> tree2 = alignedNode.getLeftNode();
            Tree<RNANodeValue> tree3 = alignedNode.getRightNode();
            if (tree2 != null && tree3 != null) {
                RNANodeValue rNANodeValue = tree2.getValue();
                RNANodeValue object = tree3.getValue();
                int n = rNANodeValue.getLeftBasePosition();
                int n2 = rNANodeValue.getRightBasePosition();
                int n3 = object.getLeftBasePosition();
                int n4 = object.getRightBasePosition();
                if (n >= 0 && n3 >= 0) {
                    this.m.addCouple(n, n3);
                }
                if (n2 >= 0 && n4 >= 0) {
                    this.m.addCouple(n2, n4);
                }
            }
            for (Tree tree4 : tree.getChildren()) {
                this.convertSubTree(tree4);
            }
        }
    }

    private static class ConvertToTree {
        private RNA rna;
        private int i = 0;

        public Tree<RNANodeValue> toTreeAux(int n) {
            Tree<RNANodeValue> tree = new Tree<RNANodeValue>();
            List list = tree.getChildren();
            tree.setValue(null);
            int n2 = this.rna.getSize();
            while (this.i < n2) {
                Object object;
                Object object2;
                ModeleBase modeleBase = this.rna.getBaseAt(this.i);
                int n3 = modeleBase.getElementStructure();
                if (n3 >= 0) {
                    if (n3 > this.i) {
                        object2 = new RNANodeValue();
                        ((RNANodeValue)object2).setLeftBasePosition(this.i);
                        ((RNANodeValue)object2).setRightBasePosition(n3);
                        ((RNANodeValue)object2).setOrigin(RNANodeValue.Origin.BASE_PAIR_FROM_HELIX);
                        if (modeleBase instanceof ModeleBaseNucleotide) {
                            ((RNANodeValue)object2).setLeftNucleotide(((ModeleBaseNucleotide)modeleBase).getBase());
                            ((RNANodeValue)object2).setRightNucleotide(((ModeleBaseNucleotide)this.rna.getBaseAt(n3)).getBase());
                        }
                        ++this.i;
                        object = this.toTreeAux(n + 1);
                        ((Tree)object).setValue(object2);
                        list.add(object);
                        continue;
                    }
                    ++this.i;
                    break;
                }
                object2 = new Tree();
                object = new RNANodeValue();
                ((RNANodeValue)object).setLeftBasePosition(this.i);
                if (modeleBase instanceof ModeleBaseNucleotide) {
                    ((RNANodeValue)object).setLeftNucleotide(((ModeleBaseNucleotide)modeleBase).getBase());
                }
                ((RNANodeValue)object).setOrigin(RNANodeValue.Origin.BASE_FROM_UNPAIRED_REGION);
                ArrayList<ModeleBP> arrayList = this.rna.getAuxBPs(this.i);
                for (ModeleBP modeleBP : arrayList) {
                    if (!modeleBP.isCanonical()) continue;
                    int n4 = ((ModeleBaseNucleotide)modeleBP.getPartner5()).getIndex();
                    int n5 = ((ModeleBaseNucleotide)modeleBP.getPartner3()).getIndex();
                    if (this.i == n4) {
                        ((RNANodeValue)object).setOrigin(RNANodeValue.Origin.BASE_FROM_HELIX_STRAND5);
                        continue;
                    }
                    if (this.i == n5) {
                        ((RNANodeValue)object).setOrigin(RNANodeValue.Origin.BASE_FROM_HELIX_STRAND3);
                        continue;
                    }
                    System.err.println("Warning: Base index is " + this.i + " but neither endpoint matches it (edge endpoints are " + n4 + " and " + n5 + ").");
                }
                ((Tree)object2).setValue(object);
                list.add(object2);
                ++this.i;
            }
            return tree;
        }

        public ConvertToTree(RNA rNA) {
            this.rna = rNA;
        }
    }
}

