/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.janocchio;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jmol.c.CBK;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.JmolPlugin;
import org.openscience.jmol.app.janocchio.Nmr;

public class NmrPlugin
implements JmolPlugin {
    Nmr nmrApp;
    Viewer jmolAppViewer;
    boolean started;
    private String jmolUnits;
    static String notification = "The Janocchio plugin is experimental; it has not been fully tested. Double-click and drag to create measurements in Hz.";

    @Override
    public void start(JFrame frame, Viewer vwr, Map<String, Object> jmolOptions) {
        this.jmolAppViewer = vwr;
        this.startApp();
    }

    private void startApp() {
        this.jmolUnits = (String)this.jmolAppViewer.evaluateExpression("measurementUnits");
        this.nmrApp = new Nmr(new String[]{"--Plugin", "-g" + this.jmolAppViewer.getScreenWidth() + "x" + this.jmolAppViewer.getScreenHeight()}, this);
        this.nmrApp.mainFrame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (notification != null) {
                    JOptionPane.showMessageDialog(NmrPlugin.this.nmrApp.mainFrame, notification);
                    NmrPlugin.this.nmrApp.nmrPanel.coupleTable.setCHequation("none");
                }
                notification = null;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                NmrPlugin.this.transferStateToJmol();
                NmrPlugin.this.nmrApp = null;
                NmrPlugin.this.started = false;
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.started = true;
    }

    private void transferStateFromJmol() {
        String state = this.jmolAppViewer.getStateInfo();
        this.nmrApp.nmrPanel.vwr.script(state);
        this.jmolAppViewer.script("select none;set measurementUnits HZ");
    }

    void transferStateToJmol() {
        this.jmolAppViewer.script(this.nmrApp.nmrPanel.vwr.getStateInfo());
        this.jmolAppViewer.script("select off none;set measurementUnits " + this.jmolUnits);
    }

    @Override
    public void destroy() {
        try {
            this.nmrApp.nmrPanel.frame.dispose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.started = false;
    }

    @Override
    public String getVersion() {
        return "0.1.0";
    }

    @Override
    public String getName() {
        return "Janocchio";
    }

    @Override
    public void setVisible(boolean b) {
        if (!b) {
            this.transferStateToJmol();
        }
        if (this.started) {
            this.transferStateFromJmol();
            this.nmrApp.nmrPanel.frame.setVisible(b);
        }
    }

    @Override
    public void notifyCallback(CBK type, Object[] data) {
    }

    @Override
    public ImageIcon getMenuIcon() {
        return null;
    }

    @Override
    public String getMenuText() {
        return "Janocchio NMR";
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public String getWebSite() {
        return "http://janocchio.sourceforge.net/index.html";
    }
}

