/*
 * Decompiled with CFR 0.152.
 */
package org.gennbo;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javajs.util.AU;
import javajs.util.PT;
import org.gennbo.NBODialog;
import org.gennbo.NBORequest;
import org.jmol.viewer.Viewer;

public class NBOService {
    static final int MODE_ERROR = -1;
    static final int MODE_RAW = 0;
    protected Viewer vwr;
    protected Process nboServer;
    protected Thread nboListener;
    protected NBODialog dialog;
    protected NBORequest currentRequest;
    protected Object lock;
    protected Queue<NBORequest> requestQueue;
    private PrintWriter nboIn;
    protected BufferedInputStream nboOut;
    private boolean cantStartServer;
    private String serverPath;
    private String exeName = "NBOServe";
    private boolean doConnect;
    private boolean isReady;
    byte[] buffer = new byte[1024];
    String cachedReply = "";
    private NBORunnable nboRunnable;
    private boolean haveLicense;

    protected void setReady(boolean tf) {
        this.isReady = tf;
    }

    public NBOService(NBODialog nboDialog, Viewer vwr, boolean doConnect) {
        this.dialog = nboDialog;
        this.vwr = vwr;
        this.doConnect = doConnect;
        this.setServerPath(nboDialog.nboPlugin.getNBOProperty("serverPath", System.getProperty("user.home") + "/NBOServe"));
        this.requestQueue = new ArrayDeque<NBORequest>();
        this.lock = new Object();
    }

    boolean isOffLine() {
        return this.cantStartServer;
    }

    String getServerPath(String fileName) {
        return fileName == null ? this.serverPath : this.serverPath + "/" + fileName;
    }

    protected void setServerPath(String path) {
        this.serverPath = path.replace('\\', '/');
        this.dialog.nboPlugin.setNBOProperty("serverPath", path);
    }

    protected boolean isEnabled() {
        return this.serverPath != null;
    }

    public boolean isWorking() {
        return this.currentRequest != null;
    }

    String startProcess() {
        try {
            this.cantStartServer = true;
            if (!this.doConnect) {
                return null;
            }
            this.nboListener = null;
            String path = this.getServerPath(this.exeName);
            System.out.println("startProcess: " + path);
            ProcessBuilder builder = new ProcessBuilder(path);
            builder.directory(new File(new File(path).getParent()));
            builder.redirectErrorStream(true);
            this.nboServer = builder.start();
            this.nboOut = (BufferedInputStream)this.nboServer.getInputStream();
            System.out.println("startProcess:" + this.nboServer);
            this.nboRunnable = new NBORunnable();
            this.nboListener = new Thread(this.nboRunnable);
            this.nboListener.setName("NBOServiceThread" + System.currentTimeMillis());
            this.nboListener.start();
            this.nboIn = new PrintWriter(this.nboServer.getOutputStream());
        }
        catch (IOException e) {
            String s = e.getMessage();
            System.out.println(s);
            if (s.contains("error=1455")) {
                s = "Jmol can't do that - low on memory";
            }
            this.dialog.logError(s);
            return s;
        }
        this.cantStartServer = false;
        return null;
    }

    public void closeProcess(boolean andPause) {
        if (this.nboRunnable != null) {
            this.nboRunnable.destroyed = true;
            andPause = true;
        }
        if (andPause) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setReady(false);
        this.nboOut = null;
        try {
            this.nboIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nboIn = null;
        try {
            this.nboListener.interrupt();
        }
        catch (Exception e) {
            System.out.println("can't interrupt");
        }
        this.nboListener = null;
        try {
            this.nboServer.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nboServer = null;
        this.currentRequest = null;
    }

    String restart() {
        this.closeProcess(true);
        return this.startProcess();
    }

    public boolean restartIfNecessary() {
        if (this.nboServer == null) {
            this.startProcess();
        }
        return this.nboServer != null;
    }

    public boolean haveGenNBO() {
        if (!this.doConnect) {
            return true;
        }
        File f = new File(this.getServerPath("gennbo.bat"));
        if (!f.exists()) {
            this.vwr.alert(f + " not found, make sure gennbo.bat is in same directory as " + this.exeName);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postToNBO(NBORequest request) {
        Object object = this.lock;
        synchronized (object) {
            this.restartIfNecessary();
            if (this.isReady && this.requestQueue.isEmpty() && this.currentRequest == null) {
                this.currentRequest = request;
                this.requestQueue.add(this.currentRequest);
                this.startRequest(this.currentRequest);
            } else {
                this.requestQueue.add(request);
            }
        }
    }

    public void clearQueue() {
        this.requestQueue.clear();
    }

    protected void startRequest(NBORequest request) {
        if (request == null || this.nboRunnable.destroyed) {
            return;
        }
        System.out.println("starting request for " + request.statusInfo + " " + request);
        if (request.timeStamp != 0L) {
            System.out.println("SENDING TWICE?");
            this.nboRunnable.destroyed = true;
            return;
        }
        request.timeStamp = System.currentTimeMillis();
        this.currentRequest = request;
        String cmdFileName = null;
        String data = null;
        int n = request.fileData.length;
        for (int i = 2; i < n + 2; i += 2) {
            cmdFileName = request.fileData[i % n];
            data = request.fileData[(i + 1) % n];
            if (cmdFileName == null) continue;
            this.dialog.inputFileHandler.writeToFile(this.getServerPath(cmdFileName), data);
            System.out.println("saved file " + cmdFileName + "\n" + data + "\n");
        }
        this.dialog.setStatus(request.statusInfo);
        String cmd = "<" + cmdFileName + ">";
        System.out.println("sending " + cmd);
        if (this.nboIn == null) {
            this.restart();
        }
        this.nboIn.println(cmd);
        this.nboIn.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processServerReturn(String s) {
        if (s.indexOf("FORTRAN STOP") >= 0) {
            System.out.println(s);
            this.dialog.alertError("NBOServe has stopped working - restarting");
            this.currentRequest = null;
            this.clearQueue();
            this.restart();
            return true;
        }
        if (s.indexOf("**NBOServe fatal error**") >= 0) {
            int index = s.indexOf("**NBOServe fatal error**");
            s = s.substring(index);
            String[] errorLines = s.split("\n");
            for (int i = 0; i < errorLines.length; ++i) {
                this.logServerLine(errorLines[i], 2);
            }
            this.dialog.alertError("NBOServe has stopped working - restarting");
            this.currentRequest = null;
            this.clearQueue();
            this.restart();
            return true;
        }
        if (this.isFortranError(s) || s.indexOf("missing or invalid") >= 0) {
            if (!s.contains("end of file")) {
                this.dialog.alertError(s);
            }
            this.currentRequest = null;
            this.clearQueue();
            this.restart();
            return true;
        }
        boolean removeRequest = true;
        try {
            int pt = s.indexOf("***errmess***");
            if (pt >= 0) {
                System.out.println(s);
                try {
                    s = PT.split(s, "\n")[2];
                    this.logServerLine(s.substring(s.indexOf("\n") + 1), 2);
                }
                catch (Exception errorLines) {
                    // empty catch block
                }
                this.logServerLine("NBOPro can't do that.", 3);
                boolean errorLines = true;
                return errorLines;
            }
            pt = s.indexOf("**NBOServe warning**");
            if (pt >= 0) {
                try {
                    int index = s.indexOf("**NBOServe warning**");
                    s = s.substring(index);
                    String[] errorLines = s.split("\n");
                    for (int i = 0; i < errorLines.length; ++i) {
                        this.logServerLine(errorLines[i], 2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.logServerLine("NBOPro can't do that.", 3);
                boolean bl = true;
                return bl;
            }
            pt = s.lastIndexOf("*start*");
            if (pt < 0) {
                if (this.currentRequest == null) {
                    removeRequest = true;
                    boolean bl = true;
                    return bl;
                }
                this.logServerLine(s, this.currentRequest.isMessy ? 5 : 2);
                removeRequest = !this.currentRequest.isMessy;
                boolean bl = removeRequest;
                return bl;
            }
            if ((pt = (s = s.substring(pt + 8)).indexOf("*end*")) < 0) {
                System.out.println("...listening...");
                removeRequest = false;
                boolean bl = false;
                return bl;
            }
            if (this.currentRequest == null) {
                if (this.haveLicense) {
                    System.out.println("TRANSMISSION ERROR: UNSOLICITED!");
                } else {
                    this.haveLicense = true;
                    this.dialog.setLicense(s);
                }
            } else {
                this.currentRequest.sendReply(s.substring(0, pt));
            }
            if (this.currentRequest != null && this.currentRequest.isVideoCreate) {
                this.dialog.logValue("Video Create has been completed.");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.currentRequest != null && removeRequest) {
                this.requestQueue.remove();
                this.currentRequest = null;
                this.dialog.setStatus("");
            }
        }
    }

    protected void logServerLine(String line, int level) {
        this.dialog.logInfo(line, level);
        if (level == 2) {
            this.dialog.setStatus("");
        }
    }

    protected boolean isFortranError(String line) {
        return line.indexOf("Permission denied") >= 0 || line.indexOf("PGFIO-F") >= 0 || line.indexOf("Invalid command") >= 0;
    }

    class NBORunnable
    implements Runnable {
        protected boolean destroyed;

        NBORunnable() {
        }

        @Override
        public void run() {
            while (!this.destroyed && !Thread.currentThread().isInterrupted()) {
                try {
                    String s;
                    if (NBOService.this.currentRequest == null || !NBOService.this.currentRequest.isVideoCreate) {
                        Thread.sleep(10L);
                    }
                    if (this.destroyed || (s = this.getNBOMessage()) == null || !NBOService.this.processServerReturn(s)) continue;
                    NBOService.this.cachedReply = "";
                    if (this.destroyed) continue;
                    NBOService.this.currentRequest = NBOService.this.requestQueue.peek();
                    NBOService.this.startRequest(NBOService.this.currentRequest);
                }
                catch (Throwable e1) {
                    NBOService.this.clearQueue();
                    e1.printStackTrace();
                    NBOService.this.dialog.setStatus(e1.getMessage());
                }
            }
            if (this.destroyed) {
                NBOService.this.closeProcess(false);
            }
        }

        protected synchronized String getNBOMessage() throws IOException, InterruptedException {
            int n;
            int n2 = n = NBOService.this.nboOut == null ? 0 : NBOService.this.nboOut.available();
            if (n <= 0) {
                return null;
            }
            NBOService.this.setReady(true);
            while (n > NBOService.this.buffer.length) {
                NBOService.this.buffer = AU.doubleLengthByte(NBOService.this.buffer);
            }
            n = NBOService.this.nboOut.read(NBOService.this.buffer, 0, n);
            String s = PT.rep(new String(NBOService.this.buffer, 0, n), "\r", "");
            if (NBOService.this.currentRequest != null && NBOService.this.currentRequest.isVideoCreate) {
                this.displayCreateVideoProgress(s);
            }
            System.out.println(">> " + s + "<<");
            NBOService.this.cachedReply = NBOService.this.cachedReply + s;
            return NBOService.this.cachedReply;
        }

        private void displayCreateVideoProgress(String s) {
            s = s.trim();
            if ((s = s.replace("\\", "/")).equals("*start*") || s.equals("*end*")) {
                return;
            }
            Pattern pattern = Pattern.compile("(.*/)(\\w+_?\\d*\\.bmp$)");
            Matcher matcher = pattern.matcher(s);
            if (matcher.matches()) {
                NBOService.this.dialog.setStatus(matcher.group(2) + " has been created.");
            }
        }
    }
}

