/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class ClassPath {
    private final Set<File> _classPathEntries;

    public ClassPath(LinkedHashSet<File> classPathEntries) {
        this._classPathEntries = Collections.unmodifiableSet(classPathEntries);
    }

    public String asArgumentString() {
        StringBuilder builder = new StringBuilder();
        String delimiter = "";
        for (File entry : this._classPathEntries) {
            builder.append(delimiter).append(entry.getAbsolutePath());
            delimiter = File.pathSeparator;
        }
        return builder.toString();
    }

    public URL[] asUrls() {
        URL[] urls = new URL[this._classPathEntries.size()];
        int i = 0;
        for (File entry : this._classPathEntries) {
            urls[i++] = ClassPath.getURL(entry);
        }
        return urls;
    }

    public Set<File> getClassPathEntries() {
        return this._classPathEntries;
    }

    private static URL getURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("URL of file is illegal: " + file.getAbsolutePath(), e);
        }
    }
}

