/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.cache;

import com.threerings.getdown.util.FileUtil;
import java.io.File;

public class GarbageCollector {
    public static void collect(File cacheDir, final long retentionPeriodMillis) {
        FileUtil.walkTree(cacheDir, new FileUtil.Visitor(){

            @Override
            public void visit(File file) {
                String[] children;
                File cachedFile = GarbageCollector.getCachedFile(file);
                File lastAccessedFile = GarbageCollector.getLastAccessedFile(file);
                if (!cachedFile.exists() || !lastAccessedFile.exists()) {
                    if (cachedFile.exists()) {
                        FileUtil.deleteHarder(cachedFile);
                    } else {
                        FileUtil.deleteHarder(lastAccessedFile);
                    }
                } else if (GarbageCollector.shouldDelete(lastAccessedFile, retentionPeriodMillis)) {
                    FileUtil.deleteHarder(lastAccessedFile);
                    FileUtil.deleteHarder(cachedFile);
                }
                File folder = file.getParentFile();
                if (folder != null && (children = folder.list()) != null && children.length == 0) {
                    FileUtil.deleteHarder(folder);
                }
            }
        });
    }

    public static void collectNative(File cacheDir, long retentionPeriodMillis) {
        File[] subdirs = cacheDir.listFiles();
        if (subdirs != null) {
            for (File dir : subdirs) {
                if (!dir.isDirectory()) continue;
                for (File file : dir.listFiles()) {
                    if (!file.getName().endsWith(".jar")) continue;
                    File cachedFile = GarbageCollector.getCachedFile(file);
                    File lastAccessedFile = GarbageCollector.getLastAccessedFile(file);
                    if (cachedFile.exists() && lastAccessedFile.exists() && !GarbageCollector.shouldDelete(lastAccessedFile, retentionPeriodMillis)) continue;
                    FileUtil.deleteDirHarder(dir);
                }
            }
        }
    }

    private static boolean shouldDelete(File lastAccessedFile, long retentionMillis) {
        return System.currentTimeMillis() - lastAccessedFile.lastModified() > retentionMillis;
    }

    private static File getLastAccessedFile(File file) {
        return GarbageCollector.isLastAccessedFile(file) ? file : new File(file.getParentFile(), file.getName() + ".lastAccessed");
    }

    private static boolean isLastAccessedFile(File file) {
        return file.getName().endsWith(".lastAccessed");
    }

    private static File getCachedFile(File file) {
        return !GarbageCollector.isLastAccessedFile(file) ? file : new File(file.getParentFile(), file.getName().substring(0, file.getName().lastIndexOf(".")));
    }
}

