/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.AlignViewportI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.SequenceI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ResidueColourScheme;
import jalview.util.Comparison;
import java.awt.Color;

public class ScoreColourScheme
extends ResidueColourScheme {
    public double min;
    public double max;
    public double[] scores;

    public ScoreColourScheme(int[] symbolIndex, double[] scores, double min, double max) {
        super(symbolIndex);
        this.scores = scores;
        this.min = min;
        this.max = max;
        int iSize = scores.length;
        this.colors = new Color[scores.length];
        for (int i = 0; i < iSize; ++i) {
            float score = (float)(scores[i] - (double)((float)min)) / (float)(max - min);
            if (score > 1.0f) {
                score = 1.0f;
            }
            if (score < 0.0f) {
                score = 0.0f;
            }
            this.colors[i] = this.makeColour(score);
        }
    }

    @Override
    public Color findColour(char c, int j, SequenceI seq) {
        if (Comparison.isGap(c)) {
            return Color.white;
        }
        return super.findColour(c);
    }

    public Color makeColour(float c) {
        return new Color(c, 0.0f, 1.0f - c);
    }

    @Override
    public String getSchemeName() {
        return "Score";
    }

    @Override
    public ColourSchemeI getInstance(AlignViewportI view, AnnotatedCollectionI coll) {
        return new ScoreColourScheme(this.symbolIndex, this.scores, this.min, this.max);
    }
}

