/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.ContactMatrix;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PContactPredictionFile
extends AlignFile {
    protected static final String CONTACT_PREDICTION = "CONTACT_PREDICTION";
    Integer fWidth;
    List<ContactMatrix> models = new ArrayList<ContactMatrix>();

    public PContactPredictionFile(String inFile, DataSourceType fileSourceType) throws IOException {
        super(inFile, fileSourceType);
    }

    public PContactPredictionFile(FileParse source) throws IOException {
        super(source);
    }

    public List<ContactMatrix> getContactMatrices() {
        return this.models;
    }

    @Override
    public void parse() throws IOException {
        String line;
        HashMap header = new HashMap();
        ContactMatrix cm = null;
        while ((line = this.nextLine()) != null) {
            int right;
            int left;
            double strength = Double.NaN;
            String[] parts = line.split("\\s+");
            if (parts.length != 3) continue;
            if (cm == null) {
                cm = new ContactMatrix(true){

                    @Override
                    public String getType() {
                        return PContactPredictionFile.CONTACT_PREDICTION;
                    }

                    @Override
                    public int getHeight() {
                        return 0;
                    }

                    @Override
                    public int getWidth() {
                        return 0;
                    }
                };
                this.models.add(cm);
            }
            try {
                left = Integer.parseInt(parts[0]);
                right = Integer.parseInt(parts[1]);
                strength = Double.parseDouble(parts[2]);
            }
            catch (Exception x) {
                this.error = true;
                this.errormessage = "Couldn't process line: " + x.getLocalizedMessage() + "\n" + line;
                return;
            }
            cm.addContact(left, right, (float)strength);
        }
        throw new Error("Not Implemented yet.");
    }

    @Override
    public String print(SequenceI[] sqs, boolean jvsuffix) {
        return "Not valid.";
    }
}

