/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.gui.Desktop;
import jalview.util.MessageManager;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public abstract class JalviewDialog
extends JPanel {
    protected JDialog frame;
    protected JButton ok = new JButton();
    protected JButton cancel = new JButton();
    boolean block = false;

    public void waitForInput() {
        if (!this.block) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    JalviewDialog.this.frame.setVisible(true);
                }
            }).start();
        } else {
            this.frame.setVisible(true);
        }
    }

    protected void initDialogFrame(Container content, boolean modal, boolean block, String title, int width, int height) {
        this.frame = new JDialog((Frame)Desktop.instance, modal);
        this.frame.setTitle(title);
        if (Desktop.instance != null) {
            Rectangle deskr = Desktop.instance.getBounds();
            this.frame.setBounds(new Rectangle((int)(deskr.getCenterX() - (double)(width / 2)), (int)(deskr.getCenterY() - (double)(height / 2)), width, height));
        } else {
            this.frame.setSize(width, height);
        }
        int minWidth = width - 100;
        int minHeight = height - 100;
        this.frame.setMinimumSize(new Dimension(minWidth, minHeight));
        this.frame.setContentPane(content);
        this.block = block;
        this.ok.setOpaque(false);
        this.ok.setText(MessageManager.getString("action.ok"));
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JalviewDialog.this.okPressed();
                JalviewDialog.this.closeDialog();
            }
        });
        this.cancel.setOpaque(false);
        this.cancel.setText(MessageManager.getString("action.cancel"));
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JalviewDialog.this.cancelPressed();
                JalviewDialog.this.closeDialog();
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JalviewDialog.this.closeDialog();
            }
        });
    }

    protected void closeDialog() {
        try {
            this.raiseClosed();
            this.frame.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract void raiseClosed();

    protected abstract void okPressed();

    protected abstract void cancelPressed();
}

