/*
 * Decompiled with CFR 0.152.
 */
package jalview.fts.core;

import jalview.bin.Cache;
import jalview.fts.api.FTSDataColumnI;
import jalview.fts.api.GFTSPanelI;
import jalview.fts.core.FTSDataColumnPreferences;
import jalview.gui.Desktop;
import jalview.gui.IProgressIndicator;
import jalview.gui.JvSwingUtils;
import jalview.gui.SequenceFetcher;
import jalview.io.cache.JvCacheableInputBox;
import jalview.util.MessageManager;
import jalview.util.Platform;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public abstract class GFTSPanel
extends JPanel
implements GFTSPanelI {
    private static final Font VERDANA_12 = new Font("Verdana", 0, 12);
    protected JInternalFrame mainFrame = new JInternalFrame(this.getFTSFrameTitle());
    protected JTabbedPane tabs = new JTabbedPane();
    protected IProgressIndicator progressIndicator;
    protected JComboBox<FTSDataColumnI> cmb_searchTarget = new JComboBox();
    protected JButton btn_ok = new JButton();
    protected JButton btn_back = new JButton();
    protected JButton btn_cancel = new JButton();
    protected JCheckBox btn_autosearch = new JCheckBox();
    protected JvCacheableInputBox<String> txt_search;
    protected SequenceFetcher seqFetcher;
    protected Collection<FTSDataColumnI> wantedFields;
    private String lastSearchTerm = "";
    protected JButton btn_next_page = new JButton();
    protected JButton btn_prev_page = new JButton();
    protected StringBuilder errorWarning = new StringBuilder();
    protected ImageIcon warningImage = new ImageIcon(this.getClass().getResource("/images/warning.gif"));
    protected ImageIcon loadingImage = new ImageIcon(this.getClass().getResource("/images/loading.gif"));
    protected ImageIcon balnkPlaceholderImage = new ImageIcon(this.getClass().getResource("/images/blank_16x16_placeholder.png"));
    protected JLabel lbl_warning = new JLabel(this.warningImage);
    protected JLabel lbl_loading = new JLabel(this.loadingImage);
    protected JLabel lbl_blank = new JLabel(this.balnkPlaceholderImage);
    JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel pnl_actions = new JPanel();
    private JPanel pnl_results = new JPanel(new CardLayout());
    private JPanel pnl_inputs = new JPanel();
    private BorderLayout mainLayout = new BorderLayout();
    protected Object[] previousWantedFields;
    protected int resultSetCount;
    protected int totalResultSetCount;
    protected int offSet;
    protected int pageLimit;
    protected HashSet<String> paginatorCart = new HashSet();
    private static final int MIN_WIDTH = 670;
    private static final int MIN_HEIGHT = 300;
    protected static final DecimalFormat totalNumberformatter = new DecimalFormat("###,###");
    private JTable tbl_summary = new JTable(){
        private boolean inLayout;

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return this.hasExcessWidth();
        }

        @Override
        public void doLayout() {
            if (this.hasExcessWidth()) {
                this.autoResizeMode = 2;
            }
            this.inLayout = true;
            super.doLayout();
            this.inLayout = false;
            this.autoResizeMode = 0;
        }

        protected boolean hasExcessWidth() {
            return this.getPreferredSize().width < this.getParent().getWidth();
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            TableColumn resizingColumn;
            if (this.isEditing()) {
                this.removeEditor();
            }
            if ((resizingColumn = this.getTableHeader().getResizingColumn()) != null && this.autoResizeMode == 0 && !this.inLayout) {
                resizingColumn.setPreferredWidth(resizingColumn.getWidth());
                String colHeader = resizingColumn.getHeaderValue().toString();
                GFTSPanel.this.getTempUserPrefs().put(colHeader, resizingColumn.getWidth());
            }
            this.resizeAndRepaint();
        }

        @Override
        public String getToolTipText(MouseEvent evt) {
            String toolTipText = null;
            Point pnt = evt.getPoint();
            int rowIndex = this.rowAtPoint(pnt);
            int colIndex = this.columnAtPoint(pnt);
            try {
                if (this.getValueAt(rowIndex, colIndex) == null) {
                    return null;
                }
                toolTipText = this.getValueAt(rowIndex, colIndex).toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            toolTipText = toolTipText == null ? null : (toolTipText.length() > 500 ? JvSwingUtils.wrapTooltip(true, toolTipText.subSequence(0, 500) + "...") : JvSwingUtils.wrapTooltip(true, toolTipText));
            return toolTipText;
        }
    };
    protected JScrollPane scrl_searchResult = new JScrollPane(this.tbl_summary);

    public GFTSPanel() {
        this((SequenceFetcher)null);
    }

    public GFTSPanel(SequenceFetcher fetcher) {
        try {
            if (fetcher == null) {
                this.tabs = null;
            }
            this.jbInit();
            if (fetcher != null) {
                this.tabs.addTab(MessageManager.getString("label.retrieve_ids"), fetcher);
                fetcher.embedIn(this);
            }
            this.mainFrame.setMinimumSize(new Dimension(670, 300));
            final GFTSPanel ftsPanel = this;
            this.mainFrame.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (GFTSPanel.this.tabs != null && GFTSPanel.this.tabs.getSelectedComponent() == ftsPanel) {
                        GFTSPanel.this.txt_search.getComponent().requestFocusInWindow();
                    }
                }
            });
            this.mainFrame.invalidate();
            this.mainFrame.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.txt_search = new JvCacheableInputBox(this.getCacheKey(), 45);
        this.populateCmbSearchTargetOptions();
        Integer width = this.getTempUserPrefs().get("FTSPanel.width") == null ? 800 : this.getTempUserPrefs().get("FTSPanel.width");
        Integer height = this.getTempUserPrefs().get("FTSPanel.height") == null ? 400 : this.getTempUserPrefs().get("FTSPanel.height");
        this.lbl_warning.setVisible(false);
        this.lbl_warning.setFont(VERDANA_12);
        this.lbl_loading.setVisible(false);
        this.lbl_loading.setFont(VERDANA_12);
        this.lbl_blank.setVisible(true);
        this.lbl_blank.setFont(VERDANA_12);
        this.tbl_summary.setAutoCreateRowSorter(true);
        this.tbl_summary.getTableHeader().setReorderingAllowed(false);
        this.tbl_summary.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GFTSPanel.this.validateSelection();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                GFTSPanel.this.validateSelection();
            }
        });
        this.tbl_summary.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                GFTSPanel.this.validateSelection();
                switch (evt.getKeyCode()) {
                    case 27: {
                        GFTSPanel.this.btn_back_ActionPerformed();
                        break;
                    }
                    case 10: {
                        if (GFTSPanel.this.btn_ok.isEnabled()) {
                            GFTSPanel.this.okAction();
                        }
                        evt.consume();
                        break;
                    }
                    case 9: {
                        if (evt.isShiftDown()) {
                            GFTSPanel.this.tabbedPane.requestFocus();
                        } else {
                            GFTSPanel.this.btn_back.requestFocus();
                        }
                        evt.consume();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        });
        JButton txt_help = new JButton("?");
        txt_help.setFont(VERDANA_12);
        txt_help.setPreferredSize(new Dimension(15, 15));
        txt_help.setToolTipText(MessageManager.getString("action.help"));
        txt_help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GFTSPanel.this.showHelp();
            }
        });
        this.btn_autosearch.setText(MessageManager.getString("option.autosearch"));
        this.btn_autosearch.setToolTipText(MessageManager.getString("option.enable_disable_autosearch"));
        this.btn_autosearch.setSelected(!Platform.isJS() && Cache.getDefault(this.getAutosearchPreference(), false));
        this.btn_autosearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cache.setProperty(GFTSPanel.this.getAutosearchPreference(), Boolean.toString(GFTSPanel.this.btn_autosearch.isSelected()));
            }
        });
        this.btn_back.setFont(VERDANA_12);
        this.btn_back.setText(MessageManager.getString("action.back"));
        this.btn_back.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GFTSPanel.this.btn_back_ActionPerformed();
            }
        });
        this.btn_back.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    GFTSPanel.this.btn_back_ActionPerformed();
                }
            }
        });
        this.btn_ok.setEnabled(false);
        this.btn_ok.setFont(VERDANA_12);
        this.btn_ok.setText(MessageManager.getString("action.ok"));
        this.btn_ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GFTSPanel.this.okAction();
            }
        });
        this.btn_ok.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    GFTSPanel.this.okAction();
                }
            }
        });
        this.btn_next_page.setEnabled(false);
        this.btn_next_page.setToolTipText(MessageManager.getString("label.next_page_tooltip"));
        this.btn_next_page.setFont(VERDANA_12);
        this.btn_next_page.setText(MessageManager.getString("action.next_page"));
        this.btn_next_page.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GFTSPanel.this.nextPageAction();
            }
        });
        this.btn_next_page.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    GFTSPanel.this.nextPageAction();
                }
            }
        });
        this.btn_prev_page.setEnabled(false);
        this.btn_prev_page.setToolTipText(MessageManager.getString("label.prev_page_tooltip"));
        this.btn_prev_page.setFont(VERDANA_12);
        this.btn_prev_page.setText(MessageManager.getString("action.prev_page"));
        this.btn_prev_page.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GFTSPanel.this.prevPageAction();
            }
        });
        this.btn_prev_page.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    GFTSPanel.this.prevPageAction();
                }
            }
        });
        if (this.isPaginationEnabled()) {
            this.btn_prev_page.setVisible(true);
            this.btn_next_page.setVisible(true);
        } else {
            this.btn_prev_page.setVisible(false);
            this.btn_next_page.setVisible(false);
        }
        this.btn_cancel.setFont(VERDANA_12);
        this.btn_cancel.setText(MessageManager.getString("action.cancel"));
        this.btn_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GFTSPanel.this.btn_cancel_ActionPerformed();
            }
        });
        this.btn_cancel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    GFTSPanel.this.btn_cancel_ActionPerformed();
                }
            }
        });
        this.scrl_searchResult.setPreferredSize(new Dimension(width, height));
        this.cmb_searchTarget.setFont(VERDANA_12);
        this.cmb_searchTarget.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String tooltipText = "all".equalsIgnoreCase(GFTSPanel.this.getCmbSearchTarget().getSelectedItem().toString()) ? MessageManager.getString("label.search_all") : ("pdb id".equalsIgnoreCase(GFTSPanel.this.getCmbSearchTarget().getSelectedItem().toString()) ? MessageManager.getString("label.separate_multiple_accession_ids") : MessageManager.formatMessage("label.separate_multiple_query_values", GFTSPanel.this.getCmbSearchTarget().getSelectedItem().toString()));
                    GFTSPanel.this.txt_search.getComponent().setToolTipText(JvSwingUtils.wrapTooltip(true, tooltipText));
                    GFTSPanel.this.searchAction(true);
                    GFTSPanel.this.setCmbSearchTargetTooltip();
                }
            }
        });
        this.txt_search.getComponent().setFont(VERDANA_12);
        this.txt_search.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (GFTSPanel.this.getTypedText() == null || GFTSPanel.this.getTypedText().isEmpty()) {
                        return;
                    }
                    String primaryKeyName = GFTSPanel.this.getFTSRestClient().getPrimaryKeyColumn().getName();
                    if (primaryKeyName.equalsIgnoreCase(GFTSPanel.this.getCmbSearchTarget().getSelectedItem().toString())) {
                        GFTSPanel.this.transferToSequenceFetcher(GFTSPanel.this.getTypedText());
                    } else {
                        GFTSPanel.this.performSearchAction();
                    }
                }
            }
        });
        final DeferredTextInputListener listener = new DeferredTextInputListener(1500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GFTSPanel.this.btn_autosearch.isSelected() || GFTSPanel.this.txt_search.wasEnterPressed()) {
                    GFTSPanel.this.performSearchAction();
                }
            }
        }, false);
        this.txt_search.addDocumentListener(listener);
        this.txt_search.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                listener.start();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.txt_search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GFTSPanel.this.performSearchAction();
            }
        });
        final String searchTabTitle = MessageManager.getString("label.search_result");
        final String configureCols = MessageManager.getString("label.configure_displayed_columns");
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane sourceTabbedPane = (JTabbedPane)changeEvent.getSource();
                int index = sourceTabbedPane.getSelectedIndex();
                GFTSPanel.this.btn_back.setVisible(true);
                GFTSPanel.this.btn_cancel.setVisible(true);
                GFTSPanel.this.btn_ok.setVisible(true);
                if (sourceTabbedPane.getTitleAt(index).equals(configureCols)) {
                    GFTSPanel.this.btn_back.setVisible(false);
                    GFTSPanel.this.btn_cancel.setVisible(false);
                    GFTSPanel.this.btn_ok.setVisible(false);
                    GFTSPanel.this.btn_back.setEnabled(false);
                    GFTSPanel.this.btn_cancel.setEnabled(false);
                    GFTSPanel.this.btn_ok.setEnabled(false);
                    GFTSPanel.this.btn_next_page.setEnabled(false);
                    GFTSPanel.this.btn_prev_page.setEnabled(false);
                    GFTSPanel.this.txt_search.getComponent().setEnabled(false);
                    GFTSPanel.this.cmb_searchTarget.setEnabled(false);
                    GFTSPanel.this.previousWantedFields = GFTSPanel.this.getFTSRestClient().getAllDefaultDisplayedFTSDataColumns().toArray(new Object[0]);
                }
                if (sourceTabbedPane.getTitleAt(index).equals(searchTabTitle)) {
                    GFTSPanel.this.btn_back.setEnabled(true);
                    GFTSPanel.this.btn_cancel.setEnabled(true);
                    GFTSPanel.this.refreshPaginatorState();
                    GFTSPanel.this.txt_search.getComponent().setEnabled(true);
                    GFTSPanel.this.cmb_searchTarget.setEnabled(true);
                    if (GFTSPanel.this.wantedFieldsUpdated()) {
                        GFTSPanel.this.searchAction(true);
                        GFTSPanel.this.paginatorCart.clear();
                    } else {
                        GFTSPanel.this.validateSelection();
                    }
                }
            }
        };
        this.tabbedPane.addChangeListener(changeListener);
        this.tabbedPane.setPreferredSize(new Dimension(width, height));
        this.tabbedPane.add(searchTabTitle, this.scrl_searchResult);
        this.tabbedPane.add(configureCols, new FTSDataColumnPreferences(FTSDataColumnPreferences.PreferenceSource.SEARCH_SUMMARY, this.getFTSRestClient()));
        this.pnl_actions.add(this.btn_back);
        this.pnl_actions.add(this.btn_ok);
        this.pnl_actions.add(this.btn_cancel);
        this.pnl_results.add(this.tabbedPane);
        this.setCmbSearchTargetTooltip();
        this.pnl_inputs.add(this.cmb_searchTarget);
        this.pnl_inputs.add(this.txt_search.getComponent());
        this.pnl_inputs.add(txt_help);
        this.pnl_inputs.add(this.btn_autosearch);
        this.pnl_inputs.add(this.lbl_loading);
        this.pnl_inputs.add(this.lbl_warning);
        this.pnl_inputs.add(this.lbl_blank);
        this.pnl_inputs.add(this.btn_prev_page);
        this.pnl_inputs.add(this.btn_next_page);
        this.setLayout(this.mainLayout);
        this.add((Component)this.pnl_inputs, "North");
        this.add((Component)this.pnl_results, "Center");
        this.add((Component)this.pnl_actions, "South");
        this.mainFrame.setFrameIcon(null);
        this.mainFrame.setVisible(true);
        if (this.tabs != null) {
            this.tabs.setOpaque(true);
            this.tabs.insertTab(MessageManager.getString("label.free_text_search"), null, this, "", 0);
            this.mainFrame.setContentPane(this.tabs);
            this.tabs.setVisible(true);
        } else {
            this.mainFrame.setContentPane(this);
        }
        this.mainFrame.setDefaultCloseOperation(2);
        this.mainFrame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                GFTSPanel.this.closeAction();
            }
        });
        this.mainFrame.setDefaultCloseOperation(2);
        Integer x = this.getTempUserPrefs().get("FTSPanel.x");
        Integer y = this.getTempUserPrefs().get("FTSPanel.y");
        if (x != null && y != null) {
            this.mainFrame.setLocation(x, y);
        }
        Desktop.addInternalFrame(this.mainFrame, this.getFTSFrameTitle(), width, height);
    }

    protected abstract void showHelp();

    protected void closeAction() {
        this.getTempUserPrefs().put("FTSPanel.width", this.getWidth());
        this.getTempUserPrefs().put("FTSPanel.height", this.pnl_results.getHeight());
        this.getTempUserPrefs().put("FTSPanel.x", this.mainFrame.getX());
        this.getTempUserPrefs().put("FTSPanel.y", this.mainFrame.getY());
        this.mainFrame.dispose();
        this.txt_search.persistCache();
    }

    void performSearchAction() {
        String typed = this.getTypedText();
        if (typed != null && typed.length() > 0 && !typed.equalsIgnoreCase(this.lastSearchTerm)) {
            this.searchAction(true);
            this.paginatorCart.clear();
            this.lastSearchTerm = typed;
        }
    }

    public boolean wantedFieldsUpdated() {
        if (this.previousWantedFields == null) {
            return false;
        }
        return !Arrays.equals(this.getFTSRestClient().getAllDefaultDisplayedFTSDataColumns().toArray(new Object[0]), this.previousWantedFields);
    }

    public void validateSelection() {
        if (this.tbl_summary.getSelectedRows().length > 0 || !this.paginatorCart.isEmpty()) {
            this.btn_ok.setEnabled(true);
        } else {
            this.btn_ok.setEnabled(false);
        }
    }

    public JComboBox<FTSDataColumnI> getCmbSearchTarget() {
        return this.cmb_searchTarget;
    }

    public JInternalFrame getMainFrame() {
        return this.mainFrame;
    }

    protected void delayAndEnableActionButtons() {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                GFTSPanel.this.btn_ok.setEnabled(true);
                GFTSPanel.this.btn_back.setEnabled(true);
                GFTSPanel.this.btn_cancel.setEnabled(true);
            }
        }.start();
    }

    protected void checkForErrors() {
        this.lbl_warning.setVisible(false);
        this.lbl_blank.setVisible(true);
        if (this.errorWarning.length() > 0) {
            this.lbl_loading.setVisible(false);
            this.lbl_blank.setVisible(false);
            this.lbl_warning.setToolTipText(JvSwingUtils.wrapTooltip(true, this.errorWarning.toString()));
            this.lbl_warning.setVisible(true);
        }
    }

    public void btn_back_ActionPerformed() {
        this.closeAction();
        new SequenceFetcher(this.progressIndicator);
    }

    protected void disableActionButtons() {
        this.btn_ok.setEnabled(false);
        this.btn_back.setEnabled(false);
        this.btn_cancel.setEnabled(false);
    }

    public void btn_cancel_ActionPerformed() {
        this.closeAction();
    }

    public void populateCmbSearchTargetOptions() {
        ArrayList<FTSDataColumnI> searchableTargets = new ArrayList<FTSDataColumnI>();
        try {
            Collection<FTSDataColumnI> foundFTSTargets = this.getFTSRestClient().getSearchableDataColumns();
            searchableTargets.addAll(foundFTSTargets);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(searchableTargets, new Comparator<FTSDataColumnI>(){

            @Override
            public int compare(FTSDataColumnI o1, FTSDataColumnI o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (FTSDataColumnI searchTarget : searchableTargets) {
            this.cmb_searchTarget.addItem(searchTarget);
        }
    }

    public void transferToSequenceFetcher(String ids) {
        this.seqFetcher.setQuery(ids);
        Thread worker = new Thread(this.seqFetcher);
        worker.start();
    }

    @Override
    public String getTypedText() {
        return this.txt_search.getUserInput();
    }

    @Override
    public JTable getResultTable() {
        return this.tbl_summary;
    }

    public void reset() {
        this.lbl_loading.setVisible(false);
        this.errorWarning.setLength(0);
        this.lbl_warning.setVisible(false);
        this.lbl_blank.setVisible(true);
        this.btn_ok.setEnabled(false);
        this.mainFrame.setTitle(this.getFTSFrameTitle());
        this.refresh();
        this.tbl_summary.setModel(new DefaultTableModel());
        this.tbl_summary.setVisible(false);
    }

    @Override
    public void setPrevPageButtonEnabled(boolean isEnabled) {
        this.btn_prev_page.setEnabled(isEnabled);
    }

    @Override
    public void setNextPageButtonEnabled(boolean isEnabled) {
        this.btn_next_page.setEnabled(isEnabled);
    }

    @Override
    public void setErrorMessage(String message) {
        this.errorWarning.append(message);
    }

    @Override
    public void updateSearchFrameTitle(String title) {
        this.mainFrame.setTitle(title);
    }

    @Override
    public void setSearchInProgress(Boolean isSearchInProgress) {
        this.lbl_blank.setVisible(isSearchInProgress == false);
        this.lbl_loading.setVisible(isSearchInProgress);
        this.txt_search.setEditable(isSearchInProgress == false);
    }

    @Override
    public void prevPageAction() {
        this.updatePaginatorCart();
        if (this.offSet >= this.pageLimit) {
            this.offSet -= this.pageLimit;
            this.searchAction(false);
        } else {
            this.refreshPaginatorState();
        }
    }

    @Override
    public void nextPageAction() {
        this.updatePaginatorCart();
        this.offSet += this.pageLimit;
        this.searchAction(false);
    }

    public void updatePaginatorCart() {
        int[] selectedRows;
        int primaryKeyColIndex = 0;
        JTable resultTable = this.getResultTable();
        int totalRows = resultTable.getRowCount();
        try {
            primaryKeyColIndex = this.getFTSRestClient().getPrimaryKeyColumIndex(this.wantedFields, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int row = 0; row < totalRows; ++row) {
            String id = (String)resultTable.getValueAt(row, primaryKeyColIndex);
            if (!this.paginatorCart.contains(id)) continue;
            this.paginatorCart.remove(id);
        }
        for (int summaryRow : selectedRows = resultTable.getSelectedRows()) {
            String idStr = resultTable.getValueAt(summaryRow, primaryKeyColIndex).toString();
            this.paginatorCart.add(idStr);
        }
    }

    public void updateSummaryTableSelections() {
        JTable resultTable = this.getResultTable();
        if (this.paginatorCart.isEmpty()) {
            return;
        }
        int primaryKeyColIndex = 0;
        try {
            primaryKeyColIndex = this.getFTSRestClient().getPrimaryKeyColumIndex(this.wantedFields, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int totalRows = resultTable.getRowCount();
        for (int row = 0; row < totalRows; ++row) {
            String id = (String)resultTable.getValueAt(row, primaryKeyColIndex);
            if (!this.paginatorCart.contains(id)) continue;
            resultTable.addRowSelectionInterval(row, row);
        }
        this.validateSelection();
    }

    public void refreshPaginatorState() {
        this.setPrevPageButtonEnabled(false);
        this.setNextPageButtonEnabled(false);
        if (this.resultSetCount == 0 && this.pageLimit == 0) {
            return;
        }
        if (this.resultSetCount >= this.pageLimit) {
            this.setNextPageButtonEnabled(true);
        }
        if (this.offSet >= this.pageLimit) {
            this.setPrevPageButtonEnabled(true);
        }
    }

    public void refresh() {
        this.mainFrame.setTitle(this.getFTSFrameTitle());
    }

    @Override
    public abstract void okAction();

    private void setCmbSearchTargetTooltip() {
        JComboBox<FTSDataColumnI> cmb = this.getCmbSearchTarget();
        if (cmb.isEnabled()) {
            boolean isAll = "all".equalsIgnoreCase(cmb.getSelectedItem().toString());
            FTSDataColumnI index = (FTSDataColumnI)cmb.getSelectedItem();
            String indexCode = index.getAltCode();
            String dbName = this.getDbName();
            String message = isAll ? MessageManager.formatMessage("label.search_db_all", dbName) : MessageManager.formatMessage("label.search_db_index", dbName, indexCode);
            cmb.setToolTipText(message);
        } else {
            cmb.setToolTipText("");
        }
    }

    public class DeferredTextInputListener
    implements DocumentListener {
        private final Timer swingTimer;

        public DeferredTextInputListener(int timeOut, ActionListener listener, boolean repeats) {
            this.swingTimer = new Timer(timeOut, listener);
            this.swingTimer.setRepeats(repeats);
        }

        public void start() {
            this.swingTimer.start();
        }

        public void stop() {
            this.swingTimer.stop();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.swingTimer.restart();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.swingTimer.restart();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.swingTimer.restart();
        }
    }
}

