/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.msa;

import compbio.data.msa.Category;
import compbio.data.msa.RegistryWS;
import compbio.ws.client.Jws2Client;
import compbio.ws.client.Services;
import java.net.ConnectException;
import java.util.Set;
import javax.xml.ws.WebServiceException;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class CategoryTester {
    RegistryWS registry = null;

    @BeforeTest(groups={"webservices"})
    public void setupTest() {
        try {
            this.registry = Jws2Client.connectToRegistry("http://localhost:8080/jabaws");
        }
        catch (ConnectException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (WebServiceException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(groups={"webservices"})
    public void categoryTest() {
        Set<Category> servicecategories = this.registry.getServiceCategories();
        boolean found = false;
        for (Category svccategory : servicecategories) {
            for (String category : new String[]{"Alignment", "Conservation", "Protein Disorder"}) {
                if (!category.equals(svccategory.name)) continue;
                found = true;
                Set<Services> catservices = svccategory.getServices();
                System.out.println("Found " + catservices.size() + " services in category " + category + "(service category string " + svccategory + ")");
            }
        }
        if (!found) {
            Assert.fail((String)"Could not match any category to one of the given category constants");
        }
    }
}

