/*
 * Decompiled with CFR 0.152.
 */
package intervalstore.api;

import java.util.Comparator;

public interface IntervalI {
    public static final Comparator<? super IntervalI> COMPARE_BEGIN_ASC_END_DESC = new Comparator<IntervalI>(){

        @Override
        public int compare(IntervalI o1, IntervalI o2) {
            int ret = Integer.signum(o1.getBegin() - o2.getBegin());
            return ret == 0 ? Integer.signum(o2.getEnd() - o1.getEnd()) : ret;
        }
    };
    public static final Comparator<? super IntervalI> COMPARE_BEGIN_ASC_END_ASC = new Comparator<IntervalI>(){

        @Override
        public int compare(IntervalI o1, IntervalI o2) {
            int ret = Integer.signum(o1.getBegin() - o2.getBegin());
            return ret == 0 ? Integer.signum(o1.getEnd() - o2.getEnd()) : ret;
        }
    };
    public static final Comparator<? super IntervalI> COMPARE_BEGIN_ASC = new Comparator<IntervalI>(){

        @Override
        public int compare(IntervalI o1, IntervalI o2) {
            return Integer.signum(o1.getBegin() - o2.getBegin());
        }
    };
    public static final Comparator<? super IntervalI> COMPARE_END_DESC = new Comparator<IntervalI>(){

        @Override
        public int compare(IntervalI o1, IntervalI o2) {
            return Integer.signum(o2.getEnd() - o1.getEnd());
        }
    };

    public int getBegin();

    public int getEnd();

    default public boolean containsInterval(IntervalI i) {
        return i != null && i.getBegin() >= this.getBegin() && i.getEnd() <= this.getEnd();
    }

    default public boolean properlyContainsInterval(IntervalI i) {
        return this.containsInterval(i) && (i.getBegin() > this.getBegin() || i.getEnd() < this.getEnd());
    }

    default public boolean equalsInterval(IntervalI i) {
        return i != null && i.getBegin() == this.getBegin() && i.getEnd() == this.getEnd();
    }

    default public boolean overlapsInterval(IntervalI i) {
        if (i == null) {
            return false;
        }
        if (i.getBegin() < this.getBegin()) {
            return i.getEnd() >= this.getBegin();
        }
        if (i.getEnd() > this.getEnd()) {
            return i.getBegin() <= this.getEnd();
        }
        return true;
    }
}

