/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.annotations;

import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.utils.XMLUtils;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.Serializable;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ChemProbAnnotation
implements Serializable {
    private static final long serialVersionUID = 5833315460145031242L;
    public static double DEFAULT_INTENSITY = 1.0;
    public static ChemProbAnnotationType DEFAULT_TYPE = ChemProbAnnotationType.ARROW;
    public static Color DEFAULT_COLOR = Color.blue.darker();
    private ModeleBase _mbfst;
    private ModeleBase _mbsnd;
    private Color _color;
    private double _intensity;
    private ChemProbAnnotationType _type;
    private boolean _outward;
    public static String XML_ELEMENT_NAME = "ChemProbAnnotation";
    public static String XML_VAR_INDEX5_NAME = "Index5";
    public static String XML_VAR_INDEX3_NAME = "Index3";
    public static String XML_VAR_COLOR_NAME = "Color";
    public static String XML_VAR_INTENSITY_NAME = "Intensity";
    public static String XML_VAR_TYPE_NAME = "Type";
    public static String XML_VAR_OUTWARD_NAME = "Outward";

    public void toXML(TransformerHandler transformerHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", XML_VAR_INDEX5_NAME, "CDATA", "" + this._mbfst.getIndex());
        attributesImpl.addAttribute("", "", XML_VAR_INDEX3_NAME, "CDATA", "" + this._mbsnd.getIndex());
        attributesImpl.addAttribute("", "", XML_VAR_COLOR_NAME, "CDATA", XMLUtils.toHTMLNotation(this._color));
        attributesImpl.addAttribute("", "", XML_VAR_INTENSITY_NAME, "CDATA", "" + this._intensity);
        attributesImpl.addAttribute("", "", XML_VAR_TYPE_NAME, "CDATA", "" + (Object)((Object)this._type));
        attributesImpl.addAttribute("", "", XML_VAR_OUTWARD_NAME, "CDATA", "" + this._outward);
        transformerHandler.startElement("", "", XML_ELEMENT_NAME, attributesImpl);
        transformerHandler.endElement("", "", XML_ELEMENT_NAME);
    }

    public ChemProbAnnotation(ModeleBase modeleBase, ModeleBase modeleBase2, String string) {
        this(modeleBase, modeleBase2);
        this.applyStyle(string);
    }

    public ChemProbAnnotation(ModeleBase modeleBase, ModeleBase modeleBase2) {
        this(modeleBase, modeleBase2, DEFAULT_TYPE, DEFAULT_INTENSITY);
    }

    public ChemProbAnnotation(ModeleBase modeleBase, ModeleBase modeleBase2, double d) {
        this(modeleBase, modeleBase2, DEFAULT_TYPE, d);
    }

    public ChemProbAnnotation(ModeleBase modeleBase, ModeleBase modeleBase2, ChemProbAnnotationType chemProbAnnotationType) {
        this(modeleBase, modeleBase2, chemProbAnnotationType, DEFAULT_INTENSITY);
    }

    public ChemProbAnnotation(ModeleBase modeleBase, ModeleBase modeleBase2, ChemProbAnnotationType chemProbAnnotationType, double d) {
        this(modeleBase, modeleBase2, chemProbAnnotationType, d, DEFAULT_COLOR, true);
    }

    public ChemProbAnnotation(ModeleBase modeleBase, ModeleBase modeleBase2, ChemProbAnnotationType chemProbAnnotationType, double d, Color color, boolean bl) {
        if (modeleBase.getIndex() > modeleBase2.getIndex()) {
            ModeleBase modeleBase3 = modeleBase2;
            modeleBase2 = modeleBase;
            modeleBase = modeleBase3;
        }
        this._mbfst = modeleBase;
        this._mbsnd = modeleBase2;
        this._type = chemProbAnnotationType;
        this._intensity = d;
        this._color = color;
        this._outward = bl;
    }

    public boolean isOut() {
        return this._outward;
    }

    public void setOut(boolean bl) {
        this._outward = bl;
    }

    public Color getColor() {
        return this._color;
    }

    public double getIntensity() {
        return this._intensity;
    }

    public ChemProbAnnotationType getType() {
        return this._type;
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public void setIntensity(double d) {
        this._intensity = d;
    }

    public Point2D.Double getAnchorPosition() {
        Point2D.Double double_ = new Point2D.Double((this._mbfst.getCoords().x + this._mbsnd.getCoords().x) / 2.0, (this._mbfst.getCoords().y + this._mbsnd.getCoords().y) / 2.0);
        return double_;
    }

    public Point2D.Double getDirVector() {
        Point2D.Double double_ = this.getNormalVector();
        Point2D.Double double_2 = new Point2D.Double(-double_.y, double_.x);
        Point2D.Double double_3 = this.getAnchorPosition();
        Point2D.Double double_4 = new Point2D.Double((this._mbfst.getCenter().x + this._mbsnd.getCenter().x) / 2.0, (this._mbfst.getCenter().y + this._mbsnd.getCenter().y) / 2.0);
        Point2D.Double double_5 = new Point2D.Double((double_4.x - double_3.x) / 2.0, (double_4.y - double_3.y) / 2.0);
        if (this._outward ? double_2.x * double_5.x + double_2.y * double_5.y > 0.0 : double_2.x * double_5.x + double_2.y * double_5.y < 0.0) {
            return new Point2D.Double(-double_2.x, -double_2.y);
        }
        return double_2;
    }

    public Point2D.Double getNormalVector() {
        Point2D.Double double_ = this._mbfst == this._mbsnd ? new Point2D.Double(-(this._mbsnd.getCenter().y - this._mbsnd.getCoords().y), this._mbsnd.getCenter().x - this._mbsnd.getCoords().x) : new Point2D.Double((this._mbsnd.getCoords().x - this._mbfst.getCoords().x) / 2.0, (this._mbsnd.getCoords().y - this._mbfst.getCoords().y) / 2.0);
        double d = double_.distance(0.0, 0.0);
        Point2D.Double double_2 = new Point2D.Double(double_.x / d, double_.y / d);
        return double_2;
    }

    public static ChemProbAnnotationType annotTypeFromString(String string) {
        if (string.toLowerCase().equals("arrow")) {
            return ChemProbAnnotationType.ARROW;
        }
        if (string.toLowerCase().equals("triangle")) {
            return ChemProbAnnotationType.TRIANGLE;
        }
        if (string.toLowerCase().equals("pin")) {
            return ChemProbAnnotationType.PIN;
        }
        if (string.toLowerCase().equals("dot")) {
            return ChemProbAnnotationType.DOT;
        }
        return ChemProbAnnotationType.ARROW;
    }

    public void applyStyle(String string) {
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length != 2) continue;
            String string3 = stringArray2[0];
            String string4 = stringArray2[1];
            if (string3.toLowerCase().equals("color")) {
                Color color = Color.decode(string4);
                if (color == null) {
                    color = this._color;
                }
                this.setColor(color);
                continue;
            }
            if (string3.toLowerCase().equals("intensity")) {
                this._intensity = Double.parseDouble(string4);
                continue;
            }
            if (string3.toLowerCase().equals("dir")) {
                this._outward = string4.toLowerCase().equals("out");
                continue;
            }
            if (!string3.toLowerCase().equals("glyph")) continue;
            this._type = ChemProbAnnotation.annotTypeFromString(string4);
        }
    }

    public void setType(ChemProbAnnotationType chemProbAnnotationType) {
        this._type = chemProbAnnotationType;
    }

    public ChemProbAnnotation clone() {
        ChemProbAnnotation chemProbAnnotation = new ChemProbAnnotation(this._mbfst, this._mbsnd);
        chemProbAnnotation._intensity = this._intensity;
        chemProbAnnotation._type = this._type;
        chemProbAnnotation._color = this._color;
        chemProbAnnotation._outward = this._outward;
        return chemProbAnnotation;
    }

    public String toString() {
        return "Chem. prob. " + (Object)((Object)this._type) + " Base#" + this._mbfst.getBaseNumber() + "-" + this._mbsnd.getBaseNumber();
    }

    public static enum ChemProbAnnotationType {
        TRIANGLE,
        ARROW,
        PIN,
        DOT;

    }
}

