/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericCifDataParser;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.T3;
import org.jmol.adapter.readers.cif.Cif2DataParser;
import org.jmol.adapter.readers.cif.CifReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.SymmetryInterface;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.Logger;

public class TopoCifParser
implements CifReader.Parser {
    static final int TOPOL_LINK = 0x1000000;
    static final int TOPOL_GROUP = 0x2000000;
    static final int TOPOL_NODE = 0x4000000;
    public static final int LINK_TYPE_SING = 1;
    public static final int LINK_TYPE_DOUB = 2;
    public static final int LINK_TYPE_TRIP = 3;
    public static final int LINK_TYPE_QUAD = 4;
    public static final int LINK_TYPE_QUIN = 5;
    public static final int LINK_TYPE_HEX = 6;
    public static final int LINK_TYPE_HEPT = 7;
    public static final int LINK_TYPE_OCT = 8;
    public static final int LINK_TYPE_AROM = 9;
    public static final int LINK_TYPE_POLY = 10;
    public static final int LINK_TYPE_DELO = 11;
    public static final int LINK_TYPE_PI = 12;
    public static final int LINK_TYPE_HBOND = 13;
    public static final int LINK_TYPE_VDW = 14;
    public static final int LINK_TYPE_OTHER = 15;
    public static String linkTypes = "?  SINTRIQUAQUIHEXHEPOCTAROPOLPI HBOVDW";
    public static final int LINK_TYPE_BITS = 4;
    static double ERROR_TOLERANCE = 0.001;
    CifReader reader;
    Lst<TAtom> atoms = new Lst();
    Lst<TNode> nodes = new Lst();
    private Lst<TLink> links = new Lst();
    Lst<TNet> nets = new Lst();
    TNet singleNet;
    int netCount;
    int linkCount;
    int atomCount;
    T3 temp1 = new P3();
    T3 temp2 = new P3();
    private int ac0 = -1;
    private int bc0;
    private GenericCifDataParser cifParser;
    String failed;
    M4[] ops;
    int i0;
    int b0;
    private String allowedTypes;
    String netNotes = "";
    private static final String[] topolFields = new String[]{"_topol_net_id", "_topol_net_label", "_topol_link_id", "_topol_link_net_id", "_topol_link_node_id_1", "_topol_link_node_id_2", "_topol_link_node_label_1", "_topol_link_node_label_2", "_topol_link_atom_label_1", "_topol_link_atom_label_2", "_topol_link_symop_1", "_topol_link_translation_1", "_topol_link_translation_1_x", "_topol_link_translation_1_y", "_topol_link_translation_1_z", "_topol_link_symop_2", "_topol_link_translation_2", "_topol_link_translation_2_x", "_topol_link_translation_2_y", "_topol_link_translation_2_z", "_topol_link_distance", "_topol_link_type", "_topol_link_multiplicity", "_topol_link_voronoi_solidangle", "_topol_link_order", "_topol_node_id", "_topol_node_net_id", "_topol_node_label", "_topol_node_atom_label", "_topol_node_symop", "_topol_node_translation", "_topol_node_translation_x", "_topol_node_translation_y", "_topol_node_translation_z", "_topol_node_fract_x", "_topol_node_fract_y", "_topol_node_fract_z", "_topol_node_chemical_formula_sum", "_topol_atom_id", "_topol_atom_atom_label", "_topol_atom_node_id", "_topol_atom_link_id", "_topol_atom_symop", "_topol_atom_translation", "_topol_atom_translation_x", "_topol_atom_translation_y", "_topol_atom_translation_z", "_topol_atom_fract_x", "_topol_atom_fract_y", "_topol_atom_fract_z", "_topol_atom_element_symbol", "_topol_link_site_symmetry_symop_1", "_topol_link_site_symmetry_translation_1_x", "_topol_link_site_symmetry_translation_1_y", "_topol_link_site_symmetry_translation_1_z", "_topol_link_site_symmetry_symop_2", "_topol_link_site_symmetry_translation_2_x", "_topol_link_site_symmetry_translation_2_y", "_topol_link_site_symmetry_translation_2_z", "_topol_link_site_symmetry_translation_1", "_topol_link_site_symmetry_translation_2"};
    private static final byte topol_net_id = 0;
    private static final byte topol_net_label = 1;
    private static final byte topol_link_id = 2;
    private static final byte topol_link_net_id = 3;
    private static final byte topol_link_node_id_1 = 4;
    private static final byte topol_link_node_id_2 = 5;
    private static final byte topol_link_node_label_1 = 6;
    private static final byte topol_link_node_label_2 = 7;
    private static final byte topol_link_atom_label_1 = 8;
    private static final byte topol_link_atom_label_2 = 9;
    private static final byte topol_link_symop_1 = 10;
    private static final byte topol_link_translation_1 = 11;
    private static final byte topol_link_translation_1_x = 12;
    private static final byte topol_link_translation_1_y = 13;
    private static final byte topol_link_translation_1_z = 14;
    private static final byte topol_link_symop_2 = 15;
    private static final byte topol_link_translation_2 = 16;
    private static final byte topol_link_translation_2_x = 17;
    private static final byte topol_link_translation_2_y = 18;
    private static final byte topol_link_translation_2_z = 19;
    private static final byte topol_link_distance = 20;
    private static final byte topol_link_type = 21;
    private static final byte topol_link_multiplicity = 22;
    private static final byte topol_link_voronoi_solidangle = 23;
    private static final byte topol_link_order = 24;
    private static final byte topol_node_id = 25;
    private static final byte topol_node_net_id = 26;
    private static final byte topol_node_label = 27;
    private static final byte topol_node_atom_label = 28;
    private static final byte topol_node_symop = 29;
    private static final byte topol_node_translation = 30;
    private static final byte topol_node_translation_x = 31;
    private static final byte topol_node_translation_y = 32;
    private static final byte topol_node_translation_z = 33;
    private static final byte topol_node_fract_x = 34;
    private static final byte topol_node_fract_y = 35;
    private static final byte topol_node_fract_z = 36;
    private static final byte topol_node_chemical_formula_sum = 37;
    private static final byte topol_atom_id = 38;
    private static final byte topol_atom_atom_label = 39;
    private static final byte topol_atom_node_id = 40;
    private static final byte topol_atom_link_id = 41;
    private static final byte topol_atom_symop = 42;
    private static final byte topol_atom_translation = 43;
    private static final byte topol_atom_translation_x = 44;
    private static final byte topol_atom_translation_y = 45;
    private static final byte topol_atom_translation_z = 46;
    private static final byte topol_atom_fract_x = 47;
    private static final byte topol_atom_fract_y = 48;
    private static final byte topol_atom_fract_z = 49;
    private static final byte topol_atom_element_symbol = 50;
    private static final byte topol_link_site_symmetry_symop_1 = 51;
    private static final byte topol_link_site_symmetry_translation_1_x = 52;
    private static final byte topol_link_site_symmetry_translation_1_y = 53;
    private static final byte topol_link_site_symmetry_translation_1_z = 54;
    private static final byte topol_link_site_symmetry_symop_2 = 55;
    private static final byte topol_link_site_symmetry_translation_2_x = 56;
    private static final byte topol_link_site_symmetry_translation_2_y = 57;
    private static final byte topol_link_site_symmetry_translation_2_z = 58;
    private static final byte topol_link_site_symmetry_translation_1 = 59;
    private static final byte topol_link_site_symmetry_translation_2 = 60;

    static int getBondType(String type) {
        if ((type = type.toUpperCase()).charAt(0) == 'V') {
            return type.length() == 1 ? 1 : 14;
        }
        if (type.length() > 3) {
            type = type.substring(0, 3);
        }
        return Math.max(1, linkTypes.indexOf(type) / 3);
    }

    @Override
    public TopoCifParser setReader(CifReader reader) {
        if (!reader.checkFilterKey("TOPOL")) {
            reader.appendLoadNote("This file has Topology analysis records. Use LOAD \"\" {1 1 1} FILTER \"TOPOL\"  to load the topology.");
            return this;
        }
        this.reader = reader;
        String types = reader.getFilter("TOPOS_TYPES=");
        if (types == null) {
            types = reader.getFilter("TOPOS_TYPE=");
        }
        if (types != null && types.length() > 0) {
            this.allowedTypes = types = "+" + types.toLowerCase() + "+";
        }
        this.i0 = reader.baseAtomIndex;
        this.b0 = reader.baseBondIndex;
        return this;
    }

    @Override
    public boolean processBlock(String key) throws Exception {
        if (this.reader == null || this.failed != null) {
            return false;
        }
        if (this.ac0 < 0) {
            this.ac0 = this.reader.asc.ac;
            this.bc0 = this.reader.asc.bondCount;
        }
        if (this.reader.ucItems != null) {
            this.reader.allow_a_len_1 = true;
            for (int i = 0; i < 6; ++i) {
                this.reader.setUnitCellItem(i, this.reader.ucItems[i]);
            }
        }
        this.reader.parseLoopParameters(topolFields);
        this.cifParser = this.reader.cifParser;
        if (key.startsWith("_topol_net")) {
            this.processNets();
        } else if (key.startsWith("_topol_link")) {
            this.processLinks();
        } else if (key.startsWith("_topol_node")) {
            this.processNodes();
        } else if (key.startsWith("_topol_atom")) {
            this.processAtoms();
        }
        return true;
    }

    private void processNets() throws Exception {
        while (this.cifParser.getData()) {
            int id = this.getInt(this.getField((byte)0));
            if (id < 0) {
                id = 0;
            }
            String netLabel = this.getField((byte)1);
            TNet net = this.getNetFor(id, netLabel);
            net.line = this.reader.line;
        }
    }

    private void processLinks() throws Exception {
        while (this.cifParser.getData()) {
            String type = ("" + this.getField((byte)21)).toLowerCase();
            if (this.allowedTypes != null && this.allowedTypes.indexOf("+" + type + "+") < 0) continue;
            TLink link = new TLink();
            link.type = type;
            int[] t1 = new int[3];
            int[] t2 = new int[3];
            int n = this.cifParser.getColumnCount();
            block17: for (int i = 0; i < n; ++i) {
                int p = this.reader.fieldProperty(i);
                String field = this.reader.field;
                switch (p) {
                    case 2: {
                        link.id = this.getInt(field);
                        continue block17;
                    }
                    case 3: {
                        int id = this.getInt(field);
                        if (id == Integer.MIN_VALUE) {
                            link.netLabel = field;
                            continue block17;
                        }
                        link.netID = this.getInt(field);
                        continue block17;
                    }
                    case 4: {
                        link.id1 = this.getInt(field);
                        continue block17;
                    }
                    case 5: {
                        link.id2 = this.getInt(field);
                        continue block17;
                    }
                    case 6: 
                    case 8: {
                        if (link.label1 != null) continue block17;
                        link.label1 = field;
                        continue block17;
                    }
                    case 7: 
                    case 9: {
                        if (link.label2 != null) continue block17;
                        link.label2 = field;
                        continue block17;
                    }
                    case 10: 
                    case 51: {
                        link.symop1 = this.getInt(field) - 1;
                        continue block17;
                    }
                    case 15: 
                    case 55: {
                        link.symop2 = this.getInt(field) - 1;
                        continue block17;
                    }
                    case 24: {
                        link.topoOrder = this.getInt(field);
                        continue block17;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 59: {
                        t1 = this.processTranslation(p, t1, field);
                        continue block17;
                    }
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 60: {
                        t2 = this.processTranslation(p, t2, field);
                        continue block17;
                    }
                    case 20: {
                        link.cartesianDistance = this.getFloat(field);
                        continue block17;
                    }
                    case 22: {
                        link.multiplicity = this.getInt(field);
                        continue block17;
                    }
                    case 23: {
                        link.voronoiAngle = this.getFloat(field);
                    }
                }
            }
            if (!link.setLink(t1, t2, this.reader.line)) {
                this.failed = "invalid link! " + link;
                return;
            }
            this.links.addLast(link);
        }
    }

    private int[] processTranslation(int p, int[] t, String field) {
        switch (p) {
            case 11: 
            case 16: 
            case 30: 
            case 43: 
            case 59: 
            case 60: {
                t = Cif2DataParser.getIntArrayFromStringList(field, 3);
                break;
            }
            case 12: 
            case 17: 
            case 31: 
            case 44: 
            case 52: 
            case 56: {
                t[0] = this.getInt(field);
                break;
            }
            case 13: 
            case 18: 
            case 32: 
            case 45: 
            case 53: 
            case 57: {
                t[1] = this.getInt(field);
                break;
            }
            case 14: 
            case 19: 
            case 33: 
            case 46: 
            case 54: 
            case 58: {
                t[2] = this.getInt(field);
            }
        }
        return t;
    }

    private void processNodes() throws Exception {
        while (this.cifParser.getData()) {
            TNode node = new TNode();
            int[] t = new int[3];
            int n = this.cifParser.getColumnCount();
            block13: for (int i = 0; i < n; ++i) {
                int p = this.reader.fieldProperty(i);
                String field = this.reader.field;
                switch (p) {
                    case 25: {
                        node.id = this.getInt(field);
                        continue block13;
                    }
                    case 27: {
                        node.label = field;
                        continue block13;
                    }
                    case 26: {
                        node.netID = this.getInt(field);
                        continue block13;
                    }
                    case 28: {
                        node.atomLabel = field;
                        continue block13;
                    }
                    case 29: {
                        node.symop = this.getInt(field) - 1;
                        continue block13;
                    }
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        t = this.processTranslation(p, t, field);
                        continue block13;
                    }
                    case 37: {
                        node.formula = field;
                        continue block13;
                    }
                    case 34: {
                        node.x = this.getFloat(field);
                        continue block13;
                    }
                    case 35: {
                        node.y = this.getFloat(field);
                        continue block13;
                    }
                    case 36: {
                        node.z = this.getFloat(field);
                    }
                }
            }
            if (!node.setNode(t, this.reader.line)) continue;
            this.nodes.addLast(node);
        }
    }

    private void processAtoms() throws Exception {
        while (this.cifParser.getData()) {
            TAtom atom = new TAtom();
            int[] t = new int[3];
            int n = this.cifParser.getColumnCount();
            block13: for (int i = 0; i < n; ++i) {
                int p = this.reader.fieldProperty(i);
                String field = this.reader.field;
                switch (p) {
                    case 38: {
                        atom.id = this.getInt(field);
                        continue block13;
                    }
                    case 39: {
                        atom.atomLabel = field;
                        continue block13;
                    }
                    case 40: {
                        atom.nodeID = this.getInt(field);
                        continue block13;
                    }
                    case 41: {
                        atom.linkID = this.getInt(field);
                        continue block13;
                    }
                    case 42: {
                        atom.symop = this.getInt(field) - 1;
                        continue block13;
                    }
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: {
                        t = this.processTranslation(p, t, field);
                        continue block13;
                    }
                    case 47: {
                        atom.x = this.getFloat(field);
                        continue block13;
                    }
                    case 48: {
                        atom.y = this.getFloat(field);
                        continue block13;
                    }
                    case 49: {
                        atom.z = this.getFloat(field);
                        continue block13;
                    }
                    case 50: {
                        atom.formula = field;
                    }
                }
            }
            if (!atom.setAtom(t, this.reader.line)) continue;
            this.atoms.addLast(atom);
        }
    }

    @Override
    public boolean finalizeReader() throws Exception {
        if (this.reader == null || this.reader.symops == null) {
            return false;
        }
        this.cifParser = null;
        this.reader.applySymmetryToBonds = true;
        M4[] ops = this.getOperations();
        for (int i = 0; i < this.atoms.size(); ++i) {
            ((TAtom)this.atoms.get(i)).finalizeAtom(ops);
        }
        SymmetryInterface sym = this.reader.getSymmetry();
        for (int i = 0; i < this.links.size(); ++i) {
            ((TLink)this.links.get(i)).finalizeLink(ops, sym);
        }
        if (this.reader.doApplySymmetry) {
            this.reader.applySymmetryAndSetTrajectory();
        }
        return true;
    }

    private M4[] getOperations() {
        Lst<String> symops = this.reader.symops;
        int nOps = symops.size();
        this.ops = new M4[nOps];
        for (int i = 0; i < nOps; ++i) {
            this.ops[i] = SymmetryOperation.getMatrixFromXYZ("!" + (String)symops.get(i));
        }
        return this.ops;
    }

    @Override
    public void finalizeSymmetry(boolean haveSymmetry) throws Exception {
        if (this.reader == null || !haveSymmetry || this.links.size() == 0) {
            return;
        }
        BS bsConnected = new BS();
        BS bsAtoms = new BS();
        int nLinks = this.processAssociations(bsConnected, bsAtoms);
        bsAtoms.or(bsConnected);
        BS bsExclude = new BS();
        int pt = 0;
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            while (bsAtoms.get(i)) {
                bsExclude.setBitTo(pt++, bsConnected.get(i++));
            }
            i = bsAtoms.nextSetBit(i + 1);
        }
        if (bsConnected.cardinality() > 0) {
            this.reader.asc.bsAtoms = bsAtoms;
            this.reader.asc.atomSetInfo.put("bsExcludeBonding", bsExclude);
        }
        this.reader.appendLoadNote("TopoCifParser created " + bsConnected.cardinality() + " nodes and " + nLinks + " links");
        Lst<Map<String, Object>> info = new Lst<Map<String, Object>>();
        int n = this.links.size();
        for (i = 0; i < n; ++i) {
            info.addLast(((TLink)this.links.get(i)).getInfo());
        }
        this.reader.asc.setCurrentModelInfo("topology", info);
        String script = "display displayed or " + ((TNet)this.nets.get((int)0)).label + "__*";
        this.reader.addJmolScript(script);
        for (int i2 = 0; i2 < this.nets.size(); ++i2) {
            ((TNet)this.nets.get(i2)).setNote();
        }
    }

    private int processAssociations(BS bsConnected, BS bsAtoms) {
        int nlinks = 0;
        Atom[] atoms = this.reader.asc.atoms;
        int i = this.reader.asc.ac;
        while (--i >= this.ac0) {
            Atom a = atoms[i];
            int idx = a.sequenceNumber;
            if (idx == Integer.MIN_VALUE || idx == 0) continue;
            if (idx > 0) {
                TNode node = this.getAssociatedNodeByIdx(idx - 1);
                if (node.bsAtoms == null) {
                    node.bsAtoms = new BS();
                }
                node.bsAtoms.set(this.i0 + a.index);
            } else {
                TLink link = this.getAssoiatedLinkByIdx(-idx - 1);
                if (link.bsAtoms == null) {
                    link.bsAtoms = new BS();
                }
                link.bsAtoms.set(this.i0 + a.index);
            }
            bsAtoms.set(a.index);
        }
        Bond[] bonds = this.reader.asc.bonds;
        int i2 = this.reader.asc.bondCount;
        while (--i2 >= this.bc0) {
            Bond b = bonds[i2];
            if (b.order >= 0x2000000) {
                bonds[i2] = null;
                continue;
            }
            if (b.order < 0x1000000) continue;
            b.order -= 0x1000000;
            int id = b.order >> 4;
            TLink link = this.getLinkById(id);
            link.bsBonds.set(this.b0 + i2);
            switch (b.order & 0xF) {
                default: {
                    b.order = 1;
                    break;
                }
                case 2: {
                    b.order = 2;
                    break;
                }
                case 3: {
                    b.order = 3;
                    break;
                }
                case 4: {
                    b.order = 4;
                    break;
                }
                case 5: {
                    b.order = 5;
                    break;
                }
                case 6: {
                    b.order = 6;
                    break;
                }
                case 10: {
                    b.order = 1;
                    break;
                }
                case 11: 
                case 12: {
                    b.order = 515;
                    break;
                }
                case 13: {
                    b.order = 2048;
                    break;
                }
                case 14: {
                    b.order = 33;
                }
            }
            bsConnected.set(b.atomIndex1);
            bsConnected.set(b.atomIndex2);
            ++nlinks;
        }
        return nlinks;
    }

    private String getField(byte field) {
        String f = this.reader.getField(field);
        return "\u0000".equals(f) ? null : f;
    }

    private int getInt(String f) {
        return f == null ? Integer.MIN_VALUE : this.reader.parseIntStr(f);
    }

    private float getFloat(String f) {
        return f == null ? Float.NaN : this.reader.parseFloatStr(f);
    }

    @Override
    public void ProcessRecord(String key, String data) {
        if (key.startsWith("_topol_net")) {
            if (key.endsWith("_id")) {
                int n = Integer.parseInt(data);
                if (this.singleNet == null) {
                    this.singleNet = new TNet(this.netCount++, n, "Net" + n);
                    this.nets.addLast(this.singleNet);
                } else {
                    this.singleNet.id = n;
                }
            } else if (key.endsWith("_label")) {
                if (this.singleNet == null) {
                    this.singleNet = new TNet(this.netCount++, 1, data);
                    this.nets.addLast(this.singleNet);
                } else {
                    this.singleNet.label = data;
                }
            }
        }
    }

    static void setTAtom(Atom a, Atom b) {
        b.setT(a);
        b.formalCharge = a.formalCharge;
        b.bondRadius = a.bondRadius;
    }

    static void setElementSymbol(Atom a, String formula) {
        String name = a.atomName;
        a.atomName = formula == null ? (a.atomName == null ? "X" : a.atomName.substring(a.atomName.indexOf(95) + 1)) : formula;
        a.getElementSymbol();
        a.atomName = name;
    }

    static void applySymmetry(Atom a, M4[] ops, int op, T3 t) {
        if (op >= 0 && (op > 1 || t.x != 0.0f || t.y != 0.0f || t.z != 0.0f)) {
            if (op > 1) {
                ops[op].rotTrans(a);
            }
            a.add(t);
        }
    }

    public TNet getNetByID(int id) {
        int i = this.nets.size();
        while (--i >= 0) {
            TNet n = (TNet)this.nets.get(i);
            if (n.id != id) continue;
            return n;
        }
        TNet n = new TNet(this.netCount++, id, "Net" + id);
        this.nets.addLast(n);
        return n;
    }

    public Atom getAtomFromName(String name) {
        name = name.substring(name.lastIndexOf("_") + 1);
        return this.reader.asc.getAtomFromName(name);
    }

    public TNet getNetFor(int id, String label) {
        TNet net = null;
        if (id > 0) {
            net = this.getNetByID(id);
        } else if (label != null) {
            net = (TNet)this.getTopo(this.nets, label, 'N');
        }
        if (net == null) {
            net = this.getNetByID(id < 1 ? 1 : id);
        }
        if (label != null) {
            net.label = label;
        }
        return net;
    }

    TLink getAssoiatedLinkByIdx(int idx) {
        int i = this.links.size();
        while (--i >= 0) {
            TLink l = (TLink)this.links.get(i);
            if (l.idx != idx) continue;
            return l;
        }
        return null;
    }

    TNode getAssociatedNodeByIdx(int idx) {
        int i = this.nodes.size();
        while (--i >= 0) {
            TNode n = (TNode)this.nodes.get(i);
            if (n.idx != idx) continue;
            return n;
        }
        return null;
    }

    public TLink getLinkById(int linkID) {
        int i = this.links.size();
        while (--i >= 0) {
            TLink l = (TLink)this.links.get(i);
            if (l.id != linkID) continue;
            return l;
        }
        return null;
    }

    public TNode getNodeById(int nodeID, int op, P3 trans) {
        int i = this.nodes.size();
        while (--i >= 0) {
            TNode n = (TNode)this.nodes.get(i);
            if (n.id != nodeID || op >= 0 && (n.linkSymop != op || !n.trans.equals(trans))) continue;
            return n;
        }
        return null;
    }

    public Object getTopo(Lst<?> l, String label, char type) {
        block5: for (int i = 0; i < l.size(); ++i) {
            Object o = l.get(i);
            switch (type) {
                case 'a': {
                    if (!((TAtom)o).atomLabel.equals(label)) continue block5;
                    return o;
                }
                case 'n': {
                    String s = ((TNode)o).label;
                    if (s == null || !s.equals(label)) continue block5;
                    return o;
                }
                case 'N': {
                    if (!((TNet)o).label.equals(label)) continue block5;
                    return o;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private class TLink
    extends Bond {
        int id;
        int netID;
        String netLabel;
        int id1;
        int id2;
        String label1;
        String label2;
        int symop1;
        int symop2;
        P3 trans1;
        P3 trans2;
        String type = "";
        int multiplicity;
        int topoOrder;
        float voronoiAngle;
        float cartesianDistance;
        int idx;
        TNet net;
        TNode node1;
        TNode node2;
        int typeBondOrder;
        Lst<TAtom> tatoms;
        BS bsAtoms = null;
        BS bsBonds = new BS();
        private String line;

        boolean setLink(int[] t1, int[] t2, String line) {
            this.line = line;
            this.idx = TopoCifParser.this.linkCount++;
            if (this.id2 == 0) {
                this.id2 = this.id1;
            }
            this.typeBondOrder = TopoCifParser.getBondType(this.type);
            this.trans1 = P3.new3(t1[0], t1[1], t1[2]);
            this.trans2 = P3.new3(t2[0], t2[1], t2[2]);
            System.out.println("TopoCifParser.setLink " + this);
            return true;
        }

        void addAtom(TAtom atom) {
            if (this.tatoms == null) {
                this.tatoms = new Lst();
            }
            this.tatoms.add(atom);
        }

        Map<String, Object> getInfo() {
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            info.put("index", this.idx + 1);
            if (this.id > 0) {
                info.put("id", this.id);
            }
            if (this.id1 > 0) {
                info.put("id1", this.id1);
            }
            if (this.id2 > 0) {
                info.put("id2", this.id2);
            }
            info.put("distance", Float.valueOf(this.cartesianDistance));
            info.put("netID", this.netID);
            info.put("netLabel", this.netLabel);
            info.put("label1", this.node1.atomName);
            info.put("label2", this.node2.atomName);
            if (!Float.isNaN(this.distance)) {
                info.put("distance", Float.valueOf(this.distance));
            }
            info.put("symop1", this.symop1 + 1);
            info.put("symop2", this.symop2 + 1);
            info.put("translation1", this.trans1);
            info.put("translation2", this.trans2);
            info.put("multiplicity", this.multiplicity);
            if (this.type != null) {
                info.put("type", this.type);
            }
            info.put("voronoiSolidAngle", Float.valueOf(this.voronoiAngle));
            info.put("atomIndex1", TopoCifParser.this.i0 + this.node1.index);
            info.put("atomIndex2", TopoCifParser.this.i0 + this.node2.index);
            if (this.bsAtoms != null && this.bsAtoms.cardinality() > 0) {
                info.put("representedAtoms", this.bsAtoms);
            }
            info.put("topoOrder", this.topoOrder);
            info.put("order", this.typeBondOrder);
            return info;
        }

        String info() {
            return "[link " + this.line + " : " + this.distance + "]";
        }

        @Override
        public String toString() {
            return this.info();
        }

        void finalizeLink(M4[] ops, SymmetryInterface sym) throws Exception {
            this.node1 = this.addLinkNodeIfNull(this.id1, this.label1, this.symop1, this.trans1);
            this.node2 = this.addLinkNodeIfNull(this.id2, this.label2, this.symop2, this.trans2);
            if (this.node1 == null || this.node2 == null) {
                Logger.warn("TopoCifParser atom " + (this.node1 == null ? this.label1 : this.label2) + " could not be found");
                return;
            }
            if (this.node1 == this.node2) {
                this.node2 = this.node1.copy();
            }
            this.node1.finalizeNode(ops);
            this.node2.finalizeNode(ops);
            TopoCifParser.applySymmetry(this.node1, ops, this.symop1, this.trans1);
            TopoCifParser.applySymmetry(this.node2, ops, this.symop2, this.trans2);
            this.atomIndex1 = this.node1.index;
            this.atomIndex2 = this.node2.index;
            this.order = 0x1000000 + (this.id << 4) + this.typeBondOrder;
            TopoCifParser.this.temp1.setT(this.node1);
            TopoCifParser.this.temp2.setT(this.node2);
            sym.toCartesian(TopoCifParser.this.temp1, true);
            sym.toCartesian(TopoCifParser.this.temp2, true);
            this.distance = TopoCifParser.this.temp1.distance(TopoCifParser.this.temp2);
            if (this.cartesianDistance != 0.0f && (double)Math.abs(this.distance - this.cartesianDistance) >= ERROR_TOLERANCE) {
                System.err.println("Distance error! distance=" + this.distance + " for " + this.line);
            }
            System.out.println("link d=" + this.distance + " " + this + this.node1 + this.node2);
            if (this.tatoms != null) {
                int i = this.tatoms.size();
                while (--i >= 0) {
                    TAtom a = (TAtom)this.tatoms.get(i);
                    a.finalizeAtom(ops);
                    a.sequenceNumber = -this.idx - 1;
                    a.atomName = this.net.label + "_" + a.atomName;
                }
            }
            TopoCifParser.this.reader.asc.addBond(this);
        }

        private TNode addLinkNodeIfNull(int id, String nodeLabel, int nodeOp, P3 nodeTrans) throws Exception {
            Atom atom;
            TNode node;
            TNode node0 = node = this.getNodeWithSym(id, nodeLabel, nodeOp, nodeTrans);
            if (node == null) {
                node = this.getNodeWithSym(id, nodeLabel, -1, null);
            }
            Atom atom2 = atom = node == null ? TopoCifParser.this.getAtomFromName(nodeLabel) : null;
            if (atom != null) {
                this.setNet(null);
                node = new TNode(TopoCifParser.this.atomCount++, atom, this.net, nodeOp, nodeTrans);
            } else if (node != null) {
                this.setNet(node);
                if (node0 == null) {
                    node = node.copy();
                }
                node.linkSymop = nodeOp;
                node.linkTrans = nodeTrans;
            } else {
                throw new Exception("TopoCIFParser.addNodeIfNull no atom or node " + nodeLabel + " line=" + this.line);
            }
            TopoCifParser.this.nodes.addLast(node);
            return node;
        }

        private void setNet(TNode node) {
            if (this.net != null) {
                return;
            }
            this.net = node == null ? TopoCifParser.this.getNetFor(this.netID, this.netLabel) : node.net;
            ++this.net.nLinks;
            this.netLabel = this.net.label;
            this.netID = this.net.id;
        }

        private TNode getNodeWithSym(int nodeID, String nodeLabel, int op, P3 trans) {
            if (nodeID > 0) {
                return TopoCifParser.this.getNodeById(nodeID, op, trans);
            }
            int i = TopoCifParser.this.nodes.size();
            while (--i >= 0) {
                TNode n = (TNode)TopoCifParser.this.nodes.get(i);
                if (!n.label.equals(nodeLabel) || op != -1 && (op != n.linkSymop || !trans.equals(n.linkTrans))) continue;
                return n;
            }
            return null;
        }
    }

    private class TNode
    extends Atom {
        public int id;
        public String formula;
        public String atomLabel;
        int netID;
        String netLabel;
        String label;
        int symop = 0;
        P3 trans = new P3();
        Lst<TAtom> tatoms;
        BS bsAtoms = null;
        int linkSymop = 0;
        P3 linkTrans = new P3();
        TNet net;
        private boolean isFinalized;
        int idx;
        private Atom atom;
        private String line;

        TNode() {
        }

        TNode(int idx, Atom atom, TNet net, int op, P3 trans) {
            this.idx = idx;
            this.atom = atom;
            this.net = net;
            this.linkSymop = op;
            this.linkTrans = trans;
            this.atomName = this.atomLabel = atom.atomName;
            this.label = this.atomLabel;
            this.formula = atom.getElementSymbol();
            TopoCifParser.setTAtom(atom, this);
        }

        boolean setNode(int[] a, String line) {
            this.line = line;
            if (this.tatoms == null) {
                if (Float.isNaN(this.x) != Float.isNaN(this.y) || Float.isNaN(this.y) != Float.isNaN(this.z)) {
                    return false;
                }
                this.idx = TopoCifParser.this.atomCount++;
                if (Float.isNaN(this.x)) {
                    this.trans = P3.new3(a[0], a[1], a[2]);
                } else {
                    this.symop = 0;
                }
                if (this.formula != null && this.formula.indexOf(" ") < 0) {
                    this.atomName = this.formula;
                    this.getElementSymbol();
                    if (!this.formula.equals(this.elementSymbol)) {
                        this.elementSymbol = "Z";
                    }
                    this.atomName = null;
                }
            }
            if (this.net == null) {
                this.net = TopoCifParser.this.getNetFor(this.netID, this.netLabel);
            }
            this.netLabel = this.net.label;
            this.netID = this.net.id;
            return true;
        }

        void addAtom(TAtom atom) {
            if (this.tatoms == null) {
                this.tatoms = new Lst();
            }
            this.tatoms.add(atom);
        }

        void finalizeNode(M4[] ops) throws Exception {
            Atom a;
            boolean haveXYZ;
            if (this.isFinalized) {
                return;
            }
            this.isFinalized = true;
            boolean bl = haveXYZ = !Float.isNaN(this.x);
            if (this.tatoms == null) {
                a = this.atom != null ? this.atom : (this.atomLabel == null ? null : TopoCifParser.this.getAtomFromName(this.atomLabel));
                TopoCifParser.setElementSymbol(this, this.formula == null ? a.elementSymbol : this.formula);
                if (a == null && !haveXYZ) {
                    throw new Exception("TopoCIFParser.finalizeNode no atom " + this.atomLabel + " line=" + this.line);
                }
            } else {
                this.setCentroid();
                if (this.tatoms.size() == 1) {
                    TAtom ta = (TAtom)this.tatoms.get(0);
                    TopoCifParser.setElementSymbol(ta, ta.elementSymbol);
                    this.atomLabel = ta.atomLabel;
                    this.formalCharge = ta.formalCharge;
                    this.tatoms = null;
                } else {
                    this.net.hasAtoms = true;
                    this.elementSymbol = "Xx";
                    int i = this.tatoms.size();
                    while (--i >= 0) {
                        TAtom ta = (TAtom)this.tatoms.get(i);
                        ta.sequenceNumber = this.idx + 1;
                        if (ta.atomName != null && ta.atomName.startsWith(this.net.label + "_")) continue;
                        ta.atomName = this.net.label + "_" + ta.atomName;
                    }
                }
                a = this;
            }
            if (a == this.atom || !haveXYZ) {
                if (a != this) {
                    TopoCifParser.setTAtom(a, this);
                }
                TopoCifParser.applySymmetry(this, ops, this.symop, this.trans);
            }
            this.atomName = this.netLabel + "__";
            if (this.label != null && this.label.startsWith(this.atomName)) {
                this.atomName = "";
            }
            this.atomName = this.atomName + (this.label != null ? this.label : (this.atomLabel != null ? this.atomLabel : "Node_" + this.id));
            this.addNode();
        }

        private void addNode() {
            TopoCifParser.this.reader.addCifAtom(this, this.atomName, null, null);
            ++this.net.nNodes;
        }

        private void setCentroid() {
            int n;
            this.z = 0.0f;
            this.y = 0.0f;
            this.x = 0.0f;
            int i = n = this.tatoms.size();
            while (--i >= 0) {
                this.add((T3)this.tatoms.get(i));
            }
            this.x /= (float)n;
            this.y /= (float)n;
            this.z /= (float)n;
        }

        public String info() {
            return "[node " + this.id + " " + this.label + "/" + this.atomName + " " + super.toString() + "]";
        }

        @Override
        public String toString() {
            return this.info();
        }

        public TNode copy() {
            TNode node = (TNode)this.clone();
            node.idx = TopoCifParser.this.atomCount++;
            if (node.isFinalized) {
                node.addNode();
            }
            if (this.tatoms != null) {
                node.tatoms = new Lst();
                int n = this.tatoms.size();
                for (int i = 0; i < n; ++i) {
                    TAtom ta = ((TAtom)this.tatoms.get(i)).getTClone();
                    node.tatoms.addLast(ta);
                    TopoCifParser.this.reader.addCifAtom(ta, ta.atomName, null, null);
                }
            }
            return node;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    private class TAtom
    extends Atom {
        int id;
        String atomLabel;
        int nodeID;
        int linkID;
        int symop = 0;
        private P3 trans = new P3();
        String formula;
        Atom atom;
        private boolean isFinalized;
        int idx;
        String line;

        TAtom() {
        }

        TAtom getTClone() {
            try {
                TAtom ta = (TAtom)this.clone();
                ta.idx = TopoCifParser.this.atomCount++;
                return ta;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        boolean setAtom(int[] a, String line) {
            this.line = line;
            if (Float.isNaN(this.x) != Float.isNaN(this.y) || Float.isNaN(this.y) != Float.isNaN(this.z)) {
                return false;
            }
            this.idx = TopoCifParser.this.atomCount++;
            if (Float.isNaN(this.x)) {
                this.trans = P3.new3(a[0], a[1], a[2]);
            } else {
                this.symop = 0;
            }
            if (this.formula != null && this.formula.indexOf(" ") < 0) {
                this.atomName = this.formula;
                this.getElementSymbol();
                if (!this.formula.equals(this.elementSymbol)) {
                    this.elementSymbol = "Z";
                }
            }
            this.atomName = this.atomLabel;
            return true;
        }

        void finalizeAtom(M4[] ops) throws Exception {
            if (this.isFinalized) {
                return;
            }
            this.isFinalized = true;
            Atom a = this.atom;
            if (a == null && this.atomLabel != null) {
                a = TopoCifParser.this.reader.asc.getAtomFromName(this.atomLabel);
            }
            TopoCifParser.setElementSymbol(this, this.formula);
            if (a == null && Float.isNaN(this.x)) {
                throw new Exception("TopoCIFParser.finalizeAtom no atom " + this.atomLabel + " line=" + this.line);
            }
            TNode node = null;
            if (this.nodeID > 0 && (node = TopoCifParser.this.getNodeById(this.nodeID, -1, null)) != null) {
                node.addAtom(this);
            }
            TLink link = null;
            if (this.linkID > 0 && (link = TopoCifParser.this.getLinkById(this.linkID)) != null) {
                link.addAtom(this);
            }
            if (node == null && link == null) {
                System.out.println("TAtom " + this + " ignored");
                return;
            }
            if (a != null && (a == this.atom || Float.isNaN(this.x))) {
                TopoCifParser.setTAtom(a, this);
                TopoCifParser.applySymmetry(this, ops, this.symop, this.trans);
            }
            this.atomName = (node != null ? "Node_" + this.nodeID + "_" : (link != null ? "Link_" + this.linkID + "_" : "TAtom_")) + this.atomLabel;
            System.out.println("TAtom adding " + this);
            TopoCifParser.this.reader.addCifAtom(this, this.atomName, null, null);
        }

        @Override
        public String toString() {
            return this.line + " " + super.toString();
        }
    }

    private class TNet {
        String line;
        int idx;
        int id;
        int nLinks;
        int nNodes;
        String label;
        public boolean hasAtoms;

        TNet(int index, int id, String label) {
            this.idx = index;
            this.id = id;
            this.label = label;
        }

        void setNote() {
            String netKey = "," + this.id + ",";
            if (TopoCifParser.this.netNotes.indexOf(netKey) < 0) {
                TopoCifParser.this.reader.appendLoadNote("Net " + this.label + " created with " + this.nLinks + " links and " + this.nNodes + " nodes.\nUse DISPLAY " + (this.hasAtoms ? this.label + "__* to display it without associated atoms or " + this.label + "_* to display it with its associated atoms" : this.label + "** to display it"));
            }
        }
    }
}

