/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.objects.utils;

import java.util.Vector;
import uk.ac.vamsas.client.ClientHandle;
import uk.ac.vamsas.client.UserHandle;
import uk.ac.vamsas.objects.core.AppData;
import uk.ac.vamsas.objects.core.ApplicationData;
import uk.ac.vamsas.objects.core.User;
import uk.ac.vamsas.objects.core.VamsasDocument;

public class AppDataReference {
    public static Vector getAppDataReferences(VamsasDocument doc) {
        if (doc != null && doc.getApplicationDataCount() > 0) {
            Vector<String> apdrefs = new Vector<String>();
            ApplicationData[] appdatas = doc.getApplicationData();
            for (int q = 0; q < appdatas.length; ++q) {
                User[] users;
                String refstring = appdatas[q].getDataReference();
                if (refstring != null) {
                    apdrefs.add(refstring);
                }
                if ((users = appdatas[q].getUser()) == null) continue;
                for (int u = 0; u < users.length; ++u) {
                    refstring = users[u].getDataReference();
                    if (refstring == null) continue;
                    apdrefs.add(new String(refstring));
                }
            }
            if (apdrefs.size() > 0) {
                return apdrefs;
            }
        }
        return null;
    }

    public static Vector searchAppDatas(VamsasDocument doc, IAppDSearch test, boolean cascade) {
        if (doc != null && doc.getApplicationDataCount() > 0) {
            Vector<AppData> apdrefs = new Vector<AppData>();
            ApplicationData[] appdatas = doc.getApplicationData();
            for (int q = 0; q < appdatas.length; ++q) {
                User[] users;
                boolean t = test.process(appdatas[q]);
                if (t) {
                    apdrefs.add(appdatas[q]);
                }
                if (!t && !cascade || (users = appdatas[q].getUser()) == null) continue;
                for (int u = 0; u < users.length; ++u) {
                    if (!test.process(users[u])) continue;
                    apdrefs.add(users[u]);
                }
            }
            if (apdrefs.size() > 0) {
                return apdrefs;
            }
        }
        return null;
    }

    public static boolean equals(User p, UserHandle u) {
        return p.getFullname().equals(u.getFullName()) && p.getOrganization().equals(u.getOrganization());
    }

    public static boolean equals(ApplicationData p, ClientHandle c) {
        return p.getName().equals(c.getClientName()) && (c.getVersion() == null || p.getVersion().equals(c.getVersion()));
    }

    public static Vector getUserandApplicationsData(VamsasDocument doc, UserHandle user, ClientHandle app) {
        if (doc == null) {
            return null;
        }
        final UserHandle u = user;
        final ClientHandle c = app;
        IAppDSearch match = new IAppDSearch(){

            public boolean process(AppData p) {
                return p instanceof User ? AppDataReference.equals((User)p, u) : p instanceof ApplicationData && AppDataReference.equals((ApplicationData)p, c);
            }
        };
        return AppDataReference.searchAppDatas(doc, match, true);
    }

    public static String uniqueAppDataReference(VamsasDocument dest, String base) {
        String urn = base.replace('/', '_').replace('\\', '_').replace(':', '_').replace('.', '_');
        int v = 1;
        int j = dest.getApplicationDataCount();
        for (int i = 0; i < j; ++i) {
            ApplicationData o = dest.getApplicationData()[i];
            while (o.getDataReference() != null && o.getDataReference().equals(urn)) {
                urn = base + "_" + v++;
            }
        }
        return urn;
    }

    static interface IAppDSearch {
        public boolean process(AppData var1);
    }
}

