/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import uk.ac.vamsas.client.ClientHandle;
import uk.ac.vamsas.client.InvalidSessionUrnException;
import uk.ac.vamsas.client.SessionHandle;
import uk.ac.vamsas.client.UserHandle;
import uk.ac.vamsas.client.simpleclient.ClientSessionFileWatcherElement;
import uk.ac.vamsas.client.simpleclient.ClientsFile;
import uk.ac.vamsas.client.simpleclient.FileWatcher;
import uk.ac.vamsas.client.simpleclient.Lock;
import uk.ac.vamsas.client.simpleclient.SessionFile;
import uk.ac.vamsas.client.simpleclient.SessionFlagFile;
import uk.ac.vamsas.client.simpleclient.SessionUrn;
import uk.ac.vamsas.client.simpleclient.SimpleClient;
import uk.ac.vamsas.client.simpleclient.SimpleSessionHandle;
import uk.ac.vamsas.client.simpleclient.SimpleSessionManager;
import uk.ac.vamsas.client.simpleclient.VamsasArchive;
import uk.ac.vamsas.client.simpleclient.VamsasFile;
import uk.ac.vamsas.client.simpleclient.WatcherCallBack;
import uk.ac.vamsas.client.simpleclient.WatcherElement;

public class VamsasSession {
    public static final String CLOSEANDSAVE_FILE = "stored.log";
    public static final String MODIFIEDDOC_FILE = "modified";
    private SimpleSessionManager sessionManager = null;
    private final int watchCycleCountBeforeLastClient = 1220;
    public int WATCH_SLEEP = 30;
    protected String clientFileDirectory = "clients";
    public static final String SESSION_LOG = "Log.txt";
    private static Log log = LogFactory.getLog((Class)VamsasSession.class);
    protected Logger slog = Logger.getLogger((String)"uk.ac.vamsas.client.SessionLog");
    private FileAppender slogAppender = null;
    protected File sessionDir;
    ClientsFile clist;
    public static final String CLIENT_LIST = "Clients.obj";
    VamsasFile vamArchive;
    public static final String VAMSAS_OBJ = "VamDoc.jar";
    private SimpleSessionHandle sessionHandle = null;
    FileWatcher store_doc_file = null;
    public ClientsFile storedocfile = null;
    VamsasArchive _va = null;
    ClientSessionFileWatcherElement clistWatchElement = null;

    protected void clearUnsavedFlag() {
        SessionFlagFile laststored = new SessionFlagFile(new File(this.sessionDir, MODIFIEDDOC_FILE));
        if (!laststored.clearFlag()) {
            log.warn((Object)("Unsaved flag was not cleared for " + this.sessionDir));
        }
    }

    protected void setUnsavedFlag() {
        SessionFlagFile laststored = new SessionFlagFile(new File(this.sessionDir, MODIFIEDDOC_FILE));
        if (!laststored.setFlag()) {
            log.warn((Object)("Couldn't set the Unsaved flag for " + this.sessionDir));
        }
    }

    protected boolean getUnsavedFlag() {
        SessionFlagFile laststored = new SessionFlagFile(new File(this.sessionDir, MODIFIEDDOC_FILE));
        return laststored.checkFlag();
    }

    private void initLog() throws IOException {
        if (this.slog != null) {
            File sessionLogFile = new File(this.sessionDir, SESSION_LOG);
            this.slogAppender = new FileAppender((Layout)new PatternLayout("%-4r [%t] %-5p %c %x - %m%n"), sessionLogFile.getAbsolutePath(), true);
            this.slog.addAppender((Appender)this.slogAppender);
        } else {
            log.info((Object)"No appender for SessionLog");
        }
    }

    private void closeSessionLog() {
        if (this.slog != null && this.slogAppender != null) {
            this.slog.removeAppender((Appender)this.slogAppender);
            this.slogAppender.close();
            this.slogAppender = null;
        }
    }

    protected VamsasSession(File sessionDir1) throws IOException {
        this(sessionDir1, null);
    }

    protected VamsasSession(File sessionDir1, File extVamDoc) throws IOException {
        this(sessionDir1, extVamDoc, null);
    }

    public VamsasSession(File sessionDir1, File extVamDoc, String preferredName) throws IOException {
        if (sessionDir1 == null) {
            throw new Error("Null directory for VamsasSession.");
        }
        if (!sessionDir1.exists() && !sessionDir1.mkdir()) {
            throw new IOException("Failed to make VamsasSession directory in " + sessionDir1);
        }
        if (!(sessionDir1.isDirectory() && sessionDir1.canWrite() && sessionDir1.canRead())) {
            throw new IOException("Cannot access '" + sessionDir1 + "' as a read/writable Directory.");
        }
        boolean existingSession = this.checkSessionFiles(sessionDir1);
        if (existingSession) {
            if (extVamDoc != null) {
                throw new Error("Client Initialisation Error: Cannot join an existing session directory with an  existing vamsas document to import.");
            }
            log.debug((Object)"Joining an existing session.");
        }
        this.sessionDir = sessionDir1;
        SessionUrn sessUrn = new SessionUrn(this.sessionDir);
        if (extVamDoc != null) {
            sessUrn = new SessionUrn(extVamDoc);
        }
        if (preferredName != null) {
            try {
                sessUrn = new SessionUrn(preferredName);
            }
            catch (InvalidSessionUrnException e) {
                throw new Error("Malformed URI : preferredName = " + preferredName, e);
            }
        }
        this.sessionHandle = new SimpleSessionHandle(sessUrn.getSessionUrn(), this.sessionDir);
        this.initSessionObjects();
        if (existingSession) {
            this.slog.debug((Object)"Initialising additional VamsasSession instance");
        } else {
            this.slog.debug((Object)"Founding client has joined VamsasSession instance");
        }
        log.debug((Object)("Attached to VamsasSession in " + sessionDir1));
        if (extVamDoc != null) {
            this.setVamsasDocument(extVamDoc);
        }
        this.slog.debug((Object)"Session directory created.");
        log.debug((Object)("Initialised VamsasSession in " + sessionDir1));
    }

    private boolean checkSessionFiles(File dir) throws IOException {
        File c_file = new File(dir, CLIENT_LIST);
        File v_doc = new File(dir, VAMSAS_OBJ);
        return c_file.exists() && v_doc.exists();
    }

    private void createSessionFiles() throws IOException {
        if (this.sessionDir == null) {
            throw new IOException("Invalid call to createSessionFiles() with null sessionDir");
        }
        File c_file = new File(this.sessionDir, CLIENT_LIST);
        File v_doc = new File(this.sessionDir, VAMSAS_OBJ);
        if (!c_file.exists() && c_file.createNewFile()) {
            log.debug((Object)("Created new ClientFile " + c_file));
        }
        if (!v_doc.exists()) {
            if (v_doc.createNewFile()) {
                log.debug((Object)("Created new Vamsas Session Document File " + v_doc));
            } else {
                log.warn((Object)("Didn't create Vamsas Session Document file in " + v_doc));
            }
        }
    }

    private void initSessionObjects() throws IOException {
        this.createSessionFiles();
        if (this.clist != null || this.vamArchive != null) {
            throw new IOException("initSessionObjects called for initialised VamsasSession object.");
        }
        this.clist = new ClientsFile(new File(this.sessionDir, CLIENT_LIST));
        this.vamArchive = new VamsasFile(new File(this.sessionDir, VAMSAS_OBJ));
        this.storedocfile = new ClientsFile(new File(this.sessionDir, CLOSEANDSAVE_FILE));
        this.initLog();
    }

    public FileWatcher getClientWatcher() {
        return new FileWatcher(this.clist.sessionFile);
    }

    public FileWatcher getDocWatcher() {
        return new FileWatcher(this.vamArchive.sessionFile);
    }

    public FileWatcher getStoreWatcher() {
        return new FileWatcher(new File(this.sessionDir, CLOSEANDSAVE_FILE));
    }

    public void addStoreDocumentRequest(ClientHandle client, UserHandle user) throws IOException {
        SessionFile sfw = new SessionFile(new File(this.sessionDir, CLOSEANDSAVE_FILE));
        while (!sfw.lockFile()) {
            log.debug((Object)"Trying to get lock for stored.log");
        }
        RandomAccessFile sfwfile = sfw.fileLock.getRaFile();
        sfwfile.setLength(0L);
        sfwfile.writeUTF(client.getClientUrn() + ":" + user.getFullName() + "@" + user.getOrganization());
        sfw.unlockFile();
        if (this.store_doc_file != null) {
            this.store_doc_file.setState();
        }
        this.slog.info((Object)("FinalizeAppData request from " + user.getFullName() + " using " + client.getClientUrn() + ""));
    }

    public void setVamsasDocument(File archive) throws IOException {
        log.debug((Object)("Transferring vamsas data from " + archive + " to session:" + this.vamArchive.sessionFile));
        SessionFile xtantdoc = new SessionFile(archive);
        while (!this.vamArchive.lockFile()) {
            log.info((Object)("Trying to get lock for " + this.vamArchive.sessionFile));
        }
        this.vamArchive.updateFrom(null, xtantdoc);
        xtantdoc.unlockFile();
        this.unlockVamsasDocument();
        log.debug((Object)"Transfer complete.");
    }

    protected void writeVamsasDocument(File destarchive, Lock extlock) throws IOException {
        log.debug((Object)("Transferring vamsas data from " + this.vamArchive.sessionFile + " to session:" + destarchive));
        SessionFile newdoc = new SessionFile(destarchive);
        if (extlock == null && !this.vamArchive.lockFile()) {
            while (!this.vamArchive.lockFile()) {
                log.info((Object)("Trying to get lock for " + this.vamArchive.sessionFile));
            }
        }
        newdoc.updateFrom(null, this.vamArchive);
        this.vamArchive.unLock();
        newdoc.unlockFile();
        log.debug((Object)"Transfer complete.");
    }

    protected VamsasArchive getVamsasDocument() throws IOException {
        if (this._va != null) {
            return this._va;
        }
        long tries = 5000L;
        while (this.vamArchive.getLock() == null && --tries > 0L) {
            log.debug((Object)("Trying to get a document lock for the " + tries + "'th time."));
        }
        if (tries == 0L) {
            throw new IOException("Failed to get lock for vamsas archive.");
        }
        VamsasArchive va = new VamsasArchive(this.vamArchive.sessionFile, false, true, this.vamArchive);
        return va;
    }

    protected void unlockVamsasDocument() throws IOException {
        if (this._va != null) {
            this._va.closeArchive();
        }
        this._va = null;
        if (this.vamArchive != null) {
            this.vamArchive.unLock();
        }
    }

    protected SessionFile getTempSessionFile(String pref, String suff) throws IOException {
        File tfile = File.createTempFile(pref, suff, this.sessionDir);
        SessionFile tempFile = new SessionFile(tfile);
        return tempFile;
    }

    protected void addClient(SimpleClient client) {
        if (client == null) {
            this.slog.error((Object)"Try to add a null client to the session ");
        } else {
            log.debug((Object)("Adding client " + client.getClientHandle().getClientUrn()));
            this.getClientWatcherElement().haltWatch();
            this.clist.addClient(client.getClientHandle());
            log.debug((Object)"Added.");
            log.debug((Object)"Register Client as Active.");
            try {
                client.createActiveClientFile();
            }
            catch (IOException e) {
                log.debug((Object)"Error during  active client file creation.");
            }
            this.getClientWatcherElement().setHandler(new AddClientWatchCallBack(client));
            this.getClientWatcherElement().enableWatch();
        }
    }

    protected void removeClient(SimpleClient client) {
        if (client == null) {
            log.error((Object)"Null client passed to removeClient");
            return;
        }
        log.info((Object)"remove client from list");
        if (this.clistWatchElement != null) {
            this.clistWatchElement.haltWatch();
            this.clistWatchElement.watched.unlockFile();
        }
        log.info((Object)"list cleared");
        log.debug((Object)"Stopping EventGenerator..");
        client.evgen.stopWatching();
        client.evgen._raise("uk.ac.vamsas.client.events.DocumentFinalizeAppData", null, client, null);
        boolean closeSession = this.isLastActiveClient(client);
        if (closeSession) {
            if (client.get_session().getUnsavedFlag()) {
                log.debug((Object)"Raising request-to-save event");
                client.evgen._raise("uk.ac.vamas.client.DocumentRequestToCloseEvent", null, client, null);
            }
            log.debug((Object)"Raising session shutdown event");
            client.evgen._raise("uk.ac.vamsas.client.events.SessionShutdownEvent", null, client.getSessionHandle(), null);
            log.debug((Object)("All events raised for finalising session " + client.getSessionHandle().toString()));
        }
        client.evgen.stopWatching();
        try {
            log.debug((Object)"Attempting to release active client locks");
            client.releaseActiveClientFile();
        }
        catch (IOException e) {
            log.error((Object)"error during active file client release");
        }
        this.tidyUp();
        if (closeSession) {
            log.debug((Object)"Last active client: closing session");
            log.info((Object)"Closing session");
            this.closeSession(client.getSessionHandle());
        }
    }

    private void tidyUp() {
        if (this.clist != null) {
            this.clist.unlockFile();
        }
        this.clist = null;
        this.storedocfile.unlockFile();
        this.storedocfile = null;
        this.closeSessionLog();
    }

    private boolean isLastActiveClient(SimpleClient client) {
        log.debug((Object)"Testing if current client is the last one.");
        log.debug((Object)("current client lockfile is '" + client.getClientlockFile() + "'"));
        boolean noOtherActiveClient = true;
        File clientlockFileDir = new File(this.sessionDir, this.clientFileDirectory);
        if (!clientlockFileDir.exists()) {
            log.error((Object)"Something wrong the active client file does not exits... should not happen");
            return false;
        }
        try {
            File[] clientFiles = clientlockFileDir.listFiles();
            if (clientFiles == null || clientFiles.length == 0) {
                return true;
            }
            for (int i = clientFiles.length - 1; i > -1 && noOtherActiveClient; --i) {
                File clientFile = clientFiles[i];
                log.debug((Object)("testing file for lock: " + clientFile.getAbsolutePath()));
                if (client.getClientLock().isTargetLockFile(clientFile)) {
                    log.debug((Object)"current client file found");
                    continue;
                }
                if (clientFile == null || !clientFile.exists()) continue;
                try {
                    log.debug((Object)"Try to acquire a lock on the file");
                    FileChannel channel = new RandomAccessFile(clientFile, "rw").getChannel();
                    try {
                        FileLock activeClientFilelock = channel.tryLock();
                        if (activeClientFilelock != null) {
                            log.debug((Object)"lock obtained : file must be from a crashed application");
                            activeClientFilelock.release();
                            log.debug((Object)"lock released");
                            channel.close();
                            log.debug((Object)"channel closed");
                            clientFile.delete();
                            log.debug((Object)"crashed application file deleted");
                            continue;
                        }
                        noOtherActiveClient = false;
                        log.debug((Object)"lock not obtained : another application is active");
                    }
                    catch (OverlappingFileLockException e) {
                        log.debug((Object)"lock not accessible ", (Throwable)e);
                    }
                    continue;
                }
                catch (Exception e) {
                    log.debug((Object)"error during lock testing ", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"error during counting active clients");
        }
        return noOtherActiveClient;
    }

    private void closeSession(SimpleClient client) {
        client.evgen._raise("uk.ac.vamas.client.DocumentRequestToCloseEvent", null, client, null);
        log.debug((Object)"close document request done");
        this.closeSession(client.getSessionHandle());
    }

    private void closeSession(SessionHandle sessionHandle) {
        this.getSessionManager().removeSession(sessionHandle);
        log.debug((Object)"Session removed");
    }

    protected SimpleSessionManager getSessionManager() {
        return this.sessionManager;
    }

    protected void setSessionManager(SimpleSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public ClientsFile getStoreDocFile() {
        if (this.storedocfile == null) {
            // empty if block
        }
        return this.storedocfile;
    }

    public ClientSessionFileWatcherElement getClientWatcherElement() {
        if (this.clistWatchElement == null) {
            this.clistWatchElement = new ClientSessionFileWatcherElement(this.clist, null);
        }
        return this.clistWatchElement;
    }

    public SimpleSessionHandle getSessionUrn() {
        return this.sessionHandle;
    }

    private class RemoveClientWatchCallBack
    implements WatcherCallBack {
        private SimpleClient client;
        private boolean manualCheckOfClientCount = false;

        protected RemoveClientWatchCallBack(SimpleClient client) {
            this.client = client;
        }

        public boolean handleWatchEvent(WatcherElement watcher, Lock lock) {
            if (this.client != null) {
                if (lock == null) {
                    boolean islastClient = true;
                    if (this.manualCheckOfClientCount) {
                        log.debug((Object)"manual checking of count of client");
                        ClientHandle[] cl = VamsasSession.this.clist.retrieveClientList();
                        if (cl == null || cl.length < 1) {
                            islastClient = true;
                            log.debug((Object)"list is empty");
                        } else {
                            islastClient = false;
                        }
                        log.debug((Object)"list is not empty");
                    }
                    if (islastClient) {
                        log.info((Object)"FROMCLIENTLIST WATCHER: last client removed: closing session");
                        VamsasSession.this.closeSession(this.client);
                    }
                } else {
                    log.debug((Object)"not the last client found ");
                }
                log.debug((Object)"Stopping EventGenerator..");
                this.client.evgen.stopWatching();
            }
            watcher.setHandler(null);
            return false;
        }
    }

    private class AddClientWatchCallBack
    implements WatcherCallBack {
        private SimpleClient client;

        protected AddClientWatchCallBack(SimpleClient client) {
            this.client = client;
        }

        public boolean handleWatchEvent(WatcherElement watcher, Lock lock) {
            boolean isWatchEnable = watcher.isWatchEnabled();
            if (lock == null) {
                return isWatchEnable;
            }
            log.debug((Object)"change on the client list ");
            if (this.client != null) {
                ClientHandle[] cl = VamsasSession.this.clist.retrieveClientList(lock);
                boolean found = false;
                if (cl != null) {
                    for (int chi = cl.length - 1; !found && chi > -1; --chi) {
                        found = cl[chi].equals(this.client.getClientHandle());
                    }
                }
                if (!found) {
                    log.debug((Object)"client not in the list ");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("the client has not been found in the list. Adding it again :" + cl));
                    }
                    VamsasSession.this.addClient(this.client);
                } else {
                    log.debug((Object)"client is in the list");
                }
            }
            log.debug((Object)("isWatchEnable " + isWatchEnable));
            return isWatchEnable;
        }
    }
}

