/*
 * Decompiled with CFR 0.152.
 */
package org.robsite.jswingreader.action;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.robsite.jswingreader.action.UpdatableAction;
import org.robsite.jswingreader.model.Channel;
import org.robsite.jswingreader.model.ChannelListModel;
import org.robsite.jswingreader.model.SimpleRSSParser;
import org.robsite.jswingreader.ui.Main;
import org.robsite.jswingreader.ui.MainWindow;

public class EditRSSFeedsAction
extends AbstractAction
implements UpdatableAction {
    private JList _listChannels;

    public EditRSSFeedsAction(JList listChannels) {
        super("Edit");
        this.putValue("MnemonicKey", new Integer(69));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 8));
        this.putValue("SmallIcon", new ImageIcon(Main.class.getResource("image/Edit16.gif")));
        this.putValue("LongDescription", "Edit");
        this._listChannels = listChannels;
    }

    public void actionPerformed(ActionEvent e) {
        String message = "Enter URL for RSS Feed";
        MainWindow parent = Main.getMainWindow();
        String urlString = JOptionPane.showInputDialog(parent, (Object)message);
        if (urlString != null && urlString.length() > 0) {
            try {
                Channel channel = SimpleRSSParser.parse(urlString);
                ChannelListModel model = (ChannelListModel)this._listChannels.getModel();
                model.removeChannelAt(this._listChannels.getSelectedIndex());
                model.addChannel(channel);
                this._listChannels.setSelectedValue(channel, true);
            }
            catch (Exception ex) {
                Main.getMainWindow().setStatusBarText("Unable to open URL: " + urlString);
            }
        }
    }

    public void update(Object o) {
        if (this._listChannels == null || this._listChannels.getModel().getSize() == 0) {
            this.setEnabled(false);
        } else if (this._listChannels.getSelectedIndex() == -1) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }
}

