/*
 * Decompiled with CFR 0.152.
 */
package net.meyfa.sha256;

public class Sha256 {
    private static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private static final int[] H0 = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private static final int BLOCK_BITS = 512;
    private static final int BLOCK_BYTES = 64;

    public static byte[] hash(byte[] message) {
        int[] W = new int[64];
        int[] H = new int[8];
        int[] TEMP = new int[8];
        System.arraycopy(H0, 0, H, 0, H0.length);
        int[] words = Sha256.pad(message);
        int n = words.length / 16;
        for (int i = 0; i < n; ++i) {
            int t;
            System.arraycopy(words, i * 16, W, 0, 16);
            for (t = 16; t < W.length; ++t) {
                W[t] = Sha256.smallSig1(W[t - 2]) + W[t - 7] + Sha256.smallSig0(W[t - 15]) + W[t - 16];
            }
            System.arraycopy(H, 0, TEMP, 0, H.length);
            for (t = 0; t < W.length; ++t) {
                int t1 = TEMP[7] + Sha256.bigSig1(TEMP[4]) + Sha256.ch(TEMP[4], TEMP[5], TEMP[6]) + K[t] + W[t];
                int t2 = Sha256.bigSig0(TEMP[0]) + Sha256.maj(TEMP[0], TEMP[1], TEMP[2]);
                System.arraycopy(TEMP, 0, TEMP, 1, TEMP.length - 1);
                TEMP[4] = TEMP[4] + t1;
                TEMP[0] = t1 + t2;
            }
            for (t = 0; t < H.length; ++t) {
                int n2 = t;
                H[n2] = H[n2] + TEMP[t];
            }
        }
        return Sha256.toByteArray(H);
    }

    public static int[] pad(byte[] message) {
        int finalBlockLength = message.length % 64;
        int blockCount = message.length / 64 + (finalBlockLength + 1 + 8 > 64 ? 2 : 1);
        int capacity = blockCount * 16;
        int[] resultArray = new int[capacity];
        int n = message.length / 4;
        int m = n * 4;
        for (int i = 0; i < n; ++i) {
            int j = 4 * i;
            resultArray[i] = Sha256.bytesToInt(message[j], message[j + 1], message[j + 2], message[j + 3]);
        }
        byte[] remainderArray = new byte[]{0, 0, 0, 0};
        for (int i = m; i < message.length; ++i) {
            remainderArray[i - m] = message[i];
        }
        remainderArray[message.length - m] = -128;
        resultArray[n] = Sha256.bytesToInt(remainderArray[0], remainderArray[1], remainderArray[2], remainderArray[3]);
        long msgLength = (long)message.length * 8L;
        resultArray[capacity - 2] = (int)(msgLength >>> 32);
        resultArray[capacity - 1] = (int)msgLength;
        return resultArray;
    }

    private static int bytesToInt(byte b0, byte b1, byte b2, byte b3) {
        return 0xFF & b3 << 0 | 0xFF00 & b2 << 8 | 0xFF0000 & b1 << 16 | 0xFF000000 & b0 << 24;
    }

    private static byte[] toByteArray(int[] ints) {
        byte[] bufArray = new byte[ints.length * 4];
        for (int i = 0; i < ints.length; ++i) {
            int j = i * 4;
            int n = ints[i];
            bufArray[j + 0] = (byte)((0xFF000000 & n) >> 24);
            bufArray[j + 1] = (byte)((0xFF0000 & n) >> 16);
            bufArray[j + 2] = (byte)((0xFF00 & n) >> 8);
            bufArray[j + 3] = (byte)((0xFF & n) >> 0);
        }
        return bufArray;
    }

    private static int ch(int x, int y, int z) {
        return x & y | ~x & z;
    }

    private static int maj(int x, int y, int z) {
        return x & y | x & z | y & z;
    }

    private static int bigSig0(int x) {
        return Integer.rotateRight(x, 2) ^ Integer.rotateRight(x, 13) ^ Integer.rotateRight(x, 22);
    }

    private static int bigSig1(int x) {
        return Integer.rotateRight(x, 6) ^ Integer.rotateRight(x, 11) ^ Integer.rotateRight(x, 25);
    }

    private static int smallSig0(int x) {
        return Integer.rotateRight(x, 7) ^ Integer.rotateRight(x, 18) ^ x >>> 3;
    }

    private static int smallSig1(int x) {
        return Integer.rotateRight(x, 17) ^ Integer.rotateRight(x, 19) ^ x >>> 10;
    }
}

