/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.bin.Cache;
import jalview.util.ChannelProperties;
import jalview.util.Platform;

public class UserAgent {
    private static String userAgentFormat = null;

    public static String getUserAgent(String className) {
        if (userAgentFormat == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(ChannelProperties.getProperty("app_name"));
            if (Platform.isJS()) {
                sb.append(" JS");
            } else {
                sb.append(" Desktop");
            }
            sb.append('/');
            sb.append(Cache.getDefault("VERSION", "Unknown"));
            sb.append(" (");
            sb.append(System.getProperty("os.name"));
            sb.append("; ");
            sb.append(System.getProperty("os.arch"));
            sb.append(' ');
            sb.append(System.getProperty("os.name"));
            sb.append(' ');
            sb.append(System.getProperty("os.version"));
            sb.append("; ");
            sb.append("java/");
            sb.append(System.getProperty("java.version"));
            sb.append("; ");
            sb.append("jalview/");
            sb.append(ChannelProperties.getProperty("channel"));
            sb.append("%s");
            String installation = Cache.applicationProperties.getProperty("INSTALLATION");
            if (installation != null) {
                sb.append("; ");
                sb.append(installation);
            }
            sb.append(')');
            sb.append(" help@jalview.org");
            userAgentFormat = sb.toString();
        }
        return String.format(userAgentFormat, className == null ? "" : "; " + className);
    }

    public static String getUserAgent() {
        return UserAgent.getUserAgent(null);
    }
}

