/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignViewportI;
import jalview.bin.Cache;
import jalview.gui.AlignmentPanel;
import jalview.gui.AnnotationLabels;
import jalview.gui.SeqCanvas;
import jalview.gui.SplitFrame;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class IdwidthAdjuster
extends JPanel
implements MouseListener,
MouseMotionListener {
    public static final int MIN_ID_WIDTH = 20;
    int oldX = 0;
    AlignmentPanel ap;

    public IdwidthAdjuster(AlignmentPanel ap) {
        this.ap = ap;
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.oldX = evt.getX();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.repaint();
        AlignViewportI viewport = this.ap.getAlignViewport();
        if (viewport.getCodingComplement() != null) {
            viewport.getCodingComplement().setIdWidth(viewport.getIdWidth());
            SplitFrame sf = (SplitFrame)this.ap.alignFrame.getSplitViewContainer();
            sf.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        SeqCanvas sc;
        int dif;
        int mouseX = evt.getX();
        AlignViewportI viewport = this.ap.getAlignViewport();
        int curwidth = viewport.getIdWidth();
        int newWidth = curwidth + (dif = mouseX - this.oldX);
        if (newWidth < 20 || newWidth > this.ap.getWidth()) {
            return;
        }
        if (viewport.getWrapAlignment() && (sc = this.ap.getSeqPanel().seqCanvas) != null && sc.getWrappedCanvasWidth(sc.getWidth() - dif) < 1) {
            return;
        }
        this.oldX = evt.getX();
        if (dif > 0 && mouseX < 0) {
            return;
        }
        int curCol = viewport.getRanges().getStartRes() + viewport.getRanges().getViewportWidth();
        viewport.setIdWidth(newWidth);
        this.ap.validateAnnotationDimensions(false);
        if (viewport.getWrapAlignment()) {
            viewport.getRanges().scrollToWrappedVisible(curCol - viewport.getRanges().getViewportWidth());
        }
        this.ap.paintAlignment(true, false);
        this.ap.getIdPanel().getIdCanvas().setManuallyAdjusted(true);
    }

    public void setWidth(int newWidth) {
        if (newWidth < 20 || this.ap.getIdPanel().getIdCanvas().isManuallyAdjusted()) {
            return;
        }
        AlignViewportI viewport = this.ap.getAlignViewport();
        viewport.setIdWidth(newWidth);
        this.ap.paintAlignment(true, false);
    }

    public boolean manuallyAdjusted() {
        return this.ap.getIdPanel().getIdCanvas().isManuallyAdjusted();
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        if (!Cache.getDefault("RESIZE_MARGINS_MARK", false)) {
            int spacer = Math.max(2, AnnotationLabels.HEIGHT_ADJUSTER_HEIGHT / 4);
            g.setColor(Color.LIGHT_GRAY);
            g.drawLine(width - 3 * spacer, 0, width - 3 * spacer, height / 2);
            g.drawLine(width - spacer, 0, width - spacer, height / 2);
        }
        this.setCursor(Cursor.getPredefinedCursor(10));
    }
}

