/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.views;

import java.util.Iterator;
import java.util.List;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.core.sequence.template.SequenceView;

public class WindowedSequence<C extends Compound>
implements Iterable<SequenceView<C>> {
    private final Sequence<C> sequence;
    private final int windowSize;

    public WindowedSequence(Sequence<C> sequence, int windowSize) {
        this.sequence = sequence;
        this.windowSize = windowSize;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public Sequence<C> getBackingSequence() {
        return this.sequence;
    }

    protected int toStartIndex(int index) {
        return (index - 1) * this.getWindowSize() + 1;
    }

    public int getLength() {
        return this.getBackingSequence().getLength() / this.getWindowSize();
    }

    public List<C> getCompounds(int index) {
        return this.get(index).getAsList();
    }

    public SequenceView<C> get(int index) {
        int start = this.toStartIndex(index);
        int end = index + (this.getWindowSize() - 1);
        return this.getBackingSequence().getSubSequence(start, end);
    }

    @Override
    public Iterator<SequenceView<C>> iterator() {
        return new WindowedSequenceIterator(this);
    }

    private static class WindowedSequenceIterator<C extends Compound>
    implements Iterator<SequenceView<C>> {
        private final int end;
        private final int window;
        private final int offset;
        private int currentIndex = 1;
        private final Sequence<C> seq;

        public WindowedSequenceIterator(WindowedSequence<C> sequence) {
            this.window = sequence.getWindowSize();
            this.offset = this.window - 1;
            this.seq = sequence.getBackingSequence();
            this.end = this.seq.getLength();
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex + this.offset <= this.end;
        }

        @Override
        public SequenceView<C> next() {
            SequenceView<C> v = this.seq.getSubSequence(this.currentIndex, this.currentIndex + this.offset);
            this.currentIndex += this.window;
            return v;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from a Windowed view");
        }
    }
}

