/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.AppDataInputStream;
import uk.ac.vamsas.client.AppDataOutputStream;
import uk.ac.vamsas.client.IClientAppdata;
import uk.ac.vamsas.client.simpleclient.ClientDocument;
import uk.ac.vamsas.client.simpleclient.SessionFile;
import uk.ac.vamsas.client.simpleclient.VamsasArchive;
import uk.ac.vamsas.client.simpleclient.VamsasArchiveReader;
import uk.ac.vamsas.objects.core.AppData;
import uk.ac.vamsas.objects.core.ApplicationData;
import uk.ac.vamsas.objects.core.User;
import uk.ac.vamsas.objects.core.VamsasDocument;
import uk.ac.vamsas.objects.utils.AppDataReference;

public class SimpleClientAppdata
implements IClientAppdata {
    private static Log log = LogFactory.getLog((Class)SimpleClientAppdata.class);
    protected boolean accessedDocument = false;
    SessionFile newUserData = null;
    JarOutputStream newUserDataStream = null;
    SessionFile newAppData = null;
    JarOutputStream newAppDataStream = null;
    protected ApplicationData appsGlobal = null;
    protected User usersData = null;
    ClientDocument clientdoc;
    private final int _TRANSFER_BUFFER = 16384;

    protected SimpleClientAppdata(ClientDocument clientdoc) {
        if (clientdoc == null) {
            log.fatal((Object)"Implementation error - Null ClientDocument for SimpleClientAppdata construction.");
            throw new Error("Implementation error - Null ClientDocument for SimpleClientAppdata construction.");
        }
        this.clientdoc = clientdoc;
    }

    private void extractAppData() {
        if (!this.accessedDocument) {
            this._extractAppData(this.clientdoc.getVamsasDocument());
        }
    }

    private void _extractAppData(VamsasDocument doc) {
        if (doc == null) {
            log.debug((Object)"extractAppData called for null document object");
            return;
        }
        if (this.accessedDocument) {
            return;
        }
        Vector apldataset = AppDataReference.getUserandApplicationsData(doc, this.clientdoc.sclient.getUserHandle(), this.clientdoc.sclient.getClientHandle());
        this.accessedDocument = true;
        if (apldataset != null && apldataset.size() > 0) {
            AppData clientdat = (AppData)apldataset.get(0);
            if (clientdat instanceof ApplicationData) {
                this.appsGlobal = (ApplicationData)clientdat;
                if (apldataset.size() > 1) {
                    clientdat = (AppData)apldataset.get(1);
                    if (clientdat instanceof User) {
                        this.usersData = (User)clientdat;
                    }
                    if (apldataset.size() > 2) {
                        log.info((Object)("Ignoring additional (" + (apldataset.size() - 2) + ") AppDatas returned by document appdata query."));
                    }
                }
            } else {
                log.warn((Object)("Unexpected entry in AppDataReference query: id=" + clientdat.getVorbaId() + " type=" + clientdat.getClass().getName()));
            }
            apldataset.removeAllElements();
        }
    }

    private InputStream getAppDataStream(AppData appdata, VamsasArchiveReader docreader) {
        String entryRef = appdata.getDataReference();
        if (entryRef != null) {
            log.debug((Object)("Resolving appData reference +" + entryRef));
            InputStream entry = docreader.getAppdataStream(entryRef);
            if (entry != null) {
                return entry;
            }
        } else {
            log.debug((Object)"GetAppDataStream called for an AppData without a data reference.");
        }
        return null;
    }

    private byte[] getAppDataAsByteArray(AppData appdata, VamsasArchiveReader docreader) {
        if (appdata.getData() == null) {
            if (docreader == null) {
                log.warn((Object)"Silently failing getAppDataAsByteArray with null docreader.", (Throwable)new Exception());
                return null;
            }
            InputStream entry = this.getAppDataStream(appdata, docreader);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            try {
                byte[] buff = new byte[16384];
                int olen = 0;
                while (entry != null && entry.available() > 0) {
                    int len = entry.read(buff, 0, 16384);
                    if (len <= -1) continue;
                    bytes.write(buff, 0, len);
                    olen += len;
                }
                buff = null;
            }
            catch (Exception e) {
                log.warn((Object)("Unexpected exception - probable truncation when accessing VamsasDocument entry " + appdata.getDataReference()), (Throwable)e);
            }
            if (bytes.size() > 0) {
                log.debug((Object)("Got " + bytes.size() + " bytes from AppDataReference " + appdata.getDataReference()));
                byte[] data = bytes.toByteArray();
                bytes = null;
                return data;
            }
            return null;
        }
        log.debug((Object)("Returning inline AppData block for " + appdata.getVorbaId()));
        return appdata.getData();
    }

    private AppDataInputStream getAppDataAsDataInputStream(AppData appdata, VamsasArchiveReader docreader) {
        if (appdata != null && docreader != null) {
            String entryRef = appdata.getDataReference();
            if (entryRef != null) {
                log.debug((Object)("Resolving AppData reference for " + entryRef));
                InputStream jstrm = docreader.getAppdataStream(entryRef);
                if (jstrm != null) {
                    return new AppDataInputStream(jstrm);
                }
                log.debug((Object)("Returning null input stream for unresolved reference (" + entryRef + ") id=" + appdata.getVorbaId()));
                return null;
            }
            byte[] data = appdata.getData();
            if (data.length > 0) {
                ByteArrayInputStream stream = new ByteArrayInputStream(data);
                return new AppDataInputStream(stream);
            }
            log.debug((Object)("Returning null input stream for empty Appdata data block in id=" + appdata.getVorbaId()));
            return null;
        }
        log.debug((Object)("Returning null DataInputStream for appdata entry:" + appdata.getVorbaId()));
        return null;
    }

    private byte[] _getappdataByteArray(boolean clientOrUser) {
        if (this.clientdoc == null) {
            throw new Error("Implementation error, Improperly initialized SimpleClientAppdata.");
        }
        byte[] data = null;
        String appdName = !clientOrUser ? "Client's Appdata" : "User's Appdata";
        log.debug((Object)("getting " + appdName + " as a byte array"));
        this.extractAppData();
        AppData object = !clientOrUser ? this.appsGlobal : this.usersData;
        if (object != null) {
            log.debug((Object)("Trying to resolve " + appdName + " object to byte array."));
            data = this.getAppDataAsByteArray(object, this.clientdoc.getVamsasArchiveReader());
        }
        if (data == null) {
            log.debug((Object)("Returning null for " + appdName + "ClientAppdata byte[] array"));
        }
        return data;
    }

    private AppDataInputStream _getappdataInputStream(boolean clientOrUser) {
        if (this.clientdoc == null) {
            throw new Error("Implementation error, Improperly initialized SimpleClientAppdata.");
        }
        String appdName = !clientOrUser ? "Client's Appdata" : "User's Appdata";
        if (log.isDebugEnabled()) {
            log.debug((Object)("getting " + appdName + " as an input stream."));
        }
        this.extractAppData();
        AppData object = !clientOrUser ? this.appsGlobal : this.usersData;
        if (object != null) {
            log.debug((Object)"Trying to resolve ClientAppdata object to an input stream.");
            return this.getAppDataAsDataInputStream(object, this.clientdoc.getVamsasArchiveReader());
        }
        log.debug((Object)"getClientInputStream returning null.");
        return null;
    }

    public byte[] getClientAppdata() {
        return this._getappdataByteArray(false);
    }

    public AppDataInputStream getClientInputStream() {
        return this._getappdataInputStream(false);
    }

    public byte[] getUserAppdata() {
        return this._getappdataByteArray(true);
    }

    public AppDataInputStream getUserInputStream() {
        return this._getappdataInputStream(true);
    }

    private AppDataOutputStream _getAppdataOutputStream(boolean clientOrUser) {
        String apdname;
        this.extractAppData();
        SessionFile apdfile = null;
        if (!clientOrUser) {
            apdname = "clientAppData";
            apdfile = this.newAppData;
        } else {
            apdname = "userAppData";
            apdfile = this.newUserData;
        }
        try {
            if (apdfile == null) {
                apdfile = this.clientdoc.sclient._session.getTempSessionFile(apdname, ".jar");
                log.debug((Object)("Successfully made temp appData file for " + apdname));
            } else {
                apdfile.fileLock.getRaFile().setLength(0L);
                log.debug((Object)("Successfully truncated existing temp appData for " + apdname));
            }
        }
        catch (Exception e) {
            log.error((Object)("Whilst opening temp file in directory " + this.clientdoc.sclient._session.sessionDir), (Throwable)e);
        }
        if (!clientOrUser) {
            this.newAppData = apdfile;
        } else {
            this.newUserData = apdfile;
        }
        try {
            apdfile.lockFile();
            JarOutputStream dstrm = new JarOutputStream(apdfile.fileLock.getBufferedOutputStream(true));
            if (!clientOrUser) {
                this.newAppDataStream = dstrm;
            } else {
                this.newUserDataStream = dstrm;
            }
            dstrm.putNextEntry(new JarEntry("appData_entry.dat"));
            return new AppDataOutputStream(dstrm);
        }
        catch (Exception e) {
            log.error((Object)("Whilst opening jar output stream for file " + apdfile.sessionFile));
            apdfile.unlockFile();
            return null;
        }
    }

    protected void updateAnAppdataEntry(VamsasArchive vdoc, AppData appd, SessionFile apdjar) throws IOException {
        if (apdjar == null || apdjar.sessionFile == null || !apdjar.sessionFile.exists()) {
            throw new IOException("No temporary Appdata to recover and transfer.");
        }
        if (vdoc == null) {
            log.fatal((Object)"FATAL! NO DOCUMENT TO WRITE TO!");
            throw new IOException("FATAL! NO DOCUMENT TO WRITE TO!");
        }
        log.debug((Object)("Recovering AppData entry from " + apdjar.sessionFile));
        JarInputStream istrm = new JarInputStream(apdjar.getBufferedInputStream(true));
        JarEntry je = null;
        while (istrm.available() > 0 && (je = istrm.getNextJarEntry()) != null && !je.getName().equals("appData_entry.dat")) {
            if (je == null) continue;
            log.debug((Object)("Ignoring extraneous entry " + je.getName()));
        }
        if (istrm.available() > 0 && je != null) {
            log.debug((Object)"Found appData_entry.dat in Jar");
            String ref = appd.getDataReference();
            if (ref == null) {
                throw new IOException("Null AppData.DataReference passed.");
            }
            log.debug((Object)("Writing appData_entry.dat as " + ref));
            if (!vdoc.writeAppdataFromStream(ref, istrm)) {
                throw new IOException("writeAppdataFromStream did not return true - expect future badness.");
            }
        } else {
            throw new IOException("Couldn't find appData_entry.dat in temporary jar file " + apdjar.sessionFile.getAbsolutePath());
        }
        log.debug((Object)"Entry updated successfully.");
        istrm.close();
    }

    public AppDataOutputStream getClientOutputStream() {
        if (this.clientdoc == null) {
            throw new Error("Implementation error, Improperly initialized SimpleClientAppdata.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("trying to getClientOutputStream for " + this.clientdoc.sclient.client.getClientUrn()));
        }
        return this._getAppdataOutputStream(false);
    }

    public AppDataOutputStream getUserOutputStream() {
        if (this.clientdoc == null) {
            throw new Error("Implementation error, Improperly initialized SimpleClientAppdata.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("trying to getUserOutputStream for (" + this.clientdoc.sclient.getUserHandle().getFullName() + ")" + this.clientdoc.sclient.client.getClientUrn()));
        }
        return this._getAppdataOutputStream(true);
    }

    public boolean hasClientAppdata() {
        if (this.clientdoc == null) {
            throw new Error("Implementation error, Improperly initialized SimpleClientAppdata.");
        }
        this.extractAppData();
        return this.appsGlobal != null && (this.appsGlobal.getDataReference() != null || this.appsGlobal.getData() != null);
    }

    public boolean hasUserAppdata() {
        if (this.clientdoc == null) {
            throw new Error("Implementation error, Improperly initialized SimpleClientAppdata.");
        }
        this.extractAppData();
        return this.usersData != null && (this.usersData.getDataReference() != null || this.usersData.getData() != null);
    }

    private boolean _writeAppDataStream(JarOutputStream ostrm, byte[] data) {
        try {
            if (data != null && data.length > 0) {
                ostrm.write(data);
            }
            ostrm.closeEntry();
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Serious! - IO error when writing AppDataStream to file " + this.newAppData.sessionFile), (Throwable)e);
            return false;
        }
    }

    public void setClientAppdata(byte[] data) {
        if (this.clientdoc == null) {
            throw new Error("Implementation error, Improperly initialized SimpleClientAppdata.");
        }
        this._getAppdataOutputStream(false);
        if (this.newAppDataStream == null) {
            log.error((Object)("Serious! - couldn't open new AppDataStream in session directory " + this.clientdoc.sclient._session.sessionDir));
        } else {
            this._writeAppDataStream(this.newAppDataStream, data);
        }
    }

    public void setUserAppdata(byte[] data) {
        if (this.clientdoc == null) {
            throw new Error("Implementation error, Improperly initialized SimpleClientAppdata.");
        }
        this._getAppdataOutputStream(true);
        if (this.newUserDataStream == null) {
            log.error((Object)("Serious! - couldn't open new UserDataStream in session directory " + this.clientdoc.sclient._session.sessionDir));
        } else {
            this._writeAppDataStream(this.newUserDataStream, data);
        }
    }

    protected void closeForWriting() throws IOException {
        if (this.newAppDataStream != null) {
            this.newAppDataStream.flush();
            this.newAppDataStream.closeEntry();
            this.newAppDataStream.close();
        }
        if (this.newUserDataStream != null) {
            this.newUserDataStream.flush();
            this.newUserDataStream.closeEntry();
            this.newUserDataStream.close();
        }
    }

    protected boolean isModified() {
        return this.newAppData != null && this.newAppData.sessionFile.exists() || this.newUserData != null && this.newUserData.sessionFile.exists();
    }

    protected void finalize() throws Throwable {
        if (this.newAppDataStream != null) {
            this.newAppDataStream = null;
        }
        if (this.newAppDataStream != null) {
            this.newUserDataStream = null;
        }
        if (this.newAppData != null) {
            this.newAppData.eraseExistence();
            this.newAppData = null;
        }
        if (this.newUserData != null) {
            this.newUserData.eraseExistence();
            this.newUserData = null;
        }
        super.finalize();
    }
}

