/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client;

import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import uk.ac.vamsas.client.InvalidSessionUrnException;

public abstract class SessionUrn {
    protected URI urn;
    protected static final Hashtable TYPES = new Hashtable();

    protected SessionUrn() {
    }

    protected SessionUrn(String type, URL url) {
        if (!TYPES.containsKey(type.toLowerCase())) {
            throw new Error("Unknown " + this.getClass().getName() + " type '" + type + "' for URL '" + url + "'");
        }
        try {
            this.setURN(type + "://" + url.getPath());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new Error(e);
        }
    }

    protected SessionUrn(String type, URI uri) {
        if (!TYPES.containsKey(type.toLowerCase())) {
            throw new Error("Unknown " + this.getClass().getName() + " type '" + type + "' for URI '" + uri + "'");
        }
        try {
            this.setURN(type + "://" + uri.getRawPath());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new Error(e);
        }
    }

    public String getSessionUrn() {
        return this.urn.toString();
    }

    protected void setURN(String urnString) throws InvalidSessionUrnException {
        try {
            this.urn = URI.create(urnString);
        }
        catch (Exception e) {
            throw new InvalidSessionUrnException(e);
        }
    }
}

