/*
 * Decompiled with CFR 0.152.
 */
package org.robsite.jswingreader.model;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.TimeZone;
import javax.mail.internet.MailDateFormat;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.robsite.jswingreader.model.Channel;
import org.robsite.jswingreader.model.Item;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleRSSParser
extends DefaultHandler {
    private static final String CONTEXT_ITEM = "item";
    private static final String CONTEXT_TEXT = "text";
    private static final String DUBLIN_CORE_URI = "http://purl.org/dc/elements/1.1/";
    private Channel _channel;
    private final RSSTagContext _context = new RSSTagContext();
    private final Map _handlers = new HashMap();

    private SimpleRSSParser(Channel channel) {
        this._channel = channel != null ? channel : new Channel();
        this.registerDefaultHandlers();
    }

    public static Channel parse(String urlString) throws MalformedURLException, SAXException, ParserConfigurationException, IOException {
        return SimpleRSSParser.parse(urlString, null);
    }

    public static void parse(Channel channel) throws MalformedURLException, SAXException, ParserConfigurationException, IOException {
        SimpleRSSParser.parse(channel.getURL(), channel);
    }

    public static Channel parse(String urlString, Channel channel) throws MalformedURLException, SAXException, IOException, ParserConfigurationException {
        URL url;
        URLConnection conn;
        if (channel == null) {
            channel = new Channel();
        }
        if ((conn = (url = new URL(urlString)).openConnection()) instanceof HttpURLConnection) {
            HttpURLConnection connection = (HttpURLConnection)conn;
            if (channel.getHTTPLastModified() != null) {
                connection.setRequestProperty("If-Modified-Since", channel.getHTTPLastModified());
            }
            if (channel.getHTTPEtag() != null) {
                connection.setRequestProperty("If-None-Match", channel.getHTTPEtag());
            }
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 304) {
                connection.disconnect();
                return channel;
            }
            if (responseCode == 200) {
                String lastModified = connection.getHeaderField("Last-Modified");
                String etag = connection.getHeaderField("ETag");
                channel.setHTTPLastModified(lastModified);
                channel.setHTTPEtag(etag);
            } else {
                throw new IOException("Could not connect to " + urlString + ": " + responseCode + " " + connection.getResponseMessage());
            }
        }
        Channel result = null;
        result = SimpleRSSParser.parse(new InputSource(conn.getInputStream()), channel);
        result.setURL(urlString);
        result.setOpen(true);
        return result;
    }

    private static Channel parse(InputSource inputSource, Channel channel) throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        SimpleRSSParser handler = new SimpleRSSParser(channel);
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        reader.parse(inputSource);
        return handler.getChannel();
    }

    public Channel getChannel() {
        return this._channel;
    }

    private void registerHandler(String elementName, RSSTagHandler handler) {
        this._handlers.put(elementName, handler);
    }

    private RSSTagHandler lookupHandler(String elementName) {
        return (RSSTagHandler)this._handlers.get(elementName);
    }

    private void registerDefaultHandlers() {
        this.registerHandler(CONTEXT_ITEM, new RSSTagHandler(){

            public void handleStartElement(RSSTagContext context) {
                context.putValue(SimpleRSSParser.CONTEXT_ITEM, new Item());
            }

            public void handleEndElement(RSSTagContext context) {
                SimpleRSSParser.this._channel.addItem((Item)context.getValue(SimpleRSSParser.CONTEXT_ITEM), false);
                context.putValue(SimpleRSSParser.CONTEXT_ITEM, null);
            }
        });
        this.registerHandler("description", new RSSTagHandler(){

            public void handleEndElement(RSSTagContext context) {
                Item item = (Item)context.getValue(SimpleRSSParser.CONTEXT_ITEM);
                if (item == null) {
                    SimpleRSSParser.this._channel.setDescription(context.getText());
                } else {
                    item.setDescription(context.getText());
                }
            }
        });
        this.registerHandler("link", new RSSTagHandler(){

            public void handleEndElement(RSSTagContext context) {
                Item item = (Item)context.getValue(SimpleRSSParser.CONTEXT_ITEM);
                if (item == null) {
                    SimpleRSSParser.this._channel.setLink(context.getText());
                } else {
                    item.setLink(context.getText());
                }
            }
        });
        this.registerHandler("title", new RSSTagHandler(){

            public void handleEndElement(RSSTagContext context) {
                Item item = (Item)context.getValue(SimpleRSSParser.CONTEXT_ITEM);
                if (item == null && "channel".equals(context.getParentElement())) {
                    SimpleRSSParser.this._channel.setTitle(context.getText());
                } else if (item != null) {
                    item.setTitle(context.getText());
                }
            }
        });
        this.registerHandler("pubDate", new RSSTagHandler(){

            public void handleEndElement(RSSTagContext context) {
                Date d;
                Item item = (Item)context.getValue(SimpleRSSParser.CONTEXT_ITEM);
                if (item != null && (d = SimpleRSSParser.this.parseDate(context.getText())) != null) {
                    item.setPublishDate(d);
                }
            }
        });
        this.registerHandler("guid", new RSSTagHandler(){

            public void handleEndElement(RSSTagContext context) {
                Item item = (Item)context.getValue(SimpleRSSParser.CONTEXT_ITEM);
                if (item != null) {
                    item.setGuid(context.getText());
                }
            }
        });
        this.registerHandler("date", new RSSTagHandler(){

            public void handleEndElement(RSSTagContext context) {
                Date date;
                Item item = (Item)context.getValue(SimpleRSSParser.CONTEXT_ITEM);
                if (item != null && SimpleRSSParser.DUBLIN_CORE_URI.equals(context.getURI()) && (date = SimpleRSSParser.this.parseDate(SimpleRSSParser.this._context.getText())) != null) {
                    item.setPublishDate(date);
                }
            }
        });
    }

    private Date parseDate(String date) {
        Date d = this.parseRFC822Date(date);
        if (d == null) {
            d = this.parseISODate(date);
        }
        return d;
    }

    private Date parseISODate(String date) {
        try {
            String formatString = null;
            TimeZone timeZone = null;
            if (date.indexOf(84) == -1) {
                formatString = "yyyy-MM-dd";
            } else if (date.length() >= 7) {
                char tzChar = date.charAt(date.length() - 6);
                if (tzChar == 'Z') {
                    date = date.substring(0, date.length() - 6);
                } else if (tzChar == '+' || tzChar == '-') {
                    String tzId = "GMT" + date.substring(date.length() - 6);
                    timeZone = TimeZone.getTimeZone(tzId);
                    date = date.substring(0, date.length() - 6);
                }
                formatString = date.indexOf(",") >= 0 ? "yyyy-MM-dd'T'HH:mm:ss,SSS" : "yyyy-MM-dd'T'HH:mm:ss";
            }
            if (formatString == null) {
                throw new Exception("Date does not parse");
            }
            SimpleDateFormat f = new SimpleDateFormat(formatString);
            if (timeZone == null) {
                timeZone = TimeZone.getTimeZone("UTC");
            }
            f.setTimeZone(timeZone);
            return f.parse(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Date parseRFC822Date(String date) {
        try {
            MailDateFormat mdf = new MailDateFormat();
            return mdf.parse(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        this._context._text = new StringBuffer();
        this._context.setURI(uri);
        this._context.setName(name);
        this._context.setQName(qName);
        this._context.setAttributes(atts);
        String handlerName = name != null && name.length() > 0 ? name : qName;
        RSSTagHandler handler = this.lookupHandler(handlerName);
        if (handler != null) {
            handler.handleStartElement(this._context);
        }
        this._context.pushPathElement(handlerName);
    }

    public void endElement(String uri, String name, String qName) {
        String handlerName = name != null && name.length() > 0 ? name : qName;
        this._context.setURI(uri);
        this._context.setName(name);
        this._context.setQName(qName);
        this._context.setAttributes(null);
        RSSTagHandler handler = this.lookupHandler(handlerName);
        this._context.popPathElement();
        if (handler != null) {
            handler.handleEndElement(this._context);
        }
        this._context._text = null;
    }

    public void characters(char[] ch, int start, int length) {
        if (this._context._text != null) {
            this._context._text.append(new String(ch, start, length));
        }
    }

    public static void main(String[] args) {
        try {
            Channel channel = null;
            System.out.println("*** BEGIN OTN NEWS ***");
            channel = SimpleRSSParser.parse("http://www.orablogs.com/duffblog/index.xml");
            System.out.println(channel.dumpString());
            System.out.println("*** END OTN NEWS ***");
            System.out.println("");
            System.out.println("");
            System.out.println("*** BEGIN ***");
            channel = SimpleRSSParser.parse("http://radio.weblogs.com/0129487/rss.xml");
            System.out.println(channel.dumpString());
            System.out.println("*** END ROBSITE.ORG NEWS ***");
            System.out.println("");
            System.out.println("");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class RSSTagContext {
        private Map _contextValues = new HashMap();
        private Attributes _attributes;
        private String _uri;
        private String _name;
        private String _qname;
        private StringBuffer _text;
        private Stack _elementPath = new Stack();

        private RSSTagContext() {
        }

        public String getPath() {
            StringBuffer pathBuffer = new StringBuffer();
            ArrayList path = new ArrayList(this._elementPath);
            pathBuffer.append("/");
            Iterator i = path.iterator();
            while (i.hasNext()) {
                pathBuffer.append(String.valueOf(i.next()));
                pathBuffer.append("/");
            }
            return pathBuffer.toString();
        }

        public String getParentElement() {
            if (!this._elementPath.isEmpty()) {
                return (String)this._elementPath.peek();
            }
            return "";
        }

        public void pushPathElement(String name) {
            this._elementPath.push(name);
        }

        public void popPathElement() {
            this._elementPath.pop();
        }

        public String getText() {
            if (this._text == null) {
                return null;
            }
            return this._text.toString();
        }

        public void setAttributes(Attributes attributes) {
            this._attributes = attributes;
        }

        public Attributes getAttributes() {
            return this._attributes;
        }

        public void setURI(String uri) {
            this._uri = uri;
        }

        public String getURI() {
            return this._uri;
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setQName(String qname) {
            this._qname = qname;
        }

        public String getQName() {
            return this._qname;
        }

        public Object getValue(Object key) {
            return this._contextValues.get(key);
        }

        public void putValue(Object key, Object value) {
            this._contextValues.put(key, value);
        }
    }

    private abstract class RSSTagHandler {
        private RSSTagHandler() {
        }

        public void handleStartElement(RSSTagContext context) {
        }

        public void handleEndElement(RSSTagContext context) {
        }
    }
}

