/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.dbsources;

import com.stevesoft.pat.Regex;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.schemes.ResidueProperties;
import jalview.util.HttpUtils;
import jalview.util.StringUtils;
import jalview.ws.seqfetcher.DbSourceProxyImpl;
import jalview.xml.binding.uniprot.DbReferenceType;
import jalview.xml.binding.uniprot.Entry;
import jalview.xml.binding.uniprot.FeatureType;
import jalview.xml.binding.uniprot.LocationType;
import jalview.xml.binding.uniprot.PositionType;
import jalview.xml.binding.uniprot.PropertyType;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class Uniprot
extends DbSourceProxyImpl {
    private static final String DEFAULT_UNIPROT_DOMAIN = "https://rest.uniprot.org";
    private static final String BAR_DELIMITER = "|";

    private String getDomain() {
        return Cache.getDefault("UNIPROT_DOMAIN", DEFAULT_UNIPROT_DOMAIN);
    }

    @Override
    public String getAccessionSeparator() {
        return null;
    }

    @Override
    public Regex getAccessionValidator() {
        return new Regex("([A-Z]+[0-9]+[A-Z0-9]+|[A-Z0-9]+_[A-Z0-9]+)");
    }

    @Override
    public String getDbSource() {
        return "UNIPROT";
    }

    @Override
    public String getDbVersion() {
        return "0";
    }

    @Override
    public AlignmentI getSequenceRecords(String queries) throws Exception {
        this.startQuery();
        try {
            InputStream istr;
            List<Entry> entries;
            queries = queries.toUpperCase(Locale.ROOT).replaceAll("(UNIPROT\\|?|UNIPROT_|UNIREF\\d+_|UNIREF\\d+\\|?)", "");
            Alignment al = null;
            String downloadstring = this.getDomain() + "/uniprotkb/" + queries + ".xml";
            URL url = new URL(downloadstring);
            HttpURLConnection urlconn = (HttpURLConnection)HttpUtils.openConnection(url);
            if (urlconn.getResponseCode() == 200 && (entries = this.getUniprotEntries(istr = urlconn.getInputStream())) != null) {
                ArrayList<SequenceI> seqs = new ArrayList<SequenceI>();
                for (Entry entry : entries) {
                    seqs.add(this.uniprotEntryToSequence(entry));
                }
                al = new Alignment(seqs.toArray(new SequenceI[seqs.size()]));
            }
            this.stopQuery();
            Alignment alignment = al;
            return alignment;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.stopQuery();
        }
    }

    SequenceI uniprotEntryToSequence(Entry entry) {
        String id = Uniprot.getUniprotEntryId(entry);
        String seqString = entry.getSequence().getValue().replaceAll("\\s*", "");
        Sequence sequence = new Sequence(id, seqString);
        sequence.setDescription(Uniprot.getUniprotEntryDescription(entry));
        String uniprotRecordVersion = "" + entry.getVersion();
        String dbVersion = this.getDbVersion();
        ArrayList<DBRefEntry> dbRefs = new ArrayList<DBRefEntry>();
        boolean canonical = true;
        for (String accessionId : entry.getAccession()) {
            DBRefEntry dbRef = new DBRefEntry("UNIPROT", uniprotRecordVersion, accessionId, null, canonical);
            canonical = false;
            dbRefs.add(dbRef);
        }
        Vector<PDBEntry> pdbRefs = new Vector<PDBEntry>();
        for (DbReferenceType dbref : entry.getDbReference()) {
            String cdsId;
            String type = dbref.getType();
            DBRefEntry dbr = new DBRefEntry(type, "UNIPROT:" + dbVersion, dbref.getId());
            dbRefs.add(dbr);
            if ("PDB".equals(type)) {
                pdbRefs.add(new PDBEntry(dbr));
            }
            if ("EMBL".equals(type) && (cdsId = Uniprot.getProperty(dbref.getProperty(), "protein sequence ID")) != null && cdsId.trim().length() > 0) {
                String[] vrs = cdsId.split("\\.");
                Object version = vrs.length > 1 ? vrs[1] : "UNIPROT:" + uniprotRecordVersion;
                dbr = new DBRefEntry("EMBLCDS", (String)version, vrs[0]);
                dbr.setCanonical(true);
                dbRefs.add(dbr);
            }
            if (type == null || !type.toLowerCase(Locale.ROOT).startsWith("ensembl")) continue;
            String[] vrs = dbref.getId().split("\\.");
            Object version = vrs.length > 1 ? vrs[1] : "UNIPROT:" + uniprotRecordVersion;
            dbr.setAccessionId(vrs[0]);
            dbr.setVersion((String)version);
            String cdsId2 = Uniprot.getProperty(dbref.getProperty(), "protein sequence ID");
            if (cdsId2 == null || cdsId2.trim().length() <= 0) continue;
            String[] cdsVrs = cdsId2.split("\\.");
            Object cdsVersion = cdsVrs.length > 1 ? cdsVrs[1] : "UNIPROT:" + uniprotRecordVersion;
            dbr = new DBRefEntry("ENSEMBL", "UNIPROT:" + (String)cdsVersion, cdsVrs[0]);
            dbRefs.add(dbr);
        }
        sequence.setPDBId(pdbRefs);
        if (entry.getFeature() != null) {
            for (FeatureType uf : entry.getFeature()) {
                LocationType location = uf.getLocation();
                int start = 0;
                int end = 0;
                String uncertain_start = null;
                String uncertain_end = null;
                String uncertain_pos = null;
                if (location.getPosition() != null) {
                    if (location.getPosition().getPosition() == null || "unknown".equals(location.getPosition().getStatus())) {
                        Console.warn("Ignoring single position feature with uncertain location " + uf.getType() + ":" + Uniprot.getDescription(uf));
                        uncertain_pos = location.getPosition().getStatus() == null ? "unknown" : location.getPosition().getStatus();
                    } else {
                        end = start = location.getPosition().getPosition().intValue();
                    }
                } else {
                    if (location.getBegin().getPosition() == null) {
                        Console.warn("Setting start position of feature with uncertain start to 1: " + uf.getType() + ":" + Uniprot.getDescription(uf));
                        start = sequence.getStart();
                        uncertain_start = location.getBegin().getStatus();
                    } else {
                        start = location.getBegin().getPosition().intValue();
                    }
                    if (location.getEnd().getPosition() == null) {
                        Console.warn("Setting start position of feature with uncertain start to 1: " + uf.getType() + ":" + Uniprot.getDescription(uf));
                        end = sequence.getEnd();
                        uncertain_end = location.getEnd().getStatus();
                    } else {
                        end = location.getEnd().getPosition().intValue();
                    }
                }
                SequenceFeature sf = new SequenceFeature(uf.getType(), Uniprot.getDescription(uf), start, end, "Uniprot");
                sf.setStatus(uf.getStatus());
                if (uncertain_end != null) {
                    sf.setValue("end_status", uncertain_end);
                }
                if (uncertain_start != null) {
                    sf.setValue("start_status", uncertain_start);
                }
                if (uncertain_pos != null) {
                    sf.setValue("pos_status", uncertain_pos);
                }
                sequence.addSequenceFeature(sf);
            }
        }
        for (DBRefEntry dbr : dbRefs) {
            sequence.addDBRef(dbr);
        }
        return sequence;
    }

    static String getDescription(FeatureType feature) {
        String description;
        String orig = feature.getOriginal();
        List<String> variants = feature.getVariation();
        StringBuilder sb = new StringBuilder();
        boolean asHtml = false;
        if (orig != null && !orig.isEmpty() && variants != null && !variants.isEmpty()) {
            int p = 0;
            for (String var : variants) {
                sb.append("p.");
                if (orig.length() < 4) {
                    int clen = orig.length();
                    for (int c = 0; c < clen; ++c) {
                        char origchar = orig.charAt(c);
                        String orig3 = ResidueProperties.aa2Triplet.get("" + origchar);
                        sb.append(orig3 == null ? Character.valueOf(origchar) : StringUtils.toSentenceCase(orig3));
                    }
                } else {
                    sb.append(orig);
                }
                LocationType location = feature.getLocation();
                PositionType start = location.getPosition() == null ? location.getBegin() : location.getPosition();
                sb.append(Integer.toString(start.getPosition().intValue()));
                if (var.length() < 4) {
                    int clen = var.length();
                    for (int c = 0; c < clen; ++c) {
                        char varchar = var.charAt(c);
                        String var3 = ResidueProperties.aa2Triplet.get("" + varchar);
                        sb.append((String)(var3 != null ? StringUtils.toSentenceCase(var3) : "" + varchar));
                    }
                } else {
                    sb.append(var);
                }
                if (++p != variants.size()) {
                    sb.append("<br/>&nbsp;&nbsp;");
                    asHtml = true;
                    continue;
                }
                sb.append(" ");
            }
        }
        if ((description = feature.getDescription()) != null) {
            sb.append(description);
        }
        if (asHtml) {
            sb.insert(0, "<html>");
            sb.append("</html>");
        }
        return sb.toString();
    }

    static String getProperty(List<PropertyType> properties, String key) {
        String value = null;
        if (properties != null) {
            for (PropertyType prop : properties) {
                if (!key.equals(prop.getType())) continue;
                value = prop.getValue();
                break;
            }
        }
        return value;
    }

    static String getUniprotEntryDescription(Entry entry) {
        String desc = "";
        if (entry.getProtein() != null && entry.getProtein().getRecommendedName() != null) {
            desc = entry.getProtein().getRecommendedName().getFullName().getValue();
        }
        return desc;
    }

    static String getUniprotEntryId(Entry entry) {
        StringBuilder name = new StringBuilder(32);
        for (String n : entry.getName()) {
            if (name.length() > 0) {
                name.append(BAR_DELIMITER);
            }
            name.append(n);
        }
        return name.toString();
    }

    @Override
    public boolean isValidReference(String accession) {
        return accession == null || accession.length() < 2 ? false : this.getAccessionValidator().search(accession);
    }

    @Override
    public String getTestQuery() {
        return "P00340";
    }

    @Override
    public String getDbName() {
        return "Uniprot";
    }

    @Override
    public int getTier() {
        return 0;
    }

    public List<Entry> getUniprotEntries(InputStream is) {
        List<Entry> entries = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"jalview.xml.binding.uniprot");
            XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(is);
            Unmarshaller um = jc.createUnmarshaller();
            JAXBElement uniprotElement = um.unmarshal(streamReader, jalview.xml.binding.uniprot.Uniprot.class);
            jalview.xml.binding.uniprot.Uniprot uniprot = (jalview.xml.binding.uniprot.Uniprot)uniprotElement.getValue();
            if (uniprot != null && !uniprot.getEntry().isEmpty()) {
                entries = uniprot.getEntry();
            }
        }
        catch (JAXBException | FactoryConfigurationError | XMLStreamException e) {
            if (e instanceof UnmarshalException && e.getCause() != null && e.getCause() instanceof XMLStreamException && e.getCause().getMessage().contains("[row,col]:[1,1]")) {
                return null;
            }
            e.printStackTrace();
        }
        return entries;
    }
}

