/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.bin.Console;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.util.Comparison;
import jalview.util.Format;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;

public class MSFfile
extends AlignFile {
    public MSFfile() {
    }

    public MSFfile(String inFile, DataSourceType type) throws IOException {
        super(inFile, type);
    }

    public MSFfile(FileParse source) throws IOException {
        super(source);
    }

    @Override
    public void parse() throws IOException {
        boolean seqFlag = false;
        ArrayList<String> headers = new ArrayList<String>();
        Hashtable<String, StringBuilder> seqhash = new Hashtable<String, StringBuilder>();
        try {
            String line;
            while ((line = this.nextLine()) != null) {
                StringTokenizer str = new StringTokenizer(line);
                String key = null;
                while (str.hasMoreTokens()) {
                    StringBuilder tempseq;
                    String inStr = str.nextToken();
                    if (inStr.indexOf("Name:") != -1) {
                        key = str.nextToken();
                        headers.add(key);
                    }
                    if (inStr.indexOf("//") != -1) {
                        seqFlag = true;
                    }
                    if (inStr.indexOf("//") != -1 || !seqFlag) continue;
                    key = inStr;
                    if (seqhash.containsKey(key)) {
                        tempseq = (StringBuilder)seqhash.get(key);
                    } else {
                        tempseq = new StringBuilder(64);
                        seqhash.put(key, tempseq);
                    }
                    while (str.hasMoreTokens()) {
                        String sequenceBlock = str.nextToken();
                        tempseq.append(sequenceBlock);
                    }
                }
            }
        }
        catch (IOException e) {
            Console.errPrintln("Exception parsing MSFFile " + e);
            e.printStackTrace();
        }
        this.noSeqs = headers.size();
        for (int i = 0; i < headers.size(); ++i) {
            if (seqhash.get(headers.get(i)) != null) {
                String head = (String)headers.get(i);
                String seq = ((StringBuilder)seqhash.get(head)).toString();
                if (this.maxLength < head.length()) {
                    this.maxLength = head.length();
                }
                seq = seq.replace('~', '.');
                Sequence newSeq = this.parseId(head);
                newSeq.setSequence(seq);
                this.seqs.addElement(newSeq);
                continue;
            }
            Console.errPrintln("MSFFile Parser: Can't find sequence for " + (String)headers.get(i));
        }
    }

    public int checkSum(String seq) {
        int check = 0;
        String sequence = seq.toUpperCase(Locale.ROOT);
        for (int i = 0; i < sequence.length(); ++i) {
            try {
                char value = sequence.charAt(i);
                if (value == '\uffffffff') continue;
                check += (i % 57 + 1) * value;
                continue;
            }
            catch (Exception e) {
                Console.errPrintln("Exception during MSF Checksum calculation");
                e.printStackTrace();
            }
        }
        return check % 10000;
    }

    @Override
    public String print(SequenceI[] sqs, boolean jvSuffix) {
        int i;
        boolean is_NA = Comparison.isNucleotide(sqs);
        SequenceI[] s = new SequenceI[sqs.length];
        StringBuilder out = new StringBuilder(256);
        out.append("!!").append(is_NA ? "NA" : "AA").append("_MULTIPLE_ALIGNMENT 1.0");
        out.append(this.newline);
        out.append(this.newline);
        int max = 0;
        int maxid = 0;
        for (i = 0; i < sqs.length && sqs[i] != null; ++i) {
            int ii;
            String seqString = sqs[i].getSequenceAsString().replace('-', '.');
            StringBuilder sb = new StringBuilder(seqString);
            for (ii = 0; ii < sb.length() && sb.charAt(ii) == '.'; ++ii) {
                sb.setCharAt(ii, '~');
            }
            for (ii = sb.length() - 1; ii > 0 && sb.charAt(ii) == '.'; --ii) {
                sb.setCharAt(ii, '~');
            }
            s[i] = new Sequence(sqs[i].getName(), sb.toString(), sqs[i].getStart(), sqs[i].getEnd());
            if (sb.length() <= max) continue;
            max = sb.length();
        }
        Format maxLenpad = new Format("%" + new String("" + max).length() + "d");
        Format maxChkpad = new Format("%" + new String("1" + max).length() + "d");
        int bigChecksum = 0;
        int[] checksums = new int[s.length];
        for (i = 0; i < s.length; ++i) {
            checksums[i] = this.checkSum(s[i].getSequenceAsString());
            bigChecksum += checksums[i];
        }
        long maxNB = 0L;
        out.append("   MSF: " + s[0].getLength() + "   Type: " + (is_NA ? "N" : "P") + "    Check:  " + bigChecksum % 10000 + "   ..");
        out.append(this.newline);
        out.append(this.newline);
        out.append(this.newline);
        String[] nameBlock = new String[s.length];
        String[] idBlock = new String[s.length];
        for (i = 0; i < s.length && s[i] != null; ++i) {
            nameBlock[i] = new String("  Name: " + this.printId(s[i], jvSuffix) + " ");
            idBlock[i] = new String("Len: " + maxLenpad.form(s[i].getLength()) + "  Check: " + maxChkpad.form(checksums[i]) + "  Weight: 1.00" + this.newline);
            if (s[i].getName().length() > maxid) {
                maxid = s[i].getName().length();
            }
            if ((long)nameBlock[i].length() <= maxNB) continue;
            maxNB = nameBlock[i].length();
        }
        if (maxid < 10) {
            maxid = 10;
        }
        if (maxNB < 15L) {
            maxNB = 15L;
        }
        Format nbFormat = new Format("%-" + maxNB + "s");
        for (i = 0; i < s.length && s[i] != null; ++i) {
            out.append(nbFormat.form(nameBlock[i]) + idBlock[i]);
        }
        ++maxid;
        out.append(this.newline);
        out.append(this.newline);
        out.append("//");
        out.append(this.newline);
        out.append(this.newline);
        int len = 50;
        int nochunks = max / len + (max % len > 0 ? 1 : 0);
        for (i = 0; i < nochunks; ++i) {
            for (int j = 0; j < s.length && s[j] != null; ++j) {
                String name = this.printId(s[j], jvSuffix);
                out.append(new Format("%-" + maxid + "s").form(name + " "));
                for (int k = 0; k < 5; ++k) {
                    int start = i * 50 + k * 10;
                    int end = start + 10;
                    int length = s[j].getLength();
                    if (end < length && start < length) {
                        out.append(s[j].getSequence(start, end));
                        if (k < 4) {
                            out.append(" ");
                            continue;
                        }
                        out.append(this.newline);
                        continue;
                    }
                    if (start < length) {
                        out.append(s[j].getSequenceAsString().substring(start));
                        out.append(this.newline);
                        continue;
                    }
                    if (k != 0) continue;
                    out.append(this.newline);
                }
            }
            out.append(this.newline);
        }
        return out.toString();
    }
}

