/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.ext.ensembl.EnsemblSeqProxy;
import jalview.ext.ensembl.EnsemblSequenceFetcher;
import java.util.ArrayList;
import java.util.List;

public class EnsemblGenome
extends EnsemblSeqProxy {
    private static final EnsemblSequenceFetcher.EnsemblFeatureType[] FEATURES_TO_FETCH = new EnsemblSequenceFetcher.EnsemblFeatureType[]{EnsemblSequenceFetcher.EnsemblFeatureType.transcript, EnsemblSequenceFetcher.EnsemblFeatureType.exon, EnsemblSequenceFetcher.EnsemblFeatureType.cds, EnsemblSequenceFetcher.EnsemblFeatureType.variation};

    public EnsemblGenome() {
    }

    public EnsemblGenome(String d) {
        super(d);
    }

    @Override
    public String getDbName() {
        return "ENSEMBL (Genomic)";
    }

    @Override
    protected EnsemblSeqProxy.EnsemblSeqType getSourceEnsemblType() {
        return EnsemblSeqProxy.EnsemblSeqType.GENOMIC;
    }

    @Override
    protected EnsemblSequenceFetcher.EnsemblFeatureType[] getFeaturesToFetch() {
        return FEATURES_TO_FETCH;
    }

    @Override
    protected boolean retainFeature(SequenceFeature sf, String accessionId) {
        if (EnsemblGenome.isTranscript(sf.getType())) {
            return false;
        }
        return this.featureMayBelong(sf, accessionId);
    }

    @Override
    protected List<SequenceFeature> getIdentifyingFeatures(SequenceI seq, String accId) {
        ArrayList<SequenceFeature> result = new ArrayList<SequenceFeature>();
        List<SequenceFeature> sfs = seq.getFeatures().getFeaturesByOntology("transcript", "NMD_transcript_variant");
        for (SequenceFeature sf : sfs) {
            String id = (String)sf.getValue("id");
            if (!accId.equals(id)) continue;
            result.add(sf);
        }
        return result;
    }
}

