/*
 * Decompiled with CFR 0.152.
 */
package jalview.commands;

import jalview.commands.EditCommand;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.ContiguousI;
import jalview.datamodel.SequenceI;
import jalview.util.Comparison;
import java.util.List;

public class JustifyLeftOrRightCommand
extends EditCommand {
    public JustifyLeftOrRightCommand(String description, boolean left, List<SequenceI> seqs, int from, int to, AlignmentI al) {
        this.description = description;
        for (SequenceI seq : seqs) {
            char[] range;
            ContiguousI cont = seq.findPositions(from + 1, to + 1);
            if (cont == null || (range = seq.getSequence(from, to + 1)) == null || range.length == 0) continue;
            int dsstart = seq.getDatasetSequence().getStart();
            char[] sqchar = seq.getDatasetSequence().getSequence(-dsstart + cont.getBegin(), -dsstart + cont.getEnd() + 1);
            char[] alseq = new char[to - from + 1];
            int sqstart = left ? 0 : alseq.length - sqchar.length;
            int gaps = alseq.length - sqchar.length;
            int gapstart = left ? sqchar.length : 0;
            char gc = al.getGapCharacter();
            for (int gp = 0; gp < gaps; ++gp) {
                alseq[gapstart + gp] = gc;
            }
            int insp = 0;
            for (int sqp = 0; sqp < alseq.length; ++sqp) {
                if (sqp >= range.length || Comparison.isGap(range[sqp])) continue;
                alseq[insp++ + sqstart] = range[sqp];
            }
            SequenceI[] sqa = new SequenceI[]{seq};
            this.addEdit(new EditCommand.Edit(this, EditCommand.Action.REPLACE, sqa, from, to + 1, al, new String(alseq)));
        }
        this.performEdit(0, null);
    }
}

