/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.datamodel.DBRefEntry;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class SequenceIdMatcher {
    private HashMap<SeqIdName, SequenceI> names = new HashMap();

    public SequenceIdMatcher(List<SequenceI> seqs) {
        this.addAll(seqs);
    }

    public void addAll(List<SequenceI> seqs) {
        for (SequenceI seq : seqs) {
            this.add(seq);
        }
    }

    public void add(SequenceI seq) {
        this.names.put(new SeqIdName(seq.getDisplayId(true)), seq);
        SequenceI dbseq = seq;
        while (dbseq.getDatasetSequence() != null) {
            dbseq = dbseq.getDatasetSequence();
        }
        Sequence.DBModList<DBRefEntry> dbr = dbseq.getDBRefs();
        if (dbr != null) {
            SeqIdName sid = null;
            int nr = dbr.size();
            for (int r = 0; r < nr; ++r) {
                sid = new SeqIdName(((DBRefEntry)dbr.get(r)).getAccessionId());
                if (this.names.containsKey(sid)) continue;
                this.names.put(sid, seq);
            }
        }
    }

    public SequenceIdMatcher(SequenceI[] sequences) {
        this(Arrays.asList(sequences));
    }

    private SequenceI pickbestMatch(SeqIdName candName, List<SequenceI> matches) {
        List<SequenceI> st = this.pickbestMatches(candName, matches);
        return st == null || st.size() == 0 ? null : st.get(0);
    }

    private List<SequenceI> pickbestMatches(SeqIdName candName, List<SequenceI> matches) {
        ArrayList<SequenceI> best = new ArrayList<SequenceI>();
        if (candName == null || matches == null || matches.size() == 0) {
            return null;
        }
        SequenceI match = matches.remove(0);
        best.add(match);
        this.names.put(new SeqIdName(match.getName()), match);
        int matchlen = match.getName().length();
        int namlen = candName.id.length();
        while (matches.size() > 0) {
            SequenceI cand = matches.remove(0);
            this.names.put(new SeqIdName(cand.getName()), cand);
            int candlen = cand.getName().length();
            int q = Math.abs(matchlen - namlen);
            int w = Math.abs(candlen - namlen);
            if (q > w && candlen > matchlen) {
                best.clear();
                match = cand;
                matchlen = candlen;
                best.add(match);
            }
            if (q != w || candlen != matchlen) continue;
            best.add(cand);
        }
        if (best.size() == 0) {
            return null;
        }
        return best;
    }

    public SequenceI findIdMatch(SequenceI seq) {
        SeqIdName nam = new SeqIdName(seq.getName());
        return this.findIdMatch(nam);
    }

    public SequenceI findIdMatch(String seqnam) {
        SeqIdName nam = new SeqIdName(seqnam);
        return this.findIdMatch(nam);
    }

    public SequenceI[] findAllIdMatches(String seqnam) {
        SeqIdName nam = new SeqIdName(seqnam);
        List<SequenceI> m = this.findAllIdMatches(nam);
        if (m != null) {
            return m.toArray(new SequenceI[m.size()]);
        }
        return null;
    }

    public SequenceI[] findIdMatch(SequenceI[] seqs) {
        SequenceI[] namedseqs = null;
        int i = 0;
        if (seqs.length > 0) {
            namedseqs = new SequenceI[seqs.length];
            do {
                SeqIdName nam;
                namedseqs[i] = this.names.containsKey(nam = new SeqIdName(seqs[i].getName())) ? this.findIdMatch(nam) : null;
            } while (++i < seqs.length);
        }
        return namedseqs;
    }

    private SequenceI findIdMatch(SeqIdName nam) {
        Vector<SequenceI> matches = new Vector<SequenceI>();
        while (this.names.containsKey(nam)) {
            matches.addElement(this.names.remove(nam));
        }
        return this.pickbestMatch(nam, matches);
    }

    private List<SequenceI> findAllIdMatches(SeqIdName nam) {
        ArrayList<SequenceI> matches = new ArrayList<SequenceI>();
        while (this.names.containsKey(nam)) {
            matches.add(this.names.remove(nam));
        }
        List<SequenceI> r = this.pickbestMatches(nam, matches);
        return r;
    }

    class SeqIdName {
        String id;
        private String WORD_SEP = "~. |#\\/<>!\"\u00a4$%^*)}[@',?_";

        SeqIdName(String s) {
            this.id = s != null ? s.toLowerCase(Locale.ROOT) : "";
        }

        public int hashCode() {
            return this.id.length() >= 4 ? this.id.substring(0, 4).hashCode() : this.id.hashCode();
        }

        public boolean equals(Object s) {
            if (s == null) {
                return false;
            }
            if (s instanceof SeqIdName) {
                return this.stringequals(((SeqIdName)s).id);
            }
            if (s instanceof String) {
                return this.stringequals(((String)s).toLowerCase(Locale.ROOT));
            }
            return false;
        }

        private boolean stringequals(String s) {
            if (this.id.length() > s.length()) {
                return this.id.startsWith(s) ? this.WORD_SEP.indexOf(this.id.charAt(s.length())) > -1 : false;
            }
            return s.startsWith(this.id) ? (s.equals(this.id) ? true : this.WORD_SEP.indexOf(s.charAt(this.id.length())) > -1) : false;
        }

        public String toString() {
            return this.id;
        }
    }
}

