/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import com.stevesoft.pat.Regex;
import jalview.analysis.AlignSeq;
import jalview.api.AlignViewportI;
import jalview.api.FeatureRenderer;
import jalview.api.FinderI;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SearchResultMatchI;
import jalview.datamodel.SearchResults;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.datamodel.features.SequenceFeaturesI;
import jalview.util.Comparison;
import jalview.util.MapList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class Finder
implements FinderI {
    private SearchResultsI searchResults;
    private List<SequenceI> idMatches;
    private AlignViewportI viewport;
    FeatureRenderer frm = null;
    private int sequenceIndex;
    private int residueIndex;
    private SequenceFeature lastFeature;
    private int lastFeatureSequenceIndex;
    private int searchedSequenceStartPosition;
    private MapList searchedSequenceMap;
    private String seqToSearch;

    public Finder(AlignViewportI av) {
        this.viewport = av;
        this.sequenceIndex = 0;
        this.residueIndex = -1;
    }

    @Override
    public void findAll(String theSearchString, boolean matchCase, boolean searchDescription, boolean searchFeatureDesc, boolean ignoreHidden) {
        this.lastFeature = null;
        this.lastFeatureSequenceIndex = 0;
        this.sequenceIndex = 0;
        this.residueIndex = -1;
        this.doFind(theSearchString, matchCase, searchDescription, searchFeatureDesc, true, ignoreHidden);
        this.sequenceIndex = 0;
        this.residueIndex = -1;
        this.lastFeature = null;
        this.lastFeatureSequenceIndex = 0;
    }

    @Override
    public void findNext(String theSearchString, boolean matchCase, boolean searchDescription, boolean searchFeatureDesc, boolean ignoreHidden) {
        this.doFind(theSearchString, matchCase, searchDescription, searchFeatureDesc, false, ignoreHidden);
        if (this.searchResults.isEmpty() && this.idMatches.isEmpty()) {
            this.sequenceIndex = 0;
            this.residueIndex = -1;
            this.lastFeature = null;
            this.lastFeatureSequenceIndex = 0;
        }
    }

    protected void doFind(String theSearchString, boolean matchCase, boolean searchDescription, boolean searchFeatureDesc, boolean findAll, boolean ignoreHidden) {
        this.searchResults = new SearchResults();
        this.idMatches = new ArrayList<SequenceI>();
        String searchString = matchCase ? theSearchString : theSearchString.toUpperCase(Locale.ROOT);
        Regex searchPattern = new Regex(searchString);
        searchPattern.setIgnoreCase(!matchCase);
        SequenceGroup selection = this.viewport.getSelectionGroup();
        if (selection != null && selection.getSize() < 1) {
            selection = null;
        }
        AlignmentI alignment = this.viewport.getAlignment();
        int end = alignment.getHeight();
        this.getSequence(ignoreHidden);
        boolean found = false;
        while ((!found || findAll) && this.sequenceIndex < end) {
            found = this.findNextMatch(searchString, searchPattern, searchDescription, searchFeatureDesc, ignoreHidden);
        }
    }

    private boolean getSequence(boolean ignoreHidden) {
        String ungapped;
        AlignmentI alignment = this.viewport.getAlignment();
        if (this.sequenceIndex >= alignment.getHeight()) {
            this.seqToSearch = "";
            return false;
        }
        SequenceI seq = alignment.getSequenceAt(this.sequenceIndex);
        SequenceGroup selection = this.viewport.getSelectionGroup();
        if (selection != null && !selection.contains(seq)) {
            if (!this.nextSequence(ignoreHidden)) {
                return false;
            }
            seq = alignment.getSequenceAt(this.sequenceIndex);
        }
        String seqString = null;
        if (ignoreHidden) {
            seqString = this.getVisibleSequence(seq);
            this.searchedSequenceStartPosition = 1;
        } else {
            int startCol = 0;
            int endCol = seq.getLength() - 1;
            this.searchedSequenceStartPosition = seq.getStart();
            if (selection != null) {
                startCol = selection.getStartRes();
                endCol = Math.min(endCol, selection.getEndRes());
                this.searchedSequenceStartPosition = seq.findPosition(startCol);
            }
            seqString = seq.getSequenceAsString(startCol, endCol + 1);
        }
        this.seqToSearch = ungapped = AlignSeq.extractGaps(Comparison.GapChars, seqString);
        return true;
    }

    private String getVisibleSequence(SequenceI seq) {
        int[] range;
        int seqStartCol = seq.findIndex(seq.getStart()) - 1;
        int seqEndCol = seq.findIndex(seq.getStart() + seq.getLength() - 1) - 1;
        Iterator<int[]> visibleColumns = this.viewport.getViewAsVisibleContigs(true);
        StringBuilder visibleSeq = new StringBuilder(seqEndCol - seqStartCol);
        ArrayList<int[]> fromRanges = new ArrayList<int[]>();
        while (visibleColumns.hasNext() && (range = visibleColumns.next())[0] <= seqEndCol) {
            if (range[1] < seqStartCol) continue;
            String subseq = seq.getSequenceAsString(range[0], range[1] + 1);
            String ungapped = AlignSeq.extractGaps(Comparison.GapChars, subseq);
            visibleSeq.append(ungapped);
            if (ungapped.isEmpty()) continue;
            int seqResFrom = seq.findPosition(range[0]);
            int seqResTo = seqResFrom + ungapped.length() - 1;
            fromRanges.add(new int[]{seqResFrom, seqResTo});
        }
        List<int[]> toRange = Arrays.asList(new int[][]{{1, visibleSeq.length()}});
        this.searchedSequenceMap = new MapList(fromRanges, toRange, 1, 1);
        return visibleSeq.toString();
    }

    private boolean nextSequence(boolean ignoreHidden) {
        ++this.sequenceIndex;
        this.residueIndex = -1;
        return this.getSequence(ignoreHidden);
    }

    protected boolean findNextMatch(String searchString, Regex searchPattern, boolean matchDescription, boolean matchFeatureDesc, boolean ignoreHidden) {
        if (this.residueIndex < 0 && this.doNonMotifSearches(searchString, searchPattern, matchDescription)) {
            return true;
        }
        int end = this.seqToSearch.length();
        while (this.residueIndex < end) {
            boolean matched = searchPattern.searchFrom(this.seqToSearch, this.residueIndex);
            if (matched) {
                if (!this.recordMatch(searchPattern, ignoreHidden)) continue;
                return true;
            }
            if (matchFeatureDesc) {
                matched = this.searchSequenceFeatures(this.residueIndex, searchPattern);
                if (matched) {
                    return true;
                }
                this.lastFeature = null;
            }
            this.residueIndex = Integer.MAX_VALUE;
        }
        this.nextSequence(ignoreHidden);
        return false;
    }

    protected boolean recordMatch(Regex searchPattern, boolean ignoreHidden) {
        SearchResultMatchI lastMatch;
        SequenceI seq = this.viewport.getAlignment().getSequenceAt(this.sequenceIndex);
        int offset = searchPattern.matchedFrom();
        int matchStartPosition = this.searchedSequenceStartPosition + offset;
        int matchEndPosition = matchStartPosition + searchPattern.charsMatched() - 1;
        this.residueIndex = searchPattern.matchedFrom() + 1;
        if (this.allHidden(seq, matchStartPosition, matchEndPosition)) {
            return false;
        }
        List<SearchResultMatchI> matches = this.searchResults.getResults();
        SearchResultMatchI searchResultMatchI = lastMatch = matches.isEmpty() ? null : matches.get(matches.size() - 1);
        if (lastMatch == null || !lastMatch.contains(seq, matchStartPosition, matchEndPosition)) {
            this.addMatch(seq, matchStartPosition, matchEndPosition, ignoreHidden);
            return true;
        }
        return false;
    }

    private void addMatch(SequenceI seq, int matchStartPosition, int matchEndPosition, boolean ignoreHidden) {
        if (!ignoreHidden) {
            this.searchResults.addResult(seq, matchStartPosition, matchEndPosition);
            return;
        }
        int[] truePositions = this.searchedSequenceMap.locateInFrom(matchStartPosition, matchEndPosition);
        this.searchResults.addResult(seq, truePositions);
    }

    private boolean allHidden(SequenceI seq, int fromPos, int toPos) {
        if (!this.viewport.hasHiddenColumns()) {
            return false;
        }
        for (int res = fromPos; res <= toPos; ++res) {
            if (!this.isVisible(seq, res)) continue;
            return false;
        }
        return true;
    }

    protected boolean doNonMotifSearches(String searchString, Regex searchPattern, boolean includeDescription) {
        SequenceI seq = this.viewport.getAlignment().getSequenceAt(this.sequenceIndex);
        this.residueIndex = 0;
        try {
            int res = Integer.parseInt(searchString);
            return this.searchForResidueNumber(seq, res);
        }
        catch (NumberFormatException numberFormatException) {
            if (this.searchSequenceName(seq, searchPattern)) {
                return true;
            }
            return includeDescription && this.searchSequenceDescription(seq, searchPattern);
        }
    }

    protected boolean searchSequenceFeatures(int from, Regex searchPattern) {
        if (this.lastFeatureSequenceIndex != this.sequenceIndex) {
            this.lastFeatureSequenceIndex = this.sequenceIndex;
            this.lastFeature = null;
        }
        SequenceI seq = this.viewport.getAlignment().getSequenceAt(this.sequenceIndex);
        SequenceFeaturesI sf = seq.getFeatures();
        List<SequenceFeature> allFeatures = null;
        allFeatures = this.frm != null ? this.frm.findFeaturesAtResidue(seq, seq.getStart(), seq.getEnd()) : sf.getAllFeatures(new String[0]);
        long fpos = 0L;
        for (SequenceFeature feature : allFeatures) {
            ++fpos;
            if (this.lastFeature != null) {
                if (this.lastFeature != feature) continue;
                this.lastFeature = null;
                continue;
            }
            if (!searchPattern.search(feature.type) && (feature.description == null || !searchPattern.search(feature.description))) continue;
            this.searchResults.addResult(seq, feature.getBegin(), feature.getEnd());
            this.lastFeature = feature;
            return true;
        }
        this.residueIndex = Integer.MAX_VALUE;
        this.lastFeature = null;
        return false;
    }

    protected boolean searchSequenceDescription(SequenceI seq, Regex searchPattern) {
        String desc = seq.getDescription();
        if (desc != null && searchPattern.search(desc) && !this.idMatches.contains(seq)) {
            this.idMatches.add(seq);
            return true;
        }
        return false;
    }

    protected boolean searchSequenceName(SequenceI seq, Regex searchPattern) {
        if (searchPattern.search(seq.getName()) && !this.idMatches.contains(seq)) {
            this.idMatches.add(seq);
            return true;
        }
        return false;
    }

    protected boolean searchForResidueNumber(SequenceI seq, int resNo) {
        if (seq.getStart() <= resNo && seq.getEnd() >= resNo && this.isVisible(seq, resNo)) {
            this.searchResults.addResult(seq, resNo, resNo);
            return true;
        }
        return false;
    }

    private boolean isVisible(SequenceI seq, int res) {
        if (!this.viewport.hasHiddenColumns()) {
            return true;
        }
        int col = seq.findIndex(res);
        return this.viewport.getAlignment().getHiddenColumns().isVisible(col - 1);
    }

    @Override
    public List<SequenceI> getIdMatches() {
        return this.idMatches;
    }

    @Override
    public SearchResultsI getSearchResults() {
        return this.searchResults;
    }

    @Override
    public void setFeatureRenderer(FeatureRenderer featureRenderer) {
        this.frm = featureRenderer;
    }
}

