/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.engine.conf.RunnerConfigMarshaller;
import compbio.metadata.AllTestSuit;
import compbio.metadata.Option;
import compbio.metadata.Parameter;
import compbio.metadata.RunnerConfig;
import compbio.metadata.ValueConstrain;
import compbio.metadata.WrongParameterException;
import compbio.runner.msa.Mafft;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.xml.sax.SAXException;

public class OptionMarshallerTester {
    public static String test_input = AllTestSuit.TEST_DATA_PATH_ABSOLUTE + "MafftParameters.xml";
    public static String test_schema_output = "NextGenMafftOptionsSchema.xml";
    public static String test_output = "MafftOptions.xml.out";
    public static String reWrittenInput = AllTestSuit.OUTPUT_DIR_ABSOLUTE + "rewrittenMafftParams.xml";
    RunnerConfig<Mafft> rconfig = null;
    Option<Mafft> matrixParam = null;

    @BeforeMethod
    public void setup() {
        try {
            this.rconfig = new RunnerConfig();
            this.rconfig.setRunnerClassName(Mafft.class.getName());
            ArrayList prms = new ArrayList();
            Parameter p1 = new Parameter("Type", "Type of the sequence (PROTEIN or DNA)");
            p1.setFurtherDetails("http://www.compbio.dundee.ac.uk/users/pvtroshin/ws/Index.html");
            p1.addPossibleValues("PROTEIN", "DNA");
            p1.setOptionName("-TYPE");
            p1.setRequired(false);
            Option p2 = new Option("MATRIX", "Protein weight matrix");
            p2.setFurtherDetails("http://www.compbio.dundee.ac.uk/users/pvtroshin/ws/Index.html");
            p2.addOptionNames("-jtree");
            p2.addOptionNames("-jfasta");
            p2.setRequired(false);
            Parameter p3 = new Parameter("MATRIX2", "Protein weight matrix");
            p3.setFurtherDetails("http://www.compbio.dundee.ac.uk/users/pvtroshin/ws/Index.html");
            p3.addPossibleValues("BLOSUM", "PAM", "GONNET", "ID");
            p3.setOptionName("-MATRIX");
            p3.setRequired(true);
            p3.setDefaultValue("id");
            ValueConstrain vc = new ValueConstrain();
            vc.setType(ValueConstrain.Type.Float);
            vc.setMin("-10.12");
            vc.setMax("0");
            p3.setValidValue(vc);
            prms.add(p1);
            prms.add(p2);
            prms.add(p3);
            this.matrixParam = p2;
            this.rconfig.setOptions(prms);
        }
        catch (WrongParameterException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
    }

    @Test(expectedExceptions={MarshalException.class})
    public void testMarshalling() throws JAXBException {
        File outfile = new File(AllTestSuit.OUTPUT_DIR_ABSOLUTE, test_output);
        try {
            RunnerConfigMarshaller rmarsh = new RunnerConfigMarshaller(RunnerConfig.class);
            rmarsh.writeAndValidate(this.rconfig, AllTestSuit.TEST_DATA_PATH_ABSOLUTE + File.separator + "RunnerConfigSchema.xsd", (OutputStream)new FileOutputStream(outfile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
        AssertJUnit.assertTrue((String)"Output file expected, but nothing found!", (boolean)outfile.exists());
    }

    @Test
    public void testUnMarshalling() {
        try {
            File input = new File(test_input);
            AssertJUnit.assertTrue((boolean)input.exists());
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{RunnerConfig.class});
            Unmarshaller um = ctx.createUnmarshaller();
            JAXBElement rconfig = um.unmarshal((Source)new StreamSource(input), RunnerConfig.class);
            RunnerConfig runner = (RunnerConfig)rconfig.getValue();
            AssertJUnit.assertNotNull((Object)runner);
            System.out.println(runner);
            AssertJUnit.assertFalse((boolean)runner.options.isEmpty());
            AssertJUnit.assertFalse((boolean)runner.parameters.isEmpty());
            AssertJUnit.assertEquals((int)7, (int)runner.options.size());
            AssertJUnit.assertEquals((int)8, (int)runner.parameters.size());
            Option stypeOption = runner.getArgument("Sequence type");
            System.out.println(stypeOption);
            AssertJUnit.assertNotNull(stypeOption);
            AssertJUnit.assertFalse((boolean)stypeOption.isRequired);
            AssertJUnit.assertEquals((String)"--auto", (String)stypeOption.defaultValue);
            AssertJUnit.assertEquals((int)2, (int)stypeOption.optionNames.size());
            AssertJUnit.assertEquals((String)" ", (String)runner.getPrmSeparator());
            Option guidetrOption = runner.getArgument("Guide tree rebuild");
            Parameter guidetr = (Parameter)guidetrOption;
            ValueConstrain constraint = guidetr.getValidValue();
            AssertJUnit.assertEquals((String)"Integer", (String)constraint.type.toString());
            AssertJUnit.assertEquals((Object)1, (Object)constraint.getMin());
            AssertJUnit.assertEquals((Object)100, (Object)constraint.getMax());
            RunnerConfigMarshaller rmarsh = new RunnerConfigMarshaller(RunnerConfig.class);
            rmarsh.write((Object)rconfig, (OutputStream)new FileOutputStream(new File(reWrittenInput)));
            RunnerConfig rc = (RunnerConfig)rmarsh.readAndValidate((InputStream)new FileInputStream(new File(reWrittenInput)), RunnerConfig.class);
            AssertJUnit.assertEquals((Object)runner, (Object)rc);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
    }
}

