/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.metadata.Limit;
import compbio.metadata.Preset;
import compbio.metadata.PresetManager;
import compbio.util.Util;
import java.util.List;
import javax.xml.bind.ValidationException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="limits")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LimitsManager<T> {
    String runnerClassName;
    List<Limit<T>> limit;

    public List<Limit<T>> getLimits() {
        return this.limit;
    }

    public String toString() {
        String value = "";
        if (null != this.limit) {
            for (Limit<T> lim : this.limit) {
                value = value + lim.toString();
            }
        }
        return value;
    }

    public Limit<T> getLimitByName(String presetName) {
        if (this.limit == null) {
            return null;
        }
        if (Util.isEmpty(presetName)) {
            return this.getDefaultLimit();
        }
        for (Limit<T> lim : this.limit) {
            String preset = lim.getPreset();
            if (preset == null || !preset.equalsIgnoreCase(presetName)) continue;
            return lim;
        }
        return null;
    }

    public Limit<T> getDefaultLimit() {
        for (Limit<T> lim : this.limit) {
            if (!lim.isDefault) continue;
            return lim;
        }
        return null;
    }

    public void validate(PresetManager<T> presets) throws ValidationException {
        int defaults = 0;
        for (Limit<T> lim : this.limit) {
            if (!lim.isDefault) continue;
            ++defaults;
        }
        if (defaults == 0) {
            throw new ValidationException("Default limit is not set!");
        }
        if (defaults > 1) {
            throw new ValidationException("Default limit is set more than once!");
        }
        if (presets != null) {
            for (Limit<T> lim : this.limit) {
                Preset<T> preset;
                lim.validate();
                String presetName = lim.getPreset();
                if (presetName == null || presetName.equals("# LocalEngineExecutionLimit #") || (preset = presets.getPresetByName(presetName)) != null) continue;
                throw new ValidationException("Preset " + presetName + " is not found!");
            }
        }
    }
}

