/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io;

import java.util.List;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.io.template.SequenceCreatorInterface;
import org.biojava.nbio.core.sequence.loader.ArrayListProxySequenceReader;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.ProxySequenceReader;

public class ProteinSequenceCreator
implements SequenceCreatorInterface<AminoAcidCompound> {
    private CompoundSet<AminoAcidCompound> compoundSet;

    public ProteinSequenceCreator(CompoundSet<AminoAcidCompound> compoundSet) {
        this.compoundSet = compoundSet;
    }

    @Override
    public AbstractSequence<AminoAcidCompound> getSequence(String sequence, long index) throws CompoundNotFoundException {
        return new ProteinSequence(sequence, this.compoundSet);
    }

    @Override
    public AbstractSequence<AminoAcidCompound> getSequence(List<AminoAcidCompound> list) {
        ArrayListProxySequenceReader<AminoAcidCompound> store = new ArrayListProxySequenceReader<AminoAcidCompound>();
        store.setCompoundSet(this.compoundSet);
        store.setContents(list);
        return new ProteinSequence(store);
    }

    @Override
    public AbstractSequence<AminoAcidCompound> getSequence(ProxySequenceReader<AminoAcidCompound> proxyLoader, long index) {
        return new ProteinSequence(proxyLoader, this.compoundSet);
    }
}

