/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import fr.orsay.lri.varna.utils.XMLUtils;
import java.awt.Color;
import java.io.Serializable;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ModeleBackboneElement
implements Serializable {
    private static final long serialVersionUID = -614968737102943216L;
    private BackboneType _type;
    private Color _color = null;
    private int _index;
    public static String XML_ELEMENT_NAME = "BackboneElement";
    public static String XML_VAR_INDEX_NAME = "index";
    public static String XML_VAR_TYPE_NAME = "type";
    public static String XML_VAR_COLOR_NAME = "color";

    public ModeleBackboneElement(int n, BackboneType backboneType) {
        this._index = n;
        if (backboneType == BackboneType.CUSTOM_COLOR) {
            throw new IllegalArgumentException("Error: Missing Color while constructing Backbone");
        }
        this._type = backboneType;
    }

    public ModeleBackboneElement(int n, Color color) {
        this._index = n;
        this._type = BackboneType.CUSTOM_COLOR;
        this._color = color;
    }

    public BackboneType getType() {
        return this._type;
    }

    public int getIndex() {
        return this._index;
    }

    public Color getColor() {
        return this._color;
    }

    public void toXML(TransformerHandler transformerHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", XML_VAR_INDEX_NAME, "CDATA", "" + this._index);
        attributesImpl.addAttribute("", "", XML_VAR_TYPE_NAME, "CDATA", "" + this._type.getLabel());
        if (this._type == BackboneType.CUSTOM_COLOR) {
            attributesImpl.addAttribute("", "", XML_VAR_COLOR_NAME, "CDATA", "" + XMLUtils.toHTMLNotation(this._color));
        }
        transformerHandler.startElement("", "", XML_ELEMENT_NAME, attributesImpl);
        transformerHandler.endElement("", "", XML_ELEMENT_NAME);
    }

    public static enum BackboneType {
        SOLID_TYPE("solid"),
        DISCONTINUOUS_TYPE("discontinuous"),
        MISSING_PART_TYPE("missing"),
        CUSTOM_COLOR("custom");

        private String label;

        private BackboneType(String string2) {
            this.label = string2;
        }

        public String getLabel() {
            return this.label;
        }

        public static BackboneType getType(String string) {
            BackboneType[] backboneTypeArray = BackboneType.values();
            for (int i = 0; i < backboneTypeArray.length; ++i) {
                if (!backboneTypeArray[i].equals(string)) continue;
                return backboneTypeArray[i];
            }
            return null;
        }
    }
}

