/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.controlers;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.exceptions.MappingException;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.rna.Mapping;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;

public class ControleurInterpolator
extends Thread {
    VARNAPanel _vpn;
    private int _numSteps = 25;
    private long _timeDelay = 15L;
    private boolean _running = false;
    Targets _d = new Targets();

    public ControleurInterpolator(VARNAPanel vARNAPanel) {
        this._vpn = vARNAPanel;
    }

    public synchronized void addTarget(RNA rNA, Mapping mapping) {
        this.addTarget(rNA, null, mapping);
    }

    public synchronized void addTarget(RNA rNA, VARNAConfig vARNAConfig, Mapping mapping) {
        this._d.add(new TargetsHolder(rNA, vARNAConfig, mapping));
    }

    public synchronized void addTarget(RNA rNA) {
        this.addTarget(rNA, null, Mapping.DefaultOutermostMapping(this._vpn.getRNA().get_listeBases().size(), rNA.get_listeBases().size()));
    }

    public boolean isInterpolationInProgress() {
        return this._running;
    }

    private Point2D.Double computeDestination(Point2D point2D, Point2D point2D2, Point2D point2D3, int n, int n2, Point2D point2D4, Point2D point2D5) {
        Point2D.Double double_ = new Point2D.Double((point2D.getX() + point2D4.getX()) / 2.0, (point2D.getY() + point2D4.getY()) / 2.0);
        Point2D.Double double_2 = new Point2D.Double((point2D2.getX() + point2D5.getX()) / 2.0, (point2D2.getY() + point2D5.getY()) / 2.0);
        Point2D.Double double_3 = new Point2D.Double(((double)(n2 - n) * double_.getX() + (double)n * double_2.getX()) / (double)n2, ((double)(n2 - n) * double_.getY() + (double)n * double_2.getY()) / (double)n2);
        Point2D.Double double_4 = new Point2D.Double(double_3.getX() - point2D3.getX(), double_3.getY() - point2D3.getY());
        Point2D.Double double_5 = new Point2D.Double(point2D3.getX() + 2.0 * double_4.getX(), point2D3.getY() + 2.0 * double_4.getY());
        return double_5;
    }

    private Vector<Vector<Integer>> clusterIndices(int n, int[] nArray) throws MappingException {
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = i;
        }
        return this.clusterIndices(nArray2, nArray);
    }

    private Vector<Vector<Integer>> clusterIndices(int[] nArray, int[] nArray2) throws MappingException {
        int n;
        int n2;
        if (nArray2.length == 0 || nArray.length == 0) {
            throw new MappingException("Mapping Error: Cannot cluster indices in an empty mapping");
        }
        Vector<Vector<Integer>> vector = new Vector<Vector<Integer>>();
        Arrays.sort(nArray);
        Arrays.sort(nArray2);
        int n3 = 0;
        Vector<Integer> vector2 = new Vector<Integer>();
        for (n2 = 0; n2 < nArray.length && n3 < nArray2.length; ++n2) {
            if (nArray[n2] == nArray2[n3]) {
                vector.add(vector2);
                vector2 = new Vector();
                vector2.add(nArray[n2]);
                vector.add(vector2);
                vector2 = new Vector();
                ++n3;
                continue;
            }
            vector2.add(nArray[n2]);
        }
        for (n2 = n = n2; n2 < nArray.length; ++n2) {
            vector2.add(nArray[n2]);
        }
        vector.add(vector2);
        return vector;
    }

    @Override
    public void run() {
        while (true) {
            TargetsHolder targetsHolder = this._d.get();
            this._running = true;
            try {
                this.nextTarget(targetsHolder.target, targetsHolder.conf, targetsHolder.mapping);
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace();
            }
            this._running = false;
        }
    }

    private static Point2D.Double computeCentroid(ArrayList<ModeleBase> arrayList, int[] nArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            Point2D.Double double_ = arrayList.get(n).getCoords();
            d += ((Point2D)double_).getX();
            d2 += ((Point2D)double_).getY();
        }
        return new Point2D.Double(d /= (double)nArray.length, d2 /= (double)nArray.length);
    }

    private static double minimizeRotateRMSD(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        MinimizeRMSD minimizeRMSD = new MinimizeRMSD(dArray, dArray2, dArray3, dArray4);
        return minimizeRMSD.computeOptimalTheta();
    }

    public static void moveNearOtherRNA(RNA rNA, RNA rNA2, Mapping mapping) {
        int[] nArray = mapping.getSourceElems();
        int[] nArray2 = mapping.getTargetElems();
        ArrayList<ModeleBase> arrayList = rNA.get_listeBases();
        ArrayList<ModeleBase> arrayList2 = rNA2.get_listeBases();
        int n = nArray.length;
        if (n < 2) {
            return;
        }
        Point2D.Double double_ = ControleurInterpolator.computeCentroid(arrayList, nArray);
        Point2D.Double double_2 = ControleurInterpolator.computeCentroid(arrayList2, nArray2);
        double[] dArray = new double[nArray.length];
        double[] dArray2 = new double[nArray.length];
        double[] dArray3 = new double[nArray2.length];
        double[] dArray4 = new double[nArray2.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            Point2D.Double double_3 = arrayList.get(n2).getCoords();
            dArray[i] = double_3.x - double_.x;
            dArray2[i] = double_3.y - double_.y;
            Point2D.Double double_4 = arrayList2.get(mapping.getPartner(n2)).getCoords();
            dArray3[i] = double_4.x - double_2.x;
            dArray4[i] = double_4.y - double_2.y;
        }
        double d = ControleurInterpolator.minimizeRotateRMSD(dArray, dArray2, dArray3, dArray4);
        rNA2.globalRotation(d * 180.0 / Math.PI);
    }

    public void nextTarget(RNA rNA, VARNAConfig vARNAConfig, Mapping mapping) {
        this.nextTarget(rNA, vARNAConfig, mapping, false);
    }

    public void nextTarget(RNA rNA, VARNAConfig vARNAConfig, Mapping mapping, boolean bl) {
        try {
            RNA rNA2;
            RNA rNA3 = rNA2 = this._vpn.getRNA();
            if (bl) {
                ControleurInterpolator.moveNearOtherRNA(rNA2, rNA, mapping);
            }
            if (rNA2.getSize() != 0 && rNA.getSize() != 0) {
                int n;
                int n2;
                Serializable serializable;
                int n3;
                int n4;
                Point2D.Double[] doubleArray;
                int n5;
                ArrayList<ModeleBase> arrayList = rNA3.get_listeBases();
                ArrayList<ModeleBase> arrayList2 = rNA.get_listeBases();
                Vector<Object> vector = new Vector();
                Vector<Object> vector2 = new Vector();
                vector = this.clusterIndices(arrayList.size(), mapping.getSourceElems());
                vector2 = this.clusterIndices(arrayList2.size(), mapping.getTargetElems());
                Point2D.Double[] doubleArray2 = new Point2D.Double[arrayList.size()];
                Point2D.Double[] doubleArray3 = new Point2D.Double[arrayList2.size()];
                for (n5 = 0; n5 < arrayList.size(); ++n5) {
                    doubleArray = arrayList.get(n5).getCoords();
                    doubleArray2[n5] = new Point2D.Double(doubleArray.getX(), doubleArray.getY());
                }
                for (n5 = 0; n5 < arrayList2.size(); ++n5) {
                    doubleArray = arrayList2.get(n5).getCoords();
                    doubleArray3[n5] = new Point2D.Double(doubleArray.getX(), doubleArray.getY());
                }
                Point2D.Double[] doubleArray4 = new Point2D.Double[doubleArray2.length];
                doubleArray = new Point2D.Double[doubleArray3.length];
                for (n4 = 0; n4 < doubleArray4.length; ++n4) {
                    if (mapping.getPartner(n4) == -1) continue;
                    Point2D.Double double_ = doubleArray3[mapping.getPartner(n4)];
                    doubleArray4[n4] = new Point2D.Double(((Point2D)double_).getX(), ((Point2D)double_).getY());
                }
                for (n4 = 0; n4 < vector.size(); n4 += 2) {
                    int n6;
                    if (n4 == 0) {
                        n6 = (Integer)((Vector)vector.get(1)).get(0);
                        n3 = (Integer)((Vector)vector.get(1)).get(0);
                    } else if (n4 == vector.size() - 1) {
                        n6 = (Integer)((Vector)vector.get(vector.size() - 2)).get(0);
                        n3 = (Integer)((Vector)vector.get(vector.size() - 2)).get(0);
                    } else {
                        n6 = (Integer)((Vector)vector.get(n4 - 1)).get(0);
                        n3 = (Integer)((Vector)vector.get(n4 + 1)).get(0);
                    }
                    serializable = (Vector)vector.get(n4);
                    for (n2 = 0; n2 < ((Vector)serializable).size(); ++n2) {
                        n = (Integer)((Vector)serializable).get(n2);
                        doubleArray4[n] = this.computeDestination(doubleArray2[n6], doubleArray2[n3], doubleArray2[n], n2 + 1, ((Vector)serializable).size() + 1, doubleArray4[n6], doubleArray4[n3]);
                    }
                }
                for (n4 = 0; n4 < doubleArray.length; ++n4) {
                    if (mapping.getAncestor(n4) == -1) continue;
                    Point2D.Double double_ = doubleArray2[mapping.getAncestor(n4)];
                    doubleArray[n4] = new Point2D.Double(((Point2D)double_).getX(), ((Point2D)double_).getY());
                }
                for (n4 = 0; n4 < vector2.size(); n4 += 2) {
                    int n7;
                    if (n4 == 0) {
                        n7 = (Integer)((Vector)vector2.get(1)).get(0);
                        n3 = (Integer)((Vector)vector2.get(1)).get(0);
                    } else if (n4 == vector2.size() - 1) {
                        n7 = (Integer)((Vector)vector2.get(vector2.size() - 2)).get(0);
                        n3 = (Integer)((Vector)vector2.get(vector2.size() - 2)).get(0);
                    } else {
                        n7 = (Integer)((Vector)vector2.get(n4 - 1)).get(0);
                        n3 = (Integer)((Vector)vector2.get(n4 + 1)).get(0);
                    }
                    serializable = (Vector)vector2.get(n4);
                    for (n2 = 0; n2 < ((Vector)serializable).size(); ++n2) {
                        n = (Integer)((Vector)serializable).get(n2);
                        doubleArray[n] = this.computeDestination(doubleArray3[n7], doubleArray3[n3], doubleArray3[n], n2 + 1, ((Vector)serializable).size() + 1, doubleArray[n7], doubleArray[n3]);
                    }
                }
                n4 = 1;
                for (int i = 0; i < this._numSteps; ++i) {
                    if (i == this._numSteps / 2) {
                        this._vpn.showRNA(rNA);
                        rNA3 = rNA;
                        arrayList = rNA3.get_listeBases();
                        n4 = 0;
                        if (vARNAConfig != null) {
                            this._vpn.setConfig(vARNAConfig);
                        }
                        for (n3 = 0; n3 < doubleArray2.length; ++n3) {
                            rNA2.setCoord(n3, doubleArray2[n3]);
                        }
                    }
                    for (n3 = 0; n3 < arrayList.size(); ++n3) {
                        Point2D.Double double_;
                        Point2D.Double double_2;
                        serializable = arrayList.get(n3);
                        if (n4 != 0) {
                            double_2 = doubleArray2[n3];
                            double_ = doubleArray4[n3];
                        } else {
                            double_2 = doubleArray[n3];
                            double_ = doubleArray3[n3];
                        }
                        ((ModeleBase)serializable).setCoords(new Point2D.Double(((double)(this._numSteps - 1 - i) * ((Point2D)double_2).getX() + (double)i * ((Point2D)double_).getX()) / (double)(this._numSteps - 1), ((double)(this._numSteps - 1 - i) * ((Point2D)double_2).getY() + (double)i * ((Point2D)double_).getY()) / (double)(this._numSteps - 1)));
                    }
                    this._vpn.repaint();
                    ControleurInterpolator.sleep(this._timeDelay);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (MappingException mappingException) {
            mappingException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._vpn.showRNA(rNA);
        this._vpn.repaint();
    }

    private class Targets {
        LinkedList<TargetsHolder> _d = new LinkedList();

        private Targets() {
        }

        public synchronized void add(TargetsHolder targetsHolder) {
            this._d.addLast(targetsHolder);
            this.notify();
        }

        public synchronized TargetsHolder get() {
            while (this._d.size() == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            TargetsHolder targetsHolder = this._d.getLast();
            this._d.clear();
            return targetsHolder;
        }
    }

    private class TargetsHolder {
        public RNA target;
        public VARNAConfig conf;
        public Mapping mapping;

        public TargetsHolder(RNA rNA, VARNAConfig vARNAConfig, Mapping mapping) {
            this.target = rNA;
            this.conf = vARNAConfig;
            this.mapping = mapping;
        }
    }

    private static class MinimizeRMSD {
        private double[] X1;
        private double[] X2;
        private double[] Y1;
        private double[] Y2;

        public MinimizeRMSD(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
            this.X1 = dArray;
            this.X2 = dArray3;
            this.Y1 = dArray2;
            this.Y2 = dArray4;
        }

        private double f(double d) {
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            int n = this.X1.length;
            double d4 = 0.0;
            for (int i = 0; i < n; ++i) {
                double d5 = this.X2[i] * d2 - this.Y2[i] * d3 - this.X1[i];
                double d6 = this.X2[i] * d3 + this.Y2[i] * d2 - this.Y1[i];
                d4 = d4 + d5 * d5 + d6 * d6;
            }
            return d4;
        }

        private double fprime(double d) {
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            int n = this.X1.length;
            double d4 = 0.0;
            for (int i = 0; i < n; ++i) {
                d4 = d4 + (this.X1[i] * this.X2[i] + this.Y1[i] * this.Y2[i]) * d3 + (this.X1[i] * this.Y2[i] - this.X2[i] * this.Y1[i]) * d2;
            }
            return d4;
        }

        private double fsecond(double d) {
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            int n = this.X1.length;
            double d4 = 0.0;
            for (int i = 0; i < n; ++i) {
                d4 = d4 + (this.X1[i] * this.X2[i] + this.Y1[i] * this.Y2[i]) * d2 + (this.X2[i] * this.Y1[i] - this.X1[i] * this.Y2[i]) * d3;
            }
            return d4;
        }

        public double computeOptimalTheta() {
            double d;
            double d2 = 0.0;
            int n = 0;
            while (true) {
                double d3;
                ++n;
                double d4 = this.fsecond(d2);
                if (d4 == 0.0) {
                    d3 = d2 + 1.0E-5 * (Math.random() - 0.5);
                } else {
                    d3 = d2 - this.fprime(d2) / this.fsecond(d2);
                    if (Math.abs(d3 - d2) < 1.0E-5) {
                        d = d3;
                        break;
                    }
                }
                if (n >= 100) {
                    d = d3;
                    break;
                }
                d2 = d3;
            }
            if (this.f(d + Math.PI) < this.f(d)) {
                d += Math.PI;
            }
            return d;
        }
    }
}

