/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna;

import fr.orsay.lri.varna.controlers.ControleurBlinkingThread;
import fr.orsay.lri.varna.controlers.ControleurClicMovement;
import fr.orsay.lri.varna.controlers.ControleurDraggedMolette;
import fr.orsay.lri.varna.controlers.ControleurInterpolator;
import fr.orsay.lri.varna.controlers.ControleurMolette;
import fr.orsay.lri.varna.controlers.ControleurVARNAPanelKeys;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionNAViewAlgorithm;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.interfaces.InterfaceVARNABasesListener;
import fr.orsay.lri.varna.interfaces.InterfaceVARNAListener;
import fr.orsay.lri.varna.interfaces.InterfaceVARNARNAListener;
import fr.orsay.lri.varna.interfaces.InterfaceVARNASelectionListener;
import fr.orsay.lri.varna.models.BaseList;
import fr.orsay.lri.varna.models.FullBackup;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.annotations.ChemProbAnnotation;
import fr.orsay.lri.varna.models.annotations.HighlightRegionAnnotation;
import fr.orsay.lri.varna.models.annotations.TextAnnotation;
import fr.orsay.lri.varna.models.export.SwingGraphics;
import fr.orsay.lri.varna.models.export.VueVARNAGraphics;
import fr.orsay.lri.varna.models.rna.Mapping;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBackbone;
import fr.orsay.lri.varna.models.rna.ModeleBackboneElement;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.ModeleBaseNucleotide;
import fr.orsay.lri.varna.models.rna.ModeleBasesComparison;
import fr.orsay.lri.varna.models.rna.ModeleColorMap;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.utils.VARNASessionParser;
import fr.orsay.lri.varna.views.VueMenu;
import fr.orsay.lri.varna.views.VueUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.undo.UndoManager;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class VARNAPanel
extends JPanel {
    private static final long serialVersionUID = 8194421570308956001L;
    private RNA _RNA = new RNA();
    private boolean _debug = false;
    private VARNAConfig _conf = new VARNAConfig();
    private ArrayList<InterfaceVARNAListener> _VARNAListeners = new ArrayList();
    private ArrayList<InterfaceVARNASelectionListener> _selectionListeners = new ArrayList();
    private ArrayList<InterfaceVARNARNAListener> _RNAListeners = new ArrayList();
    private ArrayList<InterfaceVARNABasesListener> _basesListeners = new ArrayList();
    UndoManager _manager;
    private Point2D.Double[] _realCoords = new Point2D.Double[0];
    private Point2D.Double[] _realCenters = new Point2D.Double[0];
    private double _scaleFactor = 1.0;
    private Point2D.Double _offsetPanel = new Point2D.Double();
    private Point2D.Double _offsetRNA = new Point2D.Double();
    private double _offX;
    private double _offY;
    private ControleurBlinkingThread _blink;
    private BaseList _selectedBases = new BaseList("selection");
    private ArrayList<ModeleBase> _backupSelection = new ArrayList();
    private Integer _nearestBase = null;
    private Point2D.Double _lastSelectedCoord = new Point2D.Double(0.0, 0.0);
    private Point2D.Double _linkOrigin = null;
    private Point2D.Double _linkDestination = null;
    private Rectangle _selectionRectangle = null;
    private boolean _highlightAnnotation = false;
    private int _titleHeight;
    private Dimension _border = new Dimension(0, 0);
    private boolean _drawBBox = false;
    private boolean _drawBorder = false;
    private Point _translation;
    private boolean _horsCadre;
    private boolean _premierAffichage;
    private ControleurInterpolator _interpolator;
    private VueMenu _popup = new VueMenu(this);
    private VueUI _UI = new VueUI(this);
    private TextAnnotation _selectedAnnotation;
    public static double DISTANCE_FACT = 2.0;
    Point2D.Double _target = new Point2D.Double(0.0, 0.0);
    Point2D.Double _target2 = new Point2D.Double(0.0, 0.0);
    public static String VARNA_SESSION_EXTENSION = "varna";
    public ModeleBase _hoveredBase = null;
    public static String XML_ELEMENT_NAME = "VARNASession";

    public VARNAPanel() {
        this.init();
        this.drawRNA();
    }

    public VARNAPanel(String string, String string2) throws ExceptionNonEqualLength {
        this(string, string2, 2);
    }

    public VARNAPanel(String string, String string2, int n) throws ExceptionNonEqualLength {
        this(string, string2, n, "");
    }

    public VARNAPanel(Reader reader) throws ExceptionNonEqualLength, ExceptionFileFormatOrSyntax {
        this(reader, 2);
    }

    public VARNAPanel(Reader reader, int n) throws ExceptionNonEqualLength, ExceptionFileFormatOrSyntax {
        this(reader, n, "");
    }

    public VARNAPanel(Reader reader, int n, String string) throws ExceptionNonEqualLength, ExceptionFileFormatOrSyntax {
        this.init();
        this.drawRNA(reader, n);
        this.setTitle(string);
    }

    public void setOriginLink(Point2D.Double double_) {
        this._linkOrigin = double_;
    }

    public void setDestinationLink(Point2D.Double double_) {
        this._linkDestination = double_;
    }

    public void removeLink() {
        this._linkOrigin = null;
        this._linkDestination = null;
    }

    public VARNAPanel(RNA rNA) {
        this.showRNA(rNA);
        this.init();
    }

    public VARNAPanel(String string, String string2, int n, String string3) throws ExceptionNonEqualLength {
        this.drawRNA(string, string2, n);
        this.init();
        this.setTitle(string3);
    }

    public VARNAPanel(String string, String string2, String string3, String string4, int n, String string5) {
        this._conf._comparisonMode = true;
        this.drawRNA(string, string2, string3, string4, n);
        this.init();
        this.setTitle(string5);
    }

    private void init() {
        this.setBackground(VARNAConfig.DEFAULT_BACKGROUND_COLOR);
        this._manager = new UndoManager();
        this._manager.setLimit(10000);
        this._UI.addUndoableEditListener(this._manager);
        this._blink = new ControleurBlinkingThread(this, 50L, 0.0, 1.0, 0.0, 0.2);
        this._blink.start();
        this._premierAffichage = true;
        this._translation = new Point(0, 0);
        this._horsCadre = false;
        this.setFont(this._conf._fontBasesGeneral);
        ControleurClicMovement controleurClicMovement = new ControleurClicMovement(this);
        this.addMouseListener(controleurClicMovement);
        this.addMouseMotionListener(controleurClicMovement);
        this.addMouseWheelListener(new ControleurMolette(this));
        ControleurDraggedMolette controleurDraggedMolette = new ControleurDraggedMolette(this);
        this.addMouseMotionListener(controleurDraggedMolette);
        this.addMouseListener(controleurDraggedMolette);
        ControleurVARNAPanelKeys controleurVARNAPanelKeys = new ControleurVARNAPanelKeys(this);
        this.addKeyListener(controleurVARNAPanelKeys);
        this.addFocusListener(controleurVARNAPanelKeys);
        this._interpolator = new ControleurInterpolator(this);
        this._interpolator.start();
    }

    public void undo() {
        if (this._manager.canUndo()) {
            this._manager.undo();
        }
    }

    public void redo() {
        if (this._manager.canRedo()) {
            this._manager.redo();
        }
    }

    public void setTitleFontStyle(int n) {
        this._conf._titleFont = this._conf._titleFont.deriveFont(n);
        this.updateTitleHeight();
    }

    public void setTitleFontSize(float f) {
        this._conf._titleFont = this._conf._titleFont.deriveFont(f);
        this.updateTitleHeight();
    }

    public void setTitleFontFamily(String string) {
        this._conf._titleFont = new Font(string, this._conf._titleFont.getStyle(), this._conf._titleFont.getSize());
        this.updateTitleHeight();
    }

    public void setTitleFontColor(Color color) {
        this._conf._titleColor = color;
        this.updateTitleHeight();
    }

    public void setBaseFontSize(Float f) {
        this._conf._fontBasesGeneral = this._conf._fontBasesGeneral.deriveFont(f.floatValue());
    }

    public void setNumbersFontSize(Float f) {
        this._conf._numbersFont = this._conf._numbersFont.deriveFont(f.floatValue());
    }

    public void setBaseFontStyle(int n) {
        this._conf._fontBasesGeneral = this._conf._fontBasesGeneral.deriveFont(n);
    }

    private void updateTitleHeight() {
        this._titleHeight = !this.getTitle().equals("") ? (int)((double)this._conf._titleFont.getSize() * 1.5) : 0;
        if (Math.abs(this.getZoom() - 1.0) < 0.02) {
            this._translation.y = (int)((double)(-this.getTitleHeight()) / 2.0);
        }
    }

    public void setTitle(String string) {
        this._RNA.setName(string);
        this.updateTitleHeight();
    }

    public void setNumPeriod(int n) {
        this._conf._numPeriod = n;
    }

    public int getNumPeriod() {
        return this._conf._numPeriod;
    }

    private void setScaleFactor(double d) {
        this._scaleFactor = d;
    }

    private double getScaleFactor() {
        return this._scaleFactor;
    }

    private void setAutoFit(boolean bl) {
        this._conf._autoFit = bl;
        this.repaint();
    }

    public void lockScrolling() {
        this.setAutoFit(false);
        this.setAutoCenter(false);
    }

    public void unlockScrolling() {
        this.setAutoFit(true);
        this.setAutoCenter(true);
    }

    private void drawStringOutline(VueVARNAGraphics vueVARNAGraphics, String string, double d, double d2, double d3) {
        Dimension dimension = vueVARNAGraphics.getStringDimension(string);
        vueVARNAGraphics.setColor(Color.GRAY);
        vueVARNAGraphics.setSelectionStroke();
        vueVARNAGraphics.drawRect((d -= (double)dimension.width / 2.0) - d3, (d2 += (double)dimension.height / 2.0) - (double)dimension.height - d3, (double)dimension.width + 2.0 * d3, (double)dimension.height + 2.0 * d3);
    }

    private void drawSymbol(VueVARNAGraphics vueVARNAGraphics, double d, double d2, double d3, double d4, double d5, boolean bl, ModeleBP.Edge edge) {
        Color color = vueVARNAGraphics.getColor();
        switch (edge) {
            case WC: {
                if (bl) {
                    vueVARNAGraphics.setColor(color);
                    vueVARNAGraphics.fillCircle(d - d5 / 2.0, d2 - d5 / 2.0, d5);
                    vueVARNAGraphics.drawCircle(d - d5 / 2.0, d2 - d5 / 2.0, d5);
                    break;
                }
                vueVARNAGraphics.setColor(Color.white);
                vueVARNAGraphics.fillCircle(d - d5 / 2.0, d2 - d5 / 2.0, d5);
                vueVARNAGraphics.setColor(color);
                vueVARNAGraphics.drawCircle(d - d5 / 2.0, d2 - d5 / 2.0, d5);
                break;
            }
            case HOOGSTEEN: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)(d - (d5 /= 1.05) * d3 / 2.0 - d5 * d4 / 2.0), (float)(d2 - d5 * d4 / 2.0 + d5 * d3 / 2.0));
                generalPath.lineTo((float)(d + d5 * d3 / 2.0 - d5 * d4 / 2.0), (float)(d2 + d5 * d4 / 2.0 + d5 * d3 / 2.0));
                generalPath.lineTo((float)(d + d5 * d3 / 2.0 + d5 * d4 / 2.0), (float)(d2 + d5 * d4 / 2.0 - d5 * d3 / 2.0));
                generalPath.lineTo((float)(d - d5 * d3 / 2.0 + d5 * d4 / 2.0), (float)(d2 - d5 * d4 / 2.0 - d5 * d3 / 2.0));
                generalPath.closePath();
                if (bl) {
                    vueVARNAGraphics.setColor(color);
                    vueVARNAGraphics.fill(generalPath);
                    vueVARNAGraphics.draw(generalPath);
                    break;
                }
                vueVARNAGraphics.setColor(Color.white);
                vueVARNAGraphics.fill(generalPath);
                vueVARNAGraphics.setColor(color);
                vueVARNAGraphics.draw(generalPath);
                break;
            }
            case SUGAR: {
                double d6 = d5 * d3 / 2.0;
                double d7 = d5 * d4 / 2.0;
                double d8 = d5 * d4 / 2.0;
                double d9 = -d5 * d3 / 2.0;
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)(d - d6 + d8), (float)(d2 - d7 + d9));
                generalPath.lineTo((float)(d + d6 + d8), (float)(d2 + d7 + d9));
                generalPath.lineTo((float)(d - d8), (float)(d2 - d9));
                generalPath.closePath();
                if (bl) {
                    vueVARNAGraphics.setColor(color);
                    vueVARNAGraphics.fill(generalPath);
                    vueVARNAGraphics.draw(generalPath);
                    break;
                }
                vueVARNAGraphics.setColor(Color.white);
                vueVARNAGraphics.fill(generalPath);
                vueVARNAGraphics.setColor(color);
                vueVARNAGraphics.draw(generalPath);
            }
        }
        vueVARNAGraphics.setColor(color);
    }

    private void drawBasePairArc(VueVARNAGraphics vueVARNAGraphics, int n, int n2, Point2D.Double double_, Point2D.Double double_2, double d, ModeleBP modeleBP, double d2) {
        double d3 = n2 - n == 1 ? this.getBPHeightIncrement() * 1.75 : this.getBPHeightIncrement();
        double d4 = double_2.x - double_.x;
        switch (this._conf._mainBPStyle) {
            case LW: {
                double d5 = (65.0 - (double)this._RNA.BASE_RADIUS) / 5.0 * d;
                if (modeleBP.isCanonical()) {
                    if (modeleBP.isCanonicalGC()) {
                        if (double_.x == double_2.x && double_.y == double_2.y) break;
                        vueVARNAGraphics.drawArc((double_2.x + double_.x) / 2.0, double_2.y - d * (double)this._RNA.BASE_RADIUS / 2.0, d4 - d * (double)this._RNA.BASE_RADIUS / 3.0, d4 * d3 - d * (double)this._RNA.BASE_RADIUS / 3.0, 0.0, 180.0);
                        vueVARNAGraphics.drawArc((double_2.x + double_.x) / 2.0, double_2.y - d * (double)this._RNA.BASE_RADIUS / 2.0, d4 + d * (double)this._RNA.BASE_RADIUS / 3.0, d4 * d3 + d * (double)this._RNA.BASE_RADIUS / 3.0, 0.0, 180.0);
                        break;
                    }
                    if (modeleBP.isCanonicalAU()) {
                        vueVARNAGraphics.drawArc((double_2.x + double_.x) / 2.0, double_2.y - d * (double)this._RNA.BASE_RADIUS / 2.0, d4, d4 * d3, 0.0, 180.0);
                        break;
                    }
                    if (modeleBP.isWobbleUG()) {
                        Point2D.Double double_3 = new Point2D.Double((double_2.x + double_.x) / 2.0, double_2.y - d4 * d3 / 2.0 - d * (double)this._RNA.BASE_RADIUS / 2.0);
                        vueVARNAGraphics.drawArc(double_3.x, double_2.y - d * (double)this._RNA.BASE_RADIUS / 2.0, d4, d4 * d3, 0.0, 180.0);
                        this.drawSymbol(vueVARNAGraphics, double_3.x, double_3.y, 1.0, 0.0, d5, false, ModeleBP.Edge.WC);
                        break;
                    }
                    Point2D.Double double_4 = new Point2D.Double((double_2.x + double_.x) / 2.0, double_2.y - d4 * d3 / 2.0 - d * (double)this._RNA.BASE_RADIUS / 2.0);
                    vueVARNAGraphics.drawArc(double_4.x, double_2.y - d * (double)this._RNA.BASE_RADIUS / 2.0, d4, d4 * d3, 0.0, 180.0);
                    this.drawSymbol(vueVARNAGraphics, double_4.x, double_4.y, 1.0, 0.0, d5, modeleBP.isCIS(), modeleBP.getEdgePartner5());
                    break;
                }
                ModeleBP.Edge edge = modeleBP.getEdgePartner5();
                ModeleBP.Edge edge2 = modeleBP.getEdgePartner3();
                Point2D.Double double_5 = new Point2D.Double((double_2.x + double_.x) / 2.0, double_2.y - d4 * d3 / 2.0 - d * (double)this._RNA.BASE_RADIUS / 2.0);
                vueVARNAGraphics.drawArc(double_5.x, double_2.y - d * (double)this._RNA.BASE_RADIUS / 2.0, d4, d4 * d3, 0.0, 180.0);
                if (edge == edge2) {
                    this.drawSymbol(vueVARNAGraphics, double_5.x, double_5.y, 1.0, 0.0, d5, false, modeleBP.getEdgePartner5());
                    break;
                }
                this.drawSymbol(vueVARNAGraphics, double_5.x - d * (double)this._RNA.BASE_RADIUS, double_5.y, 1.0, 0.0, d5, modeleBP.isCIS(), edge);
                this.drawSymbol(vueVARNAGraphics, double_5.x + d * (double)this._RNA.BASE_RADIUS, double_5.y, -1.0, 0.0, d5, modeleBP.isCIS(), edge2);
                break;
            }
            case LW_ALT: {
                double d6 = (65.0 - (double)this._RNA.BASE_RADIUS) / 5.0 * d;
                double d7 = DISTANCE_FACT * d;
                double_ = new Point2D.Double(double_.x, double_.y - (d7 + d2));
                double_2 = new Point2D.Double(double_2.x, double_2.y - (d7 + d2));
                if (modeleBP.isCanonical()) {
                    if (modeleBP.isCanonicalGC()) {
                        if (double_.x == double_2.x && double_.y == double_2.y) break;
                        vueVARNAGraphics.drawArc((double_2.x + double_.x) / 2.0, double_2.y - d * (double)this._RNA.BASE_RADIUS / 2.0, d4 - d * (double)this._RNA.BASE_RADIUS / 3.0, d4 * d3 - d * (double)this._RNA.BASE_RADIUS / 3.0, 0.0, 180.0);
                        vueVARNAGraphics.drawArc((double_2.x + double_.x) / 2.0, double_2.y - d * (double)this._RNA.BASE_RADIUS / 2.0, d4 + d * (double)this._RNA.BASE_RADIUS / 3.0, d4 * d3 + d * (double)this._RNA.BASE_RADIUS / 3.0, 0.0, 180.0);
                        break;
                    }
                    if (!modeleBP.isCanonicalAU()) break;
                    vueVARNAGraphics.drawArc((double_2.x + double_.x) / 2.0, double_2.y - d * (double)this._RNA.BASE_RADIUS / 2.0, d4, d4 * d3, 0.0, 180.0);
                    break;
                }
                ModeleBP.Edge edge = modeleBP.getEdgePartner5();
                ModeleBP.Edge edge3 = modeleBP.getEdgePartner3();
                Point2D.Double double_6 = new Point2D.Double((double_2.x + double_.x) / 2.0, double_2.y - d4 * d3 / 2.0 - d * (double)this._RNA.BASE_RADIUS / 2.0);
                vueVARNAGraphics.drawArc(double_6.x, double_2.y - d * (double)this._RNA.BASE_RADIUS / 2.0, d4, d4 * d3, 0.0, 180.0);
                this.drawSymbol(vueVARNAGraphics, double_.x, double_.y - d6 * 0.95, 1.0, 0.0, d6, modeleBP.isCIS(), edge);
                this.drawSymbol(vueVARNAGraphics, double_2.x, double_2.y - d6 * 0.95, -1.0, 0.0, d6, modeleBP.isCIS(), edge3);
                break;
            }
            default: {
                vueVARNAGraphics.drawArc((double_2.x + double_.x) / 2.0, double_2.y - d * (double)this._RNA.BASE_RADIUS / 2.0, d4, d4 * d3, 0.0, 180.0);
            }
        }
    }

    private void drawBasePair(VueVARNAGraphics vueVARNAGraphics, Point2D.Double double_, Point2D.Double double_2, ModeleBP modeleBP, double d, double d2) {
        double d3 = double_2.x - double_.x;
        double d4 = double_2.y - double_.y;
        double d5 = Math.sqrt((double_2.x - double_.x) * (double_2.x - double_.x) + (double_2.y - double_.y) * (double_2.y - double_.y));
        double d6 = -(d4 /= d5);
        double d7 = d3 /= d5;
        double_ = new Point2D.Double(double_.x + d * d3, double_.y + d * d4);
        double_2 = new Point2D.Double(double_2.x - d * d3, double_2.y - d * d4);
        switch (this._conf._mainBPStyle) {
            case LW: {
                double d8 = (65.0 - (double)this._RNA.BASE_RADIUS) / 5.0 * d2;
                if (modeleBP.isCanonical()) {
                    if (modeleBP.isCanonicalGC()) {
                        if (double_.x == double_2.x && double_.y == double_2.y) break;
                        vueVARNAGraphics.drawLine(double_.x + (d6 *= d2 * (double)this._RNA.BASE_RADIUS / 4.0), double_.y + (d7 *= d2 * (double)this._RNA.BASE_RADIUS / 4.0), double_2.x + d6, double_2.y + d7);
                        vueVARNAGraphics.drawLine(double_.x - d6, double_.y - d7, double_2.x - d6, double_2.y - d7);
                        break;
                    }
                    if (modeleBP.isCanonicalAU()) {
                        vueVARNAGraphics.drawLine(double_.x, double_.y, double_2.x, double_2.y);
                        break;
                    }
                    if (modeleBP.isWobbleUG()) {
                        double d9 = (double_2.x + double_.x) / 2.0;
                        double d10 = (double_2.y + double_.y) / 2.0;
                        vueVARNAGraphics.drawLine(double_.x, double_.y, double_2.x, double_2.y);
                        this.drawSymbol(vueVARNAGraphics, d9, d10, d6, d7, d8, false, ModeleBP.Edge.WC);
                        break;
                    }
                    double d11 = (double_2.x + double_.x) / 2.0;
                    double d12 = (double_2.y + double_.y) / 2.0;
                    vueVARNAGraphics.drawLine(double_.x, double_.y, double_2.x, double_2.y);
                    this.drawSymbol(vueVARNAGraphics, d11, d12, d6, d7, d8, modeleBP.isCIS(), modeleBP.getEdgePartner5());
                    break;
                }
                ModeleBP.Edge edge = modeleBP.getEdgePartner5();
                ModeleBP.Edge edge2 = modeleBP.getEdgePartner3();
                double d13 = (double_2.x + double_.x) / 2.0;
                double d14 = (double_2.y + double_.y) / 2.0;
                vueVARNAGraphics.drawLine(double_.x, double_.y, double_2.x, double_2.y);
                if (edge == edge2) {
                    this.drawSymbol(vueVARNAGraphics, d13, d14, d6, d7, d8, modeleBP.isCIS(), edge);
                    break;
                }
                double d15 = double_2.x - double_.x;
                double d16 = double_2.y - double_.y;
                this.drawSymbol(vueVARNAGraphics, d13 + (d15 /= 6.0), d14 + (d16 /= 6.0), -d6, -d7, d8, modeleBP.isCIS(), edge2);
                this.drawSymbol(vueVARNAGraphics, d13 - d15, d14 - d16, d6, d7, d8, modeleBP.isCIS(), edge);
                break;
            }
            case LW_ALT: {
                double d17 = (65.0 - (double)this._RNA.BASE_RADIUS) / 5.0 * d2;
                double d18 = DISTANCE_FACT * d2;
                Point2D.Double double_3 = new Point2D.Double(double_.x + (d18 + 0.5 * d) * d3, double_.y + (d18 + 0.5 * d) * d4);
                Point2D.Double double_4 = new Point2D.Double(double_2.x - (d18 + 0.5 * d) * d3, double_2.y - (d18 + 0.5 * d) * d4);
                if (modeleBP.isCanonical()) {
                    if (modeleBP.isCanonicalGC()) {
                        if (double_3.x == double_4.x && double_3.y == double_4.y) break;
                        vueVARNAGraphics.drawLine(double_3.x + (d6 *= d2 * (double)this._RNA.BASE_RADIUS / 4.0), double_3.y + (d7 *= d2 * (double)this._RNA.BASE_RADIUS / 4.0), double_4.x + d6, double_4.y + d7);
                        vueVARNAGraphics.drawLine(double_3.x - d6, double_3.y - d7, double_4.x - d6, double_4.y - d7);
                        break;
                    }
                    if (modeleBP.isCanonicalAU()) {
                        vueVARNAGraphics.drawLine(double_3.x, double_3.y, double_4.x, double_4.y);
                        break;
                    }
                    if (modeleBP.isWobbleUG()) {
                        double d19 = (double_4.x + double_3.x) / 2.0;
                        double d20 = (double_4.y + double_3.y) / 2.0;
                        vueVARNAGraphics.drawLine(double_3.x, double_3.y, double_4.x, double_4.y);
                        this.drawSymbol(vueVARNAGraphics, d19, d20, d6, d7, d17, false, ModeleBP.Edge.WC);
                        break;
                    }
                    double d21 = (double_4.x + double_3.x) / 2.0;
                    double d22 = (double_4.y + double_3.y) / 2.0;
                    vueVARNAGraphics.drawLine(double_3.x, double_3.y, double_4.x, double_4.y);
                    this.drawSymbol(vueVARNAGraphics, d21, d22, d6, d7, d17, modeleBP.isCIS(), modeleBP.getEdgePartner5());
                    break;
                }
                ModeleBP.Edge edge = modeleBP.getEdgePartner5();
                ModeleBP.Edge edge3 = modeleBP.getEdgePartner3();
                double d23 = (double_4.x + double_3.x) / 2.0;
                double d24 = (double_4.y + double_3.y) / 2.0;
                vueVARNAGraphics.drawLine(double_3.x, double_3.y, double_4.x, double_4.y);
                if (edge == edge3) {
                    this.drawSymbol(vueVARNAGraphics, d23, d24, d6, d7, d17, modeleBP.isCIS(), edge);
                    break;
                }
                double d25 = 0.4;
                this.drawSymbol(vueVARNAGraphics, double_4.x - d25 * d17 * d3, double_4.y - d25 * d17 * d4, -d6, -d7, d17, modeleBP.isCIS(), edge3);
                this.drawSymbol(vueVARNAGraphics, double_3.x + d25 * d17 * d3, double_3.y + d25 * d17 * d4, d6, d7, d17, modeleBP.isCIS(), edge);
                break;
            }
            case SIMPLE: {
                vueVARNAGraphics.drawLine(double_.x, double_.y, double_2.x, double_2.y);
                break;
            }
            case RNAVIZ: {
                double d26 = (double_.x + double_2.x) / 2.0;
                double d27 = (double_.y + double_2.y) / 2.0;
                double d28 = Math.max(4.0 * d2, 1.0);
                vueVARNAGraphics.fillCircle(d26 - d28, d27 - d28, 2.0 * d28);
                break;
            }
        }
    }

    private Color getHighlightedVersion(Color color, Color color2) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color2.getRed();
        int n5 = color2.getGreen();
        int n6 = color2.getBlue();
        double d = this._blink.getVal();
        int n7 = Math.max(0, Math.min((int)((double)n * d + (double)n4 * (1.0 - d)), 255));
        int n8 = Math.max(0, Math.min((int)((double)n2 * d + (double)n5 * (1.0 - d)), 255));
        int n9 = Math.max(0, Math.min((int)((double)n3 * d + (double)n6 * (1.0 - d)), 255));
        return new Color(n7, n8, n9);
    }

    private Color highlightFilter(int n, Color color, Color color2, Color color3, boolean bl) {
        if (this._selectedBases.contains(this._RNA.getBaseAt(n)) && bl) {
            return this.getHighlightedVersion(color2, color3);
        }
        return color;
    }

    private Point2D.Double computeExcentricUnitVector(int n, Point2D.Double[] doubleArray, Point2D.Double[] doubleArray2) {
        double d = doubleArray[n].distance(doubleArray2[n]);
        Point2D.Double double_ = new Point2D.Double((doubleArray[n].x - doubleArray2[n].x) / d, (doubleArray[n].y - doubleArray2[n].y) / d);
        if (n > 0 && n < doubleArray.length - 1) {
            Point2D.Double double_2 = doubleArray[n - 1];
            Point2D.Double double_3 = doubleArray[n];
            Point2D.Double double_4 = doubleArray[n + 1];
            double d2 = double_4.distance(double_3);
            Point2D.Double double_5 = new Point2D.Double((double_4.x - double_3.x) / d2, (double_4.y - double_3.y) / d2);
            Point2D.Double double_6 = new Point2D.Double(double_5.y, -double_5.x);
            double d3 = double_3.distance(double_2);
            Point2D.Double double_7 = new Point2D.Double((double_3.x - double_2.x) / d3, (double_3.y - double_2.y) / d3);
            Point2D.Double double_8 = new Point2D.Double(double_7.y, -double_7.x);
            Point2D.Double double_9 = new Point2D.Double((double_6.x + double_8.x) / 2.0, (double_6.y + double_8.y) / 2.0);
            double d4 = double_9.distance(new Point2D.Double(0.0, 0.0));
            double_9.x /= d4;
            double_9.y /= d4;
            if (double_.x * double_9.x + double_.y * double_9.y < 0.0) {
                double_9.x = -double_9.x;
                double_9.y = -double_9.y;
            }
            return double_9;
        }
        if ((n == 0 || n == doubleArray.length - 1) && doubleArray.length > 1) {
            int n2 = n == 0 ? 0 : doubleArray.length - 1;
            int n3 = n == 0 ? 1 : doubleArray.length - 2;
            double d5 = doubleArray[n2].distance(doubleArray[n3]);
            return new Point2D.Double((doubleArray[n2].x - doubleArray[n3].x) / d5, (doubleArray[n2].y - doubleArray[n3].y) / d5);
        }
        return double_;
    }

    private void drawBase(VueVARNAGraphics vueVARNAGraphics, int n, Point2D.Double[] doubleArray, Point2D.Double[] doubleArray2, double d, double d2, boolean bl) {
        String string;
        Serializable serializable;
        Point2D.Double double_ = doubleArray[n];
        ModeleBase modeleBase = this._RNA.get_listeBases().get(n);
        vueVARNAGraphics.setFont(this._conf._fontBasesGeneral);
        Color color = this.highlightFilter(n, this._RNA.getBaseInnerColor(n, this._conf), Color.white, this._RNA.getBaseInnerColor(n, this._conf), bl);
        Color color2 = this.highlightFilter(n, this._RNA.getBaseOuterColor(n, this._conf), this._RNA.getBaseOuterColor(n, this._conf), Color.white, bl);
        Color color3 = this.highlightFilter(n, this._RNA.getBaseNameColor(n, this._conf), this._RNA.getBaseNameColor(n, this._conf), Color.white, bl);
        if (RNA.whiteLabelPreferrable(color)) {
            color3 = Color.white;
        }
        if (modeleBase instanceof ModeleBaseNucleotide) {
            serializable = (ModeleBaseNucleotide)modeleBase;
            string = ((ModeleBaseNucleotide)serializable).getBase();
            if (this._hoveredBase == modeleBase && bl) {
                vueVARNAGraphics.setColor(this._conf._hoverColor);
                vueVARNAGraphics.fillCircle(double_.getX() - 1.5 * d, double_.getY() - 1.5 * d, 3.0 * d);
                vueVARNAGraphics.setColor(this._conf._hoverColor.darker());
                vueVARNAGraphics.drawCircle(double_.getX() - 1.5 * d, double_.getY() - 1.5 * d, 3.0 * d);
                vueVARNAGraphics.setPlainStroke();
            }
            if (this._conf._fillBases) {
                vueVARNAGraphics.setColor(color);
                vueVARNAGraphics.fillCircle(double_.getX() - d, double_.getY() - d, 2.0 * d);
            }
            if (this._conf._drawOutlineBases) {
                vueVARNAGraphics.setColor(color2);
                vueVARNAGraphics.setStrokeThickness(this._conf._baseThickness * d2);
                vueVARNAGraphics.drawCircle(double_.getX() - d, double_.getY() - d, 2.0 * d);
            }
            vueVARNAGraphics.setColor(color3);
            vueVARNAGraphics.drawStringCentered(String.valueOf(string), double_.getX(), double_.getY());
        } else if (modeleBase instanceof ModeleBasesComparison) {
            serializable = (ModeleBasesComparison)modeleBase;
            vueVARNAGraphics.setPlainStroke();
            vueVARNAGraphics.setStrokeThickness(this._conf._baseThickness * d2);
            vueVARNAGraphics.setColor(color);
            vueVARNAGraphics.fillRoundRect(double_.getX() - 1.5 * d, double_.getY() - d, 3.0 * d, 2.0 * d, 10.0 * d2, 10.0 * d2);
            vueVARNAGraphics.setColor(color2);
            vueVARNAGraphics.drawRoundRect(double_.getX() - 1.5 * d, double_.getY() - d, 3.0 * d, 2.0 * d, 10.0 * d2, 10.0 * d2);
            vueVARNAGraphics.drawLine(double_.getX(), double_.getY() + d - 1.0, double_.getX(), double_.getY() - d + 1.0);
            string = String.valueOf(((ModeleBasesComparison)serializable).getBase1());
            String string2 = String.valueOf(((ModeleBasesComparison)serializable).getBase2());
            vueVARNAGraphics.setColor(this.getRNA().get_listeBases().get(n).getStyleBase().get_base_name_color());
            vueVARNAGraphics.drawStringCentered(string, double_.getX() - 0.75 * d, double_.getY());
            vueVARNAGraphics.drawStringCentered(string2, double_.getX() + 0.75 * d, double_.getY());
        }
        if (this._RNA.isNumberDrawn(modeleBase, this.getNumPeriod())) {
            serializable = this.computeExcentricUnitVector(n, doubleArray, doubleArray2);
            vueVARNAGraphics.setColor(modeleBase.getStyleBase().get_base_number_color());
            vueVARNAGraphics.setFont(this._conf._numbersFont);
            double d3 = Math.min(0.5, this._conf._distNumbers);
            double d4 = Math.min(this._conf._distNumbers - 1.5, this._conf._distNumbers);
            vueVARNAGraphics.drawLine(double_.x + ((Point2D.Double)serializable).x * ((1.0 + d3) * d), double_.y + ((Point2D.Double)serializable).y * ((1.0 + d3) * d), double_.x + ((Point2D.Double)serializable).x * ((1.0 + d4) * d), double_.y + ((Point2D.Double)serializable).y * ((1.0 + d4) * d));
            vueVARNAGraphics.drawStringCentered(modeleBase.getLabel(), double_.x + ((Point2D.Double)serializable).x * ((1.0 + this._conf._distNumbers) * d), double_.y + ((Point2D.Double)serializable).y * ((1.0 + this._conf._distNumbers) * d));
        }
    }

    void drawChemProbAnnotation(VueVARNAGraphics vueVARNAGraphics, ChemProbAnnotation chemProbAnnotation, Point2D.Double double_, double d) {
        vueVARNAGraphics.setColor(chemProbAnnotation.getColor());
        vueVARNAGraphics.setStrokeThickness(RNA.CHEM_PROB_ARROW_THICKNESS * d * chemProbAnnotation.getIntensity());
        vueVARNAGraphics.setPlainStroke();
        Point2D.Double double_2 = chemProbAnnotation.getDirVector();
        Point2D.Double double_3 = chemProbAnnotation.getNormalVector();
        Point2D.Double double_4 = new Point2D.Double(double_.x + this._RNA.CHEM_PROB_DIST * d * double_2.x, double_.y + this._RNA.CHEM_PROB_DIST * d * double_2.y);
        Point2D.Double double_5 = new Point2D.Double(double_4.x + this._RNA.CHEM_PROB_BASE_LENGTH * chemProbAnnotation.getIntensity() * d * double_2.x, double_4.y + this._RNA.CHEM_PROB_BASE_LENGTH * chemProbAnnotation.getIntensity() * d * double_2.y);
        switch (chemProbAnnotation.getType()) {
            case ARROW: {
                Point2D.Double double_6 = new Point2D.Double(double_4.x + chemProbAnnotation.getIntensity() * d * (this._RNA.CHEM_PROB_ARROW_WIDTH * double_3.x + this._RNA.CHEM_PROB_ARROW_HEIGHT * double_2.x), double_4.y + chemProbAnnotation.getIntensity() * d * (this._RNA.CHEM_PROB_ARROW_WIDTH * double_3.y + this._RNA.CHEM_PROB_ARROW_HEIGHT * double_2.y));
                Point2D.Double double_7 = new Point2D.Double(double_4.x + chemProbAnnotation.getIntensity() * d * (-this._RNA.CHEM_PROB_ARROW_WIDTH * double_3.x + this._RNA.CHEM_PROB_ARROW_HEIGHT * double_2.x), double_4.y + chemProbAnnotation.getIntensity() * d * (-this._RNA.CHEM_PROB_ARROW_WIDTH * double_3.y + this._RNA.CHEM_PROB_ARROW_HEIGHT * double_2.y));
                vueVARNAGraphics.drawLine(double_4.x, double_4.y, double_5.x, double_5.y);
                vueVARNAGraphics.drawLine(double_4.x, double_4.y, double_6.x, double_6.y);
                vueVARNAGraphics.drawLine(double_4.x, double_4.y, double_7.x, double_7.y);
                break;
            }
            case PIN: {
                Point2D.Double double_8 = new Point2D.Double(double_5.x - chemProbAnnotation.getIntensity() * d * (this._RNA.CHEM_PROB_PIN_SEMIDIAG * double_2.x), double_5.y - chemProbAnnotation.getIntensity() * d * (this._RNA.CHEM_PROB_PIN_SEMIDIAG * double_2.y));
                Point2D.Double double_9 = new Point2D.Double(double_5.x - chemProbAnnotation.getIntensity() * d * (this._RNA.CHEM_PROB_PIN_SEMIDIAG * double_3.x), double_5.y - chemProbAnnotation.getIntensity() * d * (this._RNA.CHEM_PROB_PIN_SEMIDIAG * double_3.y));
                Point2D.Double double_10 = new Point2D.Double(double_5.x + chemProbAnnotation.getIntensity() * d * (this._RNA.CHEM_PROB_PIN_SEMIDIAG * double_2.x), double_5.y + chemProbAnnotation.getIntensity() * d * (this._RNA.CHEM_PROB_PIN_SEMIDIAG * double_2.y));
                Point2D.Double double_11 = new Point2D.Double(double_5.x + chemProbAnnotation.getIntensity() * d * (this._RNA.CHEM_PROB_PIN_SEMIDIAG * double_3.x), double_5.y + chemProbAnnotation.getIntensity() * d * (this._RNA.CHEM_PROB_PIN_SEMIDIAG * double_3.y));
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)double_8.x, (float)double_8.y);
                generalPath.lineTo((float)double_9.x, (float)double_9.y);
                generalPath.lineTo((float)double_10.x, (float)double_10.y);
                generalPath.lineTo((float)double_11.x, (float)double_11.y);
                generalPath.closePath();
                vueVARNAGraphics.fill(generalPath);
                vueVARNAGraphics.drawLine(double_4.x, double_4.y, double_5.x, double_5.y);
                break;
            }
            case TRIANGLE: {
                Point2D.Double double_12 = new Point2D.Double(double_5.x + chemProbAnnotation.getIntensity() * d * (this._RNA.CHEM_PROB_TRIANGLE_WIDTH * double_3.x), double_5.y + chemProbAnnotation.getIntensity() * d * (this._RNA.CHEM_PROB_TRIANGLE_WIDTH * double_3.y));
                Point2D.Double double_13 = new Point2D.Double(double_5.x + chemProbAnnotation.getIntensity() * d * (-this._RNA.CHEM_PROB_TRIANGLE_WIDTH * double_3.x), double_5.y + chemProbAnnotation.getIntensity() * d * (-this._RNA.CHEM_PROB_TRIANGLE_WIDTH * double_3.y));
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)double_4.x, (float)double_4.y);
                generalPath.lineTo((float)double_12.x, (float)double_12.y);
                generalPath.lineTo((float)double_13.x, (float)double_13.y);
                generalPath.closePath();
                vueVARNAGraphics.fill(generalPath);
                break;
            }
            case DOT: {
                Double d2 = d * this._RNA.CHEM_PROB_DOT_RADIUS * chemProbAnnotation.getIntensity();
                Point2D.Double double_14 = new Point2D.Double(double_4.x + d2 * double_2.x, double_4.y + d2 * double_2.y);
                vueVARNAGraphics.fillCircle(double_14.x - d2, double_14.y - d2, 2.0 * d2);
            }
        }
    }

    Point2D.Double buildCaptionPosition(ModeleBase modeleBase, double d, double d2) {
        double d3 = 2.0;
        if (this._RNA.isNumberDrawn(modeleBase, this.getNumPeriod())) {
            d3 += this._conf._distNumbers;
        }
        Point2D.Double double_ = modeleBase.getCenter();
        Point2D.Double double_2 = modeleBase.getCoords();
        double d4 = (double)this._RNA.BASE_RADIUS * d3 + d2;
        return new Point2D.Double(double_.getX() + (double_2.getX() - double_.getX()) * ((double_2.distance(double_) + d4) / double_2.distance(double_)), double_.getY() + (double_2.getY() - double_.getY()) * ((double_2.distance(double_) + d4) / double_2.distance(double_)));
    }

    private void renderAnnotations(VueVARNAGraphics vueVARNAGraphics, double d, double d2, double d3, double d4, double d5) {
        Point2D.Double double_;
        for (TextAnnotation serializable : this._RNA.getAnnotations()) {
            vueVARNAGraphics.setColor(serializable.getColor());
            vueVARNAGraphics.setFont(serializable.getFont().deriveFont((float)(2.0 * (double)serializable.getFont().getSize() * d5)));
            double_ = serializable.getCenterPosition();
            if (serializable.getType() == TextAnnotation.AnchorType.BASE) {
                ModeleBase modeleBase = (ModeleBase)serializable.getAncrage();
                double d6 = Math.ceil(serializable.getFont().getSize());
                double_ = this.buildCaptionPosition(modeleBase, d5, d6);
            }
            double_ = this.transformCoord(double_, d, d2, d3, d4, d5);
            vueVARNAGraphics.drawStringCentered(serializable.getTexte(), double_.x, double_.y);
            if (this._selectedAnnotation != serializable || !this._highlightAnnotation) continue;
            this.drawStringOutline(vueVARNAGraphics, serializable.getTexte(), double_.x, double_.y, 5.0);
        }
        for (ChemProbAnnotation chemProbAnnotation : this._RNA.getChemProbAnnotations()) {
            double_ = this.transformCoord(chemProbAnnotation.getAnchorPosition(), d, d2, d3, d4, d5);
            this.drawChemProbAnnotation(vueVARNAGraphics, chemProbAnnotation, double_, d5);
        }
    }

    public Rectangle2D.Double getExtendedRNABBox() {
        Rectangle2D.Double double_ = this._RNA.getBBox();
        double_.y -= this._conf._distNumbers * (double)this._RNA.BASE_RADIUS;
        double_.height += 2.0 * this._conf._distNumbers * (double)this._RNA.BASE_RADIUS;
        double_.x -= this._conf._distNumbers * (double)this._RNA.BASE_RADIUS;
        double_.width += 2.0 * this._conf._distNumbers * (double)this._RNA.BASE_RADIUS;
        if (this._RNA.hasVirtualLoops()) {
            double_.y -= 40.0;
            double_.height += 80.0;
            double_.x -= 40.0;
            double_.width += 80.0;
        }
        return double_;
    }

    public void drawBackbone(VueVARNAGraphics vueVARNAGraphics, Point2D.Double[] doubleArray, double d, double d2) {
        if (this.getDrawBackbone()) {
            vueVARNAGraphics.setStrokeThickness(1.5 * d2);
            vueVARNAGraphics.setColor(this._conf._backboneColor);
            ModeleBackbone modeleBackbone = this._RNA.getBackbone();
            for (int i = 1; i < this._RNA.get_listeBases().size(); ++i) {
                boolean bl;
                Point2D.Double double_ = doubleArray[i - 1];
                Point2D.Double double_2 = doubleArray[i];
                double d3 = double_.distance(double_2);
                int n = this._RNA.getBaseAt(i - 1).getElementStructure();
                int n2 = this._RNA.getBaseAt(i).getElementStructure();
                boolean bl2 = bl = n == i && n2 == i - 1;
                if (!(d3 > 0.0)) continue;
                Point2D.Double double_3 = new Point2D.Double();
                double_3.x = (double_2.x - double_.x) / d3;
                double_3.y = (double_2.y - double_.y) / d3;
                ModeleBackboneElement.BackboneType backboneType = modeleBackbone.getTypeBefore(i);
                if (backboneType == ModeleBackboneElement.BackboneType.DISCONTINUOUS_TYPE) continue;
                if (backboneType == ModeleBackboneElement.BackboneType.MISSING_PART_TYPE) {
                    vueVARNAGraphics.setSelectionStroke();
                } else {
                    vueVARNAGraphics.setPlainStroke();
                }
                vueVARNAGraphics.setColor(modeleBackbone.getColorBefore(i, this._conf._backboneColor));
                if (bl && this._RNA.getDrawMode() != 4 && this._RNA.getDrawMode() != 1) {
                    int n3 = 0;
                    if (i + 1 < doubleArray.length) {
                        n3 = this._RNA.testDirectionality(i - 1, i, i + 1) ? -1 : 1;
                    } else if (i - 2 >= 0) {
                        n3 = this._RNA.testDirectionality(i - 2, i - 1, i) ? -1 : 1;
                    }
                    Point2D.Double double_4 = new Point2D.Double((double)n3 * double_3.y, (double)(-n3) * double_3.x);
                    Point2D.Double double_5 = new Point2D.Double((double_.x + double_2.x) / 2.0, (double_.y + double_2.y) / 2.0);
                    double d4 = double_.distance(double_5);
                    double d5 = Math.sqrt(40.0 * d2 * 40.0 * d2 - d4 * d4);
                    Point2D.Double double_6 = new Point2D.Double(double_5.x + d5 * double_4.x, double_5.y + d5 * double_4.y);
                    double d6 = double_6.distance(double_);
                    double d7 = 360.0 * Math.atan2(-(double_.y - double_6.y), double_.x - double_6.x) / (Math.PI * 2);
                    double d8 = 360.0 * Math.atan2(-(double_2.y - double_6.y), double_2.x - double_6.x) / (Math.PI * 2);
                    double d9 = d8 - d7;
                    if ((double)(-n3) * d9 < 0.0) {
                        d9 += (double)(-n3) * 360.0;
                    }
                    vueVARNAGraphics.drawArc(double_6.x + 0.8 * d * double_4.x, double_6.y + 0.8 * d * double_4.y, 2.0 * d6, 2.0 * d6, d7, d9);
                    continue;
                }
                vueVARNAGraphics.drawLine(doubleArray[i - 1].x + d * double_3.x, doubleArray[i - 1].y + d * double_3.y, doubleArray[i].x - d * double_3.x, doubleArray[i].y - d * double_3.y);
            }
        }
    }

    public Point2D.Double logicToPanel(Point2D.Double double_) {
        return new Point2D.Double(this._offX + this.getScaleFactor() * (double_.x - this._offsetRNA.x), this._offY + this.getScaleFactor() * (double_.y - this._offsetRNA.y));
    }

    public Rectangle2D.Double renderRNA(VueVARNAGraphics vueVARNAGraphics, Rectangle2D.Double double_) {
        return this.renderRNA(vueVARNAGraphics, double_, false, true);
    }

    private double computeScaleFactor(Rectangle2D.Double double_, boolean bl, boolean bl2) {
        Rectangle2D.Double double_2 = this.getExtendedRNABBox();
        double d = Math.min(double_.width / double_2.width, double_.height / double_2.height);
        float f = Math.max(1, (int)(1.7 * (double)this._RNA.BASE_RADIUS * d));
        double_2.y -= (double)f;
        double_2.height += (double)f;
        if (this._conf._drawColorMap) {
            double_2.height += this.getColorMapHeight();
        }
        double_2.x -= (double)f;
        double_2.width += (double)f;
        d = Math.min(double_.width / double_2.width, double_.height / double_2.height);
        if (bl) {
            if (this._conf._autoFit) {
                this.setScaleFactor(d);
            }
            d = this.getScaleFactor();
        }
        return d;
    }

    public synchronized Rectangle2D.Double renderRNA(VueVARNAGraphics vueVARNAGraphics, Rectangle2D.Double double_, boolean bl, boolean bl2) {
        Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        double d = this.computeScaleFactor(double_, bl, bl2);
        float f = Math.max(1, (int)(1.7 * (double)this._RNA.BASE_RADIUS * d));
        double d2 = Math.max(1.0, d * (double)this._RNA.BASE_RADIUS);
        this.setBaseFontSize(Float.valueOf(f));
        this.setNumbersFontSize(Float.valueOf(f));
        double d3 = double_.x;
        double d4 = double_.y;
        Rectangle2D.Double double_3 = this.getExtendedRNABBox();
        if (this._RNA.getSize() != 0) {
            Object object;
            int n;
            Point2D.Double double_4 = new Point2D.Double(double_3.x, double_3.y);
            if (bl2) {
                d3 = double_.x + (double_.width - (double)Math.round(double_3.width * d)) / 2.0;
                d4 = double_.y + (double_.height - (double)Math.round(double_3.height * d)) / 2.0;
                if (bl) {
                    this._offX = d3;
                    this._offY = d4;
                    this._offsetPanel = new Point2D.Double(this._offX, this._offY);
                    this._offsetRNA = new Point2D.Double(double_3.x, double_3.y);
                }
            }
            if (bl) {
                d3 = this._offX;
                d4 = this._offY;
                double_4 = this._offsetRNA;
            }
            Point2D.Double[] doubleArray = new Point2D.Double[this._RNA.get_listeBases().size()];
            Point2D.Double[] doubleArray2 = new Point2D.Double[this._RNA.get_listeBases().size()];
            for (n = 0; n < this._RNA.get_listeBases().size(); ++n) {
                ModeleBase modeleBase = this._RNA.getBaseAt(n);
                doubleArray[n] = new Point2D.Double(d3 + d * (modeleBase.getCoords().x - double_4.x), d4 + d * (modeleBase.getCoords().y - double_4.y));
                object = this._RNA.getCenter(n);
                if ((this._RNA.get_drawMode() == 3 || this._RNA.get_drawMode() == 2) && modeleBase.getElementStructure() != -1 && n < this._RNA.get_listeBases().size() - 1 && n > 1) {
                    int n2;
                    ModeleBase modeleBase2 = this._RNA.get_listeBases().get(n - 1);
                    ModeleBase modeleBase3 = this._RNA.get_listeBases().get(n + 1);
                    int n3 = modeleBase2.getElementStructure();
                    if (n3 == -1 ^ (n2 = modeleBase3.getElementStructure()) == -1) {
                        Point2D.Double double_5 = modeleBase2.getCoords();
                        Point2D.Double double_6 = modeleBase3.getCoords();
                        Point2D.Double double_7 = modeleBase2.getCenter();
                        Point2D.Double double_8 = modeleBase3.getCenter();
                        ((Point2D.Double)object).x = modeleBase.getCoords().x + (double_7.x - double_5.x) / double_7.distance(double_5) + (double_8.x - double_6.x) / double_8.distance(double_6);
                        ((Point2D.Double)object).y = modeleBase.getCoords().y + (double_7.y - double_5.y) / double_7.distance(double_5) + (double_8.y - double_6.y) / double_8.distance(double_6);
                    }
                }
                doubleArray2[n] = new Point2D.Double(d3 + d * (((Point2D.Double)object).x - double_4.x), d4 + d * (((Point2D.Double)object).y - double_4.y));
            }
            if (bl) {
                this._realCoords = doubleArray;
                this._realCenters = doubleArray2;
            }
            vueVARNAGraphics.setStrokeThickness(1.5 * d);
            vueVARNAGraphics.setPlainStroke();
            vueVARNAGraphics.setFont(this._conf._fontBasesGeneral);
            this.drawRegionHighlightsAnnotation(vueVARNAGraphics, this._realCoords, this._realCenters, d);
            this.drawBackbone(vueVARNAGraphics, doubleArray, d2, d);
            for (n = 0; n < this._RNA.get_listeBases().size(); ++n) {
                int n4 = this._RNA.get_listeBases().get(n).getElementStructure();
                if (n4 <= n || !((ModeleBP)(object = this._RNA.get_listeBases().get(n).getStyleBP())).isCanonical() && !this._conf._drawnNonCanonicalBP) continue;
                if (this._RNA.get_drawMode() == 4) {
                    vueVARNAGraphics.setStrokeThickness(this._RNA.getBasePairThickness((ModeleBP)object, this._conf) * 2.0 * d * this._conf._bpThickness);
                } else {
                    vueVARNAGraphics.setStrokeThickness(this._RNA.getBasePairThickness((ModeleBP)object, this._conf) * 1.5 * d);
                }
                vueVARNAGraphics.setColor(this._RNA.getBasePairColor((ModeleBP)object, this._conf));
                if (this._RNA.get_drawMode() == 4) {
                    this.drawBasePairArc(vueVARNAGraphics, n, n4, doubleArray[n], doubleArray[n4], d, (ModeleBP)object, d2);
                    continue;
                }
                this.drawBasePair(vueVARNAGraphics, doubleArray[n], doubleArray[n4], (ModeleBP)object, d2, d);
            }
            if (this._conf._drawnNonPlanarBP) {
                ArrayList<ModeleBP> arrayList = this._RNA.getStructureAux();
                for (int i = 0; i < arrayList.size(); ++i) {
                    object = arrayList.get(i);
                    if (!((ModeleBP)object).isCanonical() && !this._conf._drawnNonCanonicalBP) continue;
                    int n5 = ((ModeleBP)object).getPartner5().getIndex();
                    int n6 = ((ModeleBP)object).getPartner3().getIndex();
                    if (this._RNA.get_drawMode() == 4) {
                        vueVARNAGraphics.setStrokeThickness(this._RNA.getBasePairThickness((ModeleBP)object, this._conf) * 2.5 * d * this._conf._bpThickness);
                        vueVARNAGraphics.setPlainStroke();
                    } else {
                        vueVARNAGraphics.setStrokeThickness(this._RNA.getBasePairThickness((ModeleBP)object, this._conf) * 1.5 * d);
                        vueVARNAGraphics.setPlainStroke();
                    }
                    vueVARNAGraphics.setColor(this._RNA.getBasePairColor((ModeleBP)object, this._conf));
                    if (n6 <= n5) continue;
                    if (this._RNA.get_drawMode() == 4) {
                        this.drawBasePairArc(vueVARNAGraphics, n5, n6, doubleArray[n5], doubleArray[n6], d, (ModeleBP)object, d2);
                        continue;
                    }
                    this.drawBasePair(vueVARNAGraphics, doubleArray[n5], doubleArray[n6], (ModeleBP)object, d2, d);
                }
            }
            vueVARNAGraphics.setPlainStroke();
            for (int i = 0; i < Math.min(this._RNA.get_listeBases().size(), doubleArray.length); ++i) {
                this.drawBase(vueVARNAGraphics, i, doubleArray, doubleArray2, d2, d, bl);
            }
            double_2 = new Rectangle2D.Double(d3, d4, d * double_3.width - 1.0, d * double_3.height - 1.0);
            if (bl) {
                if (this._debug || this._drawBBox) {
                    vueVARNAGraphics.setColor(Color.RED);
                    vueVARNAGraphics.setSelectionStroke();
                    vueVARNAGraphics.drawRect(double_2.x, double_2.y, double_2.width, double_2.height);
                }
                if (this._conf._drawColorMap) {
                    this.drawColorMap(vueVARNAGraphics, d, double_3);
                }
                if (this._debug || this._drawBBox) {
                    vueVARNAGraphics.setColor(Color.GRAY);
                    vueVARNAGraphics.setSelectionStroke();
                    vueVARNAGraphics.drawRect(0.0, 0.0, this.getWidth() - 1, this.getHeight() - this.getTitleHeight() - 1);
                }
            }
            this.renderAnnotations(vueVARNAGraphics, d3, d4, double_4.x, double_4.y, d);
            if (this._RNA._debugShape != null) {
                Color color = new Color(255, 0, 0, 50);
                vueVARNAGraphics.setColor(color);
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(d3 - d * double_3.x, d4 - d * double_3.y);
                affineTransform.scale(d, d);
                object = affineTransform.createTransformedShape(this._RNA._debugShape);
                if (object instanceof GeneralPath) {
                    vueVARNAGraphics.fill((GeneralPath)object);
                }
            }
        } else {
            vueVARNAGraphics.setColor(VARNAConfig.DEFAULT_MESSAGE_COLOR);
            vueVARNAGraphics.setFont(VARNAConfig.DEFAULT_MESSAGE_FONT);
            double_2 = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
            vueVARNAGraphics.drawStringCentered("No RNA here", double_.getCenterX(), double_.getCenterY());
        }
        return double_2;
    }

    public void centerViewOn(double d, double d2) {
        Rectangle2D.Double double_ = this._RNA.getBBox();
        this._target = new Point2D.Double(d, d2);
        Point2D.Double double_2 = this.logicToPanel(this._target);
        Point point = new Point((int)(-double_2.x), (int)(-double_2.y));
        this.setTranslation(point);
        this.repaint();
    }

    public ModeleBase getBaseAt(Point2D.Double double_) {
        ModeleBase modeleBase = null;
        Point2D.Double double_2 = this.panelToLogicPoint(double_);
        double d = Double.MAX_VALUE;
        for (ModeleBase modeleBase2 : this._RNA.get_listeBases()) {
            double d2 = modeleBase2.getCoords().distance(double_2);
            if (!(d > d2)) continue;
            modeleBase = modeleBase2;
            d = d2;
        }
        return modeleBase;
    }

    public void setColorMapValues(Double[] doubleArray) {
        this._RNA.setColorMapValues(doubleArray, this._conf._cm, true);
        this._conf._drawColorMap = true;
        this.repaint();
    }

    public void setColorMapMaxValue(double d) {
        this._conf._cm.setMaxValue(d);
    }

    public void setColorMapMinValue(double d) {
        this._conf._cm.setMinValue(d);
    }

    public ModeleColorMap getColorMap() {
        return this._conf._cm;
    }

    public void setColorMap(ModeleColorMap modeleColorMap) {
        this._conf._cm = modeleColorMap;
        this.repaint();
    }

    public void setColorMapCaption(String string) {
        this._conf._colorMapCaption = string;
        this.repaint();
    }

    public String getColorMapCaption() {
        return this._conf._colorMapCaption;
    }

    public void drawColorMap(boolean bl) {
        this._conf._drawColorMap = bl;
    }

    private double getColorMapHeight() {
        double d = (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE + this._conf._colorMapHeight;
        if (!this._conf._colorMapCaption.equals("")) {
            d += (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE;
        }
        return d;
    }

    private void drawColorMap(VueVARNAGraphics vueVARNAGraphics, double d, Rectangle2D.Double double_) {
        double d2 = this._conf._cm.getMinValue();
        double d3 = this._conf._cm.getMaxValue();
        vueVARNAGraphics.setPlainStroke();
        double d4 = 0.0;
        double d5 = Math.min(((double)this.getHeight() - double_.height * d - (double)this.getTitleHeight()) / 2.0, d * (this._conf._colorMapHeight + (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE));
        if ((int)d5 == 0) {
            d4 = Math.min(((double)this.getWidth() - double_.width * d) / 2.0, d * this._conf._colorMapWidth + (double)VARNAConfig.DEFAULT_COLOR_MAP_STRIPE_WIDTH);
        }
        double d6 = d4 + this._offX + d * (double_.width - this._conf._colorMapWidth - this._conf._colorMapXOffset);
        double d7 = VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE;
        double d8 = d5 + this._offY + d * (double_.height - this._conf._colorMapHeight - this._conf._colorMapYOffset - d7);
        int n = 0;
        while ((double)n < this._conf._colorMapWidth) {
            double d9 = (double)n / this._conf._colorMapWidth;
            double d10 = d2 + (d3 - d2) * d9;
            vueVARNAGraphics.setColor(this._conf._cm.getColorForValue(d10));
            double d11 = d6 + d * (double)n;
            double d12 = d8;
            vueVARNAGraphics.fillRect(d11, d12, d * (double)VARNAConfig.DEFAULT_COLOR_MAP_STRIPE_WIDTH, d * this._conf._colorMapHeight);
            ++n;
        }
        vueVARNAGraphics.setColor(VARNAConfig.DEFAULT_COLOR_MAP_OUTLINE);
        vueVARNAGraphics.drawRect(d6, d8, (double)(VARNAConfig.DEFAULT_COLOR_MAP_STRIPE_WIDTH - 1) + d * this._conf._colorMapWidth, d * this._conf._colorMapHeight);
        vueVARNAGraphics.setFont(this.getFont().deriveFont((float)(d * (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE)));
        vueVARNAGraphics.setColor(VARNAConfig.DEFAULT_COLOR_MAP_FONT_COLOR);
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(0);
        vueVARNAGraphics.drawStringCentered(numberFormat.format(this._conf._cm.getMinValue()), d6, d8 + d * (this._conf._colorMapHeight + (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE / 1.7));
        vueVARNAGraphics.drawStringCentered(numberFormat.format(this._conf._cm.getMaxValue()), d6 + (double)VARNAConfig.DEFAULT_COLOR_MAP_STRIPE_WIDTH + d * this._conf._colorMapWidth, d8 + d * (this._conf._colorMapHeight + (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE / 1.7));
        if (!this._conf._colorMapCaption.equals("")) {
            vueVARNAGraphics.drawStringCentered("" + this._conf._colorMapCaption, d6 + d * this._conf._colorMapWidth / 2.0, d8 + d * ((double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE / 1.7 + this._conf._colorMapHeight));
        }
    }

    public Point2D.Double panelToLogicPoint(Point2D.Double double_) {
        return new Point2D.Double((double_.x - this.getOffsetPanel().x) / this.getScaleFactor() + this.getRNAOffset().x, (double_.y - this.getOffsetPanel().y) / this.getScaleFactor() + this.getRNAOffset().y);
    }

    public Point2D.Double transformCoord(Point2D.Double double_, double d, double d2, double d3, double d4, double d5) {
        return new Point2D.Double(d + d5 * (double_.x - d3), d2 + d5 * (double_.y - d4));
    }

    public void eraseSequence() {
        this._RNA.eraseSequence();
    }

    public Point2D.Double transformCoord(Point2D.Double double_) {
        Rectangle2D.Double double_2 = this.getExtendedRNABBox();
        return new Point2D.Double(this._offX + this.getScaleFactor() * (double_.x - double_2.x), this._offY + this.getScaleFactor() * (double_.y - double_2.y));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.paintComponent(graphics, false);
    }

    public void paintComponent(Graphics graphics, boolean bl) {
        if (this._premierAffichage) {
            this._translation.x = 0;
            this._translation.y = (int)((double)(-this.getTitleHeight()) / 2.0);
            this._popup.buildPopupMenu();
            this.add(this._popup);
            this._premierAffichage = false;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        SwingGraphics swingGraphics = new SwingGraphics(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.removeAll();
        super.paintComponent(graphics2D);
        this.renderComponent(swingGraphics, bl, this.getScaleFactor());
        if (this.isFocusOwner()) {
            graphics2D.setStroke(new BasicStroke(1.5f));
            graphics2D.setColor(Color.decode("#C0C0C0"));
            graphics2D.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        graphics2D.setStroke(stroke);
    }

    public synchronized void renderComponent(VueVARNAGraphics vueVARNAGraphics, boolean bl, double d) {
        Point2D.Double double_;
        this.updateTitleHeight();
        if (this._debug || this._drawBorder) {
            vueVARNAGraphics.setColor(Color.BLACK);
            vueVARNAGraphics.setPlainStroke();
            vueVARNAGraphics.drawRect(this.getLeftOffset(), this.getTopOffset(), this.getInnerWidth(), this.getInnerHeight());
        }
        if (!bl) {
            super.setBackground(this._conf._backgroundColor);
        } else {
            super.setBackground(new Color(0, 0, 0, 120));
        }
        if (this.getMinimumSize().height < this.getSize().height && this.getMinimumSize().width < this.getSize().width) {
            if (!this.getTitle().equals("")) {
                vueVARNAGraphics.setColor(this._conf._titleColor);
                vueVARNAGraphics.setFont(this._conf._titleFont);
                vueVARNAGraphics.drawStringCentered(this.getTitle(), this.getWidth() / 2, (double)this.getHeight() - (double)this.getTitleHeight() / 2.0);
            }
            this.renderRNA(vueVARNAGraphics, this.getClip(), true, this._conf._autoCenter);
        }
        if (this._selectionRectangle != null) {
            vueVARNAGraphics.setColor(Color.BLACK);
            vueVARNAGraphics.setSelectionStroke();
            vueVARNAGraphics.drawRect(this._selectionRectangle.x, this._selectionRectangle.y, this._selectionRectangle.width, this._selectionRectangle.height);
        }
        if (this._linkOrigin != null && this._linkDestination != null) {
            vueVARNAGraphics.setColor(this._conf._bondColor);
            vueVARNAGraphics.setPlainStroke();
            vueVARNAGraphics.setStrokeThickness(3.0 * d);
            double_ = this._linkOrigin;
            Point2D.Double double_2 = this._linkDestination;
            vueVARNAGraphics.drawLine(double_.x, double_.y, double_2.x, double_2.y);
            for (int n : this.getSelection().getIndices()) {
                this.drawBase(vueVARNAGraphics, n, this._realCoords, this._realCenters, d * (double)this._RNA.BASE_RADIUS, d, true);
            }
        }
        if (this._debug) {
            vueVARNAGraphics.setStrokeThickness(3.0 * d);
            vueVARNAGraphics.setColor(Color.black);
            double_ = this.logicToPanel(this._target);
            vueVARNAGraphics.drawLine(double_.x - 3.0, double_.y - 3.0, double_.x + 3.0, double_.y + 3.0);
            vueVARNAGraphics.drawLine(double_.x - 3.0, double_.y + 3.0, double_.x + 3.0, double_.y - 3.0);
            vueVARNAGraphics.setColor(Color.red);
            double_ = this.logicToPanel(this._target2);
            vueVARNAGraphics.drawLine(double_.x - 3.0, double_.y - 3.0, double_.x + 3.0, double_.y + 3.0);
            vueVARNAGraphics.drawLine(double_.x - 3.0, double_.y + 3.0, double_.x + 3.0, double_.y - 3.0);
        }
    }

    public void drawRegionHighlightsAnnotation(VueVARNAGraphics vueVARNAGraphics, Point2D.Double[] doubleArray, Point2D.Double[] doubleArray2, double d) {
        vueVARNAGraphics.setStrokeThickness(2.0 * d);
        vueVARNAGraphics.setPlainStroke();
        for (HighlightRegionAnnotation highlightRegionAnnotation : this._RNA.getHighlightRegion()) {
            GeneralPath generalPath = highlightRegionAnnotation.getShape(doubleArray, doubleArray2, d);
            vueVARNAGraphics.setColor(highlightRegionAnnotation.getFillColor());
            vueVARNAGraphics.fill(generalPath);
            vueVARNAGraphics.setColor(highlightRegionAnnotation.getOutlineColor());
            vueVARNAGraphics.draw(generalPath);
        }
    }

    private Rectangle2D.Double getClip() {
        return new Rectangle2D.Double(this.getLeftOffset(), this.getTopOffset(), this.getInnerWidth(), this.getInnerHeight());
    }

    public Rectangle2D.Double getViewClip() {
        return new Rectangle2D.Double(this.getLeftOffset(), this.getTopOffset(), this.getInnerWidth(), this.getInnerHeight());
    }

    public Color getBackboneColor() {
        return this._conf._backboneColor;
    }

    public void setBackboneColor(Color color) {
        this._conf._backboneColor = color;
    }

    public Color getBondColor() {
        return this._conf._bondColor;
    }

    public String getTitle() {
        return this._RNA.getName();
    }

    public void setDefaultBPColor(Color color) {
        this._conf._bondColor = color;
    }

    public void setBorderSize(Dimension dimension) {
        this._border = dimension;
    }

    public Dimension getBorderSize() {
        return this._border;
    }

    public synchronized void showRNA(RNA rNA) {
        this.fireUINewStructure(rNA);
        this._RNA = rNA;
    }

    public void drawRNA(String string, String string2) throws ExceptionNonEqualLength {
        this.drawRNA(string, string2, this._RNA.get_drawMode());
    }

    public void drawRNA(RNA rNA, int n) {
        rNA.setDrawMode(n);
        this.drawRNA(rNA);
    }

    public void drawRNA() {
        try {
            this._RNA.drawRNA(this._RNA.get_drawMode(), this._conf);
        }
        catch (ExceptionNAViewAlgorithm exceptionNAViewAlgorithm) {
            this.errorDialog(exceptionNAViewAlgorithm);
            exceptionNAViewAlgorithm.printStackTrace();
        }
        this.repaint();
    }

    public void drawRNA(RNA rNA) {
        if (rNA != null) {
            this._RNA = rNA;
            this.drawRNA();
        }
    }

    public void drawRNA(String string, String string2, int n) throws ExceptionNonEqualLength {
        this._RNA.setDrawMode(n);
        try {
            this._RNA.setRNA(string, string2);
            this.drawRNA();
        }
        catch (ExceptionUnmatchedClosingParentheses exceptionUnmatchedClosingParentheses) {
            this.errorDialog(exceptionUnmatchedClosingParentheses);
        }
        catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
            this.errorDialog(exceptionFileFormatOrSyntax);
        }
    }

    public void drawRNA(Reader reader, int n) throws ExceptionNonEqualLength, ExceptionFileFormatOrSyntax {
        this._RNA.setDrawMode(n);
        ArrayList<RNA> arrayList = RNAFactory.loadSecStr(reader);
        if (arrayList.isEmpty()) {
            throw new ExceptionFileFormatOrSyntax("No RNA could be parsed from that source.");
        }
        this._RNA = (RNA)arrayList.iterator().next();
        this.drawRNA();
    }

    public void drawRNAInterpolated(String string, String string2) throws ExceptionNonEqualLength {
        this.drawRNAInterpolated(string, string2, this._RNA.get_drawMode());
    }

    public void drawRNAInterpolated(String string, String string2, int n) {
        this.drawRNAInterpolated(string, string2, n, Mapping.DefaultOutermostMapping(this._RNA.get_listeBases().size(), string2.length()));
    }

    public void drawRNAInterpolated(String string, String string2, Mapping mapping) {
        this.drawRNAInterpolated(string, string2, this._RNA.get_drawMode(), mapping);
    }

    public void drawRNAInterpolated(String string, String string2, int n, Mapping mapping) {
        RNA rNA = new RNA();
        try {
            rNA.setRNA(string, string2);
            this.drawRNAInterpolated(rNA, n, mapping);
        }
        catch (ExceptionUnmatchedClosingParentheses exceptionUnmatchedClosingParentheses) {
            this.errorDialog(exceptionUnmatchedClosingParentheses);
        }
        catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
            this.errorDialog(exceptionFileFormatOrSyntax);
        }
    }

    public void drawRNAInterpolated(RNA rNA) {
        this.drawRNAInterpolated(rNA, rNA.get_drawMode(), Mapping.DefaultOutermostMapping(this._RNA.get_listeBases().size(), rNA.getSize()));
    }

    public void drawRNAInterpolated(RNA rNA, Mapping mapping) {
        this.drawRNAInterpolated(rNA, rNA.get_drawMode(), mapping);
    }

    public void drawRNAInterpolated(RNA rNA, int n, Mapping mapping) {
        try {
            rNA.drawRNA(n, this._conf);
            this._conf._drawColorMap = false;
            this._interpolator.addTarget(rNA, mapping);
        }
        catch (ExceptionNAViewAlgorithm exceptionNAViewAlgorithm) {
            this.errorDialog(exceptionNAViewAlgorithm);
            exceptionNAViewAlgorithm.printStackTrace();
        }
    }

    public int getDrawMode() {
        return this._RNA.getDrawMode();
    }

    public void showRNA(RNA rNA, VARNAConfig vARNAConfig) {
        this.showRNA(rNA);
        if (vARNAConfig != null) {
            this.setConfig(vARNAConfig);
        }
        this.repaint();
    }

    public boolean isInterpolationInProgress() {
        if (this._interpolator == null) {
            return false;
        }
        return this._interpolator.isInterpolationInProgress();
    }

    public void showRNAInterpolated(RNA rNA) {
        this.showRNAInterpolated(rNA, Mapping.DefaultOutermostMapping(this._RNA.get_listeBases().size(), rNA.getSize()));
    }

    public void showRNAInterpolated(RNA rNA, Mapping mapping) {
        this.showRNAInterpolated(rNA, null, mapping);
    }

    public void showRNAInterpolated(RNA rNA, VARNAConfig vARNAConfig, Mapping mapping) {
        this._interpolator.addTarget(rNA, vARNAConfig, mapping);
    }

    public void drawRNA(String string, String string2, String string3, String string4, int n) {
        this._RNA.setDrawMode(n);
        if (string.length() == string3.length() && string2.length() == string4.length()) {
            int n2;
            if (string.length() != string2.length()) {
                if (this._conf._showWarnings) {
                    this.emitWarning("First sequence length " + string.length() + " differs from that of it's secondary structure " + string2.length() + ". \nAdapting first sequence length ...");
                }
                if (string.length() < string2.length()) {
                    while (string.length() < string2.length()) {
                        string = string + " ";
                    }
                } else {
                    string = string.substring(0, string2.length());
                }
            }
            if (string3.length() != string4.length()) {
                if (this._conf._showWarnings) {
                    this.emitWarning("Second sequence length " + string3.length() + " differs from that of it's secondary structure " + string4.length() + ". \nAdapting second sequence length ...");
                }
                if (string3.length() < string4.length()) {
                    while (string3.length() < string4.length()) {
                        string3 = string3 + " ";
                    }
                } else {
                    string3 = string3.substring(0, string4.length());
                }
            }
            int n3 = string.length();
            String string5 = new String("");
            String string6 = new String("");
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            string2 = string2.replace('-', '.');
            string4 = string4.replace('-', '.');
            for (n2 = 0; n2 < n3; ++n2) {
                if (string2.charAt(n2) == string4.charAt(n2)) {
                    string5 = string5 + string2.charAt(n2);
                    arrayList.add(0);
                    continue;
                }
                if (string2.charAt(n2) == '(' || string4.charAt(n2) == '(') {
                    string5 = string5 + '(';
                    arrayList.add(string2.charAt(n2) == '(' ? 1 : 2);
                    continue;
                }
                if (string2.charAt(n2) == ')' || string4.charAt(n2) == ')') {
                    string5 = string5 + ')';
                    arrayList.add(string2.charAt(n2) == ')' ? 1 : 2);
                    continue;
                }
                string5 = string5 + '.';
                arrayList.add(-1);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                string6 = string6 + string.charAt(n2) + string3.charAt(n2);
            }
            if (!string6.equals("") && !string5.equals("")) {
                try {
                    this._RNA.setRNA(string6, string5, arrayList);
                }
                catch (ExceptionUnmatchedClosingParentheses exceptionUnmatchedClosingParentheses) {
                    this.errorDialog(exceptionUnmatchedClosingParentheses);
                }
                catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
                    this.errorDialog(exceptionFileFormatOrSyntax);
                }
            } else {
                this.emitWarning("ERROR : The super-structure is NULL.");
            }
            switch (this._RNA.get_drawMode()) {
                case 2: {
                    this._RNA.drawRNARadiate(this._conf);
                    break;
                }
                case 1: {
                    this._RNA.drawRNACircle(this._conf);
                    break;
                }
                case 4: {
                    this._RNA.drawRNALine(this._conf);
                    break;
                }
                case 3: {
                    try {
                        this._RNA.drawRNANAView(this._conf);
                    }
                    catch (ExceptionNAViewAlgorithm exceptionNAViewAlgorithm) {
                        this.errorDialog(exceptionNAViewAlgorithm);
                    }
                    break;
                }
            }
        }
    }

    public Point2D.Double[] getRealCoords() {
        return this._realCoords;
    }

    public void setRealCoords(Point2D.Double[] doubleArray) {
        this._realCoords = doubleArray;
    }

    public VueMenu getPopup() {
        return this._popup;
    }

    public void setBondColor(Color color) {
        this._conf._bondColor = color;
    }

    public Color getTitleColor() {
        return this._conf._titleColor;
    }

    public void setTitleColor(Color color) {
        this._conf._titleColor = color;
    }

    private int getTitleHeight() {
        return this._titleHeight;
    }

    private void setTitleHeight(int n) {
        this._titleHeight = n;
    }

    public boolean isAutoCentered() {
        return this._conf._autoCenter;
    }

    public void setAutoCenter(boolean bl) {
        this._conf._autoCenter = bl;
    }

    public Font getTitleFont() {
        return this._conf._titleFont;
    }

    public void setTitleFont(Font font) {
        this._conf._titleFont = font;
        this.updateTitleHeight();
    }

    public double getBPHeightIncrement() {
        return this._RNA._bpHeightIncrement;
    }

    public void setBPHeightIncrement(double d) {
        this._RNA._bpHeightIncrement = d;
    }

    public Point2D.Double getOffsetPanel() {
        return this._offsetPanel;
    }

    private Point2D.Double getRNAOffset() {
        return this._offsetRNA;
    }

    public VueMenu getPopupMenu() {
        return this._popup;
    }

    public double getZoomIncrement() {
        return this._conf._zoomAmount;
    }

    public void setZoomIncrement(Object object) {
        this.setZoomIncrement(Float.valueOf(object.toString()));
    }

    public void setZoomIncrement(double d) {
        this._conf._zoomAmount = d;
    }

    public double getZoom() {
        return this._conf._zoom;
    }

    public void setZoom(Object object) {
        double d = Float.valueOf(object.toString()).floatValue();
        if (this._conf._zoom != d) {
            this._conf._zoom = d;
            this.fireZoomLevelChanged(d);
        }
    }

    public Point getTranslation() {
        return this._translation;
    }

    public void setTranslation(Point point) {
        this._translation = point;
        this.checkTranslation();
        this.fireTranslationChanged();
    }

    public RNA getRNA() {
        return this._RNA;
    }

    public boolean isOutOfFrame() {
        return this._horsCadre;
    }

    public void errorDialog(Exception exception) {
        this.errorDialog(exception, this);
    }

    public void errorDialog(Exception exception, Component component) {
        if (this.isErrorsOn()) {
            JOptionPane.showMessageDialog(component, exception.getMessage(), "VARNA Error", 0);
        }
    }

    public static void errorDialogStatic(Exception exception, Component component) {
        if (component != null) {
            JOptionPane.showMessageDialog(component, exception.getMessage(), "VARNA Critical Error", 0);
        } else {
            System.err.println("Error: " + exception.getMessage());
        }
    }

    public void emitWarning(String string) {
        if (this._conf._showWarnings) {
            JOptionPane.showMessageDialog(this, string, "VARNA Warning", 2);
        }
    }

    public static void emitWarningStatic(Exception exception, Component component) {
        VARNAPanel.emitWarningStatic(exception.getMessage(), component);
    }

    public static void emitWarningStatic(String string, Component component) {
        if (component != null) {
            JOptionPane.showMessageDialog(component, string, "VARNA Warning", 2);
        } else {
            System.err.println("Error: " + string);
        }
    }

    public void setModifiable(boolean bl) {
        this._conf._modifiable = bl;
    }

    public boolean isModifiable() {
        return this._conf._modifiable;
    }

    public void reset() {
        this.setBorderSize(new Dimension(0, 0));
        this.setTranslation(new Point(0, (int)((double)(-this.getTitleHeight()) / 2.0)));
        this.setZoom(1.0);
        this.setZoomIncrement(1.2);
    }

    public Color getNonStandardBasesColor() {
        return this._conf._specialBasesColor;
    }

    public void setNonStandardBasesColor(Color color) {
        this._conf._specialBasesColor = color;
    }

    public void checkTranslation() {
        if (this.getZoom() <= 1.0) {
            if (this.getTranslation().x < -((int)((double)(this.getWidth() - this.getInnerWidth()) / 2.0))) {
                this.setTranslation(new Point(-((int)((double)(this.getWidth() - this.getInnerWidth()) / 2.0)), this.getTranslation().y));
            }
            if (this.getTranslation().x > (int)((double)(this.getWidth() - this.getInnerWidth()) / 2.0)) {
                this.setTranslation(new Point((int)((double)(this.getWidth() - this.getInnerWidth()) / 2.0), this.getTranslation().y));
            }
            if (this.getTranslation().y > (int)((double)(this.getHeight() - this.getTitleHeight() * 2 - this.getInnerHeight()) / 2.0)) {
                this.setTranslation(new Point(this.getTranslation().x, (int)((double)(this.getHeight() - this.getTitleHeight() * 2 - this.getInnerHeight()) / 2.0)));
            }
            if (this.getTranslation().y < -((int)((double)(this.getHeight() - this.getInnerHeight()) / 2.0))) {
                this.setTranslation(new Point(this.getTranslation().x, -((int)((double)(this.getHeight() - this.getInnerHeight()) / 2.0))));
            }
        } else {
            Rectangle rectangle = this.getZoomedInTranslationBox();
            int n = rectangle.x;
            int n2 = rectangle.x + rectangle.width;
            int n3 = rectangle.y;
            int n4 = rectangle.y + rectangle.height;
            if (this.getTranslation().x < n) {
                this.setTranslation(new Point(n, this.getTranslation().y));
            } else if (this.getTranslation().x > n2) {
                this.setTranslation(new Point(n2, this.getTranslation().y));
            }
            if (this.getTranslation().y < n3) {
                this.setTranslation(new Point(this.getTranslation().x, n3));
            } else if (this.getTranslation().y > n4) {
                this.setTranslation(new Point(this.getTranslation().x, n4));
            }
        }
    }

    public Rectangle getZoomedInTranslationBox() {
        int n = -((int)((double)this.getInnerWidth() / 2.0));
        int n2 = (int)((double)this.getInnerWidth() / 2.0);
        int n3 = -((int)((double)this.getInnerHeight() / 2.0));
        int n4 = (int)((double)this.getInnerHeight() / 2.0);
        return new Rectangle(n, n3, n2 - n, n4 - n3);
    }

    public int getLeftOffset() {
        return this._border.width + (this.getWidth() - 2 * this._border.width - this.getInnerWidth()) / 2 + this._translation.x;
    }

    public int getInnerWidth() {
        return (int)Math.round((double)(this.getWidth() - 2 * this._border.width) * this._conf._zoom);
    }

    public int getTopOffset() {
        return this._border.height + (this.getHeight() - 2 * this._border.height - this.getInnerHeight()) / 2 + this._translation.y;
    }

    public int getInnerHeight() {
        return (int)Math.round((double)this.getHeight() * this._conf._zoom - (double)(2 * this._border.height) - (double)this.getTitleHeight());
    }

    public boolean isComparisonMode() {
        return this._conf._comparisonMode;
    }

    public void globalRotation(Double d) {
        this._RNA.globalRotation(d);
        this.fireLayoutChanged();
        this.repaint();
    }

    public Integer getNearestBase() {
        return this._nearestBase;
    }

    public void setNearestBase(Integer n) {
        this._nearestBase = n;
    }

    public Color getGapsBasesColor() {
        return this._conf._dashBasesColor;
    }

    public void setGapsBasesColor(Color color) {
        this._conf._dashBasesColor = color;
    }

    private void imprimer() {
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            if (printerJob.printDialog(hashPrintRequestAttributeSet)) {
                printerJob.print(hashPrintRequestAttributeSet);
            }
        }
        catch (PrinterException printerException) {
            this.errorDialog(printerException);
        }
    }

    public boolean isErrorsOn() {
        return this._conf._errorsOn;
    }

    public void setErrorsOn(boolean bl) {
        this._conf._errorsOn = bl;
    }

    public VueUI getVARNAUI() {
        return this._UI;
    }

    public void setUseBaseColorsForBPs(boolean bl) {
        this._conf._useBaseColorsForBPs = bl;
    }

    public boolean getUseBaseColorsForBPs() {
        return this._conf._useBaseColorsForBPs;
    }

    public void setColorNonStandardBases(boolean bl) {
        this._conf._colorSpecialBases = bl;
    }

    public boolean getColorSpecialBases() {
        return this._conf._colorSpecialBases;
    }

    public void setColorGapsBases(boolean bl) {
        this._conf._colorDashBases = bl;
    }

    public boolean getColorGapsBases() {
        return this._conf._colorDashBases;
    }

    public void setShowWarnings(boolean bl) {
        this._conf._showWarnings = bl;
    }

    public boolean getShowWarnings() {
        return this._conf._showWarnings;
    }

    public void setShowNonCanonicalBP(boolean bl) {
        this._conf._drawnNonCanonicalBP = bl;
    }

    public boolean getShowNonCanonicalBP() {
        return this._conf._drawnNonCanonicalBP;
    }

    public void setShowNonPlanarBP(boolean bl) {
        this._conf._drawnNonPlanarBP = bl;
    }

    public boolean getShowNonPlanarBP() {
        return this._conf._drawnNonPlanarBP;
    }

    public void setBPStyle(VARNAConfig.BP_STYLE bP_STYLE) {
        this._conf._mainBPStyle = bP_STYLE;
    }

    public VARNAConfig.BP_STYLE getBPStyle() {
        return this._conf._mainBPStyle;
    }

    public VARNAConfig getConfig() {
        return this._conf;
    }

    @Override
    public void setBackground(Color color) {
        if (this._conf != null) {
            if (color != null) {
                this._conf._backgroundColor = color;
                this._conf._drawBackground = !color.equals(VARNAConfig.DEFAULT_BACKGROUND_COLOR);
            } else {
                this._conf._backgroundColor = VARNAConfig.DEFAULT_BACKGROUND_COLOR;
                this._conf._drawBackground = false;
            }
        }
    }

    public void highlightSelectedBase(ModeleBase modeleBase) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = modeleBase.getIndex();
        if (n != -1) {
            arrayList.add(n);
        }
        this.setSelection(arrayList);
    }

    public void highlightSelectedStem(ModeleBase modeleBase) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = modeleBase.getIndex();
        if (n != -1) {
            ArrayList<Integer> arrayList2 = this._RNA.findStem(n);
            arrayList.addAll(arrayList2);
        }
        this.setSelection(arrayList);
    }

    public BaseList getSelection() {
        return this._selectedBases;
    }

    public ArrayList<Integer> getSelectionIndices() {
        return this._selectedBases.getIndices();
    }

    public void setSelection(ArrayList<Integer> arrayList) {
        this.setSelection((Collection<? extends ModeleBase>)this._RNA.getBasesAt(arrayList));
    }

    public void setSelection(Collection<? extends ModeleBase> collection) {
        BaseList baseList = new BaseList(this._selectedBases);
        this._selectedBases.clear();
        this._selectedBases.addBases(collection);
        this._blink.setActive(true);
        this.fireSelectionChanged(baseList, this._selectedBases);
    }

    public ArrayList<Integer> getBasesInRectangleDiff(Rectangle rectangle, Rectangle rectangle2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this._realCoords.length; ++i) {
            if (!(rectangle.contains(this._realCoords[i]) ^ rectangle2.contains(this._realCoords[i]))) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    public ArrayList<Integer> getBasesInRectangle(Rectangle rectangle) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this._realCoords.length; ++i) {
            if (!rectangle.contains(this._realCoords[i])) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    public void setSelectionRectangle(Rectangle rectangle) {
        ArrayList<Object> arrayList = new ArrayList();
        arrayList = this._selectionRectangle != null ? this.getBasesInRectangleDiff(this._selectionRectangle, rectangle) : this.getBasesInRectangle(rectangle);
        this._selectionRectangle = new Rectangle(rectangle);
        this.toggleSelection(arrayList);
        this.repaint();
    }

    public void removeSelectionRectangle() {
        this._selectionRectangle = null;
    }

    public void addToSelection(Collection<? extends Integer> collection) {
        Iterator<? extends Integer> iterator = collection.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            this.addToSelection(n);
        }
    }

    public void addToSelection(int n) {
        BaseList baseList = new BaseList(this._selectedBases);
        ModeleBase modeleBase = this._RNA.getBaseAt(n);
        this._selectedBases.addBase(modeleBase);
        this._blink.setActive(true);
        this.fireSelectionChanged(baseList, this._selectedBases);
    }

    public void removeFromSelection(int n) {
        BaseList baseList = new BaseList(this._selectedBases);
        ModeleBase modeleBase = this._RNA.getBaseAt(n);
        this._selectedBases.removeBase(modeleBase);
        if (this._selectedBases.size() == 0) {
            this._blink.setActive(false);
        } else {
            this._blink.setActive(true);
        }
        this.fireSelectionChanged(baseList, this._selectedBases);
    }

    public boolean isInSelection(int n) {
        return this._selectedBases.contains(this._RNA.getBaseAt(n));
    }

    public void toggleSelection(int n) {
        if (this.isInSelection(n)) {
            this.removeFromSelection(n);
        } else {
            this.addToSelection(n);
        }
    }

    public void toggleSelection(Collection<? extends Integer> collection) {
        Iterator<? extends Integer> iterator = collection.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            this.toggleSelection(n);
        }
    }

    public void clearSelection() {
        BaseList baseList = new BaseList(this._selectedBases);
        this._selectedBases.clear();
        this._blink.setActive(false);
        this.repaint();
        this.fireSelectionChanged(baseList, this._selectedBases);
    }

    public void saveSelection() {
        this._backupSelection.clear();
        this._backupSelection.addAll(this._selectedBases.getBases());
    }

    public void restoreSelection() {
        this.setSelection((Collection<? extends ModeleBase>)this._backupSelection);
    }

    public void resetAnnotationHighlight() {
        this._highlightAnnotation = false;
        this.repaint();
    }

    public void drawBBox(boolean bl) {
        this._drawBBox = bl;
    }

    public void drawBorder(boolean bl) {
        this._drawBorder = bl;
    }

    public void setBaseInnerColor(Color color) {
        this._RNA.setBaseInnerColor(color);
    }

    public void setBaseNumbersColor(Color color) {
        this._RNA.setBaseNumbersColor(color);
    }

    public void setBaseNameColor(Color color) {
        this._RNA.setBaseNameColor(color);
    }

    public void setBaseOutlineColor(Color color) {
        this._RNA.setBaseOutlineColor(color);
    }

    public ArrayList<TextAnnotation> getListeAnnotations() {
        return this._RNA.getAnnotations();
    }

    public void resetListeAnnotations() {
        this._RNA.clearAnnotations();
        this.repaint();
    }

    public void addAnnotation(TextAnnotation textAnnotation) {
        this._RNA.addAnnotation(textAnnotation);
        this.repaint();
    }

    public boolean removeAnnotation(TextAnnotation textAnnotation) {
        boolean bl = this._RNA.removeAnnotation(textAnnotation);
        this.repaint();
        return bl;
    }

    public TextAnnotation get_selectedAnnotation() {
        return this._selectedAnnotation;
    }

    public void set_selectedAnnotation(TextAnnotation textAnnotation) {
        this._selectedAnnotation = textAnnotation;
    }

    public void removeSelectedAnnotation() {
        this._highlightAnnotation = false;
        this._selectedAnnotation = null;
    }

    public void highlightSelectedAnnotation() {
        this._highlightAnnotation = true;
    }

    public boolean getFlatExteriorLoop() {
        return this._conf._flatExteriorLoop;
    }

    public void setFlatExteriorLoop(boolean bl) {
        this._conf._flatExteriorLoop = bl;
    }

    public void setLastSelectedPosition(Point2D.Double double_) {
        this._lastSelectedCoord.x = double_.x;
        this._lastSelectedCoord.y = double_.y;
    }

    public Point2D.Double getLastSelectedPosition() {
        return this._lastSelectedCoord;
    }

    public void setSequence(String string) {
        this._RNA.setSequence(string);
        this.repaint();
    }

    public void setColorMapVisible(boolean bl) {
        this._conf._drawColorMap = bl;
        this.repaint();
    }

    public boolean getColorMapVisible() {
        return this._conf._drawColorMap;
    }

    public void removeColorMap() {
        this._conf._drawColorMap = false;
        this.repaint();
    }

    public void saveSession(String string) {
        this.toXML(string);
    }

    public FullBackup loadSession(String string) throws ExceptionLoadingFailed {
        FullBackup fullBackup = VARNAPanel.importSession(string);
        Mapping mapping = Mapping.DefaultOutermostMapping(this.getRNA().getSize(), fullBackup.rna.getSize());
        this.showRNAInterpolated(fullBackup.rna, mapping);
        this._conf = fullBackup.config;
        this.repaint();
        return fullBackup;
    }

    public static FullBackup importSession(String string) throws ExceptionLoadingFailed {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            FullBackup fullBackup = VARNAPanel.importSession(fileInputStream, string);
            return fullBackup;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ExceptionLoadingFailed("File not found.", string);
        }
        catch (IOException iOException) {
            throw new ExceptionLoadingFailed("I/O error while loading session.", string);
        }
    }

    public static FullBackup importSession(InputStream inputStream, String string) throws ExceptionLoadingFailed {
        System.setProperty("javax.xml.parsers.SAXParserFactory", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setXIncludeAware(false);
        sAXParserFactory.setNamespaceAware(false);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            VARNASessionParser vARNASessionParser = new VARNASessionParser();
            sAXParser.parse(inputStream, (DefaultHandler)vARNASessionParser);
            FullBackup fullBackup = new FullBackup(vARNASessionParser.getVARNAConfig(), vARNASessionParser.getRNA(), "test");
            return fullBackup;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ExceptionLoadingFailed("Bad XML parser configuration", string);
        }
        catch (SAXException sAXException) {
            throw new ExceptionLoadingFailed("XML parser Exception", string);
        }
        catch (IOException iOException) {
            throw new ExceptionLoadingFailed("I/O error", string);
        }
    }

    public void loadFile(String string) {
        this.loadFile(string, false);
    }

    public boolean getDrawBackbone() {
        return this._conf._drawBackbone;
    }

    public void setDrawBackbone(boolean bl) {
        this._conf._drawBackbone = bl;
    }

    public void addHighlightRegion(HighlightRegionAnnotation highlightRegionAnnotation) {
        this._RNA.addHighlightRegion(highlightRegionAnnotation);
    }

    public void removeHighlightRegion(HighlightRegionAnnotation highlightRegionAnnotation) {
        this._RNA.removeHighlightRegion(highlightRegionAnnotation);
    }

    public void addHighlightRegion(int n, int n2) {
        this._RNA.addHighlightRegion(n, n2);
    }

    public void addHighlightRegion(int n, int n2, Color color, Color color2, double d) {
        this._RNA.addHighlightRegion(n, n2, color, color2, d);
    }

    public void loadRNA(String string) {
        this.loadRNA(string, false);
    }

    public void loadRNA(String string, boolean bl) {
        try {
            ArrayList<RNA> arrayList = RNAFactory.loadSecStr(string);
            if (arrayList.isEmpty()) {
                throw new ExceptionFileFormatOrSyntax("No RNA could be parsed from that source.");
            }
            RNA rNA = (RNA)arrayList.iterator().next();
            try {
                rNA.drawRNA(this._conf);
            }
            catch (ExceptionNAViewAlgorithm exceptionNAViewAlgorithm) {
                exceptionNAViewAlgorithm.printStackTrace();
            }
            if (!bl) {
                this.showRNA(rNA);
            } else {
                this.showRNAInterpolated(rNA);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
            exceptionFileFormatOrSyntax.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadFile(String string, boolean bl) {
        try {
            this.loadSession(string);
        }
        catch (Exception exception) {
            this.loadRNA(string, bl);
        }
    }

    public void setConfig(VARNAConfig vARNAConfig) {
        this._conf = vARNAConfig;
    }

    public void toggleDrawOutlineBases() {
        this._conf._drawOutlineBases = !this._conf._drawOutlineBases;
    }

    public void toggleFillBases() {
        this._conf._fillBases = !this._conf._fillBases;
    }

    public void setDrawOutlineBases(boolean bl) {
        this._conf._drawOutlineBases = bl;
    }

    public void setFillBases(boolean bl) {
        this._conf._fillBases = bl;
    }

    public void readValues(Reader reader) {
        this._RNA.readValues(reader, this._conf._cm);
    }

    public void addVARNAListener(InterfaceVARNAListener interfaceVARNAListener) {
        this._VARNAListeners.add(interfaceVARNAListener);
    }

    public void fireLayoutChanged() {
        for (InterfaceVARNAListener interfaceVARNAListener : this._VARNAListeners) {
            interfaceVARNAListener.onStructureRedrawn();
        }
    }

    public void fireUINewStructure(RNA rNA) {
        for (InterfaceVARNAListener interfaceVARNAListener : this._VARNAListeners) {
            interfaceVARNAListener.onUINewStructure(this._conf, rNA);
        }
    }

    public void fireZoomLevelChanged(double d) {
        for (InterfaceVARNAListener interfaceVARNAListener : this._VARNAListeners) {
            interfaceVARNAListener.onZoomLevelChanged();
        }
    }

    public void fireTranslationChanged() {
        for (InterfaceVARNAListener interfaceVARNAListener : this._VARNAListeners) {
            interfaceVARNAListener.onTranslationChanged();
        }
    }

    public void addSelectionListener(InterfaceVARNASelectionListener interfaceVARNASelectionListener) {
        this._selectionListeners.add(interfaceVARNASelectionListener);
    }

    public void fireSelectionChanged(BaseList baseList, BaseList baseList2) {
        BaseList baseList3 = baseList2.removeAll(baseList);
        BaseList baseList4 = baseList.removeAll(baseList2);
        for (InterfaceVARNASelectionListener interfaceVARNASelectionListener : this._selectionListeners) {
            interfaceVARNASelectionListener.onSelectionChanged(baseList2, baseList3, baseList4);
        }
    }

    public void fireHoverChanged(ModeleBase modeleBase, ModeleBase modeleBase2) {
        for (InterfaceVARNASelectionListener interfaceVARNASelectionListener : this._selectionListeners) {
            interfaceVARNASelectionListener.onHoverChanged(modeleBase, modeleBase2);
        }
    }

    public void addRNAListener(InterfaceVARNARNAListener interfaceVARNARNAListener) {
        this._RNAListeners.add(interfaceVARNARNAListener);
    }

    public void addVARNABasesListener(InterfaceVARNABasesListener interfaceVARNABasesListener) {
        this._basesListeners.add(interfaceVARNABasesListener);
    }

    public void fireSequenceChanged(int n, String string, String string2) {
        for (InterfaceVARNARNAListener interfaceVARNARNAListener : this._RNAListeners) {
            interfaceVARNARNAListener.onSequenceModified(n, string, string2);
        }
    }

    public void fireStructureChanged(Set<ModeleBP> set, Set<ModeleBP> set2, Set<ModeleBP> set3) {
        for (InterfaceVARNARNAListener interfaceVARNARNAListener : this._RNAListeners) {
            interfaceVARNARNAListener.onStructureModified(set, set2, set3);
        }
    }

    public void fireLayoutChanged(Hashtable<Integer, Point2D.Double> hashtable) {
        for (InterfaceVARNARNAListener interfaceVARNARNAListener : this._RNAListeners) {
            interfaceVARNARNAListener.onRNALayoutChanged(hashtable);
        }
    }

    public void fireBaseClicked(ModeleBase modeleBase, MouseEvent mouseEvent) {
        if (modeleBase != null) {
            for (InterfaceVARNABasesListener interfaceVARNABasesListener : this._basesListeners) {
                interfaceVARNABasesListener.onBaseClicked(modeleBase, mouseEvent);
            }
        }
    }

    public double getOrientation() {
        return this._RNA.getOrientation();
    }

    public void setHoverBase(ModeleBase modeleBase) {
        if (modeleBase != this._hoveredBase) {
            ModeleBase modeleBase2 = this._hoveredBase;
            this._hoveredBase = modeleBase;
            this.repaint();
            this.fireHoverChanged(modeleBase2, modeleBase);
        }
    }

    public void toXML(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            this.toXML(printWriter);
            printWriter.flush();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void toXML(PrintWriter printWriter) {
        try {
            StreamResult streamResult = new StreamResult(printWriter);
            SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler();
            Transformer transformer = transformerHandler.getTransformer();
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.setOutputProperty("doctype-system", "users.dtd");
            transformer.setOutputProperty("indent", "yes");
            transformerHandler.setResult(streamResult);
            transformerHandler.startDocument();
            this.toXML(transformerHandler);
            transformerHandler.endDocument();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    public void toXML(TransformerHandler transformerHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        transformerHandler.startElement("", "", XML_ELEMENT_NAME, attributesImpl);
        this._RNA.toXML(transformerHandler);
        this._conf.toXML(transformerHandler);
        transformerHandler.endElement("", "", XML_ELEMENT_NAME);
    }

    public TextAnnotation getNearestAnnotation(int n, int n2) {
        TextAnnotation textAnnotation = null;
        if (this.getListeAnnotations().size() != 0) {
            double d = Double.MAX_VALUE;
            for (TextAnnotation textAnnotation2 : this.getListeAnnotations()) {
                Point2D.Double double_ = textAnnotation2.getCenterPosition();
                double_ = this.transformCoord(double_);
                double d2 = Math.sqrt(Math.pow(double_.x - (double)n, 2.0) + Math.pow(double_.y - (double)n2, 2.0));
                if (!(d > d2) || !(d2 < this.getScaleFactor() * 40.0)) continue;
                textAnnotation = textAnnotation2;
                d = d2;
            }
        }
        return textAnnotation;
    }

    public ModeleBase getNearestBase(int n, int n2, boolean bl, boolean bl2) {
        int n3 = this.getNearestBaseIndex(n, n2, bl, bl2);
        if (n3 == -1) {
            return null;
        }
        return this.getRNA().get_listeBases().get(n3);
    }

    public ModeleBase getNearestBase(int n, int n2) {
        return this.getNearestBase(n, n2, false, false);
    }

    public int getNearestBaseIndex(int n, int n2, boolean bl, boolean bl2) {
        double d = Double.MAX_VALUE;
        int n3 = -1;
        for (int i = 0; i < this.getRealCoords().length; ++i) {
            double d2;
            if (bl2 && this.getRNA().get_listeBases().get(i).getElementStructure() == -1 || !(d > (d2 = Math.sqrt(Math.pow(this.getRealCoords()[i].x - (double)n, 2.0) + Math.pow(this.getRealCoords()[i].y - (double)n2, 2.0)))) || !(d2 < this.getScaleFactor() * 40.0) && !bl) continue;
            d = d2;
            n3 = i;
        }
        return n3;
    }

    public void globalRescale(double d) {
        this._RNA.rescale(d);
        this.fireLayoutChanged();
        this.repaint();
    }

    public void setSpaceBetweenBases(double d) {
        this._conf._spaceBetweenBases = d;
    }

    public double getSpaceBetweenBases() {
        return this._conf._spaceBetweenBases;
    }
}

