/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.threerings.getdown.Log;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.StringUtil;
import jalview.util.FileUtils;
import jalview.util.LaunchUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.Locale;

public class LaunchUtil {
    public static final String LOCAL_JAVA_DIR = "jre";
    private static String jvmPath = null;
    protected static boolean _isWindows;
    protected static boolean _isMacOS;
    protected static boolean _isLinux;

    public static boolean updateVersionAndRelaunch(File appdir, String getdownJarName, String newVersion) throws IOException {
        File vfile = new File(appdir, "version.txt");
        try (PrintStream ps = new PrintStream(new FileOutputStream(vfile));){
            ps.println(newVersion);
        }
        File pro = new File(appdir, getdownJarName);
        if (LaunchUtil.mustMonitorChildren() || !pro.exists()) {
            return false;
        }
        Object[] args = new String[]{LaunchUtil.getJVMPath(appdir), "-jar", pro.toString(), appdir.getPath()};
        Log.log.info("Running " + StringUtil.join(args, "\n  "), new Object[0]);
        try {
            Runtime.getRuntime().exec((String[])args, null);
            return true;
        }
        catch (IOException ioe) {
            Log.log.warning("Failed to run getdown", ioe);
            return false;
        }
    }

    public static String getJVMPath(File appdir) {
        return LaunchUtil.getJVMPath(appdir, false);
    }

    public static String getJVMPath(File appdir, boolean windebug) {
        if (jvmPath != null) {
            return jvmPath;
        }
        String appJreDir = LaunchUtil.isMacOS() ? new File(appdir, LOCAL_JAVA_DIR).getAbsolutePath() + "/Contents/Home" : new File(appdir, LOCAL_JAVA_DIR).getAbsolutePath();
        String javaBin = LaunchUtils.findJavaBin(appJreDir, windebug, true, false);
        if (javaBin == null) {
            javaBin = LaunchUtils.findJavaBin(System.getProperty("java.home"), windebug, true, false);
        }
        if (javaBin == null) {
            javaBin = LaunchUtils.findJavaBin(null, windebug, false, true);
            Log.log.warning("Unable to find java [appdir=" + appdir + ", java.home=" + System.getProperty("java.home") + "]!", new Object[0]);
        }
        if (LaunchUtil.isMacOS()) {
            try {
                File localVM = new File("/usr/bin/java").getCanonicalFile();
                if (localVM.equals(new File(javaBin).getCanonicalFile())) {
                    javaBin = "/usr/bin/java";
                }
            }
            catch (IOException ioe) {
                Log.log.warning("Failed to check Mac OS canonical VM path.", ioe);
            }
        }
        jvmPath = javaBin;
        return jvmPath;
    }

    private static String _getMD5FileChecksum(File file) {
        String algo = "MD5";
        String checksum = "";
        try {
            MessageDigest md = MessageDigest.getInstance(algo);
            md.update(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
            byte[] digest = md.digest();
            checksum = LaunchUtil.printHexBinary(digest).toUpperCase(Locale.ROOT);
        }
        catch (Exception e) {
            System.out.println("Couldn't create " + algo + " digest of " + file.getPath());
        }
        return checksum;
    }

    public static void upgradeGetdown(File oldgd, File curgd, File newgd) {
        if (!newgd.exists()) {
            return;
        }
        if (newgd.length() == curgd.length() && LaunchUtil._getMD5FileChecksum(newgd).equals(LaunchUtil._getMD5FileChecksum(curgd))) {
            return;
        }
        Log.log.info("Updating Getdown with " + newgd + "...", new Object[0]);
        if (oldgd.exists()) {
            FileUtil.deleteHarder(oldgd);
        }
        if (!curgd.exists() || curgd.renameTo(oldgd)) {
            if (newgd.renameTo(curgd)) {
                FileUtil.deleteHarder(oldgd);
                try {
                    FileUtil.copy(curgd, newgd);
                }
                catch (IOException e) {
                    Log.log.warning("Error copying updated Getdown back: " + e, new Object[0]);
                }
                return;
            }
            Log.log.warning("Unable to renameTo(" + oldgd + ").", new Object[0]);
            if (!oldgd.renameTo(curgd)) {
                Log.log.warning("Oh God, why dost thee scorn me so.", new Object[0]);
            }
        }
        Log.log.info("Attempting to upgrade by copying over " + curgd + "...", new Object[0]);
        try {
            FileUtil.copy(newgd, curgd);
        }
        catch (IOException ioe) {
            Log.log.warning("Mayday! Brute force copy method also failed.", ioe);
        }
    }

    public static boolean mustMonitorChildren() {
        String osname = System.getProperty("os.name", "").toLowerCase(Locale.ROOT);
        return osname.indexOf("windows 98") != -1 || osname.indexOf("windows me") != -1;
    }

    public static final boolean isWindows() {
        return _isWindows;
    }

    public static final boolean isMacOS() {
        return _isMacOS;
    }

    public static final boolean isLinux() {
        return _isLinux;
    }

    private static boolean checkJVMSymlink(String testBin) {
        File testBinFile = new File(testBin);
        if (!testBinFile.exists()) {
            return false;
        }
        File targetFile = null;
        targetFile = FileUtils.getCanonicalFile(testBinFile);
        return targetFile != null && ("java".equals(targetFile.getName()) || "java.exe".equals(targetFile.getName()));
    }

    protected static String checkJVMPath(String vmhome, boolean windebug) {
        String vmbase = vmhome + File.separator + "bin" + File.separator;
        String appName = System.getProperty("channel.app_name", "Jalview");
        String vmpath = vmbase + appName;
        if (LaunchUtil.checkJVMSymlink(vmpath)) {
            return vmpath;
        }
        vmpath = vmbase + "Jalview";
        if (LaunchUtil.checkJVMSymlink(vmpath)) {
            return vmpath;
        }
        vmpath = vmbase + "java";
        if (new File(vmpath).exists()) {
            return vmpath;
        }
        if (!windebug && new File(vmpath = vmbase + "javaw.exe").exists()) {
            return vmpath;
        }
        vmpath = vmbase + "java.exe";
        if (new File(vmpath).exists()) {
            return vmpath;
        }
        return null;
    }

    private static String printHexBinary(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(LaunchUtil.byteToHex(bytes[i]));
        }
        return sb.toString();
    }

    private static String byteToHex(byte num) {
        char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
        return new String(hexDigits);
    }

    static {
        try {
            String osname = System.getProperty("os.name");
            osname = osname == null ? "" : osname;
            _isWindows = osname.indexOf("Windows") != -1;
            _isMacOS = osname.indexOf("Mac OS") != -1 || osname.indexOf("MacOS") != -1;
            _isLinux = osname.indexOf("Linux") != -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

